/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.program;

import com.google.common.base.Objects;
import de.fxnn.brainfuck.program.DepthFirstTreeProgramIterator;
import de.fxnn.brainfuck.program.InstructionPointer;
import de.fxnn.brainfuck.program.InvalidInstructionPointer;
import de.fxnn.brainfuck.program.Program;
import de.fxnn.brainfuck.program.TreeInstructionPointer;
import java.util.Iterator;
import java.util.List;

public class TreeProgram
implements Program,
Iterable<Program> {
    private final List<Program> childPrograms;

    public TreeProgram(List<Program> childPrograms) {
        this.childPrograms = childPrograms;
    }

    @Override
    public InstructionPointer getStartOfProgram() {
        if (this.childPrograms.isEmpty()) {
            return InvalidInstructionPointer.invalidInstructionPointer();
        }
        return TreeInstructionPointer.createInstructionPointer(this.childPrograms);
    }

    @Override
    public Iterator<Program> iterator() {
        return new DepthFirstTreeProgramIterator(this);
    }

    public List<Program> getChildPrograms() {
        return this.childPrograms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeProgram programs = (TreeProgram)o;
        return Objects.equal(this.childPrograms, programs.childPrograms);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.childPrograms});
    }

    public String toString() {
        return "TreeProgram(childPrograms=" + this.getChildPrograms() + ")";
    }
}

