/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.tape;

import de.fxnn.brainfuck.tape.OutOfTapeBoundsException;
import de.fxnn.brainfuck.tape.Tape;
import de.fxnn.brainfuck.tape.TapeSegment;
import javax.annotation.Nonnull;

public abstract class AbstractInfiniteTape<T>
implements Tape<T> {
    private TapeSegment<T> currentSegment = this.createSegment();

    @Override
    public void moveForward() throws OutOfTapeBoundsException {
        try {
            this.currentSegment.moveForward();
        }
        catch (OutOfTapeBoundsException ex) {
            this.currentSegment = this.getOrCreateNextSegment().atBeginning();
        }
    }

    protected TapeSegment<T> getOrCreateNextSegment() {
        TapeSegment<T> nextSegment = this.currentSegment.getNextSegment();
        if (nextSegment != null) {
            return nextSegment;
        }
        return this.createNextSegment();
    }

    protected TapeSegment<T> createNextSegment() {
        TapeSegment<T> nextSegment = this.createSegment();
        nextSegment.setPreviousSegment(this.currentSegment);
        this.currentSegment.setNextSegment(nextSegment);
        return nextSegment;
    }

    @Override
    public void moveBackward() throws OutOfTapeBoundsException {
        try {
            this.currentSegment.moveBackward();
        }
        catch (OutOfTapeBoundsException ex) {
            this.currentSegment = this.getOrCreatePreviousSegment().atEnd();
        }
    }

    public TapeSegment<T> getOrCreatePreviousSegment() {
        TapeSegment<T> previousSegment = this.createSegment().getPreviousSegment();
        if (previousSegment != null) {
            return previousSegment;
        }
        return this.createPreviousSegment();
    }

    private TapeSegment<T> createPreviousSegment() {
        TapeSegment<T> previousSegment = this.createSegment();
        previousSegment.setNextSegment(this.currentSegment);
        this.currentSegment.setPreviousSegment(previousSegment);
        return previousSegment;
    }

    protected abstract TapeSegment<T> createSegment();

    protected void write(@Nonnull T value) {
        this.currentSegment.write(value);
    }

    protected T read() {
        return this.currentSegment.read();
    }
}

