/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.OptionalInt;
import org.apache.commons.io.ByteOrderMark;

public class UnicodeBuffers {
    static final Collection<ByteOrderMark> BYTE_ORDER_MARKS = Arrays.asList(ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE);
    static final Multimap<Charset, ByteOrderMark> BYTE_ORDER_MARKS_PER_CHARSET = UnicodeBuffers.mapCharsetsToByteOrderMarks();

    private UnicodeBuffers() {
    }

    public static OptionalInt getFirstCodePoint(CharBuffer charBuffer) {
        charBuffer.position(0);
        if (charBuffer.hasRemaining()) {
            char[] chars = new char[charBuffer.remaining()];
            charBuffer.get(chars);
            return OptionalInt.of(Character.codePointAt(chars, 0, chars.length));
        }
        return OptionalInt.empty();
    }

    public static void skipByteOrderMarks(ByteBuffer byteBuffer, Iterable<ByteOrderMark> byteOrderMarks) {
        for (ByteOrderMark byteOrderMark : byteOrderMarks) {
            if (byteBuffer.remaining() < byteOrderMark.length()) continue;
            byte[] bytes = new byte[byteOrderMark.length()];
            byteBuffer.get(bytes);
            if (Arrays.equals(bytes, byteOrderMark.getBytes())) {
                return;
            }
            byteBuffer.rewind();
        }
    }

    public static Collection<ByteOrderMark> getByteOrderMarksForCharset(Charset charset) {
        return BYTE_ORDER_MARKS_PER_CHARSET.get((Object)charset);
    }

    public static Collection<ByteOrderMark> getAllKnownByteOrderMarks() {
        return BYTE_ORDER_MARKS;
    }

    private static Multimap<Charset, ByteOrderMark> mapCharsetsToByteOrderMarks() {
        HashMultimap result = HashMultimap.create();
        result.put((Object)StandardCharsets.UTF_8, (Object)ByteOrderMark.UTF_8);
        result.put((Object)StandardCharsets.UTF_16, (Object)ByteOrderMark.UTF_16BE);
        result.put((Object)StandardCharsets.UTF_16, (Object)ByteOrderMark.UTF_16LE);
        result.put((Object)StandardCharsets.UTF_16BE, (Object)ByteOrderMark.UTF_16BE);
        result.put((Object)StandardCharsets.UTF_16LE, (Object)ByteOrderMark.UTF_16LE);
        result.put((Object)Charset.forName("UTF-32"), (Object)ByteOrderMark.UTF_32BE);
        result.put((Object)Charset.forName("UTF-32"), (Object)ByteOrderMark.UTF_32LE);
        result.put((Object)Charset.forName("UTF-32BE"), (Object)ByteOrderMark.UTF_32BE);
        result.put((Object)Charset.forName("UTF-32LE"), (Object)ByteOrderMark.UTF_32LE);
        return result;
    }
}

