/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.container;

import de.gesellix.docker.client.DockerAsyncCallback;
import de.gesellix.docker.client.DockerAsyncConsumer;
import de.gesellix.docker.client.DockerResponseHandler;
import de.gesellix.docker.client.container.ArchiveUtil;
import de.gesellix.docker.client.container.ManageContainer;
import de.gesellix.docker.client.image.ManageImage;
import de.gesellix.docker.client.repository.RepositoryTagParser;
import de.gesellix.docker.engine.AttachConfig;
import de.gesellix.docker.engine.EngineClient;
import de.gesellix.docker.engine.EngineResponse;
import de.gesellix.docker.rawstream.RawInputStream;
import de.gesellix.util.QueryUtil;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageContainerClient
implements ManageContainer,
GroovyObject {
    private EngineClient client;
    private DockerResponseHandler responseHandler;
    private QueryUtil queryUtil;
    private ArchiveUtil archiveUtil;
    private RepositoryTagParser repositoryTagParser;
    private ManageImage manageImage;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ManageContainerClient(EngineClient client, DockerResponseHandler responseHandler, ManageImage manageImage) {
        ManageImage manageImage2;
        DockerResponseHandler dockerResponseHandler;
        EngineClient engineClient;
        MetaClass metaClass;
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.client = engineClient = client;
        this.responseHandler = dockerResponseHandler = responseHandler;
        this.manageImage = manageImage2 = manageImage;
        Object object = callSiteArray[0].callConstructor(RepositoryTagParser.class);
        this.repositoryTagParser = (RepositoryTagParser)ScriptBytecodeAdapter.castToType((Object)object, RepositoryTagParser.class);
        Object object2 = callSiteArray[1].callConstructor(QueryUtil.class);
        this.queryUtil = (QueryUtil)ScriptBytecodeAdapter.castToType((Object)object2, QueryUtil.class);
        Object object3 = callSiteArray[2].callConstructor(ArchiveUtil.class);
        this.archiveUtil = (ArchiveUtil)ScriptBytecodeAdapter.castToType((Object)object3, ArchiveUtil.class);
    }

    @Override
    public EngineResponse attach(Object containerId, Object query, AttachConfig callback) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[3].call((Object)log, (Object)"docker attach");
        Object container = callSiteArray[4].callCurrent((GroovyObject)this, containerId);
        Boolean multiplexStreams = !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(callSiteArray[7].callGetProperty(container))));
        Object response = callSiteArray[8].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[9].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/attach"})), "query", query, "attach", callback, "multiplexStreams", multiplexStreams}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callback)) {
            boolean bl = !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty(callSiteArray[12].callGetProperty(container))));
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)callSiteArray[13].callGetProperty(response), (String)"multiplexStreams");
        }
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public WebSocket attachWebsocket(Object containerId, Object query, WebSocketListener listener) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[14].call((Object)log, (Object)"docker attach via websocket");
        WebSocket webSocket = (WebSocket)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[16].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/attach/ws"})), "query", query}), (Object)listener), WebSocket.class);
        return webSocket;
    }

    @Override
    public EngineResponse resizeTTY(Object container, Object height, Object width) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[17].call((Object)log, (Object)"docker resize container");
        Object response = callSiteArray[18].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[19].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/resize"})), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"h", height, "w", width}), "requestContentType", "text/plain"}));
        callSiteArray[20].call((Object)this.responseHandler, response, callSiteArray[21].callConstructor(IllegalStateException.class, (Object)"docker resize(tty) failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse commit(Object container, Object query, Object config) {
        Object object;
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[22].call((Object)log, (Object)"docker commit");
        Object object2 = query;
        Object finalQuery = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object object3 = container;
        ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)finalQuery, (String)"container");
        Object object4 = config;
        config = object = DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object response = callSiteArray[23].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", "/commit", "query", finalQuery, "requestContentType", "application/json", "body", config}));
        callSiteArray[24].call((Object)this.responseHandler, response, callSiteArray[25].callConstructor(IllegalStateException.class, (Object)"docker commit failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public Object getArchiveStats(Object container, Object path) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].call((Object)log)) ? callSiteArray[27].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"docker archive stats ", "|", ""})) : null;
        Object response = callSiteArray[28].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[29].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/archive"})), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", path})}));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[30].callGetProperty(callSiteArray[31].callGetProperty(response)), (Object)404)) {
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[32].call((Object)log)) ? callSiteArray[33].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"no such container ", " or path ", ""})) : null;
        }
        callSiteArray[34].call((Object)this.responseHandler, response, callSiteArray[35].callConstructor(IllegalStateException.class, (Object)"docker head archive failed"));
        List pathInfo = (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[36].call(callSiteArray[37].callGetProperty(response), callSiteArray[38].call((Object)"X-Docker-Container-Path-Stat")), List.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)pathInfo)) {
            callSiteArray[39].call((Object)log, (Object)"didn't find 'X-Docker-Container-Path-Stat' header in response");
            return response;
        }
        String firstPathInfo = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[40].call((Object)pathInfo), String.class);
        callSiteArray[41].call((Object)log, (Object)firstPathInfo);
        Object decodedPathInfo = callSiteArray[42].call(callSiteArray[43].callConstructor(JsonSlurper.class), callSiteArray[44].callConstructor(String.class, callSiteArray[45].call((Object)firstPathInfo)));
        return decodedPathInfo;
    }

    @Override
    public byte[] extractFile(String container, String filename) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[46].call((Object)log)) ? callSiteArray[47].call((Object)log, (Object)new GStringImpl(new Object[]{filename, container}, new String[]{"extract '", "' from '", "'"})) : null;
        Object response = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[48].callCurrent((GroovyObject)this, (Object)container, (Object)filename);
            response = object2;
        } else {
            EngineResponse engineResponse;
            response = engineResponse = this.getArchive(container, filename);
        }
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].call((Object)this.archiveUtil, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((InputStream)ScriptBytecodeAdapter.asType((Object)callSiteArray[50].callGetProperty(response), InputStream.class)), InputStream.class), (Object)filename), byte[].class);
    }

    @Override
    public EngineResponse getArchive(String container, String path) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[51].call((Object)log)) ? callSiteArray[52].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"docker download from ", "|", ""})) : null;
        Object response = callSiteArray[53].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[54].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/archive"})), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", path})}));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[55].callGetProperty(callSiteArray[56].callGetProperty(response)), (Object)404)) {
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[57].call((Object)log)) ? callSiteArray[58].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"no such container ", " or path ", ""})) : null;
        }
        callSiteArray[59].call((Object)this.responseHandler, response, callSiteArray[60].callConstructor(IllegalStateException.class, (Object)"docker get archive failed"));
        String pathInfo = ShortTypeHandling.castToString((Object)callSiteArray[61].call(callSiteArray[62].callGetProperty(response), callSiteArray[63].call((Object)"X-Docker-Container-Path-Stat")));
        if (DefaultTypeTransformation.booleanUnbox((Object)pathInfo)) {
            Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[64].call((Object)log)) ? callSiteArray[65].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[66].call(callSiteArray[67].callConstructor(JsonSlurper.class), callSiteArray[68].callConstructor(String.class, callSiteArray[69].call((Object)pathInfo)))}, new String[]{"archiveStats: ", ""})) : null;
        }
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse putArchive(String container, String path, InputStream archive, Map<String, ?> query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[70].call((Object)log)) ? callSiteArray[71].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"docker upload to ", "|", ""})) : null;
        Map map = query;
        Map finalQuery = DefaultTypeTransformation.booleanUnbox(map) ? map : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        String string = path;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)finalQuery, (String)"path");
        Object response = callSiteArray[72].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[73].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/archive"})), "query", finalQuery, "requestContentType", "application/x-tar", "body", archive}));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[74].callGetProperty(callSiteArray[75].callGetProperty(response)), (Object)404)) {
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[76].call((Object)log)) ? callSiteArray[77].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"no such container ", " or path ", ""})) : null;
        }
        callSiteArray[78].call((Object)this.responseHandler, response, callSiteArray[79].callConstructor(IllegalStateException.class, (Object)"docker put archive failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse createContainer(Map<String, ?> containerConfig, Map<String, ?> query, String authBase64Encoded) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[80].call((Object)log, (Object)"docker create");
        Object actualContainerConfig = callSiteArray[81].call((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), containerConfig);
        Object response = callSiteArray[82].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[83].call((Object)"/containers/create"), "query", query, "body", actualContainerConfig, "requestContentType", "application/json"}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[84].callGetProperty(callSiteArray[85].callGetProperty(response)))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[86].callGetPropertySafe(callSiteArray[87].callGetProperty(response)), (Object)404)) {
                Object object;
                Object repoAndTag = callSiteArray[88].call((Object)this.repositoryTagParser, callSiteArray[89].callGetProperty(containerConfig));
                Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[90].call((Object)log)) ? callSiteArray[91].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[92].callGetProperty(repoAndTag), callSiteArray[93].callGetProperty(repoAndTag)}, new String[]{"'", ":", "' not found."})) : null;
                Object[] objectArray = new Object[2];
                objectArray[0] = "EncodedRegistryAuth";
                String string = authBase64Encoded;
                objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "";
                callSiteArray[94].call((Object)this.manageImage, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"fromImage", callSiteArray[95].callGetProperty(repoAndTag), "tag", callSiteArray[96].callGetProperty(repoAndTag)}), (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray));
                response = object = callSiteArray[97].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[98].call((Object)"/containers/create"), "query", query, "body", actualContainerConfig, "requestContentType", "application/json"}));
                callSiteArray[99].call((Object)this.responseHandler, response, callSiteArray[100].callConstructor(IllegalStateException.class, (Object)"docker create failed after retry"));
            } else {
                callSiteArray[101].call((Object)this.responseHandler, response, callSiteArray[102].callConstructor(IllegalStateException.class, (Object)"docker create failed"));
            }
        }
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse diff(Object containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[103].call((Object)log, (Object)"docker diff");
        Object response = callSiteArray[104].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/changes"})}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse createExec(Object containerId, Map execConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[105].call((Object)log)) ? callSiteArray[106].call((Object)log, (Object)new GStringImpl(new Object[]{containerId}, new String[]{"docker create exec on '", "'"})) : null;
        Object response = callSiteArray[107].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[108].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/exec"})), "body", execConfig, "requestContentType", "application/json"}));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[109].callGetPropertySafe(callSiteArray[110].callGetProperty(response)), (Object)404)) {
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[111].call((Object)log)) ? callSiteArray[112].call((Object)log, (Object)new GStringImpl(new Object[]{containerId}, new String[]{"no such container '", "'"})) : null;
        }
        callSiteArray[113].call((Object)this.responseHandler, response, callSiteArray[114].callConstructor(IllegalStateException.class, (Object)"docker exec create failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse startExec(Object execId, Map execConfig, AttachConfig attachConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[115].call((Object)log)) ? callSiteArray[116].call((Object)log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"docker start exec '", "'"})) : null;
        Object exec = callSiteArray[117].callCurrent((GroovyObject)this, execId);
        Boolean multiplexStreams = !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[118].callGetProperty(callSiteArray[119].callGetProperty(callSiteArray[120].callGetProperty(exec))));
        Object response = callSiteArray[121].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[122].call((Object)new GStringImpl(new Object[]{execId}, new String[]{"/exec/", "/start"})), "body", execConfig, "requestContentType", "application/json", "attach", attachConfig, "multiplexStreams", multiplexStreams}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)attachConfig)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[123].callGetPropertySafe(callSiteArray[124].callGetProperty(response)), (Object)404)) {
                Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[125].call((Object)log)) ? callSiteArray[126].call((Object)log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"no such exec '", "'"})) : null;
            }
            callSiteArray[127].call((Object)this.responseHandler, response, callSiteArray[128].callConstructor(IllegalStateException.class, (Object)"docker exec start failed"));
            Boolean bl = multiplexStreams;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)callSiteArray[129].callGetProperty(response), (String)"multiplexStreams");
        }
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse inspectExec(Object execId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[130].call((Object)log)) ? callSiteArray[131].call((Object)log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"docker inspect exec '", "'"})) : null;
        Object response = callSiteArray[132].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[133].call((Object)new GStringImpl(new Object[]{execId}, new String[]{"/exec/", "/json"}))}));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[134].callGetPropertySafe(callSiteArray[135].callGetProperty(response)), (Object)404)) {
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[136].call((Object)log)) ? callSiteArray[137].call((Object)log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"no such exec '", "'"})) : null;
        }
        callSiteArray[138].call((Object)this.responseHandler, response, callSiteArray[139].callConstructor(IllegalStateException.class, (Object)"docker inspect exec failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse exec(Object containerId, Object command, Map execConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[140].call((Object)log)) ? callSiteArray[141].call((Object)log, (Object)new GStringImpl(new Object[]{containerId, command}, new String[]{"docker exec '", "' '", "'"})) : null;
        Object[] objectArray = new Object[12];
        objectArray[0] = "AttachStdin";
        Object object2 = callSiteArray[142].callGetProperty((Object)execConfig);
        objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : Boolean.valueOf(false);
        objectArray[2] = "AttachStdout";
        objectArray[3] = true;
        objectArray[4] = "AttachStderr";
        objectArray[5] = true;
        objectArray[6] = "Detach";
        Object object3 = callSiteArray[143].callGetProperty((Object)execConfig);
        objectArray[7] = DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : Boolean.valueOf(false);
        objectArray[8] = "Tty";
        Object object4 = callSiteArray[144].callGetProperty((Object)execConfig);
        objectArray[9] = DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : Boolean.valueOf(false);
        objectArray[10] = "Cmd";
        objectArray[11] = command;
        Map actualExecConfig = ScriptBytecodeAdapter.createMap((Object[])objectArray);
        Object execCreateResult = callSiteArray[145].callCurrent((GroovyObject)this, containerId, (Object)actualExecConfig);
        Object execId = callSiteArray[146].callGetProperty(callSiteArray[147].callGetProperty(execCreateResult));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[148].callCurrent((GroovyObject)this, execId, (Object)actualExecConfig), EngineResponse.class);
    }

    @Override
    public EngineResponse resizeExec(Object exec, Object height, Object width) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[149].call((Object)log, (Object)"docker resize exec");
        Object response = callSiteArray[150].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[151].call((Object)new GStringImpl(new Object[]{exec}, new String[]{"/exec/", "/resize"})), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"h", height, "w", width}), "requestContentType", "text/plain"}));
        callSiteArray[152].call((Object)this.responseHandler, response, callSiteArray[153].callConstructor(IllegalStateException.class, (Object)"docker resize(exec) failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse export(Object container) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[154].call((Object)log)) ? callSiteArray[155].call((Object)log, (Object)new GStringImpl(new Object[]{container}, new String[]{"docker export ", ""})) : null;
        Object response = callSiteArray[156].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/export"})}));
        callSiteArray[157].call((Object)this.responseHandler, response, callSiteArray[158].callConstructor(IllegalStateException.class, (Object)"docker export failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse inspectContainer(Object containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[159].call((Object)log, (Object)"docker inspect container");
        Object response = callSiteArray[160].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/json"})}));
        callSiteArray[161].call((Object)this.responseHandler, response, callSiteArray[162].callConstructor(IllegalStateException.class, (Object)"docker inspect failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse kill(Object containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[163].call((Object)log, (Object)"docker kill");
        Object response = callSiteArray[164].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[165].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/kill"}))}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse logs(Object container, DockerAsyncCallback callback) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[166].callCurrent((GroovyObject)this, container, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (Object)callback), EngineResponse.class);
    }

    @Override
    public EngineResponse logs(Object container, Object query, DockerAsyncCallback callback) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[167].call((Object)log, (Object)"docker logs");
        Boolean async = DefaultTypeTransformation.booleanUnbox((Object)callback);
        Object object = query;
        Object actualQuery = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Map defaults = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"follow", async, "stdout", true, "stderr", true, "timestamps", false, "since", 0, "tail", "all"});
        callSiteArray[168].call((Object)this.queryUtil, actualQuery, (Object)defaults);
        Boolean multiplexStreams = !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[169].callGetProperty(callSiteArray[170].callGetProperty(callSiteArray[171].callGetProperty(callSiteArray[172].callCurrent((GroovyObject)this, container)))));
        Object response = callSiteArray[173].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/logs"}), "query", actualQuery, "async", async}));
        callSiteArray[174].call((Object)this.responseHandler, response, callSiteArray[175].callConstructor(IllegalStateException.class, (Object)"docker logs failed"));
        if (DefaultTypeTransformation.booleanUnbox((Object)async)) {
            if (DefaultTypeTransformation.booleanUnbox((Object)multiplexStreams)) {
                Object object2 = callSiteArray[176].callConstructor(RawInputStream.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((InputStream)ScriptBytecodeAdapter.asType((Object)callSiteArray[177].callGetProperty(response), InputStream.class)), InputStream.class));
                ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)response, (String)"stream");
            }
            Object executor = callSiteArray[178].callStatic(Executors.class);
            Object future = callSiteArray[179].call(executor, callSiteArray[180].callConstructor(DockerAsyncConsumer.class, (Object)ScriptBytecodeAdapter.createGroovyObjectWrapper((GroovyObject)((EngineResponse)ScriptBytecodeAdapter.asType((Object)response, EngineResponse.class)), EngineResponse.class), (Object)callback));
            Object object3 = future;
            ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)response, (String)"taskFuture");
        }
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse ps(Object query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[181].call((Object)log, (Object)"docker ps");
        Object object = query;
        Object actualQuery = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Map defaults = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"all", true, "size", false});
        callSiteArray[182].call((Object)this.queryUtil, actualQuery, (Object)defaults);
        callSiteArray[183].call((Object)this.queryUtil, actualQuery);
        Object response = callSiteArray[184].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", "/containers/json", "query", actualQuery}));
        callSiteArray[185].call((Object)this.responseHandler, response, callSiteArray[186].callConstructor(IllegalStateException.class, (Object)"docker ps failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse pause(Object containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[187].call((Object)log, (Object)"docker pause");
        Object response = callSiteArray[188].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[189].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/pause"}))}));
        callSiteArray[190].call((Object)this.responseHandler, response, callSiteArray[191].callConstructor(IllegalStateException.class, (Object)"docker pause failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse pruneContainers(Object query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[192].call((Object)log, (Object)"docker container prune");
        Object object = query;
        Object actualQuery = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        callSiteArray[193].call((Object)this.queryUtil, actualQuery);
        Object response = callSiteArray[194].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", "/containers/prune", "query", actualQuery}));
        callSiteArray[195].call((Object)this.responseHandler, response, callSiteArray[196].callConstructor(IllegalStateException.class, (Object)"docker container prune failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse rename(String container, String newName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[197].call((Object)log, (Object)"docker rename");
        Object response = callSiteArray[198].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[199].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/rename"})), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", newName})}));
        callSiteArray[200].call((Object)this.responseHandler, response, callSiteArray[201].callConstructor(IllegalStateException.class, (Object)"docker rename failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse restart(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[202].call((Object)log, (Object)"docker restart");
        Object response = callSiteArray[203].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[204].call((Object)new GStringImpl(new Object[]{containerIdOrName}, new String[]{"/containers/", "/restart"})), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"t", 5})}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse rm(String containerIdOrName, Object query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[205].call((Object)log, (Object)"docker rm");
        Object response = callSiteArray[206].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[207].call((Object)new GStringImpl(new Object[]{containerIdOrName}, new String[]{"/containers/", ""})), "query", query}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public Object run(String fromImage, Object containerConfig, String tag, String name, String authBase64Encoded) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[208].call((Object)log)) ? callSiteArray[209].call((Object)log, (Object)new GStringImpl(new Object[]{fromImage, DefaultTypeTransformation.booleanUnbox((Object)tag) ? ":" : "", tag}, new String[]{"docker run ", "", "", ""})) : null;
        Map containerConfigWithImageName = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[210].call((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), containerConfig), Map.class);
        Object object2 = callSiteArray[211].call((Object)fromImage, DefaultTypeTransformation.booleanUnbox((Object)tag) ? new GStringImpl(new Object[]{tag}, new String[]{":", ""}) : "");
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)containerConfigWithImageName, (String)"Image");
        Object[] objectArray = new Object[2];
        objectArray[0] = "name";
        String string = name;
        objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "";
        Object createContainerResponse = callSiteArray[212].callCurrent((GroovyObject)this, (Object)containerConfigWithImageName, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray), (Object)authBase64Encoded);
        Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[213].call((Object)log)) ? callSiteArray[214].call((Object)log, (Object)new GStringImpl(new Object[]{createContainerResponse}, new String[]{"create container result: ", ""})) : null;
        Object startContainerResponse = callSiteArray[215].callCurrent((GroovyObject)this, callSiteArray[216].callGetProperty(callSiteArray[217].callGetProperty(createContainerResponse)));
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"container", createContainerResponse, "status", startContainerResponse});
    }

    @Override
    public EngineResponse startContainer(Object containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[218].call((Object)log, (Object)"docker start");
        Object response = callSiteArray[219].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[220].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/start"})), "requestContentType", "application/json"}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse stats(Object container, DockerAsyncCallback callback) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[221].call((Object)log, (Object)"docker stats");
        Boolean async = DefaultTypeTransformation.booleanUnbox((Object)callback);
        Object response = callSiteArray[222].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/stats"}), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"stream", async}), "async", async}));
        callSiteArray[223].call((Object)this.responseHandler, response, callSiteArray[224].callConstructor(IllegalStateException.class, (Object)"docker stats failed"));
        if (DefaultTypeTransformation.booleanUnbox((Object)async)) {
            Object executor = callSiteArray[225].callStatic(Executors.class);
            Object future = callSiteArray[226].call(executor, callSiteArray[227].callConstructor(DockerAsyncConsumer.class, (Object)ScriptBytecodeAdapter.createGroovyObjectWrapper((GroovyObject)((EngineResponse)ScriptBytecodeAdapter.asType((Object)response, EngineResponse.class)), EngineResponse.class), (Object)callback));
            Object object = future;
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)response, (String)"taskFuture");
        }
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse stop(String containerIdOrName, Integer timeoutSeconds) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[228].call((Object)log, (Object)"docker stop");
        Object[] objectArray = new Object[2];
        objectArray[0] = "t";
        Integer n = timeoutSeconds;
        objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)n) ? n : Integer.valueOf(10);
        Map query = ScriptBytecodeAdapter.createMap((Object[])objectArray);
        Object response = callSiteArray[229].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[230].call((Object)new GStringImpl(new Object[]{containerIdOrName}, new String[]{"/containers/", "/stop"})), "query", query}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse top(String containerIdOrName, Object ps_args) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[231].call((Object)log, (Object)"docker top");
        Map query = DefaultTypeTransformation.booleanUnbox((Object)ps_args) ? ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ps_args", ps_args}) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object response = callSiteArray[232].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", new GStringImpl(new Object[]{containerIdOrName}, new String[]{"/containers/", "/top"}), "query", query}));
        callSiteArray[233].call((Object)this.responseHandler, response, callSiteArray[234].callConstructor(IllegalStateException.class, (Object)"docker top failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse unpause(Object containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[235].call((Object)log, (Object)"docker unpause");
        Object response = callSiteArray[236].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[237].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/unpause"}))}));
        callSiteArray[238].call((Object)this.responseHandler, response, callSiteArray[239].callConstructor(IllegalStateException.class, (Object)"docker unpause failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse updateContainer(String container, Object updateConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[240].call(callSiteArray[241].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{container}), updateConfig), (Object)container), EngineResponse.class);
    }

    @Override
    public Map<String, EngineResponse> updateContainers(List<String> containers, Object updateConfig) {
        Reference updateConfig2 = new Reference(updateConfig);
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[242].call((Object)log)) ? callSiteArray[243].call((Object)log, (Object)new GStringImpl(new Object[]{containers}, new String[]{"docker update '", "'"})) : null;
        public final class _updateContainers_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference updateConfig;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateContainers_closure1(Object _outerInstance, Object _thisObject, Reference updateConfig) {
                Reference reference;
                CallSite[] callSiteArray = _updateContainers_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.updateConfig = reference = updateConfig;
            }

            public Object doCall(String container) {
                CallSite[] callSiteArray = _updateContainers_closure1.$getCallSiteArray();
                Object response = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[2].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/update"})), "body", this.updateConfig.get(), "requestContentType", "application/json"}));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[3].callGetPropertySafe(callSiteArray[4].callGetProperty(response)), (Object)200)) {
                    Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this))) ? callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{container}, new String[]{"error updating container '", "': {}"}), callSiteArray[9].callGetProperty(response)) : null;
                }
                Map updateResult = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                Object object = response;
                callSiteArray[10].call((Object)updateResult, (Object)container, object);
                return updateResult;
            }

            public Object call(String container) {
                CallSite[] callSiteArray = _updateContainers_closure1.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[11].callCurrent((GroovyObject)this, (Object)container);
                }
                return this.doCall(container);
            }

            @Generated
            public Object getUpdateConfig() {
                CallSite[] callSiteArray = _updateContainers_closure1.$getCallSiteArray();
                return this.updateConfig.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateContainers_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "post";
                stringArray[1] = "client";
                stringArray[2] = "toString";
                stringArray[3] = "code";
                stringArray[4] = "status";
                stringArray[5] = "isErrorEnabled";
                stringArray[6] = "log";
                stringArray[7] = "error";
                stringArray[8] = "log";
                stringArray[9] = "content";
                stringArray[10] = "putAt";
                stringArray[11] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[12];
                _updateContainers_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateContainers_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateContainers_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Map responses = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[244].call(containers, (Object)new _updateContainers_closure1(this, this, updateConfig2)), Map.class);
        return responses;
    }

    @Override
    public EngineResponse wait(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[245].call((Object)log, (Object)"docker wait");
        Object response = callSiteArray[246].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[247].call((Object)new GStringImpl(new Object[]{containerIdOrName}, new String[]{"/containers/", "/wait"}))}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    @Generated
    public EngineResponse attach(Object containerId, Object query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.attach(containerId, query, null);
    }

    @Override
    @Generated
    public EngineResponse commit(Object container, Object query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.commit(container, query, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponse putArchive(String container, String path, InputStream archive) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.putArchive(container, path, archive, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponse createContainer(Map<String, ?> containerConfig, Map<String, ?> query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.createContainer(containerConfig, query, "");
    }

    @Override
    @Generated
    public EngineResponse createContainer(Map<String, ?> containerConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.createContainer(containerConfig, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", ""}), "");
    }

    @Override
    @Generated
    public EngineResponse startExec(Object execId, Map execConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.startExec(execId, execConfig, null);
    }

    @Override
    @Generated
    public EngineResponse exec(Object containerId, Object command) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.exec(containerId, command, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Detach", false, "AttachStdin", false, "Tty", false}));
    }

    @Override
    @Generated
    public EngineResponse logs(Object container) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.logs(container, null);
    }

    @Override
    @Generated
    public EngineResponse logs(Object container, Object query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.logs(container, query, null);
    }

    @Override
    @Generated
    public EngineResponse ps() {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.ps(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponse pruneContainers() {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.pruneContainers(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponse rm(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.rm(containerIdOrName, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public Object run(String fromImage, Object containerConfig, String tag, String name) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.run(fromImage, containerConfig, tag, name, "");
    }

    @Override
    @Generated
    public Object run(String fromImage, Object containerConfig, String tag) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.run(fromImage, containerConfig, tag, "", "");
    }

    @Override
    @Generated
    public Object run(String fromImage, Object containerConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.run(fromImage, containerConfig, "", "", "");
    }

    @Override
    @Generated
    public EngineResponse stats(Object container) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.stats(container, null);
    }

    @Override
    @Generated
    public EngineResponse stop(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.stop(containerIdOrName, 10);
        }
        return this.stop(containerIdOrName, 10);
    }

    @Override
    @Generated
    public EngineResponse top(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.top(containerIdOrName, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ManageContainerClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = ManageContainerClient.$getCallSiteArray()[248].call(LoggerFactory.class, (Object)"de.gesellix.docker.client.container.ManageContainerClient");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "info";
        stringArray[4] = "inspectContainer";
        stringArray[5] = "Tty";
        stringArray[6] = "Config";
        stringArray[7] = "content";
        stringArray[8] = "post";
        stringArray[9] = "toString";
        stringArray[10] = "Tty";
        stringArray[11] = "Config";
        stringArray[12] = "content";
        stringArray[13] = "stream";
        stringArray[14] = "info";
        stringArray[15] = "webSocket";
        stringArray[16] = "toString";
        stringArray[17] = "info";
        stringArray[18] = "post";
        stringArray[19] = "toString";
        stringArray[20] = "ensureSuccessfulResponse";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "info";
        stringArray[23] = "post";
        stringArray[24] = "ensureSuccessfulResponse";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "isInfoEnabled";
        stringArray[27] = "info";
        stringArray[28] = "head";
        stringArray[29] = "toString";
        stringArray[30] = "code";
        stringArray[31] = "status";
        stringArray[32] = "isErrorEnabled";
        stringArray[33] = "error";
        stringArray[34] = "ensureSuccessfulResponse";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "getAt";
        stringArray[37] = "headers";
        stringArray[38] = "toLowerCase";
        stringArray[39] = "error";
        stringArray[40] = "first";
        stringArray[41] = "debug";
        stringArray[42] = "parseText";
        stringArray[43] = "<$constructor$>";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "decodeBase64";
        stringArray[46] = "isInfoEnabled";
        stringArray[47] = "info";
        stringArray[48] = "getArchive";
        stringArray[49] = "extractSingleTarEntry";
        stringArray[50] = "stream";
        stringArray[51] = "isInfoEnabled";
        stringArray[52] = "info";
        stringArray[53] = "get";
        stringArray[54] = "toString";
        stringArray[55] = "code";
        stringArray[56] = "status";
        stringArray[57] = "isErrorEnabled";
        stringArray[58] = "error";
        stringArray[59] = "ensureSuccessfulResponse";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "getAt";
        stringArray[62] = "headers";
        stringArray[63] = "toLowerCase";
        stringArray[64] = "isDebugEnabled";
        stringArray[65] = "debug";
        stringArray[66] = "parseText";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "decodeBase64";
        stringArray[70] = "isInfoEnabled";
        stringArray[71] = "info";
        stringArray[72] = "put";
        stringArray[73] = "toString";
        stringArray[74] = "code";
        stringArray[75] = "status";
        stringArray[76] = "isErrorEnabled";
        stringArray[77] = "error";
        stringArray[78] = "ensureSuccessfulResponse";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "info";
        stringArray[81] = "plus";
        stringArray[82] = "post";
        stringArray[83] = "toString";
        stringArray[84] = "success";
        stringArray[85] = "status";
        stringArray[86] = "code";
        stringArray[87] = "status";
        stringArray[88] = "parseRepositoryTag";
        stringArray[89] = "Image";
        stringArray[90] = "isInfoEnabled";
        stringArray[91] = "info";
        stringArray[92] = "repo";
        stringArray[93] = "tag";
        stringArray[94] = "create";
        stringArray[95] = "repo";
        stringArray[96] = "tag";
        stringArray[97] = "post";
        stringArray[98] = "toString";
        stringArray[99] = "ensureSuccessfulResponse";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "ensureSuccessfulResponse";
        stringArray[102] = "<$constructor$>";
        stringArray[103] = "info";
        stringArray[104] = "get";
        stringArray[105] = "isInfoEnabled";
        stringArray[106] = "info";
        stringArray[107] = "post";
        stringArray[108] = "toString";
        stringArray[109] = "code";
        stringArray[110] = "status";
        stringArray[111] = "isErrorEnabled";
        stringArray[112] = "error";
        stringArray[113] = "ensureSuccessfulResponse";
        stringArray[114] = "<$constructor$>";
        stringArray[115] = "isInfoEnabled";
        stringArray[116] = "info";
        stringArray[117] = "inspectExec";
        stringArray[118] = "tty";
        stringArray[119] = "ProcessConfig";
        stringArray[120] = "content";
        stringArray[121] = "post";
        stringArray[122] = "toString";
        stringArray[123] = "code";
        stringArray[124] = "status";
        stringArray[125] = "isErrorEnabled";
        stringArray[126] = "error";
        stringArray[127] = "ensureSuccessfulResponse";
        stringArray[128] = "<$constructor$>";
        stringArray[129] = "stream";
        stringArray[130] = "isInfoEnabled";
        stringArray[131] = "info";
        stringArray[132] = "get";
        stringArray[133] = "toString";
        stringArray[134] = "code";
        stringArray[135] = "status";
        stringArray[136] = "isErrorEnabled";
        stringArray[137] = "error";
        stringArray[138] = "ensureSuccessfulResponse";
        stringArray[139] = "<$constructor$>";
        stringArray[140] = "isInfoEnabled";
        stringArray[141] = "info";
        stringArray[142] = "AttachStdin";
        stringArray[143] = "Detach";
        stringArray[144] = "Tty";
        stringArray[145] = "createExec";
        stringArray[146] = "Id";
        stringArray[147] = "content";
        stringArray[148] = "startExec";
        stringArray[149] = "info";
        stringArray[150] = "post";
        stringArray[151] = "toString";
        stringArray[152] = "ensureSuccessfulResponse";
        stringArray[153] = "<$constructor$>";
        stringArray[154] = "isInfoEnabled";
        stringArray[155] = "info";
        stringArray[156] = "get";
        stringArray[157] = "ensureSuccessfulResponse";
        stringArray[158] = "<$constructor$>";
        stringArray[159] = "info";
        stringArray[160] = "get";
        stringArray[161] = "ensureSuccessfulResponse";
        stringArray[162] = "<$constructor$>";
        stringArray[163] = "info";
        stringArray[164] = "post";
        stringArray[165] = "toString";
        stringArray[166] = "logs";
        stringArray[167] = "info";
        stringArray[168] = "applyDefaults";
        stringArray[169] = "Tty";
        stringArray[170] = "Config";
        stringArray[171] = "content";
        stringArray[172] = "inspectContainer";
        stringArray[173] = "get";
        stringArray[174] = "ensureSuccessfulResponse";
        stringArray[175] = "<$constructor$>";
        stringArray[176] = "<$constructor$>";
        stringArray[177] = "stream";
        stringArray[178] = "newSingleThreadExecutor";
        stringArray[179] = "submit";
        stringArray[180] = "<$constructor$>";
        stringArray[181] = "info";
        stringArray[182] = "applyDefaults";
        stringArray[183] = "jsonEncodeFilters";
        stringArray[184] = "get";
        stringArray[185] = "ensureSuccessfulResponse";
        stringArray[186] = "<$constructor$>";
        stringArray[187] = "info";
        stringArray[188] = "post";
        stringArray[189] = "toString";
        stringArray[190] = "ensureSuccessfulResponse";
        stringArray[191] = "<$constructor$>";
        stringArray[192] = "info";
        stringArray[193] = "jsonEncodeFilters";
        stringArray[194] = "post";
        stringArray[195] = "ensureSuccessfulResponse";
        stringArray[196] = "<$constructor$>";
        stringArray[197] = "info";
        stringArray[198] = "post";
        stringArray[199] = "toString";
        stringArray[200] = "ensureSuccessfulResponse";
        stringArray[201] = "<$constructor$>";
        stringArray[202] = "info";
        stringArray[203] = "post";
        stringArray[204] = "toString";
        stringArray[205] = "info";
        stringArray[206] = "delete";
        stringArray[207] = "toString";
        stringArray[208] = "isInfoEnabled";
        stringArray[209] = "info";
        stringArray[210] = "plus";
        stringArray[211] = "plus";
        stringArray[212] = "createContainer";
        stringArray[213] = "isDebugEnabled";
        stringArray[214] = "debug";
        stringArray[215] = "startContainer";
        stringArray[216] = "Id";
        stringArray[217] = "content";
        stringArray[218] = "info";
        stringArray[219] = "post";
        stringArray[220] = "toString";
        stringArray[221] = "info";
        stringArray[222] = "get";
        stringArray[223] = "ensureSuccessfulResponse";
        stringArray[224] = "<$constructor$>";
        stringArray[225] = "newSingleThreadExecutor";
        stringArray[226] = "submit";
        stringArray[227] = "<$constructor$>";
        stringArray[228] = "info";
        stringArray[229] = "post";
        stringArray[230] = "toString";
        stringArray[231] = "info";
        stringArray[232] = "get";
        stringArray[233] = "ensureSuccessfulResponse";
        stringArray[234] = "<$constructor$>";
        stringArray[235] = "info";
        stringArray[236] = "post";
        stringArray[237] = "toString";
        stringArray[238] = "ensureSuccessfulResponse";
        stringArray[239] = "<$constructor$>";
        stringArray[240] = "getAt";
        stringArray[241] = "updateContainers";
        stringArray[242] = "isInfoEnabled";
        stringArray[243] = "info";
        stringArray[244] = "collectEntries";
        stringArray[245] = "info";
        stringArray[246] = "post";
        stringArray[247] = "toString";
        stringArray[248] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[249];
        ManageContainerClient.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ManageContainerClient.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ManageContainerClient.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

