/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.authentication;

import com.squareup.moshi.Moshi;
import de.gesellix.docker.client.authentication.AuthConfig;
import de.gesellix.docker.client.authentication.CredsStore;
import de.gesellix.docker.client.authentication.FileStore;
import de.gesellix.docker.client.authentication.ManageAuthentication;
import de.gesellix.docker.client.authentication.NativeStore;
import de.gesellix.docker.client.distribution.ReferenceParser;
import de.gesellix.docker.client.registry.RegistryElection;
import de.gesellix.docker.client.system.ManageSystem;
import de.gesellix.docker.engine.DockerEnv;
import de.gesellix.docker.engine.EngineClient;
import de.gesellix.docker.engine.EngineResponse;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import okio.Okio;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageAuthenticationClient
implements ManageAuthentication,
GroovyObject {
    private DockerEnv env;
    private EngineClient client;
    private RegistryElection registryElection;
    private Moshi moshi;
    private String legacyDefaultDomain;
    private String defaultDomain;
    private String officialRepoName;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ManageAuthenticationClient(DockerEnv env, EngineClient client, ManageSystem manageSystem) {
        EngineClient engineClient;
        DockerEnv dockerEnv;
        MetaClass metaClass;
        String string;
        String string2;
        String string3;
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        Object object = callSiteArray[0].call(callSiteArray[1].callConstructor(Moshi.Builder.class));
        this.moshi = (Moshi)ScriptBytecodeAdapter.castToType((Object)object, Moshi.class);
        this.legacyDefaultDomain = string3 = "index.docker.io";
        this.defaultDomain = string2 = "docker.io";
        this.officialRepoName = string = "library";
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.env = dockerEnv = env;
        this.client = engineClient = client;
        Object object2 = callSiteArray[2].callConstructor(RegistryElection.class, (Object)manageSystem, (Object)this);
        this.registryElection = (RegistryElection)ScriptBytecodeAdapter.castToType((Object)object2, RegistryElection.class);
    }

    @Override
    public Map<String, AuthConfig> getAllAuthConfigs(File dockerCfg) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        Map parsedDockerCfg = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callCurrent((GroovyObject)this, (Object)dockerCfg), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)parsedDockerCfg)) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        CredsStore credsStore = (CredsStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callCurrent((GroovyObject)this, (Object)parsedDockerCfg), CredsStore.class);
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call((Object)credsStore), Map.class);
    }

    @Override
    public AuthConfig readDefaultAuthConfig() {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        return (AuthConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callCurrent((GroovyObject)this, null, callSiteArray[7].call((Object)this.env)), AuthConfig.class);
    }

    @Override
    public AuthConfig readAuthConfig(String hostname, File dockerCfg) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        callSiteArray[8].call((Object)log, (Object)"read authConfig");
        if (!DefaultTypeTransformation.booleanUnbox((Object)hostname)) {
            Object object = callSiteArray[9].callGetProperty((Object)this.env);
            hostname = ShortTypeHandling.castToString((Object)object);
        }
        Map parsedDockerCfg = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].callCurrent((GroovyObject)this, (Object)dockerCfg), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)parsedDockerCfg)) {
            return (AuthConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callGetProperty(AuthConfig.class), AuthConfig.class);
        }
        CredsStore credsStore = (CredsStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callCurrent((GroovyObject)this, (Object)parsedDockerCfg, (Object)hostname), CredsStore.class);
        return (AuthConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].call((Object)credsStore, (Object)hostname), AuthConfig.class);
    }

    public Map readDockerConfigFile(File dockerCfg) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)dockerCfg)) {
            Object object = callSiteArray[14].call((Object)this.env);
            dockerCfg = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].callSafe((Object)dockerCfg))) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].call((Object)log)) ? callSiteArray[17].call((Object)log, (Object)new GStringImpl(new Object[]{dockerCfg}, new String[]{"docker config '", "' doesn't exist"})) : null;
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[18].call((Object)log)) ? callSiteArray[19].call((Object)log, (Object)new GStringImpl(new Object[]{dockerCfg}, new String[]{"reading auth info from ", ""})) : null;
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].call(callSiteArray[21].call((Object)this.moshi, Map.class), callSiteArray[22].call(Okio.class, callSiteArray[23].call(Okio.class, (Object)dockerCfg))), Map.class);
    }

    public CredsStore getCredentialsStore(Map parsedDockerCfg, String hostname) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].call((Object)parsedDockerCfg, (Object)"credHelpers")) && DefaultTypeTransformation.booleanUnbox((Object)hostname) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[25].call(callSiteArray[26].call((Object)parsedDockerCfg, (Object)"credHelpers"), (Object)hostname))) {
            return (CredsStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].callConstructor(NativeStore.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[28].call(callSiteArray[29].call((Object)parsedDockerCfg, (Object)"credHelpers"), (Object)hostname), String.class)), String.class)), CredsStore.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[30].call((Object)parsedDockerCfg, (Object)"credsStore"))) {
            return (CredsStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callConstructor(NativeStore.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[32].call((Object)parsedDockerCfg, (Object)"credsStore"), String.class)), String.class)), CredsStore.class);
        }
        return (CredsStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].callConstructor(FileStore.class, (Object)parsedDockerCfg), CredsStore.class);
    }

    @Override
    public String encodeAuthConfig(AuthConfig authConfig) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[34].call((Object)log)) ? callSiteArray[35].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[36].callGroovyObjectGetProperty((Object)authConfig), callSiteArray[37].callGroovyObjectGetProperty((Object)authConfig)}, new String[]{"encode authConfig for ", "@", ""})) : null;
        String json = ShortTypeHandling.castToString((Object)callSiteArray[38].call(callSiteArray[39].call((Object)this.moshi, AuthConfig.class), (Object)authConfig));
        return ShortTypeHandling.castToString((Object)callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].callGetProperty((Object)json))));
    }

    @Override
    public String encodeAuthConfigs(Map<String, AuthConfig> authConfigs) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].call((Object)log)) ? callSiteArray[44].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[45].call(authConfigs)}, new String[]{"encode authConfigs for ", ""})) : null;
        String json = ShortTypeHandling.castToString((Object)callSiteArray[46].call(callSiteArray[47].call((Object)this.moshi, Map.class), authConfigs));
        return ShortTypeHandling.castToString((Object)callSiteArray[48].call(callSiteArray[49].call(callSiteArray[50].callGetProperty((Object)json))));
    }

    @Override
    public EngineResponse auth(Map authDetails) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        callSiteArray[51].call((Object)log, (Object)"docker login");
        EngineResponse response = (EngineResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", "/auth", "body", authDetails, "requestContentType", "application/json"})), EngineResponse.class);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)response, null) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[53].callGetProperty((Object)response), null) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[54].callGetProperty(callSiteArray[55].callGetProperty((Object)response)))) {
                Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].call((Object)log)) ? callSiteArray[57].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[58].callGetProperty((Object)authDetails), callSiteArray[59].callGetProperty((Object)authDetails)}, new String[]{"login failed for ", "@", ""})) : null;
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)response, null) || ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[60].callGetProperty((Object)response), null) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[61].callGetProperty(callSiteArray[62].callGetProperty((Object)response)))) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[63].call((Object)log)) ? callSiteArray[64].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[65].callGetProperty((Object)authDetails), callSiteArray[66].callGetProperty((Object)authDetails)}, new String[]{"login failed for ", "@", ""})) : null;
        }
        return response;
    }

    @Override
    public String retrieveEncodedAuthTokenForImage(String image) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        AuthConfig authConfig = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[67].callCurrent((GroovyObject)this, (Object)image);
            authConfig = (AuthConfig)ScriptBytecodeAdapter.castToType((Object)object, AuthConfig.class);
        } else {
            Object object = this.resolveAuthConfigForImage(image);
            authConfig = (AuthConfig)ScriptBytecodeAdapter.castToType((Object)object, AuthConfig.class);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[68].callCurrent((GroovyObject)this, (Object)authConfig));
    }

    public Object resolveAuthConfigForImage(String image) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[69].call((Object)"^([a-f0-9]{64})$", (Object)image))) {
            throw (Throwable)callSiteArray[70].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{image}, new String[]{"invalid repository name (", "), cannot specify 64-byte hexadecimal strings"}));
        }
        String domain = null;
        String remainder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object3 = callSiteArray[71].callCurrent((GroovyObject)this, (Object)image);
            domain = ShortTypeHandling.castToString((Object)callSiteArray[72].call(object3, (Object)0));
            remainder = ShortTypeHandling.castToString((Object)callSiteArray[73].call(object3, (Object)1));
        } else {
            Object object4 = this.splitDockerDomain(image);
            domain = ShortTypeHandling.castToString((Object)callSiteArray[74].call(object4, (Object)0));
            remainder = ShortTypeHandling.castToString((Object)callSiteArray[75].call(object4, (Object)1));
        }
        String remoteName = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[76].call((Object)remainder, (Object)":"))) {
            Object object5 = callSiteArray[77].call((Object)remainder, (Object)0, callSiteArray[78].call((Object)remainder, (Object)":"));
            remoteName = ShortTypeHandling.castToString((Object)object5);
        } else {
            String string;
            remoteName = string = remainder;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[79].call((Object)remoteName), (Object)remoteName)) {
            throw (Throwable)callSiteArray[80].callConstructor(IllegalArgumentException.class, (Object)"invalid reference format: repository name must be lowercase");
        }
        Object ref = callSiteArray[81].call(callSiteArray[82].callConstructor(ReferenceParser.class), callSiteArray[83].call(callSiteArray[84].call((Object)domain, (Object)"/"), (Object)remainder));
        Object namedRef = callSiteArray[85].callCurrent((GroovyObject)this, ref);
        Object indexName = null;
        indexName = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[86].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[87].callGetProperty(namedRef), String.class)), String.class))) : (object = this.validateIndexName((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[88].callGetProperty(namedRef), String.class)));
        Map indexInfo = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", indexName, "mirrors", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "official", false, "secure", false});
        return callSiteArray[89].call((Object)this.registryElection, callSiteArray[90].callGetProperty((Object)indexInfo), callSiteArray[91].callGetProperty((Object)indexInfo));
    }

    public Object validateIndexName(String val) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)val, (Object)"index.docker.io")) {
            String string;
            val = string = "docker.io";
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[92].call((Object)val, (Object)"-")) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[93].call((Object)val, (Object)"-"))) {
            throw (Throwable)callSiteArray[94].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{val}, new String[]{"Invalid index name (", "). Cannot begin or end with a hyphen."}));
        }
        return val;
    }

    public Object getNamed(Map ref) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[95].callGetProperty((Object)ref))) {
            return ref;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[96].callGetProperty((Object)ref)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[97].callGetProperty(callSiteArray[98].callGetProperty((Object)ref)))) {
            return callSiteArray[99].callGetProperty((Object)ref);
        }
        throw (Throwable)callSiteArray[100].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{ref}, new String[]{"reference ", " has no name"}));
    }

    public Object splitDockerDomain(String name) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        public final class _splitDockerDomain_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _splitDockerDomain_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _splitDockerDomain_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String haystack, String needles) {
                Reference haystack2 = new Reference((Object)haystack);
                CallSite[] callSiteArray = _splitDockerDomain_closure1.$getCallSiteArray();
                public final class _closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference haystack;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure2(Object _outerInstance, Object _thisObject, Reference haystack) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.haystack = reference = haystack;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        return callSiteArray[0].call(this.haystack.get(), it);
                    }

                    @Generated
                    public String getHaystack() {
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.haystack.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "contains";
                        return new CallSiteArray(_closure2.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure2.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call((Object)needles, (Object)new _closure2((Object)this, this.getThisObject(), haystack2));
            }

            public Object call(String haystack, String needles) {
                Reference haystack2 = new Reference((Object)haystack);
                CallSite[] callSiteArray = _splitDockerDomain_closure1.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[1].callCurrent((GroovyObject)this, (Object)((String)haystack2.get()), (Object)needles);
                }
                return this.doCall((String)haystack2.get(), needles);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _splitDockerDomain_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "any";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _splitDockerDomain_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_splitDockerDomain_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _splitDockerDomain_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _splitDockerDomain_closure1 containsAny = new _splitDockerDomain_closure1(this, this);
        String domain = null;
        String remainder = null;
        Object i = callSiteArray[101].call((Object)name, (Object)"/");
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)i, (Object)-1) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[102].call((Object)containsAny, callSiteArray[103].call((Object)name, (Object)0, i), (Object)".:")) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[104].call((Object)name, (Object)0, i), (Object)"localhost")) {
                List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{this.defaultDomain, name});
                domain = ShortTypeHandling.castToString((Object)callSiteArray[105].call((Object)list, (Object)0));
                remainder = ShortTypeHandling.castToString((Object)callSiteArray[106].call((Object)list, (Object)1));
            } else {
                List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[107].call((Object)name, (Object)0, i), callSiteArray[108].call((Object)name, callSiteArray[109].call(i, (Object)1))});
                domain = ShortTypeHandling.castToString((Object)callSiteArray[110].call((Object)list, (Object)0));
                remainder = ShortTypeHandling.castToString((Object)callSiteArray[111].call((Object)list, (Object)1));
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)i, (Object)-1) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[112].call((Object)containsAny, callSiteArray[113].call((Object)name, (Object)0, i), (Object)".:")) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[114].call((Object)name, (Object)0, i), (Object)"localhost")) {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{this.defaultDomain, name});
            domain = ShortTypeHandling.castToString((Object)callSiteArray[115].call((Object)list, (Object)0));
            remainder = ShortTypeHandling.castToString((Object)callSiteArray[116].call((Object)list, (Object)1));
        } else {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[117].call((Object)name, (Object)0, i), callSiteArray[118].call((Object)name, callSiteArray[119].call(i, (Object)1))});
            domain = ShortTypeHandling.castToString((Object)callSiteArray[120].call((Object)list, (Object)0));
            remainder = ShortTypeHandling.castToString((Object)callSiteArray[121].call((Object)list, (Object)1));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)domain, (Object)this.legacyDefaultDomain)) {
            String string;
            domain = string = this.defaultDomain;
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)domain, (Object)this.defaultDomain) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[122].call((Object)remainder, (Object)"/"))) {
                Object object = callSiteArray[123].call(callSiteArray[124].call((Object)this.officialRepoName, (Object)"/"), (Object)remainder);
                remainder = ShortTypeHandling.castToString((Object)object);
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)domain, (Object)this.defaultDomain) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[125].call((Object)remainder, (Object)"/"))) {
            Object object = callSiteArray[126].call(callSiteArray[127].call((Object)this.officialRepoName, (Object)"/"), (Object)remainder);
            remainder = ShortTypeHandling.castToString((Object)object);
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{domain, remainder});
    }

    @Override
    @Generated
    public Map<String, AuthConfig> getAllAuthConfigs() {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        return this.getAllAuthConfigs(null);
    }

    @Generated
    public CredsStore getCredentialsStore(Map parsedDockerCfg) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        return this.getCredentialsStore(parsedDockerCfg, "");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ManageAuthenticationClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = ManageAuthenticationClient.$getCallSiteArray()[128].call(LoggerFactory.class, (Object)"de.gesellix.docker.client.authentication.ManageAuthenticationClient");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public String getLegacyDefaultDomain() {
        return this.legacyDefaultDomain;
    }

    @Generated
    public void setLegacyDefaultDomain(String string) {
        this.legacyDefaultDomain = string;
    }

    @Generated
    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    @Generated
    public void setDefaultDomain(String string) {
        this.defaultDomain = string;
    }

    @Generated
    public String getOfficialRepoName() {
        return this.officialRepoName;
    }

    @Generated
    public void setOfficialRepoName(String string) {
        this.officialRepoName = string;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "build";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "readDockerConfigFile";
        stringArray[4] = "getCredentialsStore";
        stringArray[5] = "getAuthConfigs";
        stringArray[6] = "readAuthConfig";
        stringArray[7] = "getDockerConfigFile";
        stringArray[8] = "debug";
        stringArray[9] = "indexUrl_v1";
        stringArray[10] = "readDockerConfigFile";
        stringArray[11] = "EMPTY_AUTH_CONFIG";
        stringArray[12] = "getCredentialsStore";
        stringArray[13] = "getAuthConfig";
        stringArray[14] = "getDockerConfigFile";
        stringArray[15] = "exists";
        stringArray[16] = "isInfoEnabled";
        stringArray[17] = "info";
        stringArray[18] = "isDebugEnabled";
        stringArray[19] = "debug";
        stringArray[20] = "fromJson";
        stringArray[21] = "adapter";
        stringArray[22] = "buffer";
        stringArray[23] = "source";
        stringArray[24] = "getAt";
        stringArray[25] = "getAt";
        stringArray[26] = "getAt";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "getAt";
        stringArray[29] = "getAt";
        stringArray[30] = "getAt";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "getAt";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "isDebugEnabled";
        stringArray[35] = "debug";
        stringArray[36] = "username";
        stringArray[37] = "serveraddress";
        stringArray[38] = "toJson";
        stringArray[39] = "adapter";
        stringArray[40] = "toString";
        stringArray[41] = "encodeBase64";
        stringArray[42] = "bytes";
        stringArray[43] = "isDebugEnabled";
        stringArray[44] = "debug";
        stringArray[45] = "keySet";
        stringArray[46] = "toJson";
        stringArray[47] = "adapter";
        stringArray[48] = "toString";
        stringArray[49] = "encodeBase64";
        stringArray[50] = "bytes";
        stringArray[51] = "info";
        stringArray[52] = "post";
        stringArray[53] = "status";
        stringArray[54] = "success";
        stringArray[55] = "status";
        stringArray[56] = "isInfoEnabled";
        stringArray[57] = "info";
        stringArray[58] = "username";
        stringArray[59] = "serveraddress";
        stringArray[60] = "status";
        stringArray[61] = "success";
        stringArray[62] = "status";
        stringArray[63] = "isInfoEnabled";
        stringArray[64] = "info";
        stringArray[65] = "username";
        stringArray[66] = "serveraddress";
        stringArray[67] = "resolveAuthConfigForImage";
        stringArray[68] = "encodeAuthConfig";
        stringArray[69] = "matches";
        stringArray[70] = "<$constructor$>";
        stringArray[71] = "splitDockerDomain";
        stringArray[72] = "getAt";
        stringArray[73] = "getAt";
        stringArray[74] = "getAt";
        stringArray[75] = "getAt";
        stringArray[76] = "contains";
        stringArray[77] = "substring";
        stringArray[78] = "indexOf";
        stringArray[79] = "toLowerCase";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "parse";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "plus";
        stringArray[84] = "plus";
        stringArray[85] = "getNamed";
        stringArray[86] = "validateIndexName";
        stringArray[87] = "domain";
        stringArray[88] = "domain";
        stringArray[89] = "resolveAuthConfig";
        stringArray[90] = "name";
        stringArray[91] = "official";
        stringArray[92] = "startsWith";
        stringArray[93] = "endsWith";
        stringArray[94] = "<$constructor$>";
        stringArray[95] = "domain";
        stringArray[96] = "repo";
        stringArray[97] = "domain";
        stringArray[98] = "repo";
        stringArray[99] = "repo";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "indexOf";
        stringArray[102] = "call";
        stringArray[103] = "substring";
        stringArray[104] = "substring";
        stringArray[105] = "getAt";
        stringArray[106] = "getAt";
        stringArray[107] = "substring";
        stringArray[108] = "substring";
        stringArray[109] = "plus";
        stringArray[110] = "getAt";
        stringArray[111] = "getAt";
        stringArray[112] = "call";
        stringArray[113] = "substring";
        stringArray[114] = "substring";
        stringArray[115] = "getAt";
        stringArray[116] = "getAt";
        stringArray[117] = "substring";
        stringArray[118] = "substring";
        stringArray[119] = "plus";
        stringArray[120] = "getAt";
        stringArray[121] = "getAt";
        stringArray[122] = "contains";
        stringArray[123] = "plus";
        stringArray[124] = "plus";
        stringArray[125] = "contains";
        stringArray[126] = "plus";
        stringArray[127] = "plus";
        stringArray[128] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[129];
        ManageAuthenticationClient.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ManageAuthenticationClient.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ManageAuthenticationClient.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

