/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.container;

import de.gesellix.docker.client.DockerAsyncCallback;
import de.gesellix.docker.client.DockerAsyncConsumer;
import de.gesellix.docker.client.DockerResponseHandler;
import de.gesellix.docker.client.container.ArchiveUtil;
import de.gesellix.docker.client.container.ManageContainer;
import de.gesellix.docker.client.image.ManageImage;
import de.gesellix.docker.client.repository.RepositoryTagParser;
import de.gesellix.docker.engine.AttachConfig;
import de.gesellix.docker.engine.EngineClient;
import de.gesellix.docker.engine.EngineResponse;
import de.gesellix.docker.rawstream.RawInputStream;
import de.gesellix.util.QueryUtil;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageContainerClient
implements ManageContainer,
GroovyObject {
    private EngineClient client;
    private DockerResponseHandler responseHandler;
    private QueryUtil queryUtil;
    private ArchiveUtil archiveUtil;
    private RepositoryTagParser repositoryTagParser;
    private ManageImage manageImage;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ManageContainerClient(EngineClient client, DockerResponseHandler responseHandler, ManageImage manageImage) {
        ManageImage manageImage2;
        DockerResponseHandler dockerResponseHandler;
        EngineClient engineClient;
        MetaClass metaClass;
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.client = engineClient = client;
        this.responseHandler = dockerResponseHandler = responseHandler;
        this.manageImage = manageImage2 = manageImage;
        Object object = callSiteArray[0].callConstructor(RepositoryTagParser.class);
        this.repositoryTagParser = (RepositoryTagParser)ScriptBytecodeAdapter.castToType((Object)object, RepositoryTagParser.class);
        Object object2 = callSiteArray[1].callConstructor(QueryUtil.class);
        this.queryUtil = (QueryUtil)ScriptBytecodeAdapter.castToType((Object)object2, QueryUtil.class);
        Object object3 = callSiteArray[2].callConstructor(ArchiveUtil.class);
        this.archiveUtil = (ArchiveUtil)ScriptBytecodeAdapter.castToType((Object)object3, ArchiveUtil.class);
    }

    @Override
    public EngineResponse attach(Object containerId, Object query, AttachConfig callback) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[3].call((Object)log, (Object)"docker attach");
        Object container = callSiteArray[4].callCurrent((GroovyObject)this, containerId);
        Boolean multiplexStreams = !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(callSiteArray[7].callGetProperty(container))));
        Object response = callSiteArray[8].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[9].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/attach"})), "query", query, "attach", callback, "multiplexStreams", multiplexStreams}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callback)) {
            Boolean bl = multiplexStreams;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)callSiteArray[10].callGetProperty(response), (String)"multiplexStreams");
        }
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public WebSocket attachWebsocket(Object containerId, Object query, WebSocketListener listener) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[11].call((Object)log, (Object)"docker attach via websocket");
        WebSocket webSocket = (WebSocket)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[13].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/attach/ws"})), "query", query}), (Object)listener), WebSocket.class);
        return webSocket;
    }

    @Override
    public EngineResponse resizeTTY(Object container, Object height, Object width) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[14].call((Object)log, (Object)"docker resize container");
        Object response = callSiteArray[15].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[16].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/resize"})), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"h", height, "w", width}), "requestContentType", "text/plain"}));
        callSiteArray[17].call((Object)this.responseHandler, response, callSiteArray[18].callConstructor(IllegalStateException.class, (Object)"docker resize(tty) failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse commit(String container, Map query, Map config) {
        Map map;
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[19].call((Object)log, (Object)"docker commit");
        Map map2 = query;
        Map finalQuery = DefaultTypeTransformation.booleanUnbox((Object)map2) ? map2 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        String string = container;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)finalQuery, (String)"container");
        Map map3 = config;
        config = map = DefaultTypeTransformation.booleanUnbox((Object)map3) ? map3 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object response = callSiteArray[20].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", "/commit", "query", finalQuery, "requestContentType", "application/json", "body", config}));
        callSiteArray[21].call((Object)this.responseHandler, response, callSiteArray[22].callConstructor(IllegalStateException.class, (Object)"docker commit failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public Object getArchiveStats(Object container, Object path) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call((Object)log)) ? callSiteArray[24].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"docker archive stats ", "|", ""})) : null;
        Object response = callSiteArray[25].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[26].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/archive"})), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", path})}));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[27].callGetProperty(callSiteArray[28].callGetProperty(response)), (Object)404)) {
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[29].call((Object)log)) ? callSiteArray[30].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"no such container ", " or path ", ""})) : null;
        }
        callSiteArray[31].call((Object)this.responseHandler, response, callSiteArray[32].callConstructor(IllegalStateException.class, (Object)"docker head archive failed"));
        List pathInfo = (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[33].call(callSiteArray[34].callGetProperty(response), callSiteArray[35].call((Object)"X-Docker-Container-Path-Stat")), List.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)pathInfo)) {
            callSiteArray[36].call((Object)log, (Object)"didn't find 'X-Docker-Container-Path-Stat' header in response");
            return response;
        }
        String firstPathInfo = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[37].call((Object)pathInfo), String.class);
        callSiteArray[38].call((Object)log, (Object)firstPathInfo);
        Object decodedPathInfo = callSiteArray[39].call(callSiteArray[40].callConstructor(JsonSlurper.class), callSiteArray[41].callConstructor(String.class, callSiteArray[42].call((Object)firstPathInfo)));
        return decodedPathInfo;
    }

    @Override
    public byte[] extractFile(String container, String filename) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].call((Object)log)) ? callSiteArray[44].call((Object)log, (Object)new GStringImpl(new Object[]{filename, container}, new String[]{"extract '", "' from '", "'"})) : null;
        Object response = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[45].callCurrent((GroovyObject)this, (Object)container, (Object)filename);
            response = object2;
        } else {
            EngineResponse engineResponse;
            response = engineResponse = this.getArchive(container, filename);
        }
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].call((Object)this.archiveUtil, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((InputStream)ScriptBytecodeAdapter.asType((Object)callSiteArray[47].callGetProperty(response), InputStream.class)), InputStream.class), (Object)filename), byte[].class);
    }

    @Override
    public EngineResponse getArchive(String container, String path) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].call((Object)log)) ? callSiteArray[49].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"docker download from ", "|", ""})) : null;
        Object response = callSiteArray[50].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[51].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/archive"})), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", path})}));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[52].callGetProperty(callSiteArray[53].callGetProperty(response)), (Object)404)) {
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[54].call((Object)log)) ? callSiteArray[55].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"no such container ", " or path ", ""})) : null;
        }
        callSiteArray[56].call((Object)this.responseHandler, response, callSiteArray[57].callConstructor(IllegalStateException.class, (Object)"docker get archive failed"));
        String pathInfo = ShortTypeHandling.castToString((Object)callSiteArray[58].call(callSiteArray[59].callGetProperty(response), callSiteArray[60].call((Object)"X-Docker-Container-Path-Stat")));
        if (DefaultTypeTransformation.booleanUnbox((Object)pathInfo)) {
            Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[61].call((Object)log)) ? callSiteArray[62].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[63].call(callSiteArray[64].callConstructor(JsonSlurper.class), callSiteArray[65].callConstructor(String.class, callSiteArray[66].call((Object)pathInfo)))}, new String[]{"archiveStats: ", ""})) : null;
        }
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse putArchive(String container, String path, InputStream archive, Map<String, ?> query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[67].call((Object)log)) ? callSiteArray[68].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"docker upload to ", "|", ""})) : null;
        Map map = query;
        Map finalQuery = DefaultTypeTransformation.booleanUnbox(map) ? map : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        String string = path;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)finalQuery, (String)"path");
        Object response = callSiteArray[69].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[70].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/archive"})), "query", finalQuery, "requestContentType", "application/x-tar", "body", archive}));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[71].callGetProperty(callSiteArray[72].callGetProperty(response)), (Object)404)) {
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[73].call((Object)log)) ? callSiteArray[74].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"no such container ", " or path ", ""})) : null;
        }
        callSiteArray[75].call((Object)this.responseHandler, response, callSiteArray[76].callConstructor(IllegalStateException.class, (Object)"docker put archive failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse createContainer(Map<String, ?> containerConfig, Map<String, ?> query, String authBase64Encoded) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[77].call((Object)log, (Object)"docker create");
        Object actualContainerConfig = callSiteArray[78].call((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), containerConfig);
        Object response = callSiteArray[79].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[80].call((Object)"/containers/create"), "query", query, "body", actualContainerConfig, "requestContentType", "application/json"}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[81].callGetProperty(callSiteArray[82].callGetProperty(response)))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[83].callGetPropertySafe(callSiteArray[84].callGetProperty(response)), (Object)404)) {
                Object object;
                Object repoAndTag = callSiteArray[85].call((Object)this.repositoryTagParser, callSiteArray[86].callGetProperty(containerConfig));
                Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[87].call((Object)log)) ? callSiteArray[88].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[89].callGetProperty(repoAndTag), callSiteArray[90].callGetProperty(repoAndTag)}, new String[]{"'", ":", "' not found."})) : null;
                Object[] objectArray = new Object[2];
                objectArray[0] = "EncodedRegistryAuth";
                String string = authBase64Encoded;
                objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "";
                callSiteArray[91].call((Object)this.manageImage, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"fromImage", callSiteArray[92].callGetProperty(repoAndTag), "tag", callSiteArray[93].callGetProperty(repoAndTag)}), (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray));
                response = object = callSiteArray[94].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[95].call((Object)"/containers/create"), "query", query, "body", actualContainerConfig, "requestContentType", "application/json"}));
                callSiteArray[96].call((Object)this.responseHandler, response, callSiteArray[97].callConstructor(IllegalStateException.class, (Object)"docker create failed after retry"));
            } else {
                callSiteArray[98].call((Object)this.responseHandler, response, callSiteArray[99].callConstructor(IllegalStateException.class, (Object)"docker create failed"));
            }
        }
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse diff(Object containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[100].call((Object)log, (Object)"docker diff");
        Object response = callSiteArray[101].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[102].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/changes"}))}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse createExec(Object containerId, Map execConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[103].call((Object)log)) ? callSiteArray[104].call((Object)log, (Object)new GStringImpl(new Object[]{containerId}, new String[]{"docker create exec on '", "'"})) : null;
        Object response = callSiteArray[105].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[106].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/exec"})), "body", execConfig, "requestContentType", "application/json"}));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[107].callGetPropertySafe(callSiteArray[108].callGetProperty(response)), (Object)404)) {
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[109].call((Object)log)) ? callSiteArray[110].call((Object)log, (Object)new GStringImpl(new Object[]{containerId}, new String[]{"no such container '", "'"})) : null;
        }
        callSiteArray[111].call((Object)this.responseHandler, response, callSiteArray[112].callConstructor(IllegalStateException.class, (Object)"docker exec create failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse startExec(Object execId, Map execConfig, AttachConfig attachConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[113].call((Object)log)) ? callSiteArray[114].call((Object)log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"docker start exec '", "'"})) : null;
        Object exec = callSiteArray[115].callCurrent((GroovyObject)this, execId);
        Boolean multiplexStreams = !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[116].callGetProperty(callSiteArray[117].callGetProperty(callSiteArray[118].callGetProperty(exec))));
        Object response = callSiteArray[119].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[120].call((Object)new GStringImpl(new Object[]{execId}, new String[]{"/exec/", "/start"})), "body", execConfig, "requestContentType", "application/json", "attach", attachConfig, "multiplexStreams", multiplexStreams}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)attachConfig)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[121].callGetPropertySafe(callSiteArray[122].callGetProperty(response)), (Object)404)) {
                Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[123].call((Object)log)) ? callSiteArray[124].call((Object)log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"no such exec '", "'"})) : null;
            }
            callSiteArray[125].call((Object)this.responseHandler, response, callSiteArray[126].callConstructor(IllegalStateException.class, (Object)"docker exec start failed"));
            Boolean bl = multiplexStreams;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)callSiteArray[127].callGetProperty(response), (String)"multiplexStreams");
        }
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse inspectExec(Object execId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[128].call((Object)log)) ? callSiteArray[129].call((Object)log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"docker inspect exec '", "'"})) : null;
        Object response = callSiteArray[130].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[131].call((Object)new GStringImpl(new Object[]{execId}, new String[]{"/exec/", "/json"}))}));
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[132].callGetPropertySafe(callSiteArray[133].callGetProperty(response)), (Object)404)) {
            Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[134].call((Object)log)) ? callSiteArray[135].call((Object)log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"no such exec '", "'"})) : null;
        }
        callSiteArray[136].call((Object)this.responseHandler, response, callSiteArray[137].callConstructor(IllegalStateException.class, (Object)"docker inspect exec failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse exec(Object containerId, Object command, Map execConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[138].call((Object)log)) ? callSiteArray[139].call((Object)log, (Object)new GStringImpl(new Object[]{containerId, command}, new String[]{"docker exec '", "' '", "'"})) : null;
        Object[] objectArray = new Object[12];
        objectArray[0] = "AttachStdin";
        Object object2 = callSiteArray[140].callGetProperty((Object)execConfig);
        objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : Boolean.valueOf(false);
        objectArray[2] = "AttachStdout";
        objectArray[3] = true;
        objectArray[4] = "AttachStderr";
        objectArray[5] = true;
        objectArray[6] = "Detach";
        Object object3 = callSiteArray[141].callGetProperty((Object)execConfig);
        objectArray[7] = DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : Boolean.valueOf(false);
        objectArray[8] = "Tty";
        Object object4 = callSiteArray[142].callGetProperty((Object)execConfig);
        objectArray[9] = DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : Boolean.valueOf(false);
        objectArray[10] = "Cmd";
        objectArray[11] = command;
        Map actualExecConfig = ScriptBytecodeAdapter.createMap((Object[])objectArray);
        Object execCreateResult = callSiteArray[143].callCurrent((GroovyObject)this, containerId, (Object)actualExecConfig);
        Object execId = callSiteArray[144].callGetProperty(callSiteArray[145].callGetProperty(execCreateResult));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[146].callCurrent((GroovyObject)this, execId, (Object)actualExecConfig), EngineResponse.class);
    }

    @Override
    public EngineResponse resizeExec(Object exec, Object height, Object width) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[147].call((Object)log, (Object)"docker resize exec");
        Object response = callSiteArray[148].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[149].call((Object)new GStringImpl(new Object[]{exec}, new String[]{"/exec/", "/resize"})), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"h", height, "w", width}), "requestContentType", "text/plain"}));
        callSiteArray[150].call((Object)this.responseHandler, response, callSiteArray[151].callConstructor(IllegalStateException.class, (Object)"docker resize(exec) failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse export(Object container) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[152].call((Object)log)) ? callSiteArray[153].call((Object)log, (Object)new GStringImpl(new Object[]{container}, new String[]{"docker export ", ""})) : null;
        Object response = callSiteArray[154].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[155].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/export"}))}));
        callSiteArray[156].call((Object)this.responseHandler, response, callSiteArray[157].callConstructor(IllegalStateException.class, (Object)"docker export failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse inspectContainer(Object containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[158].call((Object)log, (Object)"docker inspect container");
        Object response = callSiteArray[159].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[160].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/json"}))}));
        callSiteArray[161].call((Object)this.responseHandler, response, callSiteArray[162].callConstructor(IllegalStateException.class, (Object)"docker inspect failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse kill(Object containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[163].call((Object)log, (Object)"docker kill");
        Object response = callSiteArray[164].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[165].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/kill"}))}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse logs(Object container, DockerAsyncCallback callback) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[166].callCurrent((GroovyObject)this, container, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (Object)callback), EngineResponse.class);
    }

    @Override
    public EngineResponse logs(Object container, Object query, DockerAsyncCallback callback) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[167].call((Object)log, (Object)"docker logs");
        Boolean async = DefaultTypeTransformation.booleanUnbox((Object)callback);
        Object object = query;
        Object actualQuery = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Map defaults = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"follow", async, "stdout", true, "stderr", true, "timestamps", false, "since", 0, "tail", "all"});
        callSiteArray[168].call((Object)this.queryUtil, actualQuery, (Object)defaults);
        Boolean multiplexStreams = !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[169].callGetProperty(callSiteArray[170].callGetProperty(callSiteArray[171].callGetProperty(callSiteArray[172].callCurrent((GroovyObject)this, container)))));
        Object response = callSiteArray[173].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[174].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/logs"})), "query", actualQuery, "async", async}));
        callSiteArray[175].call((Object)this.responseHandler, response, callSiteArray[176].callConstructor(IllegalStateException.class, (Object)"docker logs failed"));
        if (DefaultTypeTransformation.booleanUnbox((Object)async)) {
            if (DefaultTypeTransformation.booleanUnbox((Object)multiplexStreams)) {
                Object object2 = callSiteArray[177].callConstructor(RawInputStream.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((InputStream)ScriptBytecodeAdapter.asType((Object)callSiteArray[178].callGetProperty(response), InputStream.class)), InputStream.class));
                ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)response, (String)"stream");
            }
            Object executor = callSiteArray[179].callStatic(Executors.class);
            Object future = callSiteArray[180].call(executor, callSiteArray[181].callConstructor(DockerAsyncConsumer.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((EngineResponse)ScriptBytecodeAdapter.asType((Object)response, EngineResponse.class)), EngineResponse.class), (Object)callback));
            Object object3 = future;
            ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)response, (String)"taskFuture");
        }
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse ps(Map<String, ?> query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[182].call((Object)log, (Object)"docker ps");
        Map map = query;
        Map actualQuery = DefaultTypeTransformation.booleanUnbox(map) ? map : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Map defaults = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"all", true, "size", false});
        callSiteArray[183].call((Object)this.queryUtil, (Object)actualQuery, (Object)defaults);
        callSiteArray[184].call((Object)this.queryUtil, (Object)actualQuery);
        Object response = callSiteArray[185].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", "/containers/json", "query", actualQuery}));
        callSiteArray[186].call((Object)this.responseHandler, response, callSiteArray[187].callConstructor(IllegalStateException.class, (Object)"docker ps failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse pause(Object containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[188].call((Object)log, (Object)"docker pause");
        Object response = callSiteArray[189].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[190].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/pause"}))}));
        callSiteArray[191].call((Object)this.responseHandler, response, callSiteArray[192].callConstructor(IllegalStateException.class, (Object)"docker pause failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse pruneContainers(Object query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[193].call((Object)log, (Object)"docker container prune");
        Object object = query;
        Object actualQuery = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        callSiteArray[194].call((Object)this.queryUtil, actualQuery);
        Object response = callSiteArray[195].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", "/containers/prune", "query", actualQuery}));
        callSiteArray[196].call((Object)this.responseHandler, response, callSiteArray[197].callConstructor(IllegalStateException.class, (Object)"docker container prune failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse rename(String container, String newName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[198].call((Object)log, (Object)"docker rename");
        Object response = callSiteArray[199].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[200].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/rename"})), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", newName})}));
        callSiteArray[201].call((Object)this.responseHandler, response, callSiteArray[202].callConstructor(IllegalStateException.class, (Object)"docker rename failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse restart(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[203].call((Object)log, (Object)"docker restart");
        Object response = callSiteArray[204].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[205].call((Object)new GStringImpl(new Object[]{containerIdOrName}, new String[]{"/containers/", "/restart"})), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"t", 5})}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse rm(String containerIdOrName, Object query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[206].call((Object)log, (Object)"docker rm");
        Object response = callSiteArray[207].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[208].call((Object)new GStringImpl(new Object[]{containerIdOrName}, new String[]{"/containers/", ""})), "query", query}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public Object run(String fromImage, Object containerConfig, String tag, String name, String authBase64Encoded) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[209].call((Object)log)) ? callSiteArray[210].call((Object)log, (Object)new GStringImpl(new Object[]{fromImage, DefaultTypeTransformation.booleanUnbox((Object)tag) ? ":" : "", tag}, new String[]{"docker run ", "", "", ""})) : null;
        Map containerConfigWithImageName = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[211].call((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), containerConfig), Map.class);
        Object object2 = callSiteArray[212].call((Object)fromImage, DefaultTypeTransformation.booleanUnbox((Object)tag) ? new GStringImpl(new Object[]{tag}, new String[]{":", ""}) : "");
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)containerConfigWithImageName, (String)"Image");
        Object[] objectArray = new Object[2];
        objectArray[0] = "name";
        String string = name;
        objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)string) ? string : "";
        Object createContainerResponse = callSiteArray[213].callCurrent((GroovyObject)this, (Object)containerConfigWithImageName, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray), (Object)authBase64Encoded);
        Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[214].call((Object)log)) ? callSiteArray[215].call((Object)log, (Object)new GStringImpl(new Object[]{createContainerResponse}, new String[]{"create container result: ", ""})) : null;
        Object startContainerResponse = callSiteArray[216].callCurrent((GroovyObject)this, callSiteArray[217].callGetProperty(callSiteArray[218].callGetProperty(createContainerResponse)));
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"container", createContainerResponse, "status", startContainerResponse});
    }

    @Override
    public EngineResponse startContainer(Object containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[219].call((Object)log, (Object)"docker start");
        Object response = callSiteArray[220].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[221].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/start"})), "requestContentType", "application/json"}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse stats(Object container, DockerAsyncCallback callback) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[222].call((Object)log, (Object)"docker stats");
        Boolean async = DefaultTypeTransformation.booleanUnbox((Object)callback);
        Object response = callSiteArray[223].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[224].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/stats"})), "query", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"stream", async}), "async", async}));
        callSiteArray[225].call((Object)this.responseHandler, response, callSiteArray[226].callConstructor(IllegalStateException.class, (Object)"docker stats failed"));
        if (DefaultTypeTransformation.booleanUnbox((Object)async)) {
            Object executor = callSiteArray[227].callStatic(Executors.class);
            Object future = callSiteArray[228].call(executor, callSiteArray[229].callConstructor(DockerAsyncConsumer.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((EngineResponse)ScriptBytecodeAdapter.asType((Object)response, EngineResponse.class)), EngineResponse.class), (Object)callback));
            Object object = future;
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)response, (String)"taskFuture");
        }
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse stop(String containerIdOrName, Integer timeoutSeconds) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[230].call((Object)log, (Object)"docker stop");
        Object[] objectArray = new Object[2];
        objectArray[0] = "t";
        Integer n = timeoutSeconds;
        objectArray[1] = DefaultTypeTransformation.booleanUnbox((Object)n) ? n : Integer.valueOf(10);
        Map query = ScriptBytecodeAdapter.createMap((Object[])objectArray);
        Object response = callSiteArray[231].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[232].call((Object)new GStringImpl(new Object[]{containerIdOrName}, new String[]{"/containers/", "/stop"})), "query", query}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse top(String containerIdOrName, Object ps_args) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[233].call((Object)log, (Object)"docker top");
        Map query = DefaultTypeTransformation.booleanUnbox((Object)ps_args) ? ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ps_args", ps_args}) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object response = callSiteArray[234].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[235].call((Object)new GStringImpl(new Object[]{containerIdOrName}, new String[]{"/containers/", "/top"})), "query", query}));
        callSiteArray[236].call((Object)this.responseHandler, response, callSiteArray[237].callConstructor(IllegalStateException.class, (Object)"docker top failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse unpause(Object containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[238].call((Object)log, (Object)"docker unpause");
        Object response = callSiteArray[239].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[240].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/unpause"}))}));
        callSiteArray[241].call((Object)this.responseHandler, response, callSiteArray[242].callConstructor(IllegalStateException.class, (Object)"docker unpause failed"));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public EngineResponse updateContainer(String container, Object updateConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[243].call(callSiteArray[244].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{container}), updateConfig), (Object)container), EngineResponse.class);
    }

    @Override
    public Map<String, EngineResponse> updateContainers(List<String> containers, Object updateConfig) {
        Reference updateConfig2 = new Reference(updateConfig);
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[245].call((Object)log)) ? callSiteArray[246].call((Object)log, (Object)new GStringImpl(new Object[]{containers}, new String[]{"docker update '", "'"})) : null;
        Reference dockerClient = new Reference((Object)this.client);
        public final class _updateContainers_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dockerClient;
            private /* synthetic */ Reference updateConfig;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateContainers_closure1(Object _outerInstance, Object _thisObject, Reference dockerClient, Reference updateConfig) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _updateContainers_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.dockerClient = reference2 = dockerClient;
                this.updateConfig = reference = updateConfig;
            }

            public Object doCall(String container) {
                CallSite[] callSiteArray = _updateContainers_closure1.$getCallSiteArray();
                Object response = callSiteArray[0].call(this.dockerClient.get(), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[1].call((Object)new GStringImpl(new Object[]{container}, new String[]{"/containers/", "/update"})), "body", this.updateConfig.get(), "requestContentType", "application/json"}));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[2].callGetPropertySafe(callSiteArray[3].callGetProperty(response)), (Object)200)) {
                    Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call(ScriptBytecodeAdapter.getField(_updateContainers_closure1.class, ManageContainerClient.class, (String)"log"))) ? callSiteArray[5].call(ScriptBytecodeAdapter.getField(_updateContainers_closure1.class, ManageContainerClient.class, (String)"log"), (Object)new GStringImpl(new Object[]{container}, new String[]{"error updating container '", "': {}"}), callSiteArray[6].callGetProperty(response)) : null;
                }
                Map updateResult = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                Object object = response;
                callSiteArray[7].call((Object)updateResult, (Object)container, object);
                return updateResult;
            }

            public Object call(String container) {
                CallSite[] callSiteArray = _updateContainers_closure1.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[8].callCurrent((GroovyObject)this, (Object)container);
                }
                return this.doCall(container);
            }

            @Generated
            public EngineClient getDockerClient() {
                CallSite[] callSiteArray = _updateContainers_closure1.$getCallSiteArray();
                return (EngineClient)ScriptBytecodeAdapter.castToType((Object)this.dockerClient.get(), EngineClient.class);
            }

            @Generated
            public Object getUpdateConfig() {
                CallSite[] callSiteArray = _updateContainers_closure1.$getCallSiteArray();
                return this.updateConfig.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateContainers_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "post";
                stringArray[1] = "toString";
                stringArray[2] = "code";
                stringArray[3] = "status";
                stringArray[4] = "isErrorEnabled";
                stringArray[5] = "error";
                stringArray[6] = "content";
                stringArray[7] = "putAt";
                stringArray[8] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[9];
                _updateContainers_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateContainers_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateContainers_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Map responses = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[247].call(containers, (Object)new _updateContainers_closure1(this, this, dockerClient, updateConfig2)), Map.class);
        return responses;
    }

    @Override
    public EngineResponse wait(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[248].call((Object)log, (Object)"docker wait");
        Object response = callSiteArray[249].call((Object)this.client, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[250].call((Object)new GStringImpl(new Object[]{containerIdOrName}, new String[]{"/containers/", "/wait"}))}));
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    @Generated
    public EngineResponse attach(Object containerId, Object query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.attach(containerId, query, null);
    }

    @Override
    @Generated
    public EngineResponse commit(String container, Map query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.commit(container, query, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponse putArchive(String container, String path, InputStream archive) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.putArchive(container, path, archive, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponse createContainer(Map<String, ?> containerConfig, Map<String, ?> query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.createContainer(containerConfig, query, "");
    }

    @Override
    @Generated
    public EngineResponse createContainer(Map<String, ?> containerConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.createContainer(containerConfig, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", ""}), "");
    }

    @Override
    @Generated
    public EngineResponse startExec(Object execId, Map execConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.startExec(execId, execConfig, null);
    }

    @Override
    @Generated
    public EngineResponse exec(Object containerId, Object command) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.exec(containerId, command, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Detach", false, "AttachStdin", false, "Tty", false}));
    }

    @Override
    @Generated
    public EngineResponse logs(Object container) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.logs(container, null);
    }

    @Override
    @Generated
    public EngineResponse logs(Object container, Object query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.logs(container, query, null);
    }

    @Override
    @Generated
    public EngineResponse ps() {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.ps(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponse pruneContainers() {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.pruneContainers(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponse rm(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.rm(containerIdOrName, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public Object run(String fromImage, Object containerConfig, String tag, String name) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.run(fromImage, containerConfig, tag, name, "");
    }

    @Override
    @Generated
    public Object run(String fromImage, Object containerConfig, String tag) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.run(fromImage, containerConfig, tag, "", "");
    }

    @Override
    @Generated
    public Object run(String fromImage, Object containerConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.run(fromImage, containerConfig, "", "", "");
    }

    @Override
    @Generated
    public EngineResponse stats(Object container) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.stats(container, null);
    }

    @Override
    @Generated
    public EngineResponse stop(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.stop(containerIdOrName, 10);
        }
        return this.stop(containerIdOrName, 10);
    }

    @Override
    @Generated
    public EngineResponse top(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.top(containerIdOrName, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ManageContainerClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = ManageContainerClient.$getCallSiteArray()[251].call(LoggerFactory.class, (Object)"de.gesellix.docker.client.container.ManageContainerClient");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "info";
        stringArray[4] = "inspectContainer";
        stringArray[5] = "Tty";
        stringArray[6] = "Config";
        stringArray[7] = "content";
        stringArray[8] = "post";
        stringArray[9] = "toString";
        stringArray[10] = "stream";
        stringArray[11] = "info";
        stringArray[12] = "webSocket";
        stringArray[13] = "toString";
        stringArray[14] = "info";
        stringArray[15] = "post";
        stringArray[16] = "toString";
        stringArray[17] = "ensureSuccessfulResponse";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "info";
        stringArray[20] = "post";
        stringArray[21] = "ensureSuccessfulResponse";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "isInfoEnabled";
        stringArray[24] = "info";
        stringArray[25] = "head";
        stringArray[26] = "toString";
        stringArray[27] = "code";
        stringArray[28] = "status";
        stringArray[29] = "isErrorEnabled";
        stringArray[30] = "error";
        stringArray[31] = "ensureSuccessfulResponse";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "getAt";
        stringArray[34] = "headers";
        stringArray[35] = "toLowerCase";
        stringArray[36] = "error";
        stringArray[37] = "first";
        stringArray[38] = "debug";
        stringArray[39] = "parseText";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "<$constructor$>";
        stringArray[42] = "decodeBase64";
        stringArray[43] = "isInfoEnabled";
        stringArray[44] = "info";
        stringArray[45] = "getArchive";
        stringArray[46] = "extractSingleTarEntry";
        stringArray[47] = "stream";
        stringArray[48] = "isInfoEnabled";
        stringArray[49] = "info";
        stringArray[50] = "get";
        stringArray[51] = "toString";
        stringArray[52] = "code";
        stringArray[53] = "status";
        stringArray[54] = "isErrorEnabled";
        stringArray[55] = "error";
        stringArray[56] = "ensureSuccessfulResponse";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "getAt";
        stringArray[59] = "headers";
        stringArray[60] = "toLowerCase";
        stringArray[61] = "isDebugEnabled";
        stringArray[62] = "debug";
        stringArray[63] = "parseText";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "decodeBase64";
        stringArray[67] = "isInfoEnabled";
        stringArray[68] = "info";
        stringArray[69] = "put";
        stringArray[70] = "toString";
        stringArray[71] = "code";
        stringArray[72] = "status";
        stringArray[73] = "isErrorEnabled";
        stringArray[74] = "error";
        stringArray[75] = "ensureSuccessfulResponse";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "info";
        stringArray[78] = "plus";
        stringArray[79] = "post";
        stringArray[80] = "toString";
        stringArray[81] = "success";
        stringArray[82] = "status";
        stringArray[83] = "code";
        stringArray[84] = "status";
        stringArray[85] = "parseRepositoryTag";
        stringArray[86] = "Image";
        stringArray[87] = "isInfoEnabled";
        stringArray[88] = "info";
        stringArray[89] = "repo";
        stringArray[90] = "tag";
        stringArray[91] = "create";
        stringArray[92] = "repo";
        stringArray[93] = "tag";
        stringArray[94] = "post";
        stringArray[95] = "toString";
        stringArray[96] = "ensureSuccessfulResponse";
        stringArray[97] = "<$constructor$>";
        stringArray[98] = "ensureSuccessfulResponse";
        stringArray[99] = "<$constructor$>";
        stringArray[100] = "info";
        stringArray[101] = "get";
        stringArray[102] = "toString";
        stringArray[103] = "isInfoEnabled";
        stringArray[104] = "info";
        stringArray[105] = "post";
        stringArray[106] = "toString";
        stringArray[107] = "code";
        stringArray[108] = "status";
        stringArray[109] = "isErrorEnabled";
        stringArray[110] = "error";
        stringArray[111] = "ensureSuccessfulResponse";
        stringArray[112] = "<$constructor$>";
        stringArray[113] = "isInfoEnabled";
        stringArray[114] = "info";
        stringArray[115] = "inspectExec";
        stringArray[116] = "tty";
        stringArray[117] = "ProcessConfig";
        stringArray[118] = "content";
        stringArray[119] = "post";
        stringArray[120] = "toString";
        stringArray[121] = "code";
        stringArray[122] = "status";
        stringArray[123] = "isErrorEnabled";
        stringArray[124] = "error";
        stringArray[125] = "ensureSuccessfulResponse";
        stringArray[126] = "<$constructor$>";
        stringArray[127] = "stream";
        stringArray[128] = "isInfoEnabled";
        stringArray[129] = "info";
        stringArray[130] = "get";
        stringArray[131] = "toString";
        stringArray[132] = "code";
        stringArray[133] = "status";
        stringArray[134] = "isErrorEnabled";
        stringArray[135] = "error";
        stringArray[136] = "ensureSuccessfulResponse";
        stringArray[137] = "<$constructor$>";
        stringArray[138] = "isInfoEnabled";
        stringArray[139] = "info";
        stringArray[140] = "AttachStdin";
        stringArray[141] = "Detach";
        stringArray[142] = "Tty";
        stringArray[143] = "createExec";
        stringArray[144] = "Id";
        stringArray[145] = "content";
        stringArray[146] = "startExec";
        stringArray[147] = "info";
        stringArray[148] = "post";
        stringArray[149] = "toString";
        stringArray[150] = "ensureSuccessfulResponse";
        stringArray[151] = "<$constructor$>";
        stringArray[152] = "isInfoEnabled";
        stringArray[153] = "info";
        stringArray[154] = "get";
        stringArray[155] = "toString";
        stringArray[156] = "ensureSuccessfulResponse";
        stringArray[157] = "<$constructor$>";
        stringArray[158] = "info";
        stringArray[159] = "get";
        stringArray[160] = "toString";
        stringArray[161] = "ensureSuccessfulResponse";
        stringArray[162] = "<$constructor$>";
        stringArray[163] = "info";
        stringArray[164] = "post";
        stringArray[165] = "toString";
        stringArray[166] = "logs";
        stringArray[167] = "info";
        stringArray[168] = "applyDefaults";
        stringArray[169] = "Tty";
        stringArray[170] = "Config";
        stringArray[171] = "content";
        stringArray[172] = "inspectContainer";
        stringArray[173] = "get";
        stringArray[174] = "toString";
        stringArray[175] = "ensureSuccessfulResponse";
        stringArray[176] = "<$constructor$>";
        stringArray[177] = "<$constructor$>";
        stringArray[178] = "stream";
        stringArray[179] = "newSingleThreadExecutor";
        stringArray[180] = "submit";
        stringArray[181] = "<$constructor$>";
        stringArray[182] = "info";
        stringArray[183] = "applyDefaults";
        stringArray[184] = "jsonEncodeFilters";
        stringArray[185] = "get";
        stringArray[186] = "ensureSuccessfulResponse";
        stringArray[187] = "<$constructor$>";
        stringArray[188] = "info";
        stringArray[189] = "post";
        stringArray[190] = "toString";
        stringArray[191] = "ensureSuccessfulResponse";
        stringArray[192] = "<$constructor$>";
        stringArray[193] = "info";
        stringArray[194] = "jsonEncodeFilters";
        stringArray[195] = "post";
        stringArray[196] = "ensureSuccessfulResponse";
        stringArray[197] = "<$constructor$>";
        stringArray[198] = "info";
        stringArray[199] = "post";
        stringArray[200] = "toString";
        stringArray[201] = "ensureSuccessfulResponse";
        stringArray[202] = "<$constructor$>";
        stringArray[203] = "info";
        stringArray[204] = "post";
        stringArray[205] = "toString";
        stringArray[206] = "info";
        stringArray[207] = "delete";
        stringArray[208] = "toString";
        stringArray[209] = "isInfoEnabled";
        stringArray[210] = "info";
        stringArray[211] = "plus";
        stringArray[212] = "plus";
        stringArray[213] = "createContainer";
        stringArray[214] = "isDebugEnabled";
        stringArray[215] = "debug";
        stringArray[216] = "startContainer";
        stringArray[217] = "Id";
        stringArray[218] = "content";
        stringArray[219] = "info";
        stringArray[220] = "post";
        stringArray[221] = "toString";
        stringArray[222] = "info";
        stringArray[223] = "get";
        stringArray[224] = "toString";
        stringArray[225] = "ensureSuccessfulResponse";
        stringArray[226] = "<$constructor$>";
        stringArray[227] = "newSingleThreadExecutor";
        stringArray[228] = "submit";
        stringArray[229] = "<$constructor$>";
        stringArray[230] = "info";
        stringArray[231] = "post";
        stringArray[232] = "toString";
        stringArray[233] = "info";
        stringArray[234] = "get";
        stringArray[235] = "toString";
        stringArray[236] = "ensureSuccessfulResponse";
        stringArray[237] = "<$constructor$>";
        stringArray[238] = "info";
        stringArray[239] = "post";
        stringArray[240] = "toString";
        stringArray[241] = "ensureSuccessfulResponse";
        stringArray[242] = "<$constructor$>";
        stringArray[243] = "getAt";
        stringArray[244] = "updateContainers";
        stringArray[245] = "isInfoEnabled";
        stringArray[246] = "info";
        stringArray[247] = "collectEntries";
        stringArray[248] = "info";
        stringArray[249] = "post";
        stringArray[250] = "toString";
        stringArray[251] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[252];
        ManageContainerClient.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ManageContainerClient.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ManageContainerClient.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

