/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.authentication;

import de.gesellix.docker.authentication.AuthConfig;
import de.gesellix.docker.authentication.AuthConfigReader;
import de.gesellix.docker.engine.DockerEnv;
import de.gesellix.docker.remote.api.SystemInfo;
import de.gesellix.docker.remote.api.client.SystemApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryElection {
    private static final Logger log = LoggerFactory.getLogger(RegistryElection.class);
    private final SystemApi systemApi;
    private final AuthConfigReader authConfigReader;

    public RegistryElection(SystemApi systemApi, AuthConfigReader authConfigReader) {
        this.systemApi = systemApi;
        this.authConfigReader = authConfigReader;
    }

    public AuthConfig resolveAuthConfig(String indexName, boolean officialIndex) {
        String configKey = indexName;
        if (officialIndex) {
            configKey = this.electAuthServer();
        }
        return this.authConfigReader.readAuthConfig(configKey, null);
    }

    public String electAuthServer() {
        String defaultServerAddress = new DockerEnv().getIndexUrl_v1();
        try {
            SystemInfo info = this.systemApi.systemInfo();
            if (info != null && info.getIndexServerAddress() != null && !info.getIndexServerAddress().isEmpty()) {
                return info.getIndexServerAddress();
            }
            log.warn("Empty registry endpoint from daemon. Using system default: " + defaultServerAddress);
        }
        catch (Exception e) {
            log.warn("Failed to get default registry endpoint from daemon. Using system default: " + defaultServerAddress, (Throwable)e);
        }
        return defaultServerAddress;
    }
}

