/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.container;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.container.ArchiveUtil;
import de.gesellix.docker.client.container.DockerResponseHandler;
import de.gesellix.docker.client.container.ManageContainer;
import de.gesellix.docker.client.repository.RepositoryTagParser;
import de.gesellix.docker.engine.AttachConfig;
import de.gesellix.docker.engine.EngineClient;
import de.gesellix.docker.engine.EngineResponse;
import de.gesellix.docker.remote.api.ContainerChangeResponseItem;
import de.gesellix.docker.remote.api.ContainerConfig;
import de.gesellix.docker.remote.api.ContainerCreateRequest;
import de.gesellix.docker.remote.api.ContainerCreateResponse;
import de.gesellix.docker.remote.api.ContainerInspectResponse;
import de.gesellix.docker.remote.api.ContainerPruneResponse;
import de.gesellix.docker.remote.api.ContainerTopResponse;
import de.gesellix.docker.remote.api.ContainerUpdateRequest;
import de.gesellix.docker.remote.api.ContainerUpdateResponse;
import de.gesellix.docker.remote.api.ContainerWaitResponse;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.ExecConfig;
import de.gesellix.docker.remote.api.ExecInspectResponse;
import de.gesellix.docker.remote.api.ExecStartConfig;
import de.gesellix.docker.remote.api.HealthConfig;
import de.gesellix.docker.remote.api.IdResponse;
import de.gesellix.docker.remote.api.core.ClientException;
import de.gesellix.docker.remote.api.core.Frame;
import de.gesellix.docker.remote.api.core.StreamCallback;
import de.gesellix.util.QueryUtil;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageContainerClient
implements ManageContainer,
GroovyObject {
    private EngineApiClient client;
    private EngineClient engineClient;
    private DockerResponseHandler responseHandler;
    private QueryUtil queryUtil;
    private ArchiveUtil archiveUtil;
    private RepositoryTagParser repositoryTagParser;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ManageContainerClient(EngineApiClient client, EngineClient engineClient) {
        EngineClient engineClient2;
        EngineApiClient engineApiClient;
        MetaClass metaClass;
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.client = engineApiClient = client;
        this.engineClient = engineClient2 = engineClient;
        Object object = callSiteArray[0].callConstructor(DockerResponseHandler.class);
        this.responseHandler = (DockerResponseHandler)ScriptBytecodeAdapter.castToType((Object)object, DockerResponseHandler.class);
        Object object2 = callSiteArray[1].callConstructor(RepositoryTagParser.class);
        this.repositoryTagParser = (RepositoryTagParser)ScriptBytecodeAdapter.castToType((Object)object2, RepositoryTagParser.class);
        Object object3 = callSiteArray[2].callConstructor(QueryUtil.class);
        this.queryUtil = (QueryUtil)ScriptBytecodeAdapter.castToType((Object)object3, QueryUtil.class);
        Object object4 = callSiteArray[3].callConstructor(ArchiveUtil.class);
        this.archiveUtil = (ArchiveUtil)ScriptBytecodeAdapter.castToType((Object)object4, ArchiveUtil.class);
    }

    @Override
    public EngineResponse attach(String containerId, Map<String, Object> query, AttachConfig callback) {
        boolean bl;
        boolean bl2;
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[4].call((Object)log, (Object)"docker attach");
        EngineResponseContent container = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[5].callCurrent((GroovyObject)this, (Object)containerId);
            container = (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)object, EngineResponseContent.class));
        } else {
            EngineResponseContent engineResponseContent;
            container = engineResponseContent = this.inspectContainer(containerId);
        }
        boolean multiplexStreams = false;
        multiplexStreams = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (bl2 = !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callGetProperty(callSiteArray[7].callGetProperty(callSiteArray[8].callGetProperty((Object)container))))) : (bl = !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callGetProperty(callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty((Object)container)))));
        Object response = callSiteArray[12].call((Object)this.engineClient, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[13].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/attach"})), "query", query, "attach", callback, "multiplexStreams", multiplexStreams}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callback)) {
            boolean bl3 = multiplexStreams;
            ScriptBytecodeAdapter.setProperty((Object)bl3, null, (Object)callSiteArray[14].callGetProperty(response), (String)"multiplexStreams");
        }
        return (EngineResponse)ScriptBytecodeAdapter.castToType((Object)response, EngineResponse.class);
    }

    @Override
    public void attach(String containerId, String detachKeys, Boolean logs, Boolean stream, Boolean stdin, Boolean stdout, Boolean stderr, StreamCallback<Frame> callback, Duration timeout) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[15].call((Object)log, (Object)"docker attach");
        callSiteArray[16].call(callSiteArray[17].callGetProperty((Object)this.client), ArrayUtil.createArray((Object)containerId, (Object)detachKeys, (Object)logs, (Object)stream, (Object)stdin, (Object)stdout, (Object)stderr, callback, (Object)callSiteArray[18].call((Object)timeout)));
    }

    @Override
    public WebSocket attachWebsocket(String containerId, Map<String, Object> query, WebSocketListener listener) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[19].call((Object)log, (Object)"docker attach via websocket");
        WebSocket webSocket = (WebSocket)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].call((Object)this.engineClient, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[21].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/attach/ws"})), "query", query}), (Object)listener), WebSocket.class);
        return webSocket;
    }

    @Override
    public void resizeTTY(String container, Integer height, Integer width) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[22].call((Object)log, (Object)"docker resize container");
        callSiteArray[23].call(callSiteArray[24].callGetProperty((Object)this.client), (Object)container, (Object)height, (Object)width);
    }

    @Override
    public EngineResponseContent<IdResponse> commit(String container, Map query, Map config) {
        Map map;
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[25].call((Object)log, (Object)"docker commit");
        Map map2 = query;
        Map finalQuery = DefaultTypeTransformation.booleanUnbox((Object)map2) ? map2 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        String string = container;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)finalQuery, (String)"container");
        Map map3 = config;
        config = map = DefaultTypeTransformation.booleanUnbox((Object)map3) ? map3 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        IdResponse imageCommit = (IdResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].call(callSiteArray[27].callGetProperty((Object)this.client), ArrayUtil.createArray((Object)container, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[28].callGetProperty((Object)query), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[29].callGetProperty((Object)query), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[30].callGetProperty((Object)query), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[31].callGetProperty((Object)query), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[32].callGetProperty((Object)query), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[33].callGetProperty((Object)query), String.class)), String.class), (Object)callSiteArray[34].callConstructor(ContainerConfig.class, ArrayUtil.createArray((Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[35].callGetProperty((Object)config), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[36].callGetProperty((Object)config), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[37].callGetProperty((Object)config), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[38].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[39].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[40].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.asType((Object)callSiteArray[41].callGetProperty((Object)config), Map.class)), Map.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[42].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[43].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[44].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((List)ScriptBytecodeAdapter.asType((Object)callSiteArray[45].callGetProperty((Object)config), List.class)), List.class), (Object)(callSiteArray[46].callGetProperty((Object)config) instanceof String ? ScriptBytecodeAdapter.createList((Object[])new Object[]{(String)ScriptBytecodeAdapter.asType((Object)callSiteArray[47].callGetProperty((Object)config), String.class)}) : (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[48].callGetProperty((Object)config), List.class)), (Object)callSiteArray[49].callConstructor(HealthConfig.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[50].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[51].callGetProperty((Object)config), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.asType((Object)callSiteArray[52].callGetProperty((Object)config), Map.class)), Map.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[53].callGetProperty((Object)config), String.class)), String.class), (Object)(callSiteArray[54].callGetProperty((Object)config) instanceof String ? ScriptBytecodeAdapter.createList((Object[])new Object[]{(String)ScriptBytecodeAdapter.asType((Object)callSiteArray[55].callGetProperty((Object)config), String.class)}) : (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[56].callGetProperty((Object)config), List.class)), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[57].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[58].callGetProperty((Object)config), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((List)ScriptBytecodeAdapter.asType((Object)callSiteArray[59].callGetProperty((Object)config), List.class)), List.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.asType((Object)callSiteArray[60].callGetProperty((Object)config), Map.class)), Map.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[61].callGetProperty((Object)config), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[62].callGetProperty((Object)config), Integer.class)), Integer.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((List)ScriptBytecodeAdapter.asType((Object)callSiteArray[63].callGetProperty((Object)config), List.class)), List.class))))), IdResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].callConstructor(EngineResponseContent.class, (Object)imageCommit), EngineResponseContent.class));
    }

    @Override
    public EngineResponseContent<Map<String, Object>> getArchiveStats(String container, String path) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[65].call((Object)log)) ? callSiteArray[66].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"docker archive stats ", "|", ""})) : null;
        Map archiveInfo = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[67].call(callSiteArray[68].callGetProperty((Object)this.client), (Object)container, (Object)path), Map.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].callConstructor(EngineResponseContent.class, (Object)archiveInfo), EngineResponseContent.class));
    }

    @Override
    public byte[] extractFile(String container, String filename) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[70].call((Object)log)) ? callSiteArray[71].call((Object)log, (Object)new GStringImpl(new Object[]{filename, container}, new String[]{"extract '", "' from '", "'"})) : null;
        EngineResponseContent response = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[72].callCurrent((GroovyObject)this, (Object)container, (Object)filename);
            response = (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)object2, EngineResponseContent.class));
        } else {
            EngineResponseContent engineResponseContent;
            response = engineResponseContent = this.getArchive(container, filename);
        }
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[73].call((Object)this.archiveUtil, callSiteArray[74].callGetProperty((Object)response), (Object)filename), byte[].class);
    }

    @Override
    public EngineResponseContent<InputStream> getArchive(String container, String path) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[75].call((Object)log)) ? callSiteArray[76].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"docker download from ", "|", ""})) : null;
        InputStream archive = (InputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[77].call(callSiteArray[78].callGetProperty((Object)this.client), (Object)container, (Object)path), InputStream.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].callConstructor(EngineResponseContent.class, (Object)archive), EngineResponseContent.class));
    }

    @Override
    public void putArchive(String container, String path, InputStream archive) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[80].call((Object)log)) ? callSiteArray[81].call((Object)log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"docker upload to ", "|", ""})) : null;
        callSiteArray[82].call(callSiteArray[83].callGetProperty((Object)this.client), ArrayUtil.createArray((Object)container, (Object)path, (Object)archive, null, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public EngineResponseContent<ContainerCreateResponse> createContainer(ContainerCreateRequest containerCreateRequest, String name, String authBase64Encoded) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[84].call((Object)log, (Object)"docker create");
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[85].callGetProperty((Object)containerCreateRequest))) {
            throw (Throwable)callSiteArray[86].callConstructor(IllegalArgumentException.class, (Object)"'Image' missing in containerCreateRequest");
        }
        ContainerCreateResponse containerCreate = (ContainerCreateResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].call(callSiteArray[88].callGetProperty((Object)this.client), (Object)containerCreateRequest, (Object)name), ContainerCreateResponse.class);
        EngineResponseContent engineResponseContent = (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].callConstructor(EngineResponseContent.class, (Object)containerCreate), EngineResponseContent.class));
        try {
            return engineResponseContent;
        }
        catch (ClientException exception) {
            if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[90].callGetProperty((Object)exception), (Object)404)) throw (Throwable)exception;
            Map repoAndTag = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].call((Object)this.repositoryTagParser, callSiteArray[92].callGetProperty((Object)containerCreateRequest)), Map.class);
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[93].call((Object)log)) ? callSiteArray[94].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[95].callGetProperty((Object)repoAndTag), callSiteArray[96].callGetProperty((Object)repoAndTag)}, new String[]{"'", ":", "' not found locally."})) : null;
            callSiteArray[97].call(callSiteArray[98].callGetProperty((Object)this.client), ArrayUtil.createArray((Object)callSiteArray[99].callGetProperty((Object)repoAndTag), null, null, (Object)callSiteArray[100].callGetProperty((Object)repoAndTag), null, (Object)authBase64Encoded, null, null, null));
            ContainerCreateResponse containerCreateWithPulledImage = (ContainerCreateResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[101].call(callSiteArray[102].callGetProperty((Object)this.client), (Object)containerCreateRequest, (Object)name), ContainerCreateResponse.class);
            EngineResponseContent engineResponseContent2 = (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[103].callConstructor(EngineResponseContent.class, (Object)containerCreateWithPulledImage), EngineResponseContent.class));
            return engineResponseContent2;
        }
    }

    @Override
    public EngineResponseContent<List<ContainerChangeResponseItem>> diff(String containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[104].call((Object)log, (Object)"docker diff");
        List containerChanges = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].call(callSiteArray[106].callGetProperty((Object)this.client), (Object)containerId), List.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[107].callConstructor(EngineResponseContent.class, (Object)containerChanges), EngineResponseContent.class));
    }

    @Override
    public EngineResponseContent<IdResponse> createExec(String containerId, ExecConfig execConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[108].call((Object)log)) ? callSiteArray[109].call((Object)log, (Object)new GStringImpl(new Object[]{containerId}, new String[]{"docker create exec on '", "'"})) : null;
        IdResponse containerExec = (IdResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[110].call(callSiteArray[111].callGetProperty((Object)this.client), (Object)containerId, (Object)execConfig), IdResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[112].callConstructor(EngineResponseContent.class, (Object)containerExec), EngineResponseContent.class));
    }

    @Override
    public void startExec(String execId, ExecStartConfig execStartConfig, AttachConfig attachConfig) {
        boolean bl;
        boolean bl2;
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[113].call((Object)log)) ? callSiteArray[114].call((Object)log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"docker start exec '", "'"})) : null;
        Object execInspect = callSiteArray[115].call(callSiteArray[116].callGetProperty((Object)this.client), (Object)execId);
        boolean multiplexStreams = false;
        multiplexStreams = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (bl2 = !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[117].callGetProperty(callSiteArray[118].callGetProperty(execInspect)))) : (bl = !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[119].callGetProperty(callSiteArray[120].callGetProperty(execInspect))));
        Object response = callSiteArray[121].call((Object)this.engineClient, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[122].call((Object)new GStringImpl(new Object[]{execId}, new String[]{"/exec/", "/start"})), "body", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Detach", callSiteArray[123].callGetProperty((Object)execStartConfig), "Tty", callSiteArray[124].callGetProperty((Object)execStartConfig)}), "requestContentType", "application/json", "attach", attachConfig, "multiplexStreams", multiplexStreams}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)attachConfig)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[125].callGetPropertySafe(callSiteArray[126].callGetProperty(response)), (Object)404)) {
                Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[127].call((Object)log)) ? callSiteArray[128].call((Object)log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"no such exec '", "'"})) : null;
            }
            callSiteArray[129].call((Object)this.responseHandler, response, callSiteArray[130].callConstructor(IllegalStateException.class, (Object)"docker exec start failed"));
            boolean bl3 = multiplexStreams;
            ScriptBytecodeAdapter.setProperty((Object)bl3, null, (Object)callSiteArray[131].callGetProperty(response), (String)"multiplexStreams");
        }
    }

    @Override
    public void startExec(String execId, ExecStartConfig execStartConfig, StreamCallback<Frame> callback, Duration timeout) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[132].call((Object)log)) ? callSiteArray[133].call((Object)log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"docker start exec '", "'"})) : null;
        callSiteArray[134].call(callSiteArray[135].callGetProperty((Object)this.client), (Object)execId, (Object)execStartConfig, callback, callSiteArray[136].callSafe((Object)timeout));
    }

    @Override
    public EngineResponseContent<ExecInspectResponse> inspectExec(String execId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[137].call((Object)log)) ? callSiteArray[138].call((Object)log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"docker inspect exec '", "'"})) : null;
        ExecInspectResponse execInspect = (ExecInspectResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[139].call(callSiteArray[140].callGetProperty((Object)this.client), (Object)execId), ExecInspectResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[141].callConstructor(EngineResponseContent.class, (Object)execInspect), EngineResponseContent.class));
    }

    @Override
    public EngineResponseContent<IdResponse> exec(String containerId, List<String> command, StreamCallback<Frame> callback, Duration timeout, Map<String, Object> execConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[142].call((Object)log)) ? callSiteArray[143].call((Object)log, (Object)new GStringImpl(new Object[]{containerId, command}, new String[]{"docker exec '", "' '", "'"})) : null;
        Object object2 = callSiteArray[145].callGetProperty(execConfig);
        Object object3 = callSiteArray[146].callGetProperty(execConfig);
        Object actualExecConfig = callSiteArray[144].callConstructor(ExecConfig.class, ArrayUtil.createArray((Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : Boolean.valueOf(false)), Boolean.class)), Boolean.class), (Object)true, (Object)true, null, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : Boolean.valueOf(false)), Boolean.class)), Boolean.class), null, command, null, null, null));
        EngineResponseContent execCreateResult = (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[147].callCurrent((GroovyObject)this, (Object)containerId, actualExecConfig), EngineResponseContent.class));
        String execId = ShortTypeHandling.castToString((Object)callSiteArray[148].callGetProperty(callSiteArray[149].callGetProperty((Object)execCreateResult)));
        Object object4 = callSiteArray[151].callGetProperty(execConfig);
        Object execStartConfig = callSiteArray[150].callConstructor(ExecStartConfig.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object4) ? object4 : Boolean.valueOf(false)), Boolean.class)), Boolean.class), callSiteArray[152].callGetProperty(actualExecConfig));
        callSiteArray[153].callCurrent((GroovyObject)this, (Object)execId, execStartConfig, callback, (Object)timeout);
        return execCreateResult;
    }

    @Override
    public void resizeExec(String exec, Integer height, Integer width) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[154].call((Object)log, (Object)"docker resize exec");
        callSiteArray[155].call(callSiteArray[156].callGetProperty((Object)this.client), (Object)exec, (Object)height, (Object)width);
    }

    @Override
    public EngineResponseContent<InputStream> export(String container) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[157].call((Object)log)) ? callSiteArray[158].call((Object)log, (Object)new GStringImpl(new Object[]{container}, new String[]{"docker export ", ""})) : null;
        InputStream containerExport = (InputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[159].call(callSiteArray[160].callGetProperty((Object)this.client), (Object)container), InputStream.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[161].callConstructor(EngineResponseContent.class, (Object)containerExport), EngineResponseContent.class));
    }

    @Override
    public EngineResponseContent<ContainerInspectResponse> inspectContainer(String containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[162].call((Object)log, (Object)"docker inspect container");
        ContainerInspectResponse containerInspect = (ContainerInspectResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[163].call(callSiteArray[164].callGetProperty((Object)this.client), (Object)containerId, null), ContainerInspectResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[165].callConstructor(EngineResponseContent.class, (Object)containerInspect), EngineResponseContent.class));
    }

    @Override
    public void kill(String containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[166].call((Object)log, (Object)"docker kill");
        callSiteArray[167].call(callSiteArray[168].callGetProperty((Object)this.client), (Object)containerId, null);
    }

    @Override
    public void logs(String container, Map<String, Object> query, StreamCallback<Frame> callback, Duration timeout) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[169].call((Object)log, (Object)"docker logs");
        Map actualQuery = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox(query)) {
            callSiteArray[170].call((Object)actualQuery, query);
        }
        Map defaults = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"follow", true, "stdout", true, "stderr", true, "timestamps", false, "since", 0, "tail", "all"});
        callSiteArray[171].call((Object)this.queryUtil, (Object)actualQuery, (Object)defaults);
        callSiteArray[172].call(callSiteArray[173].callGetProperty((Object)this.client), ArrayUtil.createArray((Object)container, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[174].callGetProperty((Object)actualQuery), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[175].callGetProperty((Object)actualQuery), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[176].callGetProperty((Object)actualQuery), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[177].callGetProperty((Object)actualQuery), Integer.class)), Integer.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[178].callGetProperty((Object)actualQuery), Integer.class)), Integer.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[179].callGetProperty((Object)actualQuery), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[180].callGetProperty((Object)actualQuery), String.class)), String.class), callback, (Object)callSiteArray[181].call((Object)timeout)));
    }

    @Override
    public EngineResponseContent<List<Map<String, Object>>> ps(Map<String, Object> query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[182].call((Object)log, (Object)"docker ps");
        Map actualQuery = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox(query)) {
            callSiteArray[183].call((Object)actualQuery, query);
        }
        Map defaults = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"all", true, "size", false});
        callSiteArray[184].call((Object)this.queryUtil, (Object)actualQuery, (Object)defaults);
        callSiteArray[185].call((Object)this.queryUtil, (Object)actualQuery, (Object)"filters");
        List containerList = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[186].call(callSiteArray[187].callGetProperty((Object)this.client), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[188].callGetProperty((Object)actualQuery), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[189].callGetProperty((Object)actualQuery), Integer.class)), Integer.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[190].callGetProperty((Object)actualQuery), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[191].callGetProperty((Object)actualQuery), String.class)), String.class)), List.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[192].callConstructor(EngineResponseContent.class, (Object)containerList), EngineResponseContent.class));
    }

    @Override
    public EngineResponseContent<List<Map<String, Object>>> ps(Boolean all, Integer limit, Boolean size, String filters) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[193].call((Object)log, (Object)"docker ps");
        Boolean bl = size;
        List containerList = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[194].call(callSiteArray[195].callGetProperty((Object)this.client), (Object)(ScriptBytecodeAdapter.compareEqual((Object)all, null) ? Boolean.valueOf(true) : all), (Object)limit, (Object)(DefaultTypeTransformation.booleanUnbox((Object)bl) ? bl : Boolean.valueOf(false)), (Object)filters), List.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[196].callConstructor(EngineResponseContent.class, (Object)containerList), EngineResponseContent.class));
    }

    @Override
    public void pause(String containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[197].call((Object)log, (Object)"docker pause");
        callSiteArray[198].call(callSiteArray[199].callGetProperty((Object)this.client), (Object)containerId);
    }

    @Override
    public EngineResponseContent<ContainerPruneResponse> pruneContainers(String filters) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[200].call((Object)log, (Object)"docker container prune");
        ContainerPruneResponse containerPrune = (ContainerPruneResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[201].call(callSiteArray[202].callGetProperty((Object)this.client), (Object)filters), ContainerPruneResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[203].callConstructor(EngineResponseContent.class, (Object)containerPrune), EngineResponseContent.class));
    }

    @Override
    public void rename(String container, String newName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[204].call((Object)log, (Object)"docker rename");
        callSiteArray[205].call(callSiteArray[206].callGetProperty((Object)this.client), (Object)container, (Object)newName);
    }

    @Override
    public void restart(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[207].call((Object)log, (Object)"docker restart");
        callSiteArray[208].call(callSiteArray[209].callGetProperty((Object)this.client), (Object)containerIdOrName, (Object)5);
    }

    @Override
    public void rm(String containerIdOrName, Map<String, Object> query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[210].call((Object)log, (Object)"docker rm");
        callSiteArray[211].call(callSiteArray[212].callGetProperty((Object)this.client), (Object)containerIdOrName, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[213].callGetProperty(query), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[214].callGetProperty(query), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[215].callGetProperty(query), Boolean.class)), Boolean.class));
    }

    @Override
    public EngineResponseContent<ContainerCreateResponse> run(ContainerCreateRequest containerCreateRequest, String name, String authBase64Encoded) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[216].call((Object)log)) ? callSiteArray[217].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[218].callGetProperty((Object)containerCreateRequest)}, new String[]{"docker run ", ""})) : null;
        EngineResponseContent createContainerResponse = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[219].callCurrent((GroovyObject)this, (Object)containerCreateRequest, (Object)name, (Object)authBase64Encoded);
            createContainerResponse = (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)object2, EngineResponseContent.class));
        } else {
            EngineResponseContent engineResponseContent;
            createContainerResponse = engineResponseContent = this.createContainer(containerCreateRequest, name, authBase64Encoded);
        }
        Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[220].call((Object)log)) ? callSiteArray[221].call((Object)log, (Object)new GStringImpl(new Object[]{createContainerResponse}, new String[]{"create container result: ", ""})) : null;
        String containerId = ShortTypeHandling.castToString((Object)callSiteArray[222].callGetProperty(callSiteArray[223].callGetProperty((Object)createContainerResponse)));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[224].callCurrent((GroovyObject)this, (Object)containerId);
        } else {
            this.startContainer(containerId);
        }
        return createContainerResponse;
    }

    @Override
    public void startContainer(String containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[225].call((Object)log, (Object)"docker start");
        callSiteArray[226].call(callSiteArray[227].callGetProperty((Object)this.client), (Object)containerId, null);
    }

    @Override
    public void stats(String container, Boolean stream, StreamCallback<Object> callback, Duration timeout) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[228].call((Object)log, (Object)"docker stats");
        callSiteArray[229].call(callSiteArray[230].callGetProperty((Object)this.client), ArrayUtil.createArray((Object)container, (Object)stream, null, callback, (Object)callSiteArray[231].call((Object)timeout)));
    }

    @Override
    public void stop(String containerIdOrName, Integer timeoutSeconds) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[232].callCurrent((GroovyObject)this, (Object)containerIdOrName, ScriptBytecodeAdapter.compareNotEqual((Object)timeoutSeconds, null) ? callSiteArray[233].call(Duration.class, (Object)timeoutSeconds, callSiteArray[234].callGetProperty(ChronoUnit.class)) : null);
    }

    @Override
    public void stop(String containerIdOrName, Duration timeout) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[235].call((Object)log, (Object)"docker stop");
        Duration duration = timeout;
        long timeoutInSeconds = DefaultTypeTransformation.longUnbox((Object)callSiteArray[236].callGetProperty(DefaultTypeTransformation.booleanUnbox((Object)duration) ? duration : callSiteArray[237].call(Duration.class, (Object)10, callSiteArray[238].callGetProperty(ChronoUnit.class))));
        callSiteArray[239].call(callSiteArray[240].callGetProperty((Object)this.client), (Object)containerIdOrName, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)timeoutInSeconds, Integer.TYPE)), Integer.TYPE));
    }

    @Override
    public EngineResponseContent<ContainerTopResponse> top(String containerIdOrName, String psArgs) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[241].call((Object)log, (Object)"docker top");
        String string = psArgs;
        ContainerTopResponse containerTop = (ContainerTopResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[242].call(callSiteArray[243].callGetProperty((Object)this.client), (Object)containerIdOrName, (Object)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : null)), ContainerTopResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[244].callConstructor(EngineResponseContent.class, (Object)containerTop), EngineResponseContent.class));
    }

    @Override
    public void unpause(String containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[245].call((Object)log, (Object)"docker unpause");
        callSiteArray[246].call(callSiteArray[247].callGetProperty((Object)this.client), (Object)containerId);
    }

    @Override
    public EngineResponseContent<ContainerUpdateResponse> updateContainer(String container, ContainerUpdateRequest containerUpdateRequest) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[248].call((Object)log)) ? callSiteArray[249].call((Object)log, (Object)new GStringImpl(new Object[]{container}, new String[]{"docker update '", "'"})) : null;
        ContainerUpdateResponse containerUpdate = (ContainerUpdateResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[250].call(callSiteArray[251].callGetProperty((Object)this.client), (Object)container, (Object)containerUpdateRequest), ContainerUpdateResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[252].callConstructor(EngineResponseContent.class, (Object)containerUpdate), EngineResponseContent.class));
    }

    @Override
    public EngineResponseContent<ContainerWaitResponse> wait(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[253].call((Object)log, (Object)"docker wait");
        ContainerWaitResponse containerWait = (ContainerWaitResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[254].call(callSiteArray[255].callGetProperty((Object)this.client), (Object)containerIdOrName, (Object)"not-running"), ContainerWaitResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[256].callConstructor(EngineResponseContent.class, (Object)containerWait), EngineResponseContent.class));
    }

    @Override
    @Generated
    public EngineResponse attach(String containerId, Map<String, Object> query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.attach(containerId, query, null);
    }

    @Override
    @Generated
    public EngineResponseContent<IdResponse> commit(String container, Map query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.commit(container, query, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerCreateResponse> createContainer(ContainerCreateRequest containerCreateRequest, String name) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.createContainer(containerCreateRequest, name, "");
        }
        return this.createContainer(containerCreateRequest, name, "");
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerCreateResponse> createContainer(ContainerCreateRequest containerCreateRequest) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.createContainer(containerCreateRequest, "", "");
        }
        return this.createContainer(containerCreateRequest, "", "");
    }

    @Override
    @Generated
    public EngineResponseContent<IdResponse> exec(String containerId, List<String> command, StreamCallback<Frame> callback, Duration timeout) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.exec(containerId, command, callback, timeout, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Detach", false, "AttachStdin", false, "Tty", false}));
    }

    @Override
    @Generated
    public EngineResponseContent<List<Map<String, Object>>> ps(Boolean all, Integer limit, Boolean size) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.ps(all, limit, size, null);
        }
        return this.ps(all, limit, size, null);
    }

    @Override
    @Generated
    public EngineResponseContent<List<Map<String, Object>>> ps(Boolean all, Integer limit) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.ps(all, limit, false, null);
        }
        return this.ps(all, limit, false, null);
    }

    @Override
    @Generated
    public EngineResponseContent<List<Map<String, Object>>> ps(Boolean all) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.ps(all, null, false, null);
        }
        return this.ps(all, null, false, null);
    }

    @Override
    @Generated
    public EngineResponseContent<List<Map<String, Object>>> ps() {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.ps(true, null, false, null);
        }
        return this.ps(true, null, false, null);
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerPruneResponse> pruneContainers() {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.pruneContainers(null);
        }
        return this.pruneContainers(null);
    }

    @Override
    @Generated
    public void rm(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        this.rm(containerIdOrName, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerCreateResponse> run(ContainerCreateRequest containerCreateRequest, String name) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.run(containerCreateRequest, name, "");
        }
        return this.run(containerCreateRequest, name, "");
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerCreateResponse> run(ContainerCreateRequest containerCreateRequest) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.run(containerCreateRequest, "", "");
        }
        return this.run(containerCreateRequest, "", "");
    }

    @Override
    @Generated
    public void stop(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            this.stop(containerIdOrName, (Duration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[257].call(Duration.class, (Object)10, callSiteArray[258].callGetProperty(ChronoUnit.class)), Duration.class));
        } else {
            this.stop(containerIdOrName, (Duration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[259].call(Duration.class, (Object)10, callSiteArray[260].callGetProperty(ChronoUnit.class)), Duration.class));
        }
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerTopResponse> top(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.top(containerIdOrName, null);
        }
        return this.top(containerIdOrName, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ManageContainerClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = ManageContainerClient.$getCallSiteArray()[261].call(LoggerFactory.class, (Object)"de.gesellix.docker.client.container.ManageContainerClient");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "info";
        stringArray[5] = "inspectContainer";
        stringArray[6] = "tty";
        stringArray[7] = "config";
        stringArray[8] = "content";
        stringArray[9] = "tty";
        stringArray[10] = "config";
        stringArray[11] = "content";
        stringArray[12] = "post";
        stringArray[13] = "toString";
        stringArray[14] = "stream";
        stringArray[15] = "info";
        stringArray[16] = "containerAttach";
        stringArray[17] = "containerApi";
        stringArray[18] = "toMillis";
        stringArray[19] = "info";
        stringArray[20] = "webSocket";
        stringArray[21] = "toString";
        stringArray[22] = "info";
        stringArray[23] = "containerResize";
        stringArray[24] = "containerApi";
        stringArray[25] = "info";
        stringArray[26] = "imageCommit";
        stringArray[27] = "imageApi";
        stringArray[28] = "repo";
        stringArray[29] = "tag";
        stringArray[30] = "comment";
        stringArray[31] = "author";
        stringArray[32] = "pause";
        stringArray[33] = "changes";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "Hostname";
        stringArray[36] = "Domainname";
        stringArray[37] = "User";
        stringArray[38] = "AttachStdin";
        stringArray[39] = "AttachStdout";
        stringArray[40] = "AttachStderr";
        stringArray[41] = "ExposedPorts";
        stringArray[42] = "Tty";
        stringArray[43] = "OpenStdin";
        stringArray[44] = "StdinOnce";
        stringArray[45] = "Env";
        stringArray[46] = "Cmd";
        stringArray[47] = "Cmd";
        stringArray[48] = "Cmd";
        stringArray[49] = "<$constructor$>";
        stringArray[50] = "ArgsEscaped";
        stringArray[51] = "Image";
        stringArray[52] = "Volumes";
        stringArray[53] = "WorkingDir";
        stringArray[54] = "Entrypoint";
        stringArray[55] = "Entrypoint";
        stringArray[56] = "Entrypoint";
        stringArray[57] = "NetworkDisabled";
        stringArray[58] = "MacAddress";
        stringArray[59] = "OnBuild";
        stringArray[60] = "Labels";
        stringArray[61] = "StopSignal";
        stringArray[62] = "StopTimeout";
        stringArray[63] = "Shell";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "isInfoEnabled";
        stringArray[66] = "info";
        stringArray[67] = "containerArchiveInfo";
        stringArray[68] = "containerApi";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "isInfoEnabled";
        stringArray[71] = "info";
        stringArray[72] = "getArchive";
        stringArray[73] = "extractSingleTarEntry";
        stringArray[74] = "content";
        stringArray[75] = "isInfoEnabled";
        stringArray[76] = "info";
        stringArray[77] = "containerArchive";
        stringArray[78] = "containerApi";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "isInfoEnabled";
        stringArray[81] = "info";
        stringArray[82] = "putContainerArchive";
        stringArray[83] = "containerApi";
        stringArray[84] = "info";
        stringArray[85] = "image";
        stringArray[86] = "<$constructor$>";
        stringArray[87] = "containerCreate";
        stringArray[88] = "containerApi";
        stringArray[89] = "<$constructor$>";
        stringArray[90] = "statusCode";
        stringArray[91] = "parseRepositoryTag";
        stringArray[92] = "image";
        stringArray[93] = "isInfoEnabled";
        stringArray[94] = "info";
        stringArray[95] = "repo";
        stringArray[96] = "tag";
        stringArray[97] = "imageCreate";
        stringArray[98] = "imageApi";
        stringArray[99] = "repo";
        stringArray[100] = "tag";
        stringArray[101] = "containerCreate";
        stringArray[102] = "containerApi";
        stringArray[103] = "<$constructor$>";
        stringArray[104] = "info";
        stringArray[105] = "containerChanges";
        stringArray[106] = "containerApi";
        stringArray[107] = "<$constructor$>";
        stringArray[108] = "isInfoEnabled";
        stringArray[109] = "info";
        stringArray[110] = "containerExec";
        stringArray[111] = "execApi";
        stringArray[112] = "<$constructor$>";
        stringArray[113] = "isInfoEnabled";
        stringArray[114] = "info";
        stringArray[115] = "execInspect";
        stringArray[116] = "execApi";
        stringArray[117] = "tty";
        stringArray[118] = "processConfig";
        stringArray[119] = "tty";
        stringArray[120] = "processConfig";
        stringArray[121] = "post";
        stringArray[122] = "toString";
        stringArray[123] = "detach";
        stringArray[124] = "tty";
        stringArray[125] = "code";
        stringArray[126] = "status";
        stringArray[127] = "isErrorEnabled";
        stringArray[128] = "error";
        stringArray[129] = "ensureSuccessfulResponse";
        stringArray[130] = "<$constructor$>";
        stringArray[131] = "stream";
        stringArray[132] = "isInfoEnabled";
        stringArray[133] = "info";
        stringArray[134] = "execStart";
        stringArray[135] = "execApi";
        stringArray[136] = "toMillis";
        stringArray[137] = "isInfoEnabled";
        stringArray[138] = "info";
        stringArray[139] = "execInspect";
        stringArray[140] = "execApi";
        stringArray[141] = "<$constructor$>";
        stringArray[142] = "isInfoEnabled";
        stringArray[143] = "info";
        stringArray[144] = "<$constructor$>";
        stringArray[145] = "AttachStdin";
        stringArray[146] = "Tty";
        stringArray[147] = "createExec";
        stringArray[148] = "id";
        stringArray[149] = "content";
        stringArray[150] = "<$constructor$>";
        stringArray[151] = "Detach";
        stringArray[152] = "tty";
        stringArray[153] = "startExec";
        stringArray[154] = "info";
        stringArray[155] = "execResize";
        stringArray[156] = "execApi";
        stringArray[157] = "isInfoEnabled";
        stringArray[158] = "info";
        stringArray[159] = "containerExport";
        stringArray[160] = "containerApi";
        stringArray[161] = "<$constructor$>";
        stringArray[162] = "info";
        stringArray[163] = "containerInspect";
        stringArray[164] = "containerApi";
        stringArray[165] = "<$constructor$>";
        stringArray[166] = "info";
        stringArray[167] = "containerKill";
        stringArray[168] = "containerApi";
        stringArray[169] = "info";
        stringArray[170] = "putAll";
        stringArray[171] = "applyDefaults";
        stringArray[172] = "containerLogs";
        stringArray[173] = "containerApi";
        stringArray[174] = "follow";
        stringArray[175] = "stdout";
        stringArray[176] = "stderr";
        stringArray[177] = "since";
        stringArray[178] = "until";
        stringArray[179] = "timestamps";
        stringArray[180] = "tail";
        stringArray[181] = "toMillis";
        stringArray[182] = "info";
        stringArray[183] = "putAll";
        stringArray[184] = "applyDefaults";
        stringArray[185] = "jsonEncodeQueryParameter";
        stringArray[186] = "containerList";
        stringArray[187] = "containerApi";
        stringArray[188] = "all";
        stringArray[189] = "limit";
        stringArray[190] = "size";
        stringArray[191] = "filters";
        stringArray[192] = "<$constructor$>";
        stringArray[193] = "info";
        stringArray[194] = "containerList";
        stringArray[195] = "containerApi";
        stringArray[196] = "<$constructor$>";
        stringArray[197] = "info";
        stringArray[198] = "containerPause";
        stringArray[199] = "containerApi";
        stringArray[200] = "info";
        stringArray[201] = "containerPrune";
        stringArray[202] = "containerApi";
        stringArray[203] = "<$constructor$>";
        stringArray[204] = "info";
        stringArray[205] = "containerRename";
        stringArray[206] = "containerApi";
        stringArray[207] = "info";
        stringArray[208] = "containerRestart";
        stringArray[209] = "containerApi";
        stringArray[210] = "info";
        stringArray[211] = "containerDelete";
        stringArray[212] = "containerApi";
        stringArray[213] = "v";
        stringArray[214] = "force";
        stringArray[215] = "link";
        stringArray[216] = "isInfoEnabled";
        stringArray[217] = "info";
        stringArray[218] = "image";
        stringArray[219] = "createContainer";
        stringArray[220] = "isDebugEnabled";
        stringArray[221] = "debug";
        stringArray[222] = "id";
        stringArray[223] = "content";
        stringArray[224] = "startContainer";
        stringArray[225] = "info";
        stringArray[226] = "containerStart";
        stringArray[227] = "containerApi";
        stringArray[228] = "info";
        stringArray[229] = "containerStats";
        stringArray[230] = "containerApi";
        stringArray[231] = "toMillis";
        stringArray[232] = "stop";
        stringArray[233] = "of";
        stringArray[234] = "SECONDS";
        stringArray[235] = "info";
        stringArray[236] = "seconds";
        stringArray[237] = "of";
        stringArray[238] = "SECONDS";
        stringArray[239] = "containerStop";
        stringArray[240] = "containerApi";
        stringArray[241] = "info";
        stringArray[242] = "containerTop";
        stringArray[243] = "containerApi";
        stringArray[244] = "<$constructor$>";
        stringArray[245] = "info";
        stringArray[246] = "containerUnpause";
        stringArray[247] = "containerApi";
        stringArray[248] = "isInfoEnabled";
        stringArray[249] = "info";
        stringArray[250] = "containerUpdate";
        stringArray[251] = "containerApi";
        stringArray[252] = "<$constructor$>";
        stringArray[253] = "info";
        stringArray[254] = "containerWait";
        stringArray[255] = "containerApi";
        stringArray[256] = "<$constructor$>";
        stringArray[257] = "of";
        stringArray[258] = "SECONDS";
        stringArray[259] = "of";
        stringArray[260] = "SECONDS";
        stringArray[261] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[262];
        ManageContainerClient.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ManageContainerClient.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ManageContainerClient.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

