/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.authentication;

import com.squareup.moshi.Moshi;
import de.gesellix.docker.authentication.AuthConfig;
import de.gesellix.docker.authentication.AuthConfigReader;
import de.gesellix.docker.authentication.CredsStore;
import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.authentication.ManageAuthentication;
import de.gesellix.docker.client.authentication.ReferenceParser;
import de.gesellix.docker.client.authentication.RegistryElection;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.SystemAuthResponse;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageAuthenticationClient
implements ManageAuthentication,
GroovyObject {
    private AuthConfigReader authConfigReader;
    private EngineApiClient client;
    private RegistryElection registryElection;
    private Moshi moshi;
    private final String legacyDefaultDomain;
    private final String defaultDomain;
    private final String officialRepoName;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ManageAuthenticationClient(EngineApiClient client, AuthConfigReader authConfigReader) {
        AuthConfigReader authConfigReader2;
        EngineApiClient engineApiClient;
        MetaClass metaClass;
        String string;
        String string2;
        String string3;
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        Object object = callSiteArray[0].call(callSiteArray[1].callConstructor(Moshi.Builder.class));
        this.moshi = (Moshi)ScriptBytecodeAdapter.castToType((Object)object, Moshi.class);
        this.legacyDefaultDomain = string3 = "index.docker.io";
        this.defaultDomain = string2 = "docker.io";
        this.officialRepoName = string = "library";
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.client = engineApiClient = client;
        this.authConfigReader = authConfigReader2 = authConfigReader;
        Object object2 = callSiteArray[2].callConstructor(RegistryElection.class, callSiteArray[3].call((Object)client), (Object)authConfigReader);
        this.registryElection = (RegistryElection)ScriptBytecodeAdapter.castToType((Object)object2, RegistryElection.class);
    }

    @Override
    public Map<String, AuthConfig> getAllAuthConfigs(File dockerCfg) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        Map parsedDockerCfg = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call((Object)this.authConfigReader, (Object)dockerCfg), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)parsedDockerCfg)) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        CredsStore credsStore = (CredsStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call((Object)this.authConfigReader, (Object)parsedDockerCfg), CredsStore.class);
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].call((Object)credsStore), Map.class);
    }

    @Override
    public AuthConfig readDefaultAuthConfig() {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        return (AuthConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].call((Object)this.authConfigReader), AuthConfig.class);
    }

    @Override
    public AuthConfig readAuthConfig(String hostname, File dockerCfg) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        return (AuthConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].call((Object)this.authConfigReader, (Object)hostname, (Object)dockerCfg), AuthConfig.class);
    }

    @Override
    public String encodeAuthConfig(AuthConfig authConfig) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call((Object)log)) ? callSiteArray[10].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[11].callGetProperty((Object)authConfig), callSiteArray[12].callGetProperty((Object)authConfig)}, new String[]{"encode authConfig for ", "@", ""})) : null;
        String json = ShortTypeHandling.castToString((Object)callSiteArray[13].call(callSiteArray[14].call((Object)this.moshi, AuthConfig.class), (Object)authConfig));
        return ShortTypeHandling.castToString((Object)callSiteArray[15].call(callSiteArray[16].call(callSiteArray[17].callGetProperty((Object)json))));
    }

    @Override
    public String encodeAuthConfigs(Map<String, AuthConfig> authConfigs) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[18].call((Object)log)) ? callSiteArray[19].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[20].call(authConfigs)}, new String[]{"encode authConfigs for ", ""})) : null;
        String json = ShortTypeHandling.castToString((Object)callSiteArray[21].call(callSiteArray[22].call((Object)this.moshi, Map.class), authConfigs));
        return ShortTypeHandling.castToString((Object)callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].callGetProperty((Object)json))));
    }

    @Override
    public EngineResponseContent<SystemAuthResponse> auth(de.gesellix.docker.remote.api.AuthConfig authDetails) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        callSiteArray[26].call((Object)log, (Object)"docker login");
        SystemAuthResponse systemAuth = (SystemAuthResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call(callSiteArray[28].callGetProperty((Object)this.client), (Object)authDetails), SystemAuthResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].callConstructor(EngineResponseContent.class, (Object)systemAuth), EngineResponseContent.class));
    }

    @Override
    public String retrieveEncodedAuthTokenForImage(String image) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        AuthConfig authConfig = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[30].callCurrent((GroovyObject)this, (Object)image);
            authConfig = (AuthConfig)ScriptBytecodeAdapter.castToType((Object)object, AuthConfig.class);
        } else {
            AuthConfig authConfig2;
            authConfig = authConfig2 = this.resolveAuthConfigForImage(image);
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[31].callCurrent((GroovyObject)this, (Object)authConfig));
    }

    @Override
    public AuthConfig resolveAuthConfigForImage(String image) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[32].call((Object)"^([a-f0-9]{64})$", (Object)image))) {
            throw (Throwable)callSiteArray[33].callConstructor(IllegalArgumentException.class, (Object)new GStringImpl(new Object[]{image}, new String[]{"invalid repository name (", "), cannot specify 64-byte hexadecimal strings"}));
        }
        String domain = null;
        String remainder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[34].callCurrent((GroovyObject)this, (Object)image);
            domain = ShortTypeHandling.castToString((Object)callSiteArray[35].call(object, (Object)0));
            remainder = ShortTypeHandling.castToString((Object)callSiteArray[36].call(object, (Object)1));
        } else {
            Object object = this.splitDockerDomain(image);
            domain = ShortTypeHandling.castToString((Object)callSiteArray[37].call(object, (Object)0));
            remainder = ShortTypeHandling.castToString((Object)callSiteArray[38].call(object, (Object)1));
        }
        String remoteName = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[39].call((Object)remainder, (Object)":"))) {
            Object object = callSiteArray[40].call((Object)remainder, (Object)0, callSiteArray[41].call((Object)remainder, (Object)":"));
            remoteName = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            remoteName = string = remainder;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[42].call((Object)remoteName), (Object)remoteName)) {
            throw (Throwable)callSiteArray[43].callConstructor(IllegalArgumentException.class, (Object)"invalid reference format: repository name must be lowercase");
        }
        Object ref = callSiteArray[44].call(callSiteArray[45].callConstructor(ReferenceParser.class), callSiteArray[46].call(callSiteArray[47].call((Object)domain, (Object)"/"), (Object)remainder));
        Object namedRef = callSiteArray[48].callCurrent((GroovyObject)this, ref);
        String indexName = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[49].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[50].callGetProperty(namedRef), String.class)), String.class));
            indexName = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            indexName = string = this.validateIndexName((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[51].callGetProperty(namedRef), String.class));
        }
        Map indexInfo = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", indexName, "mirrors", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "official", ScriptBytecodeAdapter.compareEqual((Object)indexName, (Object)this.defaultDomain), "secure", false});
        return (AuthConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].call((Object)this.registryElection, callSiteArray[53].callGetProperty((Object)indexInfo), callSiteArray[54].callGetProperty((Object)indexInfo)), AuthConfig.class);
    }

    public String validateIndexName(String val) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)val, (Object)this.legacyDefaultDomain)) {
            String string;
            val = string = this.defaultDomain;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[55].call((Object)val, (Object)"-")) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].call((Object)val, (Object)"-"))) {
            throw (Throwable)callSiteArray[57].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{val}, new String[]{"Invalid index name (", "). Cannot begin or end with a hyphen."}));
        }
        return val;
    }

    public Object getNamed(Map ref) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].callGetProperty((Object)ref))) {
            return ref;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].callGetProperty((Object)ref)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].callGetProperty(callSiteArray[61].callGetProperty((Object)ref)))) {
            return callSiteArray[62].callGetProperty((Object)ref);
        }
        throw (Throwable)callSiteArray[63].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{ref}, new String[]{"reference ", " has no name"}));
    }

    public Object splitDockerDomain(String name) {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        public final class _splitDockerDomain_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _splitDockerDomain_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _splitDockerDomain_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String haystack, String needles) {
                Reference haystack2 = new Reference((Object)haystack);
                CallSite[] callSiteArray = _splitDockerDomain_closure1.$getCallSiteArray();
                public final class _closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference haystack;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure2(Object _outerInstance, Object _thisObject, Reference haystack) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.haystack = reference = haystack;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        return callSiteArray[0].call(this.haystack.get(), it);
                    }

                    @Generated
                    public String getHaystack() {
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.haystack.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _closure2.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "contains";
                        return new CallSiteArray(_closure2.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure2.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call((Object)needles, (Object)new _closure2((Object)this, this.getThisObject(), haystack2));
            }

            @Generated
            public Object call(String haystack, String needles) {
                Reference haystack2 = new Reference((Object)haystack);
                CallSite[] callSiteArray = _splitDockerDomain_closure1.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[1].callCurrent((GroovyObject)this, (Object)((String)haystack2.get()), (Object)needles);
                }
                return this.doCall((String)haystack2.get(), needles);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _splitDockerDomain_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "any";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _splitDockerDomain_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_splitDockerDomain_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _splitDockerDomain_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _splitDockerDomain_closure1 containsAny = new _splitDockerDomain_closure1(this, this);
        String domain = null;
        String remainder = null;
        int i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[64].call((Object)name, (Object)"/"));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)i, (Object)-1) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[65].call((Object)containsAny, callSiteArray[66].call((Object)name, (Object)0, (Object)i), (Object)".:")) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[67].call((Object)name, (Object)0, (Object)i), (Object)"localhost")) {
                List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{this.defaultDomain, name});
                domain = ShortTypeHandling.castToString((Object)callSiteArray[68].call((Object)list, (Object)0));
                remainder = ShortTypeHandling.castToString((Object)callSiteArray[69].call((Object)list, (Object)1));
            } else {
                List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[70].call((Object)name, (Object)0, (Object)i), callSiteArray[71].call((Object)name, callSiteArray[72].call((Object)i, (Object)1))});
                domain = ShortTypeHandling.castToString((Object)callSiteArray[73].call((Object)list, (Object)0));
                remainder = ShortTypeHandling.castToString((Object)callSiteArray[74].call((Object)list, (Object)1));
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)i, (Object)-1) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[75].call((Object)containsAny, callSiteArray[76].call((Object)name, (Object)0, (Object)i), (Object)".:")) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[77].call((Object)name, (Object)0, (Object)i), (Object)"localhost")) {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{this.defaultDomain, name});
            domain = ShortTypeHandling.castToString((Object)callSiteArray[78].call((Object)list, (Object)0));
            remainder = ShortTypeHandling.castToString((Object)callSiteArray[79].call((Object)list, (Object)1));
        } else {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[80].call((Object)name, (Object)0, (Object)i), callSiteArray[81].call((Object)name, (Object)(i + 1))});
            domain = ShortTypeHandling.castToString((Object)callSiteArray[82].call((Object)list, (Object)0));
            remainder = ShortTypeHandling.castToString((Object)callSiteArray[83].call((Object)list, (Object)1));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)domain, (Object)this.legacyDefaultDomain)) {
            String string;
            domain = string = this.defaultDomain;
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)domain, (Object)this.defaultDomain) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[84].call((Object)remainder, (Object)"/"))) {
                Object object = callSiteArray[85].call(callSiteArray[86].call((Object)this.officialRepoName, (Object)"/"), (Object)remainder);
                remainder = ShortTypeHandling.castToString((Object)object);
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)domain, (Object)this.defaultDomain) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[87].call((Object)remainder, (Object)"/"))) {
            Object object = callSiteArray[88].call(callSiteArray[89].call((Object)this.officialRepoName, (Object)"/"), (Object)remainder);
            remainder = ShortTypeHandling.castToString((Object)object);
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{domain, remainder});
    }

    @Override
    @Generated
    public Map<String, AuthConfig> getAllAuthConfigs() {
        CallSite[] callSiteArray = ManageAuthenticationClient.$getCallSiteArray();
        return this.getAllAuthConfigs(null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ManageAuthenticationClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = ManageAuthenticationClient.$getCallSiteArray()[90].call(LoggerFactory.class, (Object)"de.gesellix.docker.client.authentication.ManageAuthenticationClient");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public AuthConfigReader getAuthConfigReader() {
        return this.authConfigReader;
    }

    @Generated
    public void setAuthConfigReader(AuthConfigReader authConfigReader) {
        this.authConfigReader = authConfigReader;
    }

    @Generated
    public EngineApiClient getClient() {
        return this.client;
    }

    @Generated
    public void setClient(EngineApiClient engineApiClient) {
        this.client = engineApiClient;
    }

    @Generated
    public final String getLegacyDefaultDomain() {
        return this.legacyDefaultDomain;
    }

    @Generated
    public final String getDefaultDomain() {
        return this.defaultDomain;
    }

    @Generated
    public final String getOfficialRepoName() {
        return this.officialRepoName;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "build";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "getSystemApi";
        stringArray[4] = "readDockerConfigFile";
        stringArray[5] = "getCredentialsStore";
        stringArray[6] = "getAuthConfigs";
        stringArray[7] = "readDefaultAuthConfig";
        stringArray[8] = "readAuthConfig";
        stringArray[9] = "isDebugEnabled";
        stringArray[10] = "debug";
        stringArray[11] = "username";
        stringArray[12] = "serveraddress";
        stringArray[13] = "toJson";
        stringArray[14] = "adapter";
        stringArray[15] = "toString";
        stringArray[16] = "encodeBase64";
        stringArray[17] = "bytes";
        stringArray[18] = "isDebugEnabled";
        stringArray[19] = "debug";
        stringArray[20] = "keySet";
        stringArray[21] = "toJson";
        stringArray[22] = "adapter";
        stringArray[23] = "toString";
        stringArray[24] = "encodeBase64";
        stringArray[25] = "bytes";
        stringArray[26] = "info";
        stringArray[27] = "systemAuth";
        stringArray[28] = "systemApi";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "resolveAuthConfigForImage";
        stringArray[31] = "encodeAuthConfig";
        stringArray[32] = "matches";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "splitDockerDomain";
        stringArray[35] = "getAt";
        stringArray[36] = "getAt";
        stringArray[37] = "getAt";
        stringArray[38] = "getAt";
        stringArray[39] = "contains";
        stringArray[40] = "substring";
        stringArray[41] = "indexOf";
        stringArray[42] = "toLowerCase";
        stringArray[43] = "<$constructor$>";
        stringArray[44] = "parse";
        stringArray[45] = "<$constructor$>";
        stringArray[46] = "plus";
        stringArray[47] = "plus";
        stringArray[48] = "getNamed";
        stringArray[49] = "validateIndexName";
        stringArray[50] = "domain";
        stringArray[51] = "domain";
        stringArray[52] = "resolveAuthConfig";
        stringArray[53] = "name";
        stringArray[54] = "official";
        stringArray[55] = "startsWith";
        stringArray[56] = "endsWith";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "domain";
        stringArray[59] = "repo";
        stringArray[60] = "domain";
        stringArray[61] = "repo";
        stringArray[62] = "repo";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "indexOf";
        stringArray[65] = "call";
        stringArray[66] = "substring";
        stringArray[67] = "substring";
        stringArray[68] = "getAt";
        stringArray[69] = "getAt";
        stringArray[70] = "substring";
        stringArray[71] = "substring";
        stringArray[72] = "plus";
        stringArray[73] = "getAt";
        stringArray[74] = "getAt";
        stringArray[75] = "call";
        stringArray[76] = "substring";
        stringArray[77] = "substring";
        stringArray[78] = "getAt";
        stringArray[79] = "getAt";
        stringArray[80] = "substring";
        stringArray[81] = "substring";
        stringArray[82] = "getAt";
        stringArray[83] = "getAt";
        stringArray[84] = "contains";
        stringArray[85] = "plus";
        stringArray[86] = "plus";
        stringArray[87] = "contains";
        stringArray[88] = "plus";
        stringArray[89] = "plus";
        stringArray[90] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[91];
        ManageAuthenticationClient.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ManageAuthenticationClient.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ManageAuthenticationClient.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

