/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.container;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.container.ArchiveUtil;
import de.gesellix.docker.client.container.DockerResponseHandler;
import de.gesellix.docker.client.container.ManageContainer;
import de.gesellix.docker.client.repository.RepositoryAndTag;
import de.gesellix.docker.client.repository.RepositoryTagParser;
import de.gesellix.docker.engine.AttachConfig;
import de.gesellix.docker.engine.EngineClient;
import de.gesellix.docker.engine.EngineResponse;
import de.gesellix.docker.remote.api.ContainerChangeResponseItem;
import de.gesellix.docker.remote.api.ContainerConfig;
import de.gesellix.docker.remote.api.ContainerCreateRequest;
import de.gesellix.docker.remote.api.ContainerCreateResponse;
import de.gesellix.docker.remote.api.ContainerInspectResponse;
import de.gesellix.docker.remote.api.ContainerPruneResponse;
import de.gesellix.docker.remote.api.ContainerTopResponse;
import de.gesellix.docker.remote.api.ContainerUpdateRequest;
import de.gesellix.docker.remote.api.ContainerUpdateResponse;
import de.gesellix.docker.remote.api.ContainerWaitResponse;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.ExecConfig;
import de.gesellix.docker.remote.api.ExecInspectResponse;
import de.gesellix.docker.remote.api.ExecStartConfig;
import de.gesellix.docker.remote.api.HealthConfig;
import de.gesellix.docker.remote.api.IdResponse;
import de.gesellix.docker.remote.api.client.ContainerApi;
import de.gesellix.docker.remote.api.core.ClientException;
import de.gesellix.docker.remote.api.core.Frame;
import de.gesellix.docker.remote.api.core.StreamCallback;
import de.gesellix.util.QueryUtil;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageContainerClient
implements ManageContainer,
GroovyObject {
    private final Logger log;
    private EngineApiClient client;
    private EngineClient engineClient;
    private DockerResponseHandler responseHandler;
    private QueryUtil queryUtil;
    private ArchiveUtil archiveUtil;
    private RepositoryTagParser repositoryTagParser;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ManageContainerClient(EngineApiClient client, EngineClient engineClient) {
        EngineClient engineClient2;
        EngineApiClient engineApiClient;
        MetaClass metaClass;
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = callSiteArray[0].call(LoggerFactory.class, ManageContainerClient.class);
        this.log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.client = engineApiClient = client;
        this.engineClient = engineClient2 = engineClient;
        Object object2 = callSiteArray[1].callConstructor(DockerResponseHandler.class);
        this.responseHandler = (DockerResponseHandler)ScriptBytecodeAdapter.castToType((Object)object2, DockerResponseHandler.class);
        Object object3 = callSiteArray[2].callConstructor(RepositoryTagParser.class);
        this.repositoryTagParser = (RepositoryTagParser)ScriptBytecodeAdapter.castToType((Object)object3, RepositoryTagParser.class);
        Object object4 = callSiteArray[3].callConstructor(QueryUtil.class);
        this.queryUtil = (QueryUtil)ScriptBytecodeAdapter.castToType((Object)object4, QueryUtil.class);
        Object object5 = callSiteArray[4].callConstructor(ArchiveUtil.class);
        this.archiveUtil = (ArchiveUtil)ScriptBytecodeAdapter.castToType((Object)object5, ArchiveUtil.class);
    }

    @Override
    public EngineResponse attach(String containerId, Map<String, Object> query, AttachConfig callback) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[5].call((Object)this.log, (Object)"docker attach");
        EngineResponseContent container = null;
        container = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].callCurrent((GroovyObject)this, (Object)containerId), EngineResponseContent.class)) : this.inspectContainer(containerId);
        boolean multiplexStreams = false;
        multiplexStreams = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callGetProperty(callSiteArray[8].callGetProperty(callSiteArray[9].callGetProperty((Object)container)))) : !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty(callSiteArray[12].callGetProperty((Object)container))));
        EngineResponse response = (EngineResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].call((Object)this.engineClient, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[14].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/attach"})), "query", query, "attach", callback, "multiplexStreams", multiplexStreams})), EngineResponse.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callback)) {
            boolean bl = multiplexStreams;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)callSiteArray[15].callGetProperty((Object)response), (String)"multiplexStreams");
        }
        return response;
    }

    @Override
    public void attach(String containerId, String detachKeys, Boolean logs, Boolean stream, Boolean stdin, Boolean stdout, Boolean stderr, StreamCallback<Frame> callback, Duration timeout) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[16].call((Object)this.log, (Object)"docker attach");
        callSiteArray[17].call(callSiteArray[18].callGetProperty((Object)this.client), ArrayUtil.createArray((Object)containerId, (Object)detachKeys, (Object)logs, (Object)stream, (Object)stdin, (Object)stdout, (Object)stderr, callback, (Object)callSiteArray[19].call((Object)timeout)));
    }

    @Override
    public WebSocket attachWebsocket(String containerId, Map<String, Object> query, WebSocketListener listener) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[20].call((Object)this.log, (Object)"docker attach via websocket");
        WebSocket webSocket = (WebSocket)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call((Object)this.engineClient, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[22].call((Object)new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/attach/ws"})), "query", query}), (Object)listener), WebSocket.class);
        return webSocket;
    }

    @Override
    public void resizeTTY(String container, Integer height, Integer width) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[23].call((Object)this.log, (Object)"docker resize container");
        callSiteArray[24].call(callSiteArray[25].callGetProperty((Object)this.client), (Object)container, (Object)height, (Object)width);
    }

    @Override
    public EngineResponseContent<IdResponse> commit(String container, Map query, Map config) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[26].call((Object)this.log, (Object)"docker commit");
        Map map = query;
        Map finalQuery = DefaultTypeTransformation.booleanUnbox((Object)map) ? map : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        String string = container;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)finalQuery, (String)"container");
        Map map2 = config;
        config = DefaultTypeTransformation.booleanUnbox((Object)map2) ? map2 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        IdResponse imageCommit = (IdResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call(callSiteArray[28].callGetProperty((Object)this.client), ArrayUtil.createArray((Object)container, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[29].callGetProperty((Object)query), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[30].callGetProperty((Object)query), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[31].callGetProperty((Object)query), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[32].callGetProperty((Object)query), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[33].callGetProperty((Object)query), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[34].callGetProperty((Object)query), String.class)), String.class), (Object)callSiteArray[35].callConstructor(ContainerConfig.class, ArrayUtil.createArray((Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[36].callGetProperty((Object)config), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[37].callGetProperty((Object)config), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[38].callGetProperty((Object)config), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[39].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[40].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[41].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.asType((Object)callSiteArray[42].callGetProperty((Object)config), Map.class)), Map.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[43].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[44].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[45].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((List)ScriptBytecodeAdapter.asType((Object)callSiteArray[46].callGetProperty((Object)config), List.class)), List.class), (Object)(callSiteArray[47].callGetProperty((Object)config) instanceof String ? ScriptBytecodeAdapter.createList((Object[])new Object[]{(String)ScriptBytecodeAdapter.asType((Object)callSiteArray[48].callGetProperty((Object)config), String.class)}) : (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[49].callGetProperty((Object)config), List.class)), (Object)callSiteArray[50].callConstructor(HealthConfig.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[51].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[52].callGetProperty((Object)config), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.asType((Object)callSiteArray[53].callGetProperty((Object)config), Map.class)), Map.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[54].callGetProperty((Object)config), String.class)), String.class), (Object)(callSiteArray[55].callGetProperty((Object)config) instanceof String ? ScriptBytecodeAdapter.createList((Object[])new Object[]{(String)ScriptBytecodeAdapter.asType((Object)callSiteArray[56].callGetProperty((Object)config), String.class)}) : (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[57].callGetProperty((Object)config), List.class)), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[58].callGetProperty((Object)config), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[59].callGetProperty((Object)config), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((List)ScriptBytecodeAdapter.asType((Object)callSiteArray[60].callGetProperty((Object)config), List.class)), List.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.asType((Object)callSiteArray[61].callGetProperty((Object)config), Map.class)), Map.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[62].callGetProperty((Object)config), String.class)), String.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[63].callGetProperty((Object)config), Integer.class)), Integer.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((List)ScriptBytecodeAdapter.asType((Object)callSiteArray[64].callGetProperty((Object)config), List.class)), List.class))))), IdResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[65].callConstructor(EngineResponseContent.class, (Object)imageCommit), EngineResponseContent.class));
    }

    @Override
    public EngineResponseContent<Map<String, Object>> getArchiveStats(String container, String path) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[66].call((Object)this.log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"docker archive stats ", "|", ""}));
        Map archiveInfo = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[67].call(callSiteArray[68].callGetProperty((Object)this.client), (Object)container, (Object)path), Map.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].callConstructor(EngineResponseContent.class, (Object)archiveInfo), EngineResponseContent.class));
    }

    @Override
    public byte[] extractFile(String container, String filename) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[70].call((Object)this.log, (Object)new GStringImpl(new Object[]{filename, container}, new String[]{"extract '", "' from '", "'"}));
        EngineResponseContent response = null;
        response = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].callCurrent((GroovyObject)this, (Object)container, (Object)filename), EngineResponseContent.class)) : this.getArchive(container, filename);
        Object output = callSiteArray[72].callConstructor(ByteArrayOutputStream.class);
        Object bytesRead = callSiteArray[73].call((Object)this.archiveUtil, callSiteArray[74].callGetProperty((Object)response), (Object)filename, output);
        callSiteArray[75].call((Object)this.log, (Object)new GStringImpl(new Object[]{bytesRead}, new String[]{"read ", " bytes"}));
        return (byte[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].call(output), byte[].class);
    }

    @Override
    public EngineResponseContent<InputStream> getArchive(String container, String path) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[77].call((Object)this.log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"docker download from ", "|", ""}));
        InputStream archive = (InputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].call(callSiteArray[79].callGetProperty((Object)this.client), (Object)container, (Object)path), InputStream.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].callConstructor(EngineResponseContent.class, (Object)archive), EngineResponseContent.class));
    }

    @Override
    public void putArchive(String container, String path, InputStream archive) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[81].call((Object)this.log, (Object)new GStringImpl(new Object[]{container, path}, new String[]{"docker upload to ", "|", ""}));
        callSiteArray[82].call(callSiteArray[83].callGetProperty((Object)this.client), ArrayUtil.createArray((Object)container, (Object)path, (Object)archive, null, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public EngineResponseContent<ContainerCreateResponse> createContainer(ContainerCreateRequest containerCreateRequest, String name, String authBase64Encoded) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[84].call((Object)this.log, (Object)"docker create");
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[85].callGetProperty((Object)containerCreateRequest))) {
            throw (Throwable)callSiteArray[86].callConstructor(IllegalArgumentException.class, (Object)"'Image' missing in containerCreateRequest");
        }
        ContainerCreateResponse containerCreate = (ContainerCreateResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].call(callSiteArray[88].callGetProperty((Object)this.client), (Object)containerCreateRequest, (Object)name), ContainerCreateResponse.class);
        EngineResponseContent engineResponseContent = (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].callConstructor(EngineResponseContent.class, (Object)containerCreate), EngineResponseContent.class));
        try {
            return engineResponseContent;
        }
        catch (ClientException exception) {
            if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[90].callGetProperty((Object)exception), (Object)404)) throw (Throwable)exception;
            RepositoryAndTag repoAndTag = (RepositoryAndTag)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].call((Object)this.repositoryTagParser, callSiteArray[92].callGetProperty((Object)containerCreateRequest)), RepositoryAndTag.class);
            callSiteArray[93].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[94].callGetProperty((Object)repoAndTag), callSiteArray[95].callGetProperty((Object)repoAndTag)}, new String[]{"'", ":", "' not found locally."}));
            callSiteArray[96].call(callSiteArray[97].callGetProperty((Object)this.client), ArrayUtil.createArray((Object)callSiteArray[98].callGetProperty((Object)repoAndTag), null, null, (Object)callSiteArray[99].callGetProperty((Object)repoAndTag), null, (Object)authBase64Encoded, null, null, null));
            ContainerCreateResponse containerCreateWithPulledImage = (ContainerCreateResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[100].call(callSiteArray[101].callGetProperty((Object)this.client), (Object)containerCreateRequest, (Object)name), ContainerCreateResponse.class);
            EngineResponseContent engineResponseContent2 = (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[102].callConstructor(EngineResponseContent.class, (Object)containerCreateWithPulledImage), EngineResponseContent.class));
            return engineResponseContent2;
        }
    }

    @Override
    public EngineResponseContent<List<ContainerChangeResponseItem>> diff(String containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[103].call((Object)this.log, (Object)"docker diff");
        List containerChanges = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[104].call(callSiteArray[105].callGetProperty((Object)this.client), (Object)containerId), List.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[106].callConstructor(EngineResponseContent.class, (Object)containerChanges), EngineResponseContent.class));
    }

    @Override
    public EngineResponseContent<IdResponse> createExec(String containerId, ExecConfig execConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[107].call((Object)this.log, (Object)new GStringImpl(new Object[]{containerId}, new String[]{"docker create exec on '", "'"}));
        IdResponse containerExec = (IdResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[108].call(callSiteArray[109].callGetProperty((Object)this.client), (Object)containerId, (Object)execConfig), IdResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[110].callConstructor(EngineResponseContent.class, (Object)containerExec), EngineResponseContent.class));
    }

    @Override
    public void startExec(String execId, ExecStartConfig execStartConfig, AttachConfig attachConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[111].call((Object)this.log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"docker start exec '", "'"}));
        ExecInspectResponse execInspect = (ExecInspectResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[112].call(callSiteArray[113].callGetProperty((Object)this.client), (Object)execId), ExecInspectResponse.class);
        boolean multiplexStreams = false;
        multiplexStreams = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[114].callGetProperty(callSiteArray[115].callGetProperty((Object)execInspect))) : !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[116].callGetProperty(callSiteArray[117].callGetProperty((Object)execInspect)));
        EngineResponse response = (EngineResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[118].call((Object)this.engineClient, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", callSiteArray[119].call((Object)new GStringImpl(new Object[]{execId}, new String[]{"/exec/", "/start"})), "body", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Detach", callSiteArray[120].callGetProperty((Object)execStartConfig), "Tty", callSiteArray[121].callGetProperty((Object)execStartConfig)}), "requestContentType", "application/json", "attach", attachConfig, "multiplexStreams", multiplexStreams})), EngineResponse.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)attachConfig)) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[122].callGetPropertySafe(callSiteArray[123].callGetProperty((Object)response)), (Object)404)) {
                callSiteArray[124].call((Object)this.log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"no such exec '", "'"}));
            }
            callSiteArray[125].call((Object)this.responseHandler, (Object)response, callSiteArray[126].callConstructor(IllegalStateException.class, (Object)"docker exec start failed"));
            boolean bl = multiplexStreams;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)callSiteArray[127].callGetProperty((Object)response), (String)"multiplexStreams");
        }
    }

    @Override
    public void startExec(String execId, ExecStartConfig execStartConfig, StreamCallback<Frame> callback, Duration timeout) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[128].call((Object)this.log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"docker start exec '", "'"}));
        callSiteArray[129].call(callSiteArray[130].callGetProperty((Object)this.client), (Object)execId, (Object)execStartConfig, callback, callSiteArray[131].callSafe((Object)timeout));
    }

    @Override
    public EngineResponseContent<ExecInspectResponse> inspectExec(String execId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[132].call((Object)this.log, (Object)new GStringImpl(new Object[]{execId}, new String[]{"docker inspect exec '", "'"}));
        ExecInspectResponse execInspect = (ExecInspectResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[133].call(callSiteArray[134].callGetProperty((Object)this.client), (Object)execId), ExecInspectResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[135].callConstructor(EngineResponseContent.class, (Object)execInspect), EngineResponseContent.class));
    }

    @Override
    public EngineResponseContent<IdResponse> exec(String containerId, List<String> command, StreamCallback<Frame> callback, Duration timeout, Map<String, Object> execConfig) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[136].call((Object)this.log, (Object)new GStringImpl(new Object[]{containerId, command}, new String[]{"docker exec '", "' '", "'"}));
        Object object = callSiteArray[138].callGetProperty(execConfig);
        Object object2 = callSiteArray[139].callGetProperty(execConfig);
        ExecConfig actualExecConfig = (ExecConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[137].callConstructor(ExecConfig.class, ArrayUtil.createArray((Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Boolean.valueOf(false)), Boolean.class)), Boolean.class), (Object)true, (Object)true, null, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : Boolean.valueOf(false)), Boolean.class)), Boolean.class), null, command, null, null, null)), ExecConfig.class);
        EngineResponseContent execCreateResult = null;
        execCreateResult = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[140].callCurrent((GroovyObject)this, (Object)containerId, (Object)actualExecConfig), EngineResponseContent.class)) : this.createExec(containerId, actualExecConfig);
        String execId = ShortTypeHandling.castToString((Object)callSiteArray[141].callGetProperty(callSiteArray[142].callGetProperty((Object)execCreateResult)));
        Object object3 = callSiteArray[144].callGetProperty(execConfig);
        ExecStartConfig execStartConfig = (ExecStartConfig)ScriptBytecodeAdapter.castToType((Object)callSiteArray[143].callConstructor(ExecStartConfig.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : Boolean.valueOf(false)), Boolean.class)), Boolean.class), callSiteArray[145].callGetProperty((Object)actualExecConfig)), ExecStartConfig.class);
        callSiteArray[146].callCurrent((GroovyObject)this, (Object)execId, (Object)execStartConfig, callback, (Object)timeout);
        return execCreateResult;
    }

    @Override
    public void resizeExec(String exec, Integer height, Integer width) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[147].call((Object)this.log, (Object)"docker resize exec");
        callSiteArray[148].call(callSiteArray[149].callGetProperty((Object)this.client), (Object)exec, (Object)height, (Object)width);
    }

    @Override
    public EngineResponseContent<InputStream> export(String container) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[150].call((Object)this.log, (Object)new GStringImpl(new Object[]{container}, new String[]{"docker export ", ""}));
        InputStream containerExport = (InputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[151].call(callSiteArray[152].callGetProperty((Object)this.client), (Object)container), InputStream.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[153].callConstructor(EngineResponseContent.class, (Object)containerExport), EngineResponseContent.class));
    }

    @Override
    public EngineResponseContent<ContainerInspectResponse> inspectContainer(String containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[154].call((Object)this.log, (Object)"docker inspect container");
        ContainerInspectResponse containerInspect = (ContainerInspectResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[155].call(callSiteArray[156].callGetProperty((Object)this.client), (Object)containerId, null), ContainerInspectResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[157].callConstructor(EngineResponseContent.class, (Object)containerInspect), EngineResponseContent.class));
    }

    @Override
    public void kill(String containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[158].call((Object)this.log, (Object)"docker kill");
        callSiteArray[159].call(callSiteArray[160].callGetProperty((Object)this.client), (Object)containerId, null);
    }

    @Override
    public void logs(String container, Map<String, Object> query, StreamCallback<Frame> callback, Duration timeout) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[161].call((Object)this.log, (Object)"docker logs");
        Map actualQuery = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox(query)) {
            callSiteArray[162].call((Object)actualQuery, query);
        }
        Map defaults = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"follow", true, "stdout", true, "stderr", true, "timestamps", false, "since", 0, "tail", "all"});
        callSiteArray[163].call((Object)this.queryUtil, (Object)actualQuery, (Object)defaults);
        callSiteArray[164].call(callSiteArray[165].callGetProperty((Object)this.client), ArrayUtil.createArray((Object)container, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[166].callGetProperty((Object)actualQuery), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[167].callGetProperty((Object)actualQuery), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[168].callGetProperty((Object)actualQuery), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[169].callGetProperty((Object)actualQuery), Integer.class)), Integer.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[170].callGetProperty((Object)actualQuery), Integer.class)), Integer.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[171].callGetProperty((Object)actualQuery), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[172].callGetProperty((Object)actualQuery), String.class)), String.class), callback, (Object)callSiteArray[173].call((Object)timeout)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void waitForLogEvent(String container, Map<String, Object> query, Predicate<Frame> matcher, Duration timeout) {
        void var3_3;
        void var2_2;
        Reference container2 = new Reference((Object)container);
        Reference query2 = new Reference((Object)var2_2);
        Reference matcher2 = new Reference((Object)var3_3);
        Reference timeout2 = new Reference((Object)timeout);
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Reference latch = new Reference((Object)((CountDownLatch)ScriptBytecodeAdapter.castToType((Object)callSiteArray[174].callConstructor(CountDownLatch.class, (Object)1), CountDownLatch.class)));
        Reference frameHandler = new Reference((Object)new StreamCallback<Frame>(this, matcher2, latch){
            public /* synthetic */ Reference latch;
            public /* synthetic */ Reference matcher;
            final /* synthetic */ ManageContainerClient this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                ManageContainerClient manageContainerClient;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = manageContainerClient = p0;
                this.matcher = reference2 = p1;
                this.latch = reference = p2;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public void onNext(Frame element) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)((Predicate)ScriptBytecodeAdapter.castToType((Object)this.matcher.get(), Predicate.class)), (Object)element))) {
                    callSiteArray[1].call((Object)((CountDownLatch)ScriptBytecodeAdapter.castToType((Object)this.latch.get(), CountDownLatch.class)));
                }
            }

            public void onFailed(Exception e) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)"Logs failed", (Object)e);
                callSiteArray[4].call((Object)((CountDownLatch)ScriptBytecodeAdapter.castToType((Object)this.latch.get(), CountDownLatch.class)));
            }

            public void onFinished() {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                callSiteArray[5].call((Object)((CountDownLatch)ScriptBytecodeAdapter.castToType((Object)this.latch.get(), CountDownLatch.class)));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                if (!(args instanceof Object[])) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, ManageContainerClient.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                }
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                        return ScriptBytecodeAdapter.invokeMethodN(1.class, ManageContainerClient.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[7].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                    }
                } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[8].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, ManageContainerClient.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                }
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ManageContainerClient.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0.this$dist$set$1(name, value);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ManageContainerClient.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, ManageContainerClient.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "test";
                stringArray[1] = "countDown";
                stringArray[2] = "error";
                stringArray[3] = "log";
                stringArray[4] = "countDown";
                stringArray[5] = "countDown";
                stringArray[6] = "length";
                stringArray[7] = "getAt";
                stringArray[8] = "length";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[9];
                1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        public final class _waitForLogEvent_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference query;
            private /* synthetic */ Reference container;
            private /* synthetic */ Reference frameHandler;
            private /* synthetic */ Reference timeout;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _waitForLogEvent_closure1(Object _outerInstance, Object _thisObject, Reference query, Reference container, Reference frameHandler, Reference timeout) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _waitForLogEvent_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.query = reference4 = query;
                this.container = reference3 = container;
                this.frameHandler = reference2 = frameHandler;
                this.timeout = reference = timeout;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _waitForLogEvent_closure1.$getCallSiteArray();
                int n = 1;
                ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)((Map)ScriptBytecodeAdapter.castToType((Object)this.query.get(), Map.class)), (String)"tail");
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)ShortTypeHandling.castToString((Object)this.container.get()), (Object)((Map)ScriptBytecodeAdapter.castToType((Object)this.query.get(), Map.class)), this.frameHandler.get(), (Object)((Duration)ScriptBytecodeAdapter.castToType((Object)this.timeout.get(), Duration.class)));
            }

            @Generated
            public Map getQuery() {
                CallSite[] callSiteArray = _waitForLogEvent_closure1.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.query.get(), Map.class);
            }

            @Generated
            public String getContainer() {
                CallSite[] callSiteArray = _waitForLogEvent_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.container.get());
            }

            @Generated
            public Object getFrameHandler() {
                CallSite[] callSiteArray = _waitForLogEvent_closure1.$getCallSiteArray();
                return this.frameHandler.get();
            }

            @Generated
            public Duration getTimeout() {
                CallSite[] callSiteArray = _waitForLogEvent_closure1.$getCallSiteArray();
                return (Duration)ScriptBytecodeAdapter.castToType((Object)this.timeout.get(), Duration.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _waitForLogEvent_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _waitForLogEvent_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "logs";
                return new CallSiteArray(_waitForLogEvent_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _waitForLogEvent_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[175].call(callSiteArray[176].callConstructor(Thread.class, (Object)new _waitForLogEvent_closure1(this, this, query2, container2, frameHandler, timeout2)));
        Object success = callSiteArray[177].call((Object)((CountDownLatch)latch.get()), callSiteArray[178].call((Object)((Duration)timeout2.get())), callSiteArray[179].callGetProperty(TimeUnit.class));
        if (!DefaultTypeTransformation.booleanUnbox((Object)success)) {
            callSiteArray[180].call((Object)this.log, (Object)"Timeout reached after {} while waiting for the expected log message", (Object)((Duration)timeout2.get()));
        }
    }

    @Override
    public EngineResponseContent<List<Map<String, Object>>> ps(Map<String, Object> query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[181].call((Object)this.log, (Object)"docker ps");
        Map actualQuery = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox(query)) {
            callSiteArray[182].call((Object)actualQuery, query);
        }
        Map defaults = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"all", true, "size", false});
        callSiteArray[183].call((Object)this.queryUtil, (Object)actualQuery, (Object)defaults);
        callSiteArray[184].call((Object)this.queryUtil, (Object)actualQuery, (Object)"filters");
        List containerList = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[185].call(callSiteArray[186].callGetProperty((Object)this.client), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[187].callGetProperty((Object)actualQuery), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[188].callGetProperty((Object)actualQuery), Integer.class)), Integer.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[189].callGetProperty((Object)actualQuery), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[190].callGetProperty((Object)actualQuery), String.class)), String.class)), List.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[191].callConstructor(EngineResponseContent.class, (Object)containerList), EngineResponseContent.class));
    }

    @Override
    public EngineResponseContent<List<Map<String, Object>>> ps(Boolean all, Integer limit, Boolean size, String filters) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[192].call((Object)this.log, (Object)"docker ps");
        Boolean bl = size;
        List containerList = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[193].call(callSiteArray[194].callGetProperty((Object)this.client), (Object)(ScriptBytecodeAdapter.compareEqual((Object)all, null) ? Boolean.valueOf(true) : all), (Object)limit, (Object)(DefaultTypeTransformation.booleanUnbox((Object)bl) ? bl : Boolean.valueOf(false)), (Object)filters), List.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[195].callConstructor(EngineResponseContent.class, (Object)containerList), EngineResponseContent.class));
    }

    @Override
    public void pause(String containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[196].call((Object)this.log, (Object)"docker pause");
        callSiteArray[197].call(callSiteArray[198].callGetProperty((Object)this.client), (Object)containerId);
    }

    @Override
    public EngineResponseContent<ContainerPruneResponse> pruneContainers(String filters) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[199].call((Object)this.log, (Object)"docker container prune");
        ContainerPruneResponse containerPrune = (ContainerPruneResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[200].call(callSiteArray[201].callGetProperty((Object)this.client), (Object)filters), ContainerPruneResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[202].callConstructor(EngineResponseContent.class, (Object)containerPrune), EngineResponseContent.class));
    }

    @Override
    public void rename(String container, String newName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[203].call((Object)this.log, (Object)"docker rename");
        callSiteArray[204].call(callSiteArray[205].callGetProperty((Object)this.client), (Object)container, (Object)newName);
    }

    @Override
    public void restart(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[206].call((Object)this.log, (Object)"docker restart");
        callSiteArray[207].call(callSiteArray[208].callGetProperty((Object)this.client), (Object)containerIdOrName, (Object)5);
    }

    @Override
    public void rm(String containerIdOrName, Map<String, Object> query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[209].call((Object)this.log, (Object)"docker rm");
        callSiteArray[210].call(callSiteArray[211].callGetProperty((Object)this.client), (Object)containerIdOrName, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[212].callGetProperty(query), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[213].callGetProperty(query), Boolean.class)), Boolean.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[214].callGetProperty(query), Boolean.class)), Boolean.class));
    }

    @Override
    public EngineResponseContent<ContainerCreateResponse> run(ContainerCreateRequest containerCreateRequest, String name, String authBase64Encoded) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[215].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[216].callGetProperty((Object)containerCreateRequest)}, new String[]{"docker run ", ""}));
        EngineResponseContent createContainerResponse = null;
        createContainerResponse = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[217].callCurrent((GroovyObject)this, (Object)containerCreateRequest, (Object)name, (Object)authBase64Encoded), EngineResponseContent.class)) : this.createContainer(containerCreateRequest, name, authBase64Encoded);
        callSiteArray[218].call((Object)this.log, (Object)new GStringImpl(new Object[]{createContainerResponse}, new String[]{"create container result: ", ""}));
        String containerId = ShortTypeHandling.castToString((Object)callSiteArray[219].callGetProperty(callSiteArray[220].callGetProperty((Object)createContainerResponse)));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[221].callCurrent((GroovyObject)this, (Object)containerId);
        } else {
            this.startContainer(containerId);
        }
        return createContainerResponse;
    }

    @Override
    public void startContainer(String containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[222].call((Object)this.log, (Object)"docker start");
        callSiteArray[223].call(callSiteArray[224].callGetProperty((Object)this.client), (Object)containerId, null);
    }

    @Override
    public void stats(String container, Boolean stream, StreamCallback<Object> callback, Duration timeout) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[225].call((Object)this.log, (Object)"docker stats");
        callSiteArray[226].call(callSiteArray[227].callGetProperty((Object)this.client), ArrayUtil.createArray((Object)container, (Object)stream, null, callback, (Object)callSiteArray[228].call((Object)timeout)));
    }

    @Override
    public void stop(String containerIdOrName, Integer timeoutSeconds) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[229].callCurrent((GroovyObject)this, (Object)containerIdOrName, ScriptBytecodeAdapter.compareNotEqual((Object)timeoutSeconds, null) ? callSiteArray[230].call(Duration.class, (Object)timeoutSeconds, callSiteArray[231].callGetProperty(ChronoUnit.class)) : null);
    }

    @Override
    public void stop(String containerIdOrName, Duration timeout) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[232].call((Object)this.log, (Object)"docker stop");
        Duration duration = timeout;
        long timeoutInSeconds = DefaultTypeTransformation.longUnbox((Object)callSiteArray[233].callGetProperty(DefaultTypeTransformation.booleanUnbox((Object)duration) ? duration : callSiteArray[234].call(Duration.class, (Object)10, callSiteArray[235].callGetProperty(ChronoUnit.class))));
        callSiteArray[236].call(callSiteArray[237].callGetProperty((Object)this.client), (Object)containerIdOrName, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)timeoutInSeconds, Integer.TYPE)), Integer.TYPE));
    }

    @Override
    public EngineResponseContent<ContainerTopResponse> top(String containerIdOrName, String psArgs) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[238].call((Object)this.log, (Object)"docker top");
        String string = psArgs;
        ContainerTopResponse containerTop = (ContainerTopResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[239].call(callSiteArray[240].callGetProperty((Object)this.client), (Object)containerIdOrName, (Object)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : null)), ContainerTopResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[241].callConstructor(EngineResponseContent.class, (Object)containerTop), EngineResponseContent.class));
    }

    @Override
    public void unpause(String containerId) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[242].call((Object)this.log, (Object)"docker unpause");
        callSiteArray[243].call(callSiteArray[244].callGetProperty((Object)this.client), (Object)containerId);
    }

    @Override
    public EngineResponseContent<ContainerUpdateResponse> updateContainer(String container, ContainerUpdateRequest containerUpdateRequest) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[245].call((Object)this.log, (Object)new GStringImpl(new Object[]{container}, new String[]{"docker update '", "'"}));
        ContainerUpdateResponse containerUpdate = (ContainerUpdateResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[246].call(callSiteArray[247].callGetProperty((Object)this.client), (Object)container, (Object)containerUpdateRequest), ContainerUpdateResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[248].callConstructor(EngineResponseContent.class, (Object)containerUpdate), EngineResponseContent.class));
    }

    @Override
    public EngineResponseContent<ContainerWaitResponse> wait(String containerIdOrName, ContainerApi.ConditionContainerWait condition) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        callSiteArray[249].call((Object)this.log, (Object)"docker wait");
        ContainerWaitResponse containerWait = (ContainerWaitResponse)ScriptBytecodeAdapter.castToType((Object)callSiteArray[250].call(callSiteArray[251].callGetProperty((Object)this.client), (Object)containerIdOrName, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)condition, ContainerApi.ConditionContainerWait.class)), ContainerWaitResponse.class);
        return (EngineResponseContent)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[252].callConstructor(EngineResponseContent.class, (Object)containerWait), EngineResponseContent.class));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ManageContainerClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ManageContainerClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[253].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ManageContainerClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[254].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[255].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ManageContainerClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ManageContainerClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ManageContainerClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ManageContainerClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    @Generated
    public EngineResponse attach(String containerId, Map<String, Object> query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.attach(containerId, query, null);
    }

    @Override
    @Generated
    public EngineResponseContent<IdResponse> commit(String container, Map query) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.commit(container, query, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerCreateResponse> createContainer(ContainerCreateRequest containerCreateRequest, String name) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.createContainer(containerCreateRequest, name, "");
        }
        return this.createContainer(containerCreateRequest, name, "");
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerCreateResponse> createContainer(ContainerCreateRequest containerCreateRequest) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.createContainer(containerCreateRequest, "", "");
        }
        return this.createContainer(containerCreateRequest, "", "");
    }

    @Override
    @Generated
    public EngineResponseContent<IdResponse> exec(String containerId, List<String> command, StreamCallback<Frame> callback, Duration timeout) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        return this.exec(containerId, command, callback, timeout, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Detach", false, "AttachStdin", false, "Tty", false}));
    }

    @Override
    @Generated
    public EngineResponseContent<List<Map<String, Object>>> ps(Boolean all, Integer limit, Boolean size) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.ps(all, limit, size, null);
        }
        return this.ps(all, limit, size, null);
    }

    @Override
    @Generated
    public EngineResponseContent<List<Map<String, Object>>> ps(Boolean all, Integer limit) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.ps(all, limit, false, null);
        }
        return this.ps(all, limit, false, null);
    }

    @Override
    @Generated
    public EngineResponseContent<List<Map<String, Object>>> ps(Boolean all) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.ps(all, null, false, null);
        }
        return this.ps(all, null, false, null);
    }

    @Override
    @Generated
    public EngineResponseContent<List<Map<String, Object>>> ps() {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.ps(true, null, false, null);
        }
        return this.ps(true, null, false, null);
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerPruneResponse> pruneContainers() {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.pruneContainers(null);
        }
        return this.pruneContainers(null);
    }

    @Override
    @Generated
    public void rm(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        this.rm(containerIdOrName, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerCreateResponse> run(ContainerCreateRequest containerCreateRequest, String name) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.run(containerCreateRequest, name, "");
        }
        return this.run(containerCreateRequest, name, "");
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerCreateResponse> run(ContainerCreateRequest containerCreateRequest) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.run(containerCreateRequest, "", "");
        }
        return this.run(containerCreateRequest, "", "");
    }

    @Override
    @Generated
    public void stop(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            this.stop(containerIdOrName, (Duration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[256].call(Duration.class, (Object)10, callSiteArray[257].callGetProperty(ChronoUnit.class)), Duration.class));
        } else {
            this.stop(containerIdOrName, (Duration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[258].call(Duration.class, (Object)10, callSiteArray[259].callGetProperty(ChronoUnit.class)), Duration.class));
        }
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerTopResponse> top(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.top(containerIdOrName, null);
        }
        return this.top(containerIdOrName, null);
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerWaitResponse> wait(String containerIdOrName) {
        CallSite[] callSiteArray = ManageContainerClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.wait(containerIdOrName, null);
        }
        return this.wait(containerIdOrName, null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getLogger";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "info";
        stringArray[6] = "inspectContainer";
        stringArray[7] = "tty";
        stringArray[8] = "config";
        stringArray[9] = "content";
        stringArray[10] = "tty";
        stringArray[11] = "config";
        stringArray[12] = "content";
        stringArray[13] = "post";
        stringArray[14] = "toString";
        stringArray[15] = "stream";
        stringArray[16] = "info";
        stringArray[17] = "containerAttach";
        stringArray[18] = "containerApi";
        stringArray[19] = "toMillis";
        stringArray[20] = "info";
        stringArray[21] = "webSocket";
        stringArray[22] = "toString";
        stringArray[23] = "info";
        stringArray[24] = "containerResize";
        stringArray[25] = "containerApi";
        stringArray[26] = "info";
        stringArray[27] = "imageCommit";
        stringArray[28] = "imageApi";
        stringArray[29] = "repo";
        stringArray[30] = "tag";
        stringArray[31] = "comment";
        stringArray[32] = "author";
        stringArray[33] = "pause";
        stringArray[34] = "changes";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "Hostname";
        stringArray[37] = "Domainname";
        stringArray[38] = "User";
        stringArray[39] = "AttachStdin";
        stringArray[40] = "AttachStdout";
        stringArray[41] = "AttachStderr";
        stringArray[42] = "ExposedPorts";
        stringArray[43] = "Tty";
        stringArray[44] = "OpenStdin";
        stringArray[45] = "StdinOnce";
        stringArray[46] = "Env";
        stringArray[47] = "Cmd";
        stringArray[48] = "Cmd";
        stringArray[49] = "Cmd";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "ArgsEscaped";
        stringArray[52] = "Image";
        stringArray[53] = "Volumes";
        stringArray[54] = "WorkingDir";
        stringArray[55] = "Entrypoint";
        stringArray[56] = "Entrypoint";
        stringArray[57] = "Entrypoint";
        stringArray[58] = "NetworkDisabled";
        stringArray[59] = "MacAddress";
        stringArray[60] = "OnBuild";
        stringArray[61] = "Labels";
        stringArray[62] = "StopSignal";
        stringArray[63] = "StopTimeout";
        stringArray[64] = "Shell";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "info";
        stringArray[67] = "containerArchiveInfo";
        stringArray[68] = "containerApi";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "info";
        stringArray[71] = "getArchive";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "copySingleTarEntry";
        stringArray[74] = "content";
        stringArray[75] = "info";
        stringArray[76] = "toByteArray";
        stringArray[77] = "info";
        stringArray[78] = "containerArchive";
        stringArray[79] = "containerApi";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "info";
        stringArray[82] = "putContainerArchive";
        stringArray[83] = "containerApi";
        stringArray[84] = "info";
        stringArray[85] = "image";
        stringArray[86] = "<$constructor$>";
        stringArray[87] = "containerCreate";
        stringArray[88] = "containerApi";
        stringArray[89] = "<$constructor$>";
        stringArray[90] = "statusCode";
        stringArray[91] = "parseRepositoryTag";
        stringArray[92] = "image";
        stringArray[93] = "info";
        stringArray[94] = "repo";
        stringArray[95] = "tag";
        stringArray[96] = "imageCreate";
        stringArray[97] = "imageApi";
        stringArray[98] = "repo";
        stringArray[99] = "tag";
        stringArray[100] = "containerCreate";
        stringArray[101] = "containerApi";
        stringArray[102] = "<$constructor$>";
        stringArray[103] = "info";
        stringArray[104] = "containerChanges";
        stringArray[105] = "containerApi";
        stringArray[106] = "<$constructor$>";
        stringArray[107] = "info";
        stringArray[108] = "containerExec";
        stringArray[109] = "execApi";
        stringArray[110] = "<$constructor$>";
        stringArray[111] = "info";
        stringArray[112] = "execInspect";
        stringArray[113] = "execApi";
        stringArray[114] = "tty";
        stringArray[115] = "processConfig";
        stringArray[116] = "tty";
        stringArray[117] = "processConfig";
        stringArray[118] = "post";
        stringArray[119] = "toString";
        stringArray[120] = "detach";
        stringArray[121] = "tty";
        stringArray[122] = "code";
        stringArray[123] = "status";
        stringArray[124] = "error";
        stringArray[125] = "ensureSuccessfulResponse";
        stringArray[126] = "<$constructor$>";
        stringArray[127] = "stream";
        stringArray[128] = "info";
        stringArray[129] = "execStart";
        stringArray[130] = "execApi";
        stringArray[131] = "toMillis";
        stringArray[132] = "info";
        stringArray[133] = "execInspect";
        stringArray[134] = "execApi";
        stringArray[135] = "<$constructor$>";
        stringArray[136] = "info";
        stringArray[137] = "<$constructor$>";
        stringArray[138] = "AttachStdin";
        stringArray[139] = "Tty";
        stringArray[140] = "createExec";
        stringArray[141] = "id";
        stringArray[142] = "content";
        stringArray[143] = "<$constructor$>";
        stringArray[144] = "Detach";
        stringArray[145] = "tty";
        stringArray[146] = "startExec";
        stringArray[147] = "info";
        stringArray[148] = "execResize";
        stringArray[149] = "execApi";
        stringArray[150] = "info";
        stringArray[151] = "containerExport";
        stringArray[152] = "containerApi";
        stringArray[153] = "<$constructor$>";
        stringArray[154] = "info";
        stringArray[155] = "containerInspect";
        stringArray[156] = "containerApi";
        stringArray[157] = "<$constructor$>";
        stringArray[158] = "info";
        stringArray[159] = "containerKill";
        stringArray[160] = "containerApi";
        stringArray[161] = "info";
        stringArray[162] = "putAll";
        stringArray[163] = "applyDefaults";
        stringArray[164] = "containerLogs";
        stringArray[165] = "containerApi";
        stringArray[166] = "follow";
        stringArray[167] = "stdout";
        stringArray[168] = "stderr";
        stringArray[169] = "since";
        stringArray[170] = "until";
        stringArray[171] = "timestamps";
        stringArray[172] = "tail";
        stringArray[173] = "toMillis";
        stringArray[174] = "<$constructor$>";
        stringArray[175] = "start";
        stringArray[176] = "<$constructor$>";
        stringArray[177] = "await";
        stringArray[178] = "toMillis";
        stringArray[179] = "MILLISECONDS";
        stringArray[180] = "warn";
        stringArray[181] = "info";
        stringArray[182] = "putAll";
        stringArray[183] = "applyDefaults";
        stringArray[184] = "jsonEncodeQueryParameter";
        stringArray[185] = "containerList";
        stringArray[186] = "containerApi";
        stringArray[187] = "all";
        stringArray[188] = "limit";
        stringArray[189] = "size";
        stringArray[190] = "filters";
        stringArray[191] = "<$constructor$>";
        stringArray[192] = "info";
        stringArray[193] = "containerList";
        stringArray[194] = "containerApi";
        stringArray[195] = "<$constructor$>";
        stringArray[196] = "info";
        stringArray[197] = "containerPause";
        stringArray[198] = "containerApi";
        stringArray[199] = "info";
        stringArray[200] = "containerPrune";
        stringArray[201] = "containerApi";
        stringArray[202] = "<$constructor$>";
        stringArray[203] = "info";
        stringArray[204] = "containerRename";
        stringArray[205] = "containerApi";
        stringArray[206] = "info";
        stringArray[207] = "containerRestart";
        stringArray[208] = "containerApi";
        stringArray[209] = "info";
        stringArray[210] = "containerDelete";
        stringArray[211] = "containerApi";
        stringArray[212] = "v";
        stringArray[213] = "force";
        stringArray[214] = "link";
        stringArray[215] = "info";
        stringArray[216] = "image";
        stringArray[217] = "createContainer";
        stringArray[218] = "debug";
        stringArray[219] = "id";
        stringArray[220] = "content";
        stringArray[221] = "startContainer";
        stringArray[222] = "info";
        stringArray[223] = "containerStart";
        stringArray[224] = "containerApi";
        stringArray[225] = "info";
        stringArray[226] = "containerStats";
        stringArray[227] = "containerApi";
        stringArray[228] = "toMillis";
        stringArray[229] = "stop";
        stringArray[230] = "of";
        stringArray[231] = "SECONDS";
        stringArray[232] = "info";
        stringArray[233] = "seconds";
        stringArray[234] = "of";
        stringArray[235] = "SECONDS";
        stringArray[236] = "containerStop";
        stringArray[237] = "containerApi";
        stringArray[238] = "info";
        stringArray[239] = "containerTop";
        stringArray[240] = "containerApi";
        stringArray[241] = "<$constructor$>";
        stringArray[242] = "info";
        stringArray[243] = "containerUnpause";
        stringArray[244] = "containerApi";
        stringArray[245] = "info";
        stringArray[246] = "containerUpdate";
        stringArray[247] = "containerApi";
        stringArray[248] = "<$constructor$>";
        stringArray[249] = "info";
        stringArray[250] = "containerWait";
        stringArray[251] = "containerApi";
        stringArray[252] = "<$constructor$>";
        stringArray[253] = "length";
        stringArray[254] = "getAt";
        stringArray[255] = "length";
        stringArray[256] = "of";
        stringArray[257] = "SECONDS";
        stringArray[258] = "of";
        stringArray[259] = "SECONDS";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[260];
        ManageContainerClient.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ManageContainerClient.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ManageContainerClient.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

