/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.container;

import de.gesellix.docker.engine.EngineResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerResponseHandler {
    private final Logger log = LoggerFactory.getLogger(DockerResponseHandler.class);

    public void ensureSuccessfulResponse(EngineResponse response, Throwable throwable) throws Throwable {
        if (response == null || !response.getStatus().getSuccess() || this.hasError(response)) {
            this.logError(response);
            throw throwable;
        }
    }

    public void logError(EngineResponse response) {
        if (response != null && response.getContent() instanceof String) {
            this.log.error("request failed: '{}'", response.getContent());
        } else {
            this.log.error("request failed: {}", this.getErrors(response));
        }
    }

    public boolean hasError(EngineResponse response) {
        return this.getErrors(response).size() > 0;
    }

    public List<Object> getErrors(EngineResponse response) {
        if (response == null || response.getContent() == null) {
            return Collections.emptyList();
        }
        if (response.getMimeType() == null || response.getMimeType().equals("application/json")) {
            ArrayList<Object> foundErrors = new ArrayList<Object>();
            if (response.getContent() instanceof List) {
                List content = (List)response.getContent();
                content.forEach(element -> {
                    if (element instanceof Map) {
                        foundErrors.add(((Map)element).get("error"));
                    } else if (element != null) {
                        foundErrors.add(element.toString());
                    }
                });
            } else if (response.getContent() instanceof Map) {
                Map content = (Map)response.getContent();
                if (content.containsKey("error")) {
                    foundErrors.add(content.get("error"));
                } else if (content.containsKey("message")) {
                    foundErrors.add(content.get("message"));
                }
            } else {
                this.log.debug("won't search for errors in {}", response.getContent().getClass());
            }
            return foundErrors;
        }
        return Collections.emptyList();
    }
}

