/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.swarm;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.swarm.ManageSwarm;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.Swarm;
import de.gesellix.docker.remote.api.SwarmInitRequest;
import de.gesellix.docker.remote.api.SwarmJoinRequest;
import de.gesellix.docker.remote.api.SwarmSpec;
import de.gesellix.docker.remote.api.SwarmUnlockRequest;
import de.gesellix.docker.remote.api.UnlockKeyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageSwarmClient
implements ManageSwarm {
    private final Logger log = LoggerFactory.getLogger(ManageSwarmClient.class);
    private final EngineApiClient client;

    public ManageSwarmClient(EngineApiClient client) {
        this.client = client;
    }

    @Override
    public SwarmInitRequest newSwarmInitRequest() {
        return new SwarmInitRequest("0.0.0.0:2377", null, null, null, null, Boolean.valueOf(false), null, null);
    }

    @Override
    public EngineResponseContent<String> initSwarm() {
        return this.initSwarm(this.newSwarmInitRequest());
    }

    @Override
    public EngineResponseContent<String> initSwarm(SwarmInitRequest swarmInitRequest) {
        this.log.info("docker swarm init");
        String nodeId = this.client.getSwarmApi().swarmInit(swarmInitRequest);
        return new EngineResponseContent<String>(nodeId);
    }

    @Override
    public void joinSwarm(SwarmJoinRequest swarmJoinRequest) {
        this.log.info("docker swarm join");
        this.client.getSwarmApi().swarmJoin(swarmJoinRequest);
    }

    @Override
    public void leaveSwarm(Boolean force) {
        this.log.info("docker swarm leave");
        this.client.getSwarmApi().swarmLeave(force);
    }

    @Override
    public void leaveSwarm() {
        this.leaveSwarm(null);
    }

    @Override
    public void updateSwarm(long version, SwarmSpec spec, Boolean rotateWorkerToken, Boolean rotateManagerToken, Boolean rotateManagerUnlockKey) {
        this.log.info("docker swarm update");
        this.client.getSwarmApi().swarmUpdate(version, spec, rotateWorkerToken, rotateManagerToken, rotateManagerUnlockKey);
    }

    @Override
    public void updateSwarm(long version, SwarmSpec spec, Boolean rotateWorkerToken, Boolean rotateManagerToken) {
        this.updateSwarm(version, spec, rotateWorkerToken, rotateManagerToken, null);
    }

    @Override
    public void updateSwarm(long version, SwarmSpec spec, Boolean rotateWorkerToken) {
        this.updateSwarm(version, spec, rotateWorkerToken, null, null);
    }

    @Override
    public void updateSwarm(long version, SwarmSpec spec) {
        this.updateSwarm(version, spec, null, null, null);
    }

    @Override
    public String getSwarmWorkerToken() {
        this.log.info("docker swarm join-token worker");
        Swarm swarm = (Swarm)this.inspectSwarm().getContent();
        return swarm.getJoinTokens().getWorker();
    }

    @Override
    public String rotateSwarmWorkerToken() {
        this.log.info("docker swarm join-token rotate worker token");
        Swarm swarm = (Swarm)this.inspectSwarm().getContent();
        this.client.getSwarmApi().swarmUpdate((long)swarm.getVersion().getIndex().intValue(), swarm.getSpec(), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        return this.getSwarmWorkerToken();
    }

    @Override
    public String getSwarmManagerToken() {
        this.log.info("docker swarm join-token manager");
        Swarm swarm = (Swarm)this.inspectSwarm().getContent();
        return swarm.getJoinTokens().getManager();
    }

    @Override
    public String rotateSwarmManagerToken() {
        this.log.info("docker swarm join-token rotate manager token");
        Swarm swarm = (Swarm)this.inspectSwarm().getContent();
        this.client.getSwarmApi().swarmUpdate((long)swarm.getVersion().getIndex().intValue(), swarm.getSpec(), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
        return this.getSwarmManagerToken();
    }

    @Override
    public String getSwarmManagerUnlockKey() {
        this.log.info("docker swarm manager unlock key");
        UnlockKeyResponse unlockkey = this.client.getSwarmApi().swarmUnlockkey();
        return unlockkey.getUnlockKey();
    }

    @Override
    public String rotateSwarmManagerUnlockKey() {
        this.log.info("docker swarm join-token rotate manager unlock key");
        Swarm swarm = (Swarm)this.inspectSwarm().getContent();
        this.client.getSwarmApi().swarmUpdate((long)swarm.getVersion().getIndex().intValue(), swarm.getSpec(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true));
        return this.getSwarmManagerUnlockKey();
    }

    @Override
    public void unlockSwarm(String unlockKey) {
        this.log.info("docker swarm unlock");
        this.client.getSwarmApi().swarmUnlock(new SwarmUnlockRequest(unlockKey));
    }

    @Override
    public EngineResponseContent<Swarm> inspectSwarm() {
        this.log.info("docker swarm inspect");
        Swarm swarmInspect = this.client.getSwarmApi().swarmInspect();
        return new EngineResponseContent<Swarm>(swarmInspect);
    }
}

