/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.image;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.authentication.ManageAuthentication;
import de.gesellix.docker.client.image.ManageImage;
import de.gesellix.docker.client.repository.RepositoryTagParser;
import de.gesellix.docker.remote.api.BuildInfo;
import de.gesellix.docker.remote.api.CreateImageInfo;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.HistoryResponseItem;
import de.gesellix.docker.remote.api.ImageDeleteResponseItem;
import de.gesellix.docker.remote.api.ImageInspect;
import de.gesellix.docker.remote.api.ImagePruneResponse;
import de.gesellix.docker.remote.api.ImageSearchResponseItem;
import de.gesellix.docker.remote.api.ImageSummary;
import de.gesellix.docker.remote.api.PushImageInfo;
import de.gesellix.docker.remote.api.client.ImageApi;
import de.gesellix.docker.remote.api.core.StreamCallback;
import de.gesellix.util.QueryUtil;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageImageClient
implements ManageImage,
GroovyObject {
    private final Logger log;
    private EngineApiClient client;
    private RepositoryTagParser repositoryTagParser;
    private QueryUtil queryUtil;
    private ManageAuthentication manageAuthentication;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ManageImageClient(EngineApiClient client, ManageAuthentication manageAuthentication) {
        ManageAuthentication manageAuthentication2;
        EngineApiClient engineApiClient;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, ManageImageClient.class);
        this.log = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.client = engineApiClient = client;
        this.manageAuthentication = manageAuthentication2 = manageAuthentication;
        CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, RepositoryTagParser.class);
        this.repositoryTagParser = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        CallSite callSite3 = IndyInterface.bootstrap("init", "<init>", 0, QueryUtil.class);
        this.queryUtil = IndyInterface.bootstrap("cast", "()", 0, callSite3);
    }

    @Override
    public EngineResponseContent<List<ImageSearchResponseItem>> search(String term, Integer limit) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker search");
        CallSite imageSearch = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "imageSearch", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), term, limit, null));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, imageSearch));
    }

    @Override
    public void build(InputStream buildContext) {
        IndyInterface.bootstrap("invoke", "build", 2, this, null, null, buildContext);
    }

    @Override
    public void build(StreamCallback<BuildInfo> callback, Duration timeout, InputStream buildContext) {
        IndyInterface.bootstrap("invoke", "build", 2, this, callback, timeout, null, null, null, null, null, null, null, null, null, null, buildContext);
    }

    @Override
    public void build(String tag, InputStream buildContext) {
        IndyInterface.bootstrap("invoke", "build", 2, this, null, null, buildContext);
    }

    @Override
    public void build(StreamCallback<BuildInfo> callback, Duration timeout, String tag, InputStream buildContext) {
        IndyInterface.bootstrap("invoke", "build", 2, this, callback, timeout, null, tag, null, null, null, null, null, null, null, null, buildContext);
    }

    @Override
    public void build(String dockerfile, String tag, Boolean quiet, Boolean nocache, String pull, Boolean rm, String buildargs, String labels, String encodedRegistryConfig, String contentType, InputStream buildContext) {
        IndyInterface.bootstrap("invoke", "build", 2, this, null, null, dockerfile, tag, quiet, nocache, pull, rm, buildargs, labels, encodedRegistryConfig, contentType, buildContext);
    }

    @Override
    public void build(StreamCallback<BuildInfo> callback, Duration timeout, String dockerfile, String tag, Boolean quiet, Boolean nocache, String pull, Boolean rm, String buildargs, String labels, String encodedRegistryConfig, String contentType, InputStream buildContext) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker build");
        if (IndyInterface.bootstrap("cast", "()", 0, encodedRegistryConfig) == false) {
            encodedRegistryConfig = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "encodeAuthConfigs", 0, this.manageAuthentication, IndyInterface.bootstrap("invoke", "getAllAuthConfigs", 0, this.manageAuthentication)));
        }
        CallSite contentTypeImageBuild = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, contentType) != false ? IndyInterface.bootstrap("invoke", "valueOf", 0, ImageApi.ContentTypeImageBuild.class, contentType) : IndyInterface.bootstrap("getProperty", "ApplicationSlashXMinusTar", 0, ImageApi.ContentTypeImageBuild.class));
        IndyInterface.bootstrap("invoke", "imageBuild", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), dockerfile, tag, null, null, quiet, nocache, null, pull, ScriptBytecodeAdapter.compareEqual((Object)rm, null) ? Boolean.valueOf(true) : rm, null, null, null, null, null, null, null, buildargs, null, null, labels, null, contentTypeImageBuild, encodedRegistryConfig, null, null, null, buildContext, callback, IndyInterface.bootstrap("cast", "()", 0, timeout) != false ? IndyInterface.bootstrap("invoke", "toMillis", 0, timeout) : null);
    }

    @Override
    public EngineResponseContent<List<HistoryResponseItem>> history(String imageId) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker history");
        CallSite imageHistory = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "imageHistory", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), imageId));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, imageHistory));
    }

    @Override
    public EngineResponseContent<ImageInspect> inspectImage(String imageId) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker inspect image");
        CallSite imageInspect = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "imageInspect", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), imageId));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, imageInspect));
    }

    @Override
    public void load(InputStream imagesTarball) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker load");
        IndyInterface.bootstrap("invoke", "imageLoad", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), null, imagesTarball);
    }

    @Override
    @Deprecated
    public EngineResponseContent<List<ImageSummary>> images(Map<String, Object> query) {
        CallSite actualQuery = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        if (ScriptBytecodeAdapter.compareNotEqual(query, null)) {
            IndyInterface.bootstrap("invoke", "putAll", 0, actualQuery, query);
        }
        Map defaults = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"all", false});
        IndyInterface.bootstrap("invoke", "applyDefaults", 0, this.queryUtil, actualQuery, defaults);
        IndyInterface.bootstrap("invoke", "jsonEncodeQueryParameter", 0, this.queryUtil, actualQuery, "filters");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "images", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, actualQuery, "all")), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, actualQuery, "filters")), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, actualQuery, "digests")), Boolean.class)));
    }

    @Override
    public EngineResponseContent<List<ImageSummary>> images(Boolean all, String filters, Boolean digests) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker images");
        CallSite imageList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "imageList", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), all, filters, digests));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, imageList));
    }

    @Override
    @Deprecated
    public EngineResponseContent<ImagePruneResponse> pruneImages(Map<String, Object> query) {
        CallSite actualQuery = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        if (ScriptBytecodeAdapter.compareNotEqual(query, null)) {
            IndyInterface.bootstrap("invoke", "putAll", 0, actualQuery, query);
        }
        IndyInterface.bootstrap("invoke", "jsonEncodeQueryParameter", 0, this.queryUtil, actualQuery, "filters");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "pruneImages", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "filters", 0, actualQuery), String.class))), String.class)));
    }

    @Override
    public EngineResponseContent<ImagePruneResponse> pruneImages(String filters) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker image prune");
        CallSite imagePrune = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "imagePrune", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), filters));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, imagePrune));
    }

    @Override
    public void pull(StreamCallback<CreateImageInfo> callback, Duration timeout, String imageName, String tag, String authBase64Encoded) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker pull '{}:{}'", imageName, tag);
        String string = tag;
        IndyInterface.bootstrap("invoke", "imageCreate", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), imageName, null, null, IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : "", null, authBase64Encoded, null, null, null, callback, IndyInterface.bootstrap("cast", "()", 0, timeout) != false ? IndyInterface.bootstrap("invoke", "toMillis", 0, timeout) : null);
    }

    @Override
    public void importUrl(StreamCallback<CreateImageInfo> callback, Duration timeout, String url, String repository, String tag) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker import '{}' into {}:{}", url, repository, tag);
        String string = repository;
        String string2 = tag;
        IndyInterface.bootstrap("invoke", "imageCreate", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), null, url, IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : "", IndyInterface.bootstrap("cast", "()", 0, string2) != false ? string2 : "", null, null, null, null, null, callback, IndyInterface.bootstrap("cast", "()", 0, timeout) != false ? IndyInterface.bootstrap("invoke", "toMillis", 0, timeout) : null);
    }

    @Override
    public void importStream(StreamCallback<CreateImageInfo> callback, Duration timeout, InputStream stream, String repository, String tag) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{repository, tag}, new String[]{"docker import stream into ", ":", ""}));
        String string = repository;
        String string2 = tag;
        IndyInterface.bootstrap("invoke", "imageCreate", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), null, "-", IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : "", IndyInterface.bootstrap("cast", "()", 0, string2) != false ? string2 : "", null, null, null, null, stream, callback, IndyInterface.bootstrap("cast", "()", 0, timeout) != false ? IndyInterface.bootstrap("invoke", "toMillis", 0, timeout) : null);
    }

    @Override
    public void push(String imageName, String authBase64Encoded, String registry) {
        IndyInterface.bootstrap("invoke", "push", 2, this, null, null, imageName, authBase64Encoded, registry);
    }

    @Override
    public void push(StreamCallback<PushImageInfo> callback, Duration timeout, String imageName, String authBase64Encoded, String registry) {
        String string;
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{imageName}, new String[]{"docker push '", "'"}));
        Object actualImageName = imageName;
        if (IndyInterface.bootstrap("cast", "()", 0, registry) != false) {
            actualImageName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{registry, imageName}, new String[]{"", "/", ""})));
            IndyInterface.bootstrap("invoke", "tag", 2, this, imageName, actualImageName);
        }
        CallSite repoAndTag = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseRepositoryTag", 0, this.repositoryTagParser, actualImageName));
        IndyInterface.bootstrap("invoke", "imagePush", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "repo", 0, repoAndTag), String.class))), String.class), IndyInterface.bootstrap("cast", "()", 0, string = authBase64Encoded) != false ? string : ".", ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "tag", 0, repoAndTag), String.class))), String.class), callback, IndyInterface.bootstrap("cast", "()", 0, timeout) != false ? IndyInterface.bootstrap("invoke", "toMillis", 0, timeout) : null);
    }

    @Override
    public EngineResponseContent<List<ImageDeleteResponseItem>> rmi(String imageId) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker rmi");
        CallSite imageDelete = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "imageDelete", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), imageId, null, null));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, imageDelete));
    }

    @Override
    public EngineResponseContent<InputStream> save(List<String> images) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker save");
        CallSite savedImages = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "imageGetAll", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), images));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, savedImages));
    }

    @Override
    public void tag(String imageId, String repository) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker tag");
        CallSite repoAndTag = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseRepositoryTag", 0, this.repositoryTagParser, repository));
        IndyInterface.bootstrap("invoke", "imageTag", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), imageId, IndyInterface.bootstrap("getProperty", "repo", 0, repoAndTag), IndyInterface.bootstrap("getProperty", "tag", 0, repoAndTag));
    }

    @Override
    public String findImageId(String imageName, String tag) {
        boolean isDigest = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, imageName, "@"));
        CallSite images = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "content", 0, IndyInterface.bootstrap("invoke", "images", 2, this, isDigest ? ScriptBytecodeAdapter.createMap((Object[])new Object[]{"digests", "1"}) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]))));
        public final class _findImageId_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _findImageId_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object image) {
                Reference image2 = new Reference(image);
                public final class _closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference image;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure3(Object _outerInstance, Object _thisObject, Reference image) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.image = reference = image;
                    }

                    public Object doCall(String repoDigest) {
                        CallSite idByDigest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "id", 0, this.image.get()));
                        IndyInterface.bootstrap("invoke", "putAt", 0, idByDigest, repoDigest, callSite);
                        return idByDigest;
                    }

                    @Generated
                    public Object call(String repoDigest) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, repoDigest);
                    }

                    @Generated
                    public Object getImage() {
                        return this.image.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite = IndyInterface.bootstrap("invoke", "collectEntries", 1, IndyInterface.bootstrap("getProperty", "repoDigests", 0, image2.get()), new _closure3((Object)this, this.getThisObject(), image2));
                return IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findImageId_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite imageIdsByRepoDigest = IndyInterface.bootstrap("invoke", "collectEntries", 0, images, new _findImageId_closure1(this, this));
        public final class _findImageId_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _findImageId_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object image) {
                Reference image2 = new Reference(image);
                public final class _closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference image;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure4(Object _outerInstance, Object _thisObject, Reference image) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.image = reference = image;
                    }

                    public Object doCall(String repoTag) {
                        CallSite idByName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "id", 0, this.image.get()));
                        IndyInterface.bootstrap("invoke", "putAt", 0, idByName, repoTag, callSite);
                        return idByName;
                    }

                    @Generated
                    public Object call(String repoTag) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, repoTag);
                    }

                    @Generated
                    public Object getImage() {
                        return this.image.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite = IndyInterface.bootstrap("invoke", "collectEntries", 1, IndyInterface.bootstrap("getProperty", "repoTags", 0, image2.get()), new _closure4((Object)this, this.getThisObject(), image2));
                return IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findImageId_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite imageIdsByName = IndyInterface.bootstrap("invoke", "collectEntries", 0, images, new _findImageId_closure2(this, this));
        if (isDigest) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, imageIdsByRepoDigest, IndyInterface.bootstrap("invoke", "toString", 0, imageName))) != false) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, imageIdsByRepoDigest, IndyInterface.bootstrap("invoke", "toString", 0, imageName)));
            }
            IndyInterface.bootstrap("invoke", "warn", 0, this.log, new GStringImpl(new Object[]{imageName}, new String[]{"couldn't find imageId for `", "` via `docker images`"}));
            return imageName;
        }
        String string = tag;
        CallSite canonicalImageName = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{imageName, IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : "latest"}, new String[]{"", ":", ""}));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, imageIdsByName, canonicalImageName)) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, imageIdsByName, canonicalImageName));
        }
        IndyInterface.bootstrap("invoke", "warn", 0, this.log, new GStringImpl(new Object[]{canonicalImageName}, new String[]{"couldn't find imageId for `", "` via `docker images`"}));
        return canonicalImageName;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ManageImageClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    @Generated
    public EngineResponseContent<List<ImageSearchResponseItem>> search(String term) {
        return this.search(term, 25);
    }

    @Generated
    public EngineResponseContent<List<ImageSummary>> images(Boolean all, String filters) {
        return this.images(all, filters, null);
    }

    @Generated
    public EngineResponseContent<List<ImageSummary>> images(Boolean all) {
        return this.images(all, null, null);
    }

    @Override
    @Generated
    public EngineResponseContent<List<ImageSummary>> images() {
        return this.images(false, null, null);
    }

    @Override
    @Generated
    public EngineResponseContent<ImagePruneResponse> pruneImages() {
        return this.pruneImages((String)null);
    }

    @Override
    @Generated
    public void pull(StreamCallback<CreateImageInfo> callback, Duration timeout, String imageName, String tag) {
        this.pull(callback, timeout, imageName, tag, ".");
    }

    @Override
    @Generated
    public void pull(StreamCallback<CreateImageInfo> callback, Duration timeout, String imageName) {
        this.pull(callback, timeout, imageName, "", ".");
    }

    @Override
    @Generated
    public void importUrl(StreamCallback<CreateImageInfo> callback, Duration timeout, String url, String repository) {
        this.importUrl(callback, timeout, url, repository, "");
    }

    @Override
    @Generated
    public void importUrl(StreamCallback<CreateImageInfo> callback, Duration timeout, String url) {
        this.importUrl(callback, timeout, url, "", "");
    }

    @Override
    @Generated
    public void importStream(StreamCallback<CreateImageInfo> callback, Duration timeout, InputStream stream, String repository) {
        this.importStream(callback, timeout, stream, repository, "");
    }

    @Override
    @Generated
    public void importStream(StreamCallback<CreateImageInfo> callback, Duration timeout, InputStream stream) {
        this.importStream(callback, timeout, stream, "", "");
    }

    @Override
    @Generated
    public void push(String imageName, String authBase64Encoded) {
        this.push(imageName, authBase64Encoded, "");
    }

    @Override
    @Generated
    public void push(String imageName) {
        this.push(imageName, ".", "");
    }

    @Override
    @Generated
    public void push(StreamCallback<PushImageInfo> callback, Duration timeout, String imageName, String authBase64Encoded) {
        this.push(callback, timeout, imageName, authBase64Encoded, "");
    }

    @Override
    @Generated
    public void push(StreamCallback<PushImageInfo> callback, Duration timeout, String imageName) {
        this.push(callback, timeout, imageName, ".", "");
    }

    @Override
    @Generated
    public String findImageId(String imageName) {
        return this.findImageId(imageName, "");
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

