/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.service;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.node.NodeUtil;
import de.gesellix.docker.client.service.ManageService;
import de.gesellix.docker.client.tasks.ManageTask;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.Service;
import de.gesellix.docker.remote.api.ServiceCreateRequest;
import de.gesellix.docker.remote.api.ServiceCreateResponse;
import de.gesellix.docker.remote.api.ServiceUpdateRequest;
import de.gesellix.docker.remote.api.ServiceUpdateResponse;
import de.gesellix.docker.remote.api.Task;
import de.gesellix.docker.remote.api.client.ServiceApi;
import de.gesellix.util.QueryUtil;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageServiceClient
implements ManageService,
GroovyObject {
    private final Logger log;
    private EngineApiClient client;
    private QueryUtil queryUtil;
    private ManageTask manageTask;
    private NodeUtil nodeUtil;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ManageServiceClient(EngineApiClient client, ManageTask manageTask, NodeUtil nodeUtil) {
        NodeUtil nodeUtil2;
        ManageTask manageTask2;
        EngineApiClient engineApiClient;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, ManageServiceClient.class);
        this.log = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.client = engineApiClient = client;
        CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, QueryUtil.class);
        this.queryUtil = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        this.manageTask = manageTask2 = manageTask;
        this.nodeUtil = nodeUtil2 = nodeUtil;
    }

    @Override
    public EngineResponseContent<List<Service>> services(Map<String, Object> query) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker service ls");
        CallSite actualQuery = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        if (ScriptBytecodeAdapter.compareNotEqual(query, null)) {
            IndyInterface.bootstrap("invoke", "putAll", 0, actualQuery, query);
        }
        IndyInterface.bootstrap("invoke", "jsonEncodeQueryParameter", 0, this.queryUtil, actualQuery, "filters");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "services", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, actualQuery, "filters")), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, actualQuery, "status")), Boolean.class)));
    }

    @Override
    public EngineResponseContent<List<Service>> services(String filters, Boolean status) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker service ls");
        CallSite serviceList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "serviceList", 0, IndyInterface.bootstrap("getProperty", "serviceApi", 0, this.client), filters, status));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, serviceList));
    }

    @Override
    public EngineResponseContent<ServiceCreateResponse> createService(ServiceCreateRequest serviceSpec, String encodedRegistryAuth) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker service create");
        CallSite serviceCreate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "serviceCreate", 0, IndyInterface.bootstrap("getProperty", "serviceApi", 0, this.client), serviceSpec, encodedRegistryAuth));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, serviceCreate));
    }

    @Override
    public void rmService(String name) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker service rm");
        IndyInterface.bootstrap("invoke", "serviceDelete", 0, IndyInterface.bootstrap("getProperty", "serviceApi", 0, this.client), name);
    }

    @Override
    public EngineResponseContent<Service> inspectService(String name) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker service inspect");
        CallSite serviceInspect = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "serviceInspect", 0, IndyInterface.bootstrap("getProperty", "serviceApi", 0, this.client), name, null));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, serviceInspect));
    }

    @Override
    public EngineResponseContent<ServiceUpdateResponse> updateService(String name, int version, ServiceUpdateRequest serviceSpec, String registryAuthFrom, String encodedRegistryAuth) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker service update {}@{}", name, version);
        CallSite authFrom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, registryAuthFrom) != false ? IndyInterface.bootstrap("invoke", "valueOf", 0, ServiceApi.RegistryAuthFromServiceUpdate.class, registryAuthFrom) : IndyInterface.bootstrap("getProperty", "Spec", 0, ServiceApi.RegistryAuthFromServiceUpdate.class));
        CallSite serviceUpdate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "serviceUpdate", 0, IndyInterface.bootstrap("getProperty", "serviceApi", 0, this.client), name, version, serviceSpec, authFrom, null, encodedRegistryAuth));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, serviceUpdate));
    }

    @Override
    public EngineResponseContent<ServiceUpdateResponse> updateService(String name, int version, String rollback, String registryAuthFrom, String encodedRegistryAuth) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker service update {}@{}", name, version);
        CallSite authFrom = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, registryAuthFrom) != false ? IndyInterface.bootstrap("invoke", "valueOf", 0, ServiceApi.RegistryAuthFromServiceUpdate.class, registryAuthFrom) : IndyInterface.bootstrap("getProperty", "Spec", 0, ServiceApi.RegistryAuthFromServiceUpdate.class));
        CallSite serviceUpdate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "serviceUpdate", 0, IndyInterface.bootstrap("getProperty", "serviceApi", 0, this.client), name, version, null, authFrom, rollback, encodedRegistryAuth));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, serviceUpdate));
    }

    @Override
    public EngineResponseContent<ServiceUpdateResponse> scaleService(String name, int replicas) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker service scale");
        CallSite service = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "content", 0, IndyInterface.bootstrap("invoke", "inspectService", 2, this, name)));
        CallSite mode = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "mode", 0, IndyInterface.bootstrap("getProperty", "spec", 0, service)));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "replicated", 0, mode), null)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "scale can only be used with replicated mode"));
        }
        int n = replicas;
        ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)IndyInterface.bootstrap("getProperty", "replicated", 0, mode), (String)"replicas");
        CallSite serviceUpdateRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ServiceUpdateRequest.class, null, null, null, mode, null, null, null, null));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "updateService", 2, this, name, IndyInterface.bootstrap("getProperty", "index", 0, IndyInterface.bootstrap("getProperty", "version", 0, service)), serviceUpdateRequest));
    }

    @Override
    public EngineResponseContent<List<Task>> tasksOfService(String service, Map<String, Object> query) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker service ps");
        Map<String, Object> map = query;
        Map<String, Object> actualQuery = IndyInterface.bootstrap("cast", "()", 0, map) != false ? map : IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, actualQuery, "filters")) == false) {
            IndyInterface.bootstrap("invoke", "put", 0, actualQuery, "filters", IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        }
        CallSite filters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, actualQuery, "filters"));
        IndyInterface.bootstrap("invoke", "put", 0, filters, "service", ScriptBytecodeAdapter.createList((Object[])new Object[]{service}));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "get", 0, filters, "node"), null)) {
            IndyInterface.bootstrap("invoke", "put", 0, filters, "node", IndyInterface.bootstrap("invoke", "resolveNodeId", 0, this.nodeUtil, IndyInterface.bootstrap("invoke", "get", 0, filters, "node")));
        }
        IndyInterface.bootstrap("invoke", "jsonEncodeQueryParameter", 0, IndyInterface.bootstrap("init", "<init>", 0, QueryUtil.class), actualQuery, "filters");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "tasks", 0, this.manageTask, ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, actualQuery, "filters")), String.class)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ManageServiceClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    @Generated
    public EngineResponseContent<List<Service>> services(String filters) {
        return this.services(filters, null);
    }

    @Override
    @Generated
    public EngineResponseContent<List<Service>> services() {
        return this.services(null, null);
    }

    @Override
    @Generated
    public EngineResponseContent<ServiceCreateResponse> createService(ServiceCreateRequest serviceSpec) {
        return this.createService(serviceSpec, null);
    }

    @Override
    @Generated
    public EngineResponseContent<ServiceUpdateResponse> updateService(String name, int version, ServiceUpdateRequest serviceSpec, String registryAuthFrom) {
        return this.updateService(name, version, serviceSpec, registryAuthFrom, null);
    }

    @Override
    @Generated
    public EngineResponseContent<ServiceUpdateResponse> updateService(String name, int version, ServiceUpdateRequest serviceSpec) {
        return this.updateService(name, version, serviceSpec, null, null);
    }

    @Override
    @Generated
    public EngineResponseContent<ServiceUpdateResponse> updateService(String name, int version, String rollback, String registryAuthFrom) {
        return this.updateService(name, version, rollback, registryAuthFrom, null);
    }

    @Override
    @Generated
    public EngineResponseContent<ServiceUpdateResponse> updateService(String name, int version, String rollback) {
        return this.updateService(name, version, rollback, null, null);
    }

    @Override
    @Generated
    public EngineResponseContent<List<Task>> tasksOfService(String service) {
        return this.tasksOfService(service, (Map)((Object)IndyInterface.bootstrap("init", "<init>", 0, HashMap.class)));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

