/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.network;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.network.ManageNetwork;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.IPAM;
import de.gesellix.docker.remote.api.Network;
import de.gesellix.docker.remote.api.NetworkConnectRequest;
import de.gesellix.docker.remote.api.NetworkCreateRequest;
import de.gesellix.docker.remote.api.NetworkCreateResponse;
import de.gesellix.docker.remote.api.NetworkDisconnectRequest;
import de.gesellix.docker.remote.api.NetworkPruneResponse;
import de.gesellix.util.QueryParameterEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageNetworkClient
implements ManageNetwork {
    private final Logger log = LoggerFactory.getLogger(ManageNetworkClient.class);
    private final EngineApiClient client;
    private final QueryParameterEncoder queryParameterEncoder;

    public ManageNetworkClient(EngineApiClient client) {
        this.client = client;
        this.queryParameterEncoder = new QueryParameterEncoder();
    }

    @Override
    @Deprecated
    public EngineResponseContent<List<Network>> networks(Map<String, Object> query) {
        this.log.info("docker network ls");
        HashMap<String, Object> actualQuery = new HashMap<String, Object>();
        if (query != null) {
            actualQuery.putAll(query);
        }
        this.queryParameterEncoder.jsonEncodeQueryParameter(actualQuery, "filters");
        return this.networks((String)actualQuery.get("filters"));
    }

    @Override
    public EngineResponseContent<List<Network>> networks(String filters) {
        this.log.info("docker network ls");
        List networks = this.client.getNetworkApi().networkList(filters);
        return new EngineResponseContent<List<Network>>(networks);
    }

    @Override
    public EngineResponseContent<List<Network>> networks() {
        return this.networks((String)null);
    }

    @Override
    public EngineResponseContent<Network> inspectNetwork(String name) {
        this.log.info("docker network inspect");
        Network network = this.client.getNetworkApi().networkInspect(name, null, null);
        return new EngineResponseContent<Network>(network);
    }

    @Override
    @Deprecated
    public EngineResponseContent<NetworkCreateResponse> createNetwork(String name, Map<String, Object> config) {
        HashMap<String, Object> actualConfig = new HashMap<String, Object>();
        if (config != null) {
            actualConfig.putAll(config);
        }
        Map ipam = (Map)actualConfig.get("IPAM");
        NetworkCreateRequest request = new NetworkCreateRequest(name, Boolean.valueOf(true), (String)actualConfig.get("Driver"), (Boolean)actualConfig.get("Internal"), (Boolean)actualConfig.get("Attachable"), (Boolean)actualConfig.get("Ingress"), ipam == null ? null : new IPAM(ipam == null ? null : (String)ipam.get("Driver"), ipam == null ? null : (List)ipam.get("Config"), ipam == null ? null : (Map)ipam.get("Options")), (Boolean)actualConfig.get("EnableIPv6"), (Map)actualConfig.get("Options"), (Map)actualConfig.get("Labels"));
        return this.createNetwork(request);
    }

    @Override
    public EngineResponseContent<NetworkCreateResponse> createNetwork(String name) {
        NetworkCreateRequest request = new NetworkCreateRequest(name, Boolean.valueOf(true), null, null, null, null, null, null, null, null);
        return this.createNetwork(request);
    }

    @Override
    public EngineResponseContent<NetworkCreateResponse> createNetwork(NetworkCreateRequest networkCreateRequest) {
        this.log.info("docker network create");
        NetworkCreateResponse networkCreate = this.client.getNetworkApi().networkCreate(networkCreateRequest);
        return new EngineResponseContent<NetworkCreateResponse>(networkCreate);
    }

    @Override
    public void connectNetwork(String network, String container) {
        this.log.info("docker network connect");
        this.client.getNetworkApi().networkConnect(network, new NetworkConnectRequest(container, null));
    }

    @Override
    public void disconnectNetwork(String network, String container) {
        this.log.info("docker network disconnect");
        this.client.getNetworkApi().networkDisconnect(network, new NetworkDisconnectRequest(container, null));
    }

    @Override
    public void rmNetwork(String name) {
        this.log.info("docker network rm");
        this.client.getNetworkApi().networkDelete(name);
    }

    @Override
    @Deprecated
    public EngineResponseContent<NetworkPruneResponse> pruneNetworks(Map<String, Object> query) {
        this.log.info("docker network prune");
        HashMap<String, Object> actualQuery = new HashMap<String, Object>();
        if (query != null) {
            actualQuery.putAll(query);
        }
        this.queryParameterEncoder.jsonEncodeQueryParameter(actualQuery, "filters");
        return this.pruneNetworks((String)actualQuery.get("filters"));
    }

    @Override
    public EngineResponseContent<NetworkPruneResponse> pruneNetworks(String filters) {
        this.log.info("docker network prune");
        NetworkPruneResponse networkPrune = this.client.getNetworkApi().networkPrune(filters);
        return new EngineResponseContent<NetworkPruneResponse>(networkPrune);
    }

    @Override
    public EngineResponseContent<NetworkPruneResponse> pruneNetworks() {
        return this.pruneNetworks((String)null);
    }
}

