/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.tasks;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.tasks.ManageTask;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.Task;
import de.gesellix.util.QueryParameterEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageTaskClient
implements ManageTask {
    private final Logger log = LoggerFactory.getLogger(ManageTaskClient.class);
    private final EngineApiClient client;

    public ManageTaskClient(EngineApiClient client) {
        this.client = client;
    }

    @Override
    @Deprecated
    public EngineResponseContent<List<Task>> tasks(Map<String, Object> query) {
        HashMap<String, Object> actualQuery = new HashMap<String, Object>();
        if (query != null) {
            actualQuery.putAll(query);
        }
        new QueryParameterEncoder().jsonEncodeQueryParameter(actualQuery, "filters");
        return this.tasks((String)actualQuery.get("filters"));
    }

    @Override
    public EngineResponseContent<List<Task>> tasks(String filters) {
        this.log.info("docker tasks");
        List tasks = this.client.getTaskApi().taskList(filters);
        return new EngineResponseContent<List<Task>>(tasks);
    }

    @Override
    public EngineResponseContent<List<Task>> tasks() {
        return this.tasks((String)null);
    }

    @Override
    public EngineResponseContent<Task> inspectTask(String name) {
        this.log.info("docker task inspect");
        Task taskInspect = this.client.getTaskApi().taskInspect(name);
        return new EngineResponseContent<Task>(taskInspect);
    }
}

