/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.volume;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.volume.ManageVolume;
import de.gesellix.docker.remote.api.ClusterVolumeSpec;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.Volume;
import de.gesellix.docker.remote.api.VolumeCreateOptions;
import de.gesellix.docker.remote.api.VolumeListResponse;
import de.gesellix.docker.remote.api.VolumePruneResponse;
import de.gesellix.util.QueryParameterEncoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageVolumeClient
implements ManageVolume {
    private final Logger log = LoggerFactory.getLogger(ManageVolumeClient.class);
    private final EngineApiClient client;
    private final QueryParameterEncoder queryParameterEncoder;

    public ManageVolumeClient(EngineApiClient client) {
        this.client = client;
        this.queryParameterEncoder = new QueryParameterEncoder();
    }

    @Override
    @Deprecated
    public EngineResponseContent<VolumeListResponse> volumes(Map<String, Object> query) {
        this.log.info("docker volume ls");
        HashMap<String, Object> actualQuery = new HashMap<String, Object>();
        if (query != null) {
            actualQuery.putAll(query);
        }
        this.queryParameterEncoder.jsonEncodeQueryParameter(actualQuery, "filters");
        return this.volumes((String)actualQuery.get("filters"));
    }

    @Override
    public EngineResponseContent<VolumeListResponse> volumes(String filters) {
        this.log.info("docker volume ls");
        VolumeListResponse volumeList = this.client.getVolumeApi().volumeList(filters);
        return new EngineResponseContent<VolumeListResponse>(volumeList);
    }

    @Override
    public EngineResponseContent<VolumeListResponse> volumes() {
        return this.volumes((String)null);
    }

    @Override
    public EngineResponseContent<Volume> inspectVolume(String name) {
        this.log.info("docker volume inspect");
        Volume volumeInspect = this.client.getVolumeApi().volumeInspect(name);
        return new EngineResponseContent<Volume>(volumeInspect);
    }

    @Override
    @Deprecated
    public EngineResponseContent<Volume> createVolume(Map<String, Object> config) {
        this.log.info("docker volume create");
        return this.createVolume(new VolumeCreateOptions(config == null ? null : (String)config.get("Name"), config == null ? null : (String)config.get("Driver"), config == null ? null : (Map)config.get("DriverOpts"), config == null ? null : (Map)config.get("Labels"), config == null ? null : (ClusterVolumeSpec)config.get("ClusterVolumeSpec")));
    }

    @Override
    public EngineResponseContent<Volume> createVolume(VolumeCreateOptions volumeConfig) {
        this.log.info("docker volume create");
        Volume volume = this.client.getVolumeApi().volumeCreate(volumeConfig);
        return new EngineResponseContent<Volume>(volume);
    }

    @Override
    public EngineResponseContent<Volume> createVolume() {
        return this.createVolume(new VolumeCreateOptions());
    }

    @Override
    public void rmVolume(String name) {
        this.log.info("docker volume rm");
        this.client.getVolumeApi().volumeDelete(name, null);
    }

    @Override
    @Deprecated
    public EngineResponseContent<VolumePruneResponse> pruneVolumes(Map<String, Object> query) {
        this.log.info("docker volume prune");
        HashMap<String, Object> actualQuery = new HashMap<String, Object>();
        if (query != null) {
            actualQuery.putAll(query);
        }
        this.queryParameterEncoder.jsonEncodeQueryParameter(actualQuery, "filters");
        return this.pruneVolumes((String)actualQuery.get("filters"));
    }

    @Override
    public EngineResponseContent<VolumePruneResponse> pruneVolumes(String filters) {
        this.log.info("docker volume prune");
        VolumePruneResponse pruneResponse = this.client.getVolumeApi().volumePrune(filters);
        return new EngineResponseContent<VolumePruneResponse>(pruneResponse);
    }

    @Override
    public EngineResponseContent<VolumePruneResponse> pruneVolumes() {
        return this.pruneVolumes((String)null);
    }
}

