/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.node;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.node.ManageNode;
import de.gesellix.docker.client.node.NodeUtil;
import de.gesellix.docker.client.tasks.ManageTask;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.Node;
import de.gesellix.docker.remote.api.NodeSpec;
import de.gesellix.docker.remote.api.Task;
import de.gesellix.util.QueryParameterEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageNodeClient
implements ManageNode {
    private final Logger log = LoggerFactory.getLogger(ManageNodeClient.class);
    private final EngineApiClient client;
    private final ManageTask manageTask;
    private final NodeUtil nodeUtil;

    public ManageNodeClient(EngineApiClient client, ManageTask manageTask, NodeUtil nodeUtil) {
        this.client = client;
        this.manageTask = manageTask;
        this.nodeUtil = nodeUtil;
    }

    @Override
    @Deprecated
    public EngineResponseContent<List<Node>> nodes(Map<String, Object> query) {
        HashMap<String, Object> actualQuery = new HashMap<String, Object>();
        if (query != null) {
            actualQuery.putAll(query);
        }
        new QueryParameterEncoder().jsonEncodeQueryParameter(actualQuery, "filters");
        return this.nodes((String)actualQuery.get("filters"));
    }

    @Override
    public EngineResponseContent<List<Node>> nodes(String filters) {
        this.log.info("docker node ls");
        List response = this.client.getNodeApi().nodeList(filters);
        return new EngineResponseContent<List<Node>>(response);
    }

    @Override
    public EngineResponseContent<List<Node>> nodes() {
        return this.nodes((String)null);
    }

    @Override
    public EngineResponseContent<Node> inspectNode(String name) {
        this.log.info("docker node inspect");
        Node nodeInspect = this.client.getNodeApi().nodeInspect(name);
        return new EngineResponseContent<Node>(nodeInspect);
    }

    @Override
    public void rmNode(String name) {
        this.log.info("docker node rm");
        this.client.getNodeApi().nodeDelete(name, null);
    }

    @Override
    public void updateNode(String name, long version, NodeSpec nodeSpec) {
        this.log.info("docker node update");
        this.client.getNodeApi().nodeUpdate(name, version, nodeSpec);
    }

    @Override
    public void promoteNodes(String ... nodes) {
        this.log.info("docker node promote");
        for (String node : nodes) {
            Node nodeInfo = (Node)this.inspectNode(node).getContent();
            if (NodeSpec.Role.Manager.equals((Object)nodeInfo.getSpec().getRole())) {
                this.log.warn("Node {} is already a manager.", (Object)node);
                continue;
            }
            NodeSpec nodeSpec = new NodeSpec(nodeInfo.getSpec().getName(), nodeInfo.getSpec().getLabels(), NodeSpec.Role.Manager, nodeInfo.getSpec().getAvailability());
            this.updateNode(nodeInfo.getID(), nodeInfo.getVersion().getIndex().intValue(), nodeSpec);
            this.log.info("Node {} promoted to a manager in the swarm.", (Object)node);
        }
    }

    @Override
    public void demoteNodes(String ... nodes) {
        this.log.info("docker node demote");
        for (String node : nodes) {
            Node nodeInfo = (Node)this.inspectNode(node).getContent();
            if (NodeSpec.Role.Worker.equals((Object)nodeInfo.getSpec().getRole())) {
                this.log.warn("Node {} is already a worker.", (Object)node);
                continue;
            }
            NodeSpec nodeSpec = new NodeSpec(nodeInfo.getSpec().getName(), nodeInfo.getSpec().getLabels(), NodeSpec.Role.Worker, nodeInfo.getSpec().getAvailability());
            this.updateNode(nodeInfo.getID(), nodeInfo.getVersion().getIndex().intValue(), nodeSpec);
            this.log.info("Manager {} demoted in the swarm.", (Object)node);
        }
    }

    @Override
    public EngineResponseContent<List<Task>> tasksOnNode(String node, Map<String, Object> query) {
        this.log.info("docker node ps");
        HashMap<String, Object> actualQuery = new HashMap<String, Object>();
        if (query != null) {
            actualQuery.putAll(query);
        }
        if (!actualQuery.containsKey("filters")) {
            actualQuery.put("filters", new HashMap());
        }
        Map filters = (Map)actualQuery.get("filters");
        filters.put("node", this.nodeUtil.resolveNodeId(node));
        new QueryParameterEncoder().jsonEncodeQueryParameter(actualQuery, "filters");
        return this.manageTask.tasks((String)actualQuery.get("filters"));
    }

    @Override
    public EngineResponseContent<List<Task>> tasksOnNode(String node) {
        return this.tasksOnNode(node, new HashMap<String, Object>());
    }
}

