/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.secret;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.secret.ManageSecret;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.IdResponse;
import de.gesellix.docker.remote.api.Secret;
import de.gesellix.docker.remote.api.SecretCreateRequest;
import de.gesellix.docker.remote.api.SecretSpec;
import de.gesellix.util.QueryParameterEncoder;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageSecretClient
implements ManageSecret {
    private final Logger log = LoggerFactory.getLogger(ManageSecretClient.class);
    private final EngineApiClient client;

    public ManageSecretClient(EngineApiClient client) {
        this.client = client;
    }

    @Override
    public EngineResponseContent<IdResponse> createSecret(String name, byte[] secretData, Map<String, String> labels) {
        this.log.info("docker secret create");
        String secretDataBase64 = Base64.getEncoder().encodeToString(secretData);
        SecretCreateRequest secretConfig = new SecretCreateRequest(name, labels, secretDataBase64, null, null);
        IdResponse secretCreate = this.client.getSecretApi().secretCreate(secretConfig);
        return new EngineResponseContent<IdResponse>(secretCreate);
    }

    @Override
    public EngineResponseContent<IdResponse> createSecret(String name, byte[] secretData) {
        return this.createSecret(name, secretData, new HashMap<String, String>());
    }

    @Override
    public EngineResponseContent<Secret> inspectSecret(String secretId) {
        this.log.info("docker secret inspect");
        Secret secretInspect = this.client.getSecretApi().secretInspect(secretId);
        return new EngineResponseContent<Secret>(secretInspect);
    }

    @Override
    @Deprecated
    public EngineResponseContent<List<Secret>> secrets(Map<String, Object> query) {
        HashMap<String, Object> actualQuery = new HashMap<String, Object>();
        if (query != null) {
            actualQuery.putAll(query);
        }
        new QueryParameterEncoder().jsonEncodeQueryParameter(actualQuery, "filters");
        return this.secrets((String)actualQuery.get("filters"));
    }

    @Override
    public EngineResponseContent<List<Secret>> secrets(String filters) {
        this.log.info("docker secret ls");
        List secrets = this.client.getSecretApi().secretList(filters);
        return new EngineResponseContent<List<Secret>>(secrets);
    }

    @Override
    public EngineResponseContent<List<Secret>> secrets() {
        return this.secrets((String)null);
    }

    @Override
    public void rmSecret(String secretId) {
        this.log.info("docker secret rm");
        this.client.getSecretApi().secretDelete(secretId);
    }

    @Override
    public void updateSecret(String secretId, long version, SecretSpec secretSpec) {
        this.log.info("docker secret update");
        this.client.getSecretApi().secretUpdate(secretId, version, secretSpec);
    }
}

