/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.system;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.system.ManageSystem;
import de.gesellix.docker.client.system.SystemEventsRequest;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.EventMessage;
import de.gesellix.docker.remote.api.SystemDataUsageResponse;
import de.gesellix.docker.remote.api.SystemInfo;
import de.gesellix.docker.remote.api.SystemVersion;
import de.gesellix.docker.remote.api.core.StreamCallback;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageSystemClient
implements ManageSystem {
    private final Logger log = LoggerFactory.getLogger(ManageSystemClient.class);
    private final EngineApiClient client;

    public ManageSystemClient(EngineApiClient client) {
        this.client = client;
    }

    @Override
    public EngineResponseContent<SystemDataUsageResponse> systemDf() {
        this.log.info("docker system df");
        SystemDataUsageResponse systemDataUsage = this.client.getSystemApi().systemDataUsage();
        return new EngineResponseContent<SystemDataUsageResponse>(systemDataUsage);
    }

    @Override
    public void events(SystemEventsRequest request, StreamCallback<EventMessage> callback, Duration timeout) {
        this.log.info("docker events");
        this.client.getSystemApi().systemEvents(request.getSince(), request.getUntil(), request.getFilters(), callback, timeout.toMillis());
    }

    @Override
    public EngineResponseContent<String> ping() {
        this.log.info("docker ping");
        String systemPing = this.client.getSystemApi().systemPing();
        return new EngineResponseContent<String>(systemPing);
    }

    @Override
    public EngineResponseContent<SystemVersion> version() {
        this.log.info("docker version");
        SystemVersion systemVersion = this.client.getSystemApi().systemVersion();
        return new EngineResponseContent<SystemVersion>(systemVersion);
    }

    @Override
    public EngineResponseContent<SystemInfo> info() {
        this.log.info("docker info");
        SystemInfo systemInfo = this.client.getSystemApi().systemInfo();
        return new EngineResponseContent<SystemInfo>(systemInfo);
    }
}

