/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.authentication;

import com.squareup.moshi.Moshi;
import de.gesellix.docker.authentication.AuthConfig;
import de.gesellix.docker.authentication.AuthConfigReader;
import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.authentication.ManageAuthentication;
import de.gesellix.docker.client.authentication.ReferenceParser;
import de.gesellix.docker.client.authentication.RegistryElection;
import de.gesellix.docker.engine.DockerConfigReader;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.SystemAuthResponse;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageAuthenticationClient
implements ManageAuthentication,
GroovyObject {
    private final Logger log;
    private DockerConfigReader dockerConfigReader;
    private AuthConfigReader authConfigReader;
    private EngineApiClient client;
    private RegistryElection registryElection;
    private Moshi moshi;
    private final String legacyDefaultDomain;
    private final String defaultDomain;
    private final String officialRepoName;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ManageAuthenticationClient(EngineApiClient client, AuthConfigReader authConfigReader, DockerConfigReader dockerConfigReader) {
        DockerConfigReader dockerConfigReader2;
        AuthConfigReader authConfigReader2;
        EngineApiClient engineApiClient;
        MetaClass metaClass;
        String string;
        String string2;
        String string3;
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, ManageAuthenticationClient.class);
        this.log = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("init", "<init>", 0, Moshi.Builder.class));
        this.moshi = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        this.legacyDefaultDomain = string3 = "index.docker.io";
        this.defaultDomain = string2 = "docker.io";
        this.officialRepoName = string = "library";
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.client = engineApiClient = client;
        this.authConfigReader = authConfigReader2 = authConfigReader;
        this.dockerConfigReader = dockerConfigReader2 = dockerConfigReader;
        CallSite callSite3 = IndyInterface.bootstrap("init", "<init>", 0, RegistryElection.class, authConfigReader);
        this.registryElection = IndyInterface.bootstrap("cast", "()", 0, callSite3);
    }

    @Override
    public Map<String, AuthConfig> getAllAuthConfigs(File dockerCfg) {
        CallSite parsedDockerCfg = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "readDockerConfigFile", 0, this.dockerConfigReader, dockerCfg));
        if (IndyInterface.bootstrap("cast", "()", 0, parsedDockerCfg) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        }
        CallSite credsStore = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCredentialsStore", 0, this.authConfigReader, parsedDockerCfg));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAuthConfigs", 0, credsStore));
    }

    @Override
    public AuthConfig readDefaultAuthConfig() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "readDefaultAuthConfig", 0, this.authConfigReader));
    }

    @Override
    public AuthConfig readAuthConfig(String hostname, File dockerCfg) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "readAuthConfig", 0, this.authConfigReader, hostname, dockerCfg));
    }

    @Override
    public String encodeAuthConfig(AuthConfig authConfig) {
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "username", 0, authConfig), IndyInterface.bootstrap("getProperty", "serveraddress", 0, authConfig)}, new String[]{"encode authConfig for ", "@", ""}));
        CallSite json = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toJson", 0, IndyInterface.bootstrap("invoke", "adapter", 0, this.moshi, AuthConfig.class), authConfig));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "encodeBase64", 0, IndyInterface.bootstrap("getProperty", "bytes", 0, json))));
    }

    @Override
    public String encodeAuthConfigs(Map<String, AuthConfig> authConfigs) {
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "keySet", 0, authConfigs)}, new String[]{"encode authConfigs for ", ""}));
        CallSite json = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toJson", 0, IndyInterface.bootstrap("invoke", "adapter", 0, this.moshi, Map.class), authConfigs));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "encodeBase64", 0, IndyInterface.bootstrap("getProperty", "bytes", 0, json))));
    }

    @Override
    public EngineResponseContent<SystemAuthResponse> auth(de.gesellix.docker.remote.api.AuthConfig authDetails) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker login");
        CallSite systemAuth = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "systemAuth", 0, IndyInterface.bootstrap("getProperty", "systemApi", 0, this.client), authDetails));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, systemAuth));
    }

    @Override
    public String retrieveEncodedAuthTokenForImage(String image) {
        CallSite authConfig = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveAuthConfigForImage", 2, this, image));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "encodeAuthConfig", 2, this, authConfig));
    }

    @Override
    public AuthConfig resolveAuthConfigForImage(String image) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, "^([a-f0-9]{64})$", image)) != false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{image}, new String[]{"invalid repository name (", "), cannot specify 64-byte hexadecimal strings"})));
        }
        CallSite domain = null;
        CallSite remainder = null;
        CallSite callSite = IndyInterface.bootstrap("invoke", "splitDockerDomain", 2, this, image);
        domain = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, callSite, Integer.valueOf(0)));
        remainder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, callSite, Integer.valueOf(1)));
        CallSite remoteName = null;
        remoteName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, remainder, ":")) != false ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, remainder, false, IndyInterface.bootstrap("invoke", "indexOf", 0, remainder, ":"))) : remainder;
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "toLowerCase", 0, remoteName), (Object)remoteName)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "invalid reference format: repository name must be lowercase"));
        }
        CallSite ref = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, ReferenceParser.class), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, domain, "/"), remainder)));
        CallSite namedRef = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getNamed", 2, this, ref));
        CallSite indexName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateIndexName", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "domain", 0, namedRef), String.class))), String.class)));
        Map indexInfo = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", indexName, "mirrors", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "official", ScriptBytecodeAdapter.compareEqual((Object)indexName, (Object)this.defaultDomain), "secure", false});
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveAuthConfig", 0, this.registryElection, IndyInterface.bootstrap("getProperty", "name", 0, indexInfo), IndyInterface.bootstrap("getProperty", "official", 0, indexInfo)));
    }

    public String validateIndexName(String val) {
        if (ScriptBytecodeAdapter.compareEqual((Object)val, (Object)this.legacyDefaultDomain)) {
            val = this.defaultDomain;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "startsWith", 0, val, "-")) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "endsWith", 0, val, "-"))) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{val}, new String[]{"Invalid index name (", "). Cannot begin or end with a hyphen."})));
        }
        return val;
    }

    public Map<String, Object> getNamed(Map<String, Object> ref) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "domain", 0, ref)) != false) {
            return ref;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "repo", 0, ref)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "domain", 0, IndyInterface.bootstrap("getProperty", "repo", 0, ref)))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "repo", 0, ref));
        }
        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{ref}, new String[]{"reference ", " has no name"})));
    }

    public Object splitDockerDomain(String name) {
        public final class _splitDockerDomain_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _splitDockerDomain_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String haystack, String needles) {
                Reference haystack2 = new Reference((Object)haystack);
                public final class _closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference haystack;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure2(Object _outerInstance, Object _thisObject, Reference haystack) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.haystack = reference = haystack;
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.haystack.get()), it);
                    }

                    @Generated
                    public String getHaystack() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.haystack.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "any", 0, needles, new _closure2((Object)this, this.getThisObject(), haystack2));
            }

            @Generated
            public Object call(String haystack, String needles) {
                Reference haystack2 = new Reference((Object)haystack);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, (String)haystack2.get(), needles);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _splitDockerDomain_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        _splitDockerDomain_closure1 containsAny = new _splitDockerDomain_closure1(this, this);
        Object domain = null;
        CallSite remainder = null;
        int i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, name, "/"));
        if (i == -1 || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "call", 0, containsAny, IndyInterface.bootstrap("invoke", "substring", 0, name, false, i), ".:")) == false && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "substring", 0, name, false, i), (Object)"localhost")) {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{this.defaultDomain, name});
            domain = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, list, Integer.valueOf(0)));
            remainder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, list, Integer.valueOf(1)));
        } else {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "substring", 0, name, false, i), IndyInterface.bootstrap("invoke", "substring", 0, name, IndyInterface.bootstrap("invoke", "plus", 0, i, true))});
            domain = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, list, Integer.valueOf(0)));
            remainder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, list, Integer.valueOf(1)));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)domain, (Object)this.legacyDefaultDomain)) {
            domain = this.defaultDomain;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)domain, (Object)this.defaultDomain) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, remainder, "/")) == false) {
            remainder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, this.officialRepoName, "/"), remainder));
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{domain, remainder});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ManageAuthenticationClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    @Generated
    public Map<String, AuthConfig> getAllAuthConfigs() {
        return this.getAllAuthConfigs(null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public DockerConfigReader getDockerConfigReader() {
        return this.dockerConfigReader;
    }

    @Generated
    public void setDockerConfigReader(DockerConfigReader dockerConfigReader) {
        this.dockerConfigReader = dockerConfigReader;
    }

    @Generated
    public AuthConfigReader getAuthConfigReader() {
        return this.authConfigReader;
    }

    @Generated
    public void setAuthConfigReader(AuthConfigReader authConfigReader) {
        this.authConfigReader = authConfigReader;
    }

    @Generated
    public EngineApiClient getClient() {
        return this.client;
    }

    @Generated
    public void setClient(EngineApiClient engineApiClient) {
        this.client = engineApiClient;
    }

    @Generated
    public String getLegacyDefaultDomain() {
        return this.legacyDefaultDomain;
    }

    @Generated
    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    @Generated
    public String getOfficialRepoName() {
        return this.officialRepoName;
    }
}

