/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.config;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.config.ManageConfig;
import de.gesellix.docker.remote.api.Config;
import de.gesellix.docker.remote.api.ConfigCreateRequest;
import de.gesellix.docker.remote.api.ConfigSpec;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.IdResponse;
import de.gesellix.util.QueryParameterEncoder;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageConfigClient
implements ManageConfig {
    private final Logger log = LoggerFactory.getLogger(ManageConfigClient.class);
    private final EngineApiClient client;

    public ManageConfigClient(EngineApiClient client) {
        this.client = client;
    }

    @Override
    public EngineResponseContent<IdResponse> createConfig(String name, byte[] configData, Map<String, String> labels) {
        this.log.info("docker config create");
        String configDataBase64 = Base64.getEncoder().encodeToString(configData);
        ConfigCreateRequest configConfig = new ConfigCreateRequest(name, labels, configDataBase64, null);
        IdResponse response = this.client.getConfigApi().configCreate(configConfig);
        return new EngineResponseContent<IdResponse>(response);
    }

    @Override
    public EngineResponseContent<IdResponse> createConfig(String name, byte[] configData) {
        return this.createConfig(name, configData, new HashMap<String, String>());
    }

    @Override
    public EngineResponseContent<Config> inspectConfig(String configId) {
        this.log.info("docker config inspect");
        Config configInspect = this.client.getConfigApi().configInspect(configId);
        return new EngineResponseContent<Config>(configInspect);
    }

    @Override
    @Deprecated
    public EngineResponseContent<List<Config>> configs(Map<String, Object> query) {
        HashMap<String, Object> actualQuery = new HashMap<String, Object>();
        if (query != null) {
            actualQuery.putAll(query);
        }
        new QueryParameterEncoder().jsonEncodeQueryParameter(actualQuery, "filters");
        return this.configs((String)actualQuery.get("filters"));
    }

    @Override
    public EngineResponseContent<List<Config>> configs(String filters) {
        this.log.info("docker config ls");
        List configs = this.client.getConfigApi().configList(filters);
        return new EngineResponseContent<List<Config>>(configs);
    }

    @Override
    public EngineResponseContent<List<Config>> configs() {
        return this.configs((String)null);
    }

    @Override
    public void rmConfig(String configId) {
        this.log.info("docker config rm");
        this.client.getConfigApi().configDelete(configId);
    }

    @Override
    public void updateConfig(String configId, long version, ConfigSpec configSpec) {
        this.log.info("docker config update");
        this.client.getConfigApi().configUpdate(configId, version, configSpec);
    }
}

