/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.container;

import de.gesellix.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveUtil {
    private final Logger log = LoggerFactory.getLogger(ArchiveUtil.class);

    @Deprecated
    public byte[] extractSingleTarEntry(InputStream tarContent, String filename) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        long bytesRead = this.copySingleTarEntry(tarContent, filename, output);
        return output.toByteArray();
    }

    public long copySingleTarEntry(InputStream tarContent, String filename, OutputStream target) {
        TarArchiveEntry entry;
        TarArchiveInputStream stream = new TarArchiveInputStream((InputStream)new BufferedInputStream(tarContent));
        try {
            entry = stream.getNextEntry();
            this.log.debug("entry size: {}", (Object)entry.getSize());
        }
        catch (Exception e) {
            throw new RuntimeException("failed to get next TarArchiveEntry", e);
        }
        String entryName = entry.getName();
        if (!filename.endsWith(entryName)) {
            this.log.warn("entry name '{}' doesn't match expected filename '{}'", (Object)entryName, (Object)filename);
        } else {
            this.log.debug("entry name: '{}'", (Object)entryName);
        }
        byte[] content = new byte[(int)entry.getSize()];
        this.log.debug("going to read {} bytes", (Object)content.length);
        Source source = Okio.source((InputStream)stream);
        Sink sink = Okio.sink((OutputStream)target);
        try {
            IOUtils.copy((Source)source, (Sink)sink);
            long l = entry.getSize();
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to write TarArchiveEntry to target OutputStream", e);
        }
        finally {
            this.silently(() -> {
                sink.flush();
                return null;
            });
            this.silently(() -> {
                sink.close();
                return null;
            });
            this.silently(() -> {
                source.close();
                return null;
            });
        }
    }

    private void silently(Callable<Void> action) {
        try {
            action.call();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

