/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.container;

import de.gesellix.docker.client.EngineResponseContent;
import de.gesellix.docker.client.container.ArchiveUtil;
import de.gesellix.docker.client.container.DockerResponseHandler;
import de.gesellix.docker.client.container.ManageContainer;
import de.gesellix.docker.client.repository.RepositoryTagParser;
import de.gesellix.docker.engine.AttachConfig;
import de.gesellix.docker.engine.EngineClient;
import de.gesellix.docker.engine.EngineResponse;
import de.gesellix.docker.remote.api.ContainerConfig;
import de.gesellix.docker.remote.api.ContainerCreateRequest;
import de.gesellix.docker.remote.api.ContainerCreateResponse;
import de.gesellix.docker.remote.api.ContainerInspectResponse;
import de.gesellix.docker.remote.api.ContainerPruneResponse;
import de.gesellix.docker.remote.api.ContainerTopResponse;
import de.gesellix.docker.remote.api.ContainerUpdateRequest;
import de.gesellix.docker.remote.api.ContainerUpdateResponse;
import de.gesellix.docker.remote.api.ContainerWaitResponse;
import de.gesellix.docker.remote.api.EngineApiClient;
import de.gesellix.docker.remote.api.ExecConfig;
import de.gesellix.docker.remote.api.ExecInspectResponse;
import de.gesellix.docker.remote.api.ExecStartConfig;
import de.gesellix.docker.remote.api.FilesystemChange;
import de.gesellix.docker.remote.api.HealthConfig;
import de.gesellix.docker.remote.api.IdResponse;
import de.gesellix.docker.remote.api.client.ContainerApi;
import de.gesellix.docker.remote.api.core.ClientException;
import de.gesellix.docker.remote.api.core.Frame;
import de.gesellix.docker.remote.api.core.StreamCallback;
import de.gesellix.util.QueryParameterEncoder;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageContainerClient
implements ManageContainer,
GroovyObject {
    private final Logger log;
    private EngineApiClient client;
    private EngineClient engineClient;
    private DockerResponseHandler responseHandler;
    private QueryParameterEncoder queryParameterEncoder;
    private ArchiveUtil archiveUtil;
    private RepositoryTagParser repositoryTagParser;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ManageContainerClient(EngineApiClient client, EngineClient engineClient) {
        EngineClient engineClient2;
        EngineApiClient engineApiClient;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, ManageContainerClient.class);
        this.log = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.client = engineApiClient = client;
        this.engineClient = engineClient2 = engineClient;
        CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, DockerResponseHandler.class);
        this.responseHandler = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        CallSite callSite3 = IndyInterface.bootstrap("init", "<init>", 0, RepositoryTagParser.class);
        this.repositoryTagParser = IndyInterface.bootstrap("cast", "()", 0, callSite3);
        CallSite callSite4 = IndyInterface.bootstrap("init", "<init>", 0, QueryParameterEncoder.class);
        this.queryParameterEncoder = IndyInterface.bootstrap("cast", "()", 0, callSite4);
        CallSite callSite5 = IndyInterface.bootstrap("init", "<init>", 0, ArchiveUtil.class);
        this.archiveUtil = IndyInterface.bootstrap("cast", "()", 0, callSite5);
    }

    @Override
    public EngineResponse attach(String containerId, Map<String, Object> query, AttachConfig callback) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker attach");
        CallSite container = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "inspectContainer", 2, this, containerId));
        boolean multiplexStreams = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "tty", 0, IndyInterface.bootstrap("getProperty", "config", 0, IndyInterface.bootstrap("getProperty", "content", 0, container)))) == false;
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "post", 0, this.engineClient, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/attach"})), "query", query, "attach", callback, "multiplexStreams", multiplexStreams})));
        if (IndyInterface.bootstrap("cast", "()", 0, callback) == false) {
            boolean bl = multiplexStreams;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)IndyInterface.bootstrap("getProperty", "stream", 0, response), (String)"multiplexStreams");
        }
        return response;
    }

    @Override
    public void attach(String containerId, String detachKeys, Boolean logs, Boolean stream, Boolean stdin, Boolean stdout, Boolean stderr, StreamCallback<Frame> callback, Duration timeout) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker attach");
        IndyInterface.bootstrap("invoke", "containerAttach", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerId, detachKeys, logs, stream, stdin, stdout, stderr, callback, IndyInterface.bootstrap("invoke", "toMillis", 0, timeout));
    }

    @Override
    public WebSocket attachWebsocket(String containerId, Map<String, Object> query, WebSocketListener listener) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker attach via websocket");
        CallSite webSocket = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "webSocket", 0, this.engineClient, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{containerId}, new String[]{"/containers/", "/attach/ws"})), "query", query}), listener));
        return webSocket;
    }

    @Override
    public void resizeTTY(String container, Integer height, Integer width) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker resize container");
        IndyInterface.bootstrap("invoke", "containerResize", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), container, height, width);
    }

    @Override
    public EngineResponseContent<IdResponse> commit(String container, Map query, Map config) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker commit");
        Map map = query;
        Map finalQuery = IndyInterface.bootstrap("cast", "()", 0, map) != false ? map : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        String string = container;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)finalQuery, (String)"container");
        Map map2 = config;
        config = IndyInterface.bootstrap("cast", "()", 0, map2) != false ? map2 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        CallSite imageCommit = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "imageCommit", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), container, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "repo", 0, query), String.class))), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "tag", 0, query), String.class))), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "comment", 0, query), String.class))), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "author", 0, query), String.class))), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "pause", 0, query), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "changes", 0, query), String.class))), String.class), IndyInterface.bootstrap("init", "<init>", 0, ContainerConfig.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "Hostname", 0, config), String.class))), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "Domainname", 0, config), String.class))), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "User", 0, config), String.class))), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "AttachStdin", 0, config), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "AttachStdout", 0, config), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "AttachStderr", 0, config), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "ExposedPorts", 0, config), Map.class))), Map.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "Tty", 0, config), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "OpenStdin", 0, config), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "StdinOnce", 0, config), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "Env", 0, config), List.class))), List.class), IndyInterface.bootstrap("getProperty", "Cmd", 0, config) instanceof String ? ScriptBytecodeAdapter.createList((Object[])new Object[]{(String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "Cmd", 0, config), String.class))}) : (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "Cmd", 0, config), List.class)), IndyInterface.bootstrap("init", "<init>", 0, HealthConfig.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "ArgsEscaped", 0, config), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "Image", 0, config), String.class))), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "Volumes", 0, config), Map.class))), Map.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "WorkingDir", 0, config), String.class))), String.class), IndyInterface.bootstrap("getProperty", "Entrypoint", 0, config) instanceof String ? ScriptBytecodeAdapter.createList((Object[])new Object[]{(String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "Entrypoint", 0, config), String.class))}) : (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "Entrypoint", 0, config), List.class)), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "NetworkDisabled", 0, config), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "MacAddress", 0, config), String.class))), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "OnBuild", 0, config), List.class))), List.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "Labels", 0, config), Map.class))), Map.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "StopSignal", 0, config), String.class))), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "StopTimeout", 0, config), Integer.class))), Integer.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "Shell", 0, config), List.class))), List.class))));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, imageCommit));
    }

    @Override
    public EngineResponseContent<Map<String, Object>> getArchiveStats(String container, String path) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{container, path}, new String[]{"docker archive stats ", "|", ""}));
        CallSite archiveInfo = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerArchiveInfo", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), container, path));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, archiveInfo));
    }

    @Override
    public byte[] extractFile(String container, String filename) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{filename, container}, new String[]{"extract '", "' from '", "'"}));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getArchive", 2, this, container, filename));
        CallSite output = IndyInterface.bootstrap("init", "<init>", 0, ByteArrayOutputStream.class);
        CallSite bytesRead = IndyInterface.bootstrap("invoke", "copySingleTarEntry", 0, this.archiveUtil, IndyInterface.bootstrap("getProperty", "content", 0, response), filename, output);
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{bytesRead}, new String[]{"read ", " bytes"}));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toByteArray", 0, output));
    }

    @Override
    public EngineResponseContent<InputStream> getArchive(String container, String path) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{container, path}, new String[]{"docker download from ", "|", ""}));
        CallSite archive = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerArchive", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), container, path));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, archive));
    }

    @Override
    public void putArchive(String container, String path, InputStream archive) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{container, path}, new String[]{"docker upload to ", "|", ""}));
        IndyInterface.bootstrap("invoke", "putContainerArchive", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), container, path, archive, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public EngineResponseContent<ContainerCreateResponse> createContainer(ContainerCreateRequest containerCreateRequest, String name, String authBase64Encoded) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker create");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "image", 0, containerCreateRequest)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "'Image' missing in containerCreateRequest"));
        }
        CallSite containerCreate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerCreate", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerCreateRequest, name));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, containerCreate));
        try {
            return callSite;
        }
        catch (ClientException exception) {
            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "statusCode", 0, exception), (Object)404)) throw (Throwable)exception;
            CallSite repoAndTag = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseRepositoryTag", 0, this.repositoryTagParser, IndyInterface.bootstrap("getProperty", "image", 0, containerCreateRequest)));
            IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "repo", 0, repoAndTag), IndyInterface.bootstrap("getProperty", "tag", 0, repoAndTag)}, new String[]{"'", ":", "' not found locally."}));
            IndyInterface.bootstrap("invoke", "imageCreate", 0, IndyInterface.bootstrap("getProperty", "imageApi", 0, this.client), IndyInterface.bootstrap("getProperty", "repo", 0, repoAndTag), null, null, IndyInterface.bootstrap("getProperty", "tag", 0, repoAndTag), null, authBase64Encoded, null, null, null);
            CallSite containerCreateWithPulledImage = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerCreate", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerCreateRequest, name));
            CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, containerCreateWithPulledImage));
            return callSite2;
        }
    }

    @Override
    public EngineResponseContent<List<FilesystemChange>> diff(String containerId) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker diff");
        CallSite containerChanges = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerChanges", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerId));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, containerChanges));
    }

    @Override
    public EngineResponseContent<IdResponse> createExec(String containerId, ExecConfig execConfig) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{containerId}, new String[]{"docker create exec on '", "'"}));
        CallSite containerExec = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerExec", 0, IndyInterface.bootstrap("getProperty", "execApi", 0, this.client), containerId, execConfig));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, containerExec));
    }

    @Override
    public void startExec(String execId, ExecStartConfig execStartConfig, AttachConfig attachConfig) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{execId}, new String[]{"docker start exec '", "'"}));
        CallSite execInspect = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execInspect", 0, IndyInterface.bootstrap("getProperty", "execApi", 0, this.client), execId));
        boolean multiplexStreams = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "tty", 0, IndyInterface.bootstrap("getProperty", "processConfig", 0, execInspect))) == false;
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "post", 0, this.engineClient, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{execId}, new String[]{"/exec/", "/start"})), "body", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Detach", IndyInterface.bootstrap("getProperty", "detach", 0, execStartConfig), "Tty", IndyInterface.bootstrap("getProperty", "tty", 0, execStartConfig)}), "requestContentType", "application/json", "attach", attachConfig, "multiplexStreams", multiplexStreams})));
        if (IndyInterface.bootstrap("cast", "()", 0, attachConfig) == false) {
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "code", 1, IndyInterface.bootstrap("getProperty", "status", 0, response)), (Object)404)) {
                IndyInterface.bootstrap("invoke", "error", 0, this.log, new GStringImpl(new Object[]{execId}, new String[]{"no such exec '", "'"}));
            }
            IndyInterface.bootstrap("invoke", "ensureSuccessfulResponse", 0, this.responseHandler, response, IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "docker exec start failed"));
            boolean bl = multiplexStreams;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)IndyInterface.bootstrap("getProperty", "stream", 0, response), (String)"multiplexStreams");
        }
    }

    @Override
    public void startExec(String execId, ExecStartConfig execStartConfig, StreamCallback<Frame> callback, Duration timeout) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{execId}, new String[]{"docker start exec '", "'"}));
        IndyInterface.bootstrap("invoke", "execStart", 0, IndyInterface.bootstrap("getProperty", "execApi", 0, this.client), execId, execStartConfig, callback, IndyInterface.bootstrap("invoke", "toMillis", 1, timeout));
    }

    @Override
    public EngineResponseContent<ExecInspectResponse> inspectExec(String execId) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{execId}, new String[]{"docker inspect exec '", "'"}));
        CallSite execInspect = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execInspect", 0, IndyInterface.bootstrap("getProperty", "execApi", 0, this.client), execId));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, execInspect));
    }

    @Override
    public EngineResponseContent<IdResponse> exec(String containerId, List<String> command, StreamCallback<Frame> callback, Duration timeout, Map<String, Object> execConfig) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{containerId, command}, new String[]{"docker exec '", "' '", "'"}));
        CallSite callSite = IndyInterface.bootstrap("getProperty", "AttachStdin", 0, execConfig);
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "Tty", 0, execConfig);
        CallSite actualExecConfig = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ExecConfig.class, ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Boolean.valueOf(false), Boolean.class)), Boolean.class), true, true, null, null, ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : Boolean.valueOf(false), Boolean.class)), Boolean.class), null, command, null, null, null));
        CallSite execCreateResult = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createExec", 2, this, containerId, actualExecConfig));
        CallSite execId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("getProperty", "content", 0, execCreateResult)));
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "Detach", 0, execConfig);
        CallSite execStartConfig = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ExecStartConfig.class, ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("cast", "()", 0, callSite3) != false ? callSite3 : Boolean.valueOf(false), Boolean.class)), Boolean.class), IndyInterface.bootstrap("getProperty", "tty", 0, actualExecConfig), null));
        IndyInterface.bootstrap("invoke", "startExec", 2, this, execId, execStartConfig, callback, timeout);
        return execCreateResult;
    }

    @Override
    public void resizeExec(String exec, Integer height, Integer width) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker resize exec");
        IndyInterface.bootstrap("invoke", "execResize", 0, IndyInterface.bootstrap("getProperty", "execApi", 0, this.client), exec, height, width);
    }

    @Override
    public EngineResponseContent<InputStream> export(String container) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{container}, new String[]{"docker export ", ""}));
        CallSite containerExport = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerExport", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), container));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, containerExport));
    }

    @Override
    public EngineResponseContent<ContainerInspectResponse> inspectContainer(String containerId) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker inspect container");
        CallSite containerInspect = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerInspect", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerId, null));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, containerInspect));
    }

    @Override
    public void kill(String containerId) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker kill");
        IndyInterface.bootstrap("invoke", "containerKill", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerId, null);
    }

    @Override
    public void logs(String container, Map<String, Object> query, StreamCallback<Frame> callback, Duration timeout) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker logs");
        Map actualQuery = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (IndyInterface.bootstrap("cast", "()", 0, query) != false) {
            IndyInterface.bootstrap("invoke", "putAll", 0, actualQuery, query);
        }
        IndyInterface.bootstrap("invoke", "containerLogs", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), container, ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getOrDefault", 0, actualQuery, "follow", true), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getOrDefault", 0, actualQuery, "stdout", true), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getOrDefault", 0, actualQuery, "stderr", true), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getOrDefault", 0, actualQuery, "since", false), Integer.class))), Integer.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "until", 0, actualQuery), Integer.class))), Integer.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getOrDefault", 0, actualQuery, "timestamps", false), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getOrDefault", 0, actualQuery, "tail", "all"), String.class))), String.class), callback, IndyInterface.bootstrap("invoke", "toMillis", 0, timeout));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void waitForLogEvent(String container, Map<String, Object> query, Predicate<Frame> matcher, Duration timeout) {
        void var3_3;
        void var2_2;
        Reference container2 = new Reference((Object)container);
        Reference query2 = new Reference((Object)var2_2);
        Reference matcher2 = new Reference((Object)var3_3);
        Reference timeout2 = new Reference((Object)timeout);
        Reference latch = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, CountDownLatch.class, true)));
        Reference frameHandler = new Reference((Object)new StreamCallback<Frame>(this, matcher2, latch){
            public /* synthetic */ Reference latch;
            public /* synthetic */ Reference matcher;
            final /* synthetic */ ManageContainerClient this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                ManageContainerClient manageContainerClient;
                this.this$0 = manageContainerClient = p0;
                this.matcher = reference2 = p1;
                this.latch = reference = p2;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public void onNext(Frame element) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "test", 0, IndyInterface.bootstrap("cast", "()", 0, this.matcher.get()), element)) != false) {
                    IndyInterface.bootstrap("invoke", "countDown", 0, IndyInterface.bootstrap("cast", "()", 0, this.latch.get()));
                }
            }

            public void onFailed(Exception e) {
                IndyInterface.bootstrap("invoke", "error", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "Logs failed", e);
                IndyInterface.bootstrap("invoke", "countDown", 0, IndyInterface.bootstrap("cast", "()", 0, this.latch.get()));
            }

            public void onFinished() {
                IndyInterface.bootstrap("invoke", "countDown", 0, IndyInterface.bootstrap("cast", "()", 0, this.latch.get()));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                try {
                    return this.this$0.this$dist$invoke$1(name, args);
                }
                catch (MissingMethodException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound)));
                }
            }

            /*
             * Unable to fully structure code
             */
            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                if (!(args instanceof Object[] == false)) ** GOTO lbl8
                var2_2 = ScriptBytecodeAdapter.invokeMethodN(1.class, ManageContainerClient.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                return var2_2;
lbl8:
                // 1 sources

                if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
                var3_3 = ScriptBytecodeAdapter.invokeMethodN(1.class, ManageContainerClient.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
                return var3_3;
lbl14:
                // 1 sources

                var4_4 = ScriptBytecodeAdapter.invokeMethodN(1.class, ManageContainerClient.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                try {
                    return var4_4;
                }
                catch (MissingMethodException notFound) {
                    throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
                }
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                try {
                    this.this$0.this$dist$set$1(name, value);
                    return;
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                }
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                try {
                    Object object = value;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, ManageContainerClient.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                }
            }

            public /* synthetic */ Object propertyMissing(String name) {
                try {
                    return this.this$0.this$dist$get$1(name);
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                }
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                Object object = ScriptBytecodeAdapter.getProperty(1.class, ManageContainerClient.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                try {
                    return object;
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                }
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }

            public /* synthetic */ void super$1$onFailed(Exception exception) {
                super.onFailed(exception);
            }

            public /* synthetic */ void super$1$onFinished() {
                super.onFinished();
            }
        });
        public final class _waitForLogEvent_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference query;
            private /* synthetic */ Reference container;
            private /* synthetic */ Reference frameHandler;
            private /* synthetic */ Reference timeout;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _waitForLogEvent_closure1(Object _outerInstance, Object _thisObject, Reference query, Reference container, Reference frameHandler, Reference timeout) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.query = reference4 = query;
                this.container = reference3 = container;
                this.frameHandler = reference2 = frameHandler;
                this.timeout = reference = timeout;
            }

            public Object doCall(Object it) {
                int n = 1;
                ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)IndyInterface.bootstrap("cast", "()", 0, this.query.get()), (String)"tail");
                return IndyInterface.bootstrap("invoke", "logs", 2, this, IndyInterface.bootstrap("cast", "()", 0, this.container.get()), IndyInterface.bootstrap("cast", "()", 0, this.query.get()), this.frameHandler.get(), IndyInterface.bootstrap("cast", "()", 0, this.timeout.get()));
            }

            @Generated
            public Map getQuery() {
                return IndyInterface.bootstrap("cast", "()", 0, this.query.get());
            }

            @Generated
            public String getContainer() {
                return IndyInterface.bootstrap("cast", "()", 0, this.container.get());
            }

            @Generated
            public Object getFrameHandler() {
                return this.frameHandler.get();
            }

            @Generated
            public Duration getTimeout() {
                return IndyInterface.bootstrap("cast", "()", 0, this.timeout.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _waitForLogEvent_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "start", 0, IndyInterface.bootstrap("init", "<init>", 0, Thread.class, new _waitForLogEvent_closure1(this, this, query2, container2, frameHandler, timeout2)));
        CallSite success = IndyInterface.bootstrap("invoke", "await", 0, (CountDownLatch)latch.get(), IndyInterface.bootstrap("invoke", "toMillis", 0, (Duration)timeout2.get()), IndyInterface.bootstrap("getProperty", "MILLISECONDS", 0, TimeUnit.class));
        if (IndyInterface.bootstrap("cast", "()", 0, success) == false) {
            IndyInterface.bootstrap("invoke", "warn", 0, this.log, "Timeout reached after {} while waiting for the expected log message", (Duration)timeout2.get());
        }
    }

    @Override
    public EngineResponseContent<List<Map<String, Object>>> ps(Map<String, Object> query) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker ps");
        Map actualQuery = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (IndyInterface.bootstrap("cast", "()", 0, query) != false) {
            IndyInterface.bootstrap("invoke", "putAll", 0, actualQuery, query);
        }
        IndyInterface.bootstrap("invoke", "jsonEncodeQueryParameter", 0, this.queryParameterEncoder, actualQuery, "filters");
        CallSite containerList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerList", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getOrDefault", 0, actualQuery, "all", true), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "limit", 0, actualQuery), Integer.class))), Integer.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getOrDefault", 0, actualQuery, "size", false), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "filters", 0, actualQuery), String.class))), String.class)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, containerList));
    }

    @Override
    public EngineResponseContent<List<Map<String, Object>>> ps(Boolean all, Integer limit, Boolean size, String filters) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker ps");
        Boolean bl = size;
        CallSite containerList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerList", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), ScriptBytecodeAdapter.compareEqual((Object)all, null) ? Boolean.valueOf(true) : all, limit, IndyInterface.bootstrap("cast", "()", 0, bl) != false ? bl : Boolean.valueOf(false), filters));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, containerList));
    }

    @Override
    public void pause(String containerId) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker pause");
        IndyInterface.bootstrap("invoke", "containerPause", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerId);
    }

    @Override
    public EngineResponseContent<ContainerPruneResponse> pruneContainers(String filters) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker container prune");
        CallSite containerPrune = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerPrune", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), filters));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, containerPrune));
    }

    @Override
    public void rename(String container, String newName) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker rename");
        IndyInterface.bootstrap("invoke", "containerRename", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), container, newName);
    }

    @Override
    public void restart(String containerIdOrName) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker restart");
        IndyInterface.bootstrap("invoke", "containerRestart", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerIdOrName, 5);
    }

    @Override
    public void rm(String containerIdOrName, Map<String, Object> query) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker rm");
        IndyInterface.bootstrap("invoke", "containerDelete", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerIdOrName, ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "v", 0, query), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "force", 0, query), Boolean.class)), Boolean.class), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "link", 0, query), Boolean.class)), Boolean.class));
    }

    @Override
    public EngineResponseContent<ContainerCreateResponse> run(ContainerCreateRequest containerCreateRequest, String name, String authBase64Encoded) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "image", 0, containerCreateRequest)}, new String[]{"docker run ", ""}));
        CallSite createContainerResponse = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createContainer", 2, this, containerCreateRequest, name, authBase64Encoded));
        IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{createContainerResponse}, new String[]{"create container result: ", ""}));
        CallSite containerId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("getProperty", "content", 0, createContainerResponse)));
        IndyInterface.bootstrap("invoke", "startContainer", 2, this, containerId);
        return createContainerResponse;
    }

    @Override
    public void startContainer(String containerId) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker start");
        IndyInterface.bootstrap("invoke", "containerStart", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerId, null);
    }

    @Override
    public void stats(String container, Boolean stream, StreamCallback<Object> callback, Duration timeout) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker stats");
        IndyInterface.bootstrap("invoke", "containerStats", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), container, stream, null, callback, IndyInterface.bootstrap("invoke", "toMillis", 0, timeout));
    }

    @Override
    public void stop(String containerIdOrName, Integer timeoutSeconds) {
        IndyInterface.bootstrap("invoke", "stop", 2, this, containerIdOrName, ScriptBytecodeAdapter.compareNotEqual((Object)timeoutSeconds, null) ? IndyInterface.bootstrap("invoke", "of", 0, Duration.class, timeoutSeconds, IndyInterface.bootstrap("getProperty", "SECONDS", 0, ChronoUnit.class)) : null);
    }

    @Override
    public void stop(String containerIdOrName, Duration timeout) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker stop");
        Duration duration = timeout;
        long timeoutInSeconds = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("getProperty", "seconds", 0, IndyInterface.bootstrap("cast", "()", 0, duration) != false ? duration : IndyInterface.bootstrap("invoke", "of", 0, Duration.class, 10, IndyInterface.bootstrap("getProperty", "SECONDS", 0, ChronoUnit.class))));
        IndyInterface.bootstrap("invoke", "containerStop", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerIdOrName, ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, timeoutInSeconds, Integer.class))), Integer.TYPE));
    }

    @Override
    public EngineResponseContent<ContainerTopResponse> top(String containerIdOrName, String psArgs) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker top");
        String string = psArgs;
        CallSite containerTop = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerTop", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerIdOrName, IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : null));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, containerTop));
    }

    @Override
    public void unpause(String containerId) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker unpause");
        IndyInterface.bootstrap("invoke", "containerUnpause", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerId);
    }

    @Override
    public EngineResponseContent<ContainerUpdateResponse> updateContainer(String container, ContainerUpdateRequest containerUpdateRequest) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{container}, new String[]{"docker update '", "'"}));
        CallSite containerUpdate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerUpdate", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), container, containerUpdateRequest));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, containerUpdate));
    }

    @Override
    public EngineResponseContent<ContainerWaitResponse> wait(String containerIdOrName, ContainerApi.ConditionContainerWait condition) {
        IndyInterface.bootstrap("invoke", "info", 0, this.log, "docker wait");
        CallSite containerWait = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containerWait", 0, IndyInterface.bootstrap("getProperty", "containerApi", 0, this.client), containerIdOrName, ScriptBytecodeAdapter.createPojoWrapper((Object)condition, ContainerApi.ConditionContainerWait.class)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EngineResponseContent.class, containerWait));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ManageContainerClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ManageContainerClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ManageContainerClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ManageContainerClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ManageContainerClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ManageContainerClient.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Override
    @Generated
    public EngineResponse attach(String containerId, Map<String, Object> query) {
        return this.attach(containerId, query, null);
    }

    @Override
    @Generated
    public EngineResponseContent<IdResponse> commit(String container, Map query) {
        return this.commit(container, query, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerCreateResponse> createContainer(ContainerCreateRequest containerCreateRequest, String name) {
        return this.createContainer(containerCreateRequest, name, "");
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerCreateResponse> createContainer(ContainerCreateRequest containerCreateRequest) {
        return this.createContainer(containerCreateRequest, "", "");
    }

    @Override
    @Generated
    public EngineResponseContent<IdResponse> exec(String containerId, List<String> command, StreamCallback<Frame> callback, Duration timeout) {
        return this.exec(containerId, command, callback, timeout, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"Detach", false, "AttachStdin", false, "Tty", false}));
    }

    @Override
    @Generated
    public EngineResponseContent<List<Map<String, Object>>> ps(Boolean all, Integer limit, Boolean size) {
        return this.ps(all, limit, size, null);
    }

    @Override
    @Generated
    public EngineResponseContent<List<Map<String, Object>>> ps(Boolean all, Integer limit) {
        return this.ps(all, limit, false, null);
    }

    @Override
    @Generated
    public EngineResponseContent<List<Map<String, Object>>> ps(Boolean all) {
        return this.ps(all, null, false, null);
    }

    @Override
    @Generated
    public EngineResponseContent<List<Map<String, Object>>> ps() {
        return this.ps(true, null, false, null);
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerPruneResponse> pruneContainers() {
        return this.pruneContainers(null);
    }

    @Override
    @Generated
    public void rm(String containerIdOrName) {
        this.rm(containerIdOrName, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerCreateResponse> run(ContainerCreateRequest containerCreateRequest, String name) {
        return this.run(containerCreateRequest, name, "");
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerCreateResponse> run(ContainerCreateRequest containerCreateRequest) {
        return this.run(containerCreateRequest, "", "");
    }

    @Override
    @Generated
    public void stop(String containerIdOrName) {
        this.stop(containerIdOrName, (Duration)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "of", 0, Duration.class, 10, IndyInterface.bootstrap("getProperty", "SECONDS", 0, ChronoUnit.class)))));
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerTopResponse> top(String containerIdOrName) {
        return this.top(containerIdOrName, null);
    }

    @Override
    @Generated
    public EngineResponseContent<ContainerWaitResponse> wait(String containerIdOrName) {
        return this.wait(containerIdOrName, null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

