/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.compose.interpolation;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/gesellix/docker/compose/interpolation/Template;", "", "<init>", "()V", "delimiter", "", "substitution", "patternString", "pattern", "Lcom/google/re2j/Pattern;", "substitute", "input", "environment", "", "partition", "Lde/gesellix/docker/compose/interpolation/Template$Partitions;", "s", "sep", "Lkotlin/text/Regex;", "lookupEnv", "Lde/gesellix/docker/compose/interpolation/Template$Result;", "name", "Partitions", "Result", "docker-compose-v3"})
public final class Template {
    @NotNull
    private final String delimiter;
    @NotNull
    private final String substitution;
    @NotNull
    private final String patternString;
    @NotNull
    private final Pattern pattern;

    public Template() {
        this.delimiter = "\\$";
        this.substitution = "[_a-z][_a-z0-9]*(?::?-[^}]+)?";
        this.patternString = this.delimiter + "(?i:(?P<escaped>" + this.delimiter + ")|(?P<named>" + this.substitution + ")|{(?P<braced>" + this.substitution + ")}|(?P<invalid>))";
        Pattern pattern = Pattern.compile((String)this.patternString);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.pattern = pattern;
    }

    @NotNull
    public final String substitute(@NotNull String input, @NotNull Map<String, String> environment) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        StringBuffer result = new StringBuffer();
        Matcher m = this.pattern.matcher((CharSequence)input);
        while (m.find()) {
            String substitution = null;
            if (m.group(2) != null) {
                substitution = m.group(2);
            } else if (m.group(3) != null) {
                substitution = m.group(3);
            }
            if (substitution != null) {
                Matcher matcher;
                boolean ok;
                String value;
                Result result2;
                String name;
                Object object;
                if (StringsKt.contains$default((CharSequence)substitution, (CharSequence)":-", (boolean)false, (int)2, null)) {
                    Matcher matcher2;
                    object = this.partition(substitution, new Regex(":-"));
                    name = ((Partitions)object).component1();
                    String defaultValue = ((Partitions)object).component2();
                    result2 = this.lookupEnv(name, environment);
                    value = result2.component1();
                    ok = result2.component2();
                    if (ok && !Intrinsics.areEqual((Object)value, (Object)"")) {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        matcher2 = m.appendReplacement(result, value);
                        continue;
                    }
                    matcher2 = m.appendReplacement(result, defaultValue);
                    continue;
                }
                if (StringsKt.contains$default((CharSequence)substitution, (CharSequence)"-", (boolean)false, (int)2, null)) {
                    Matcher matcher3;
                    object = this.partition(substitution, new Regex("-"));
                    name = ((Partitions)object).component1();
                    String defaultValue = ((Partitions)object).component2();
                    result2 = this.lookupEnv(name, environment);
                    value = result2.component1();
                    ok = result2.component2();
                    if (ok) {
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                        matcher3 = m.appendReplacement(result, value);
                        continue;
                    }
                    matcher3 = m.appendReplacement(result, defaultValue);
                    continue;
                }
                object = this.lookupEnv(substitution, environment);
                String value2 = ((Result)object).component1();
                boolean ok2 = ((Result)object).component2();
                if (ok2) {
                    Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.String");
                    matcher = m.appendReplacement(result, value2);
                    continue;
                }
                matcher = m.appendReplacement(result, "");
                continue;
            }
            if (m.group(1) != null) {
                m.appendReplacement(result, m.group(1));
                continue;
            }
            throw new IllegalStateException("Invalid template: " + input);
        }
        m.appendTail(result);
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final Partitions partition(String s, Regex sep) {
        if (sep.containsMatchIn((CharSequence)s)) {
            CharSequence charSequence = s;
            int n = 2;
            List parts = sep.split(charSequence, n);
            return new Partitions((String)parts.get(0), (String)parts.get(1));
        }
        return new Partitions(s, "");
    }

    private final Result lookupEnv(String name, Map<String, String> environment) {
        return new Result(environment.get(name), environment.containsKey(name));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lde/gesellix/docker/compose/interpolation/Template$Partitions;", "", "left", "", "right", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getLeft", "()Ljava/lang/String;", "getRight", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "docker-compose-v3"})
    public static final class Partitions {
        @NotNull
        private final String left;
        @NotNull
        private final String right;

        public Partitions(@NotNull String left, @NotNull String right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            this.left = left;
            this.right = right;
        }

        @NotNull
        public final String getLeft() {
            return this.left;
        }

        @NotNull
        public final String getRight() {
            return this.right;
        }

        @NotNull
        public final String component1() {
            return this.left;
        }

        @NotNull
        public final String component2() {
            return this.right;
        }

        @NotNull
        public final Partitions copy(@NotNull String left, @NotNull String right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            return new Partitions(left, right);
        }

        public static /* synthetic */ Partitions copy$default(Partitions partitions, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = partitions.left;
            }
            if ((n & 2) != 0) {
                string2 = partitions.right;
            }
            return partitions.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Partitions(left=" + this.left + ", right=" + this.right + ')';
        }

        public int hashCode() {
            int result = this.left.hashCode();
            result = result * 31 + this.right.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Partitions)) {
                return false;
            }
            Partitions partitions = (Partitions)other;
            if (!Intrinsics.areEqual((Object)this.left, (Object)partitions.left)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.right, (Object)partitions.right);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lde/gesellix/docker/compose/interpolation/Template$Result;", "", "result", "", "found", "", "<init>", "(Ljava/lang/String;Z)V", "getResult", "()Ljava/lang/String;", "getFound", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "docker-compose-v3"})
    public static final class Result {
        @Nullable
        private final String result;
        private final boolean found;

        public Result(@Nullable String result, boolean found) {
            this.result = result;
            this.found = found;
        }

        @Nullable
        public final String getResult() {
            return this.result;
        }

        public final boolean getFound() {
            return this.found;
        }

        @Nullable
        public final String component1() {
            return this.result;
        }

        public final boolean component2() {
            return this.found;
        }

        @NotNull
        public final Result copy(@Nullable String result, boolean found) {
            return new Result(result, found);
        }

        public static /* synthetic */ Result copy$default(Result result, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = result.result;
            }
            if ((n & 2) != 0) {
                bl = result.found;
            }
            return result.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "Result(result=" + this.result + ", found=" + this.found + ')';
        }

        public int hashCode() {
            int result = this.result == null ? 0 : this.result.hashCode();
            result = result * 31 + Boolean.hashCode(this.found);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (!Intrinsics.areEqual((Object)this.result, (Object)result.result)) {
                return false;
            }
            return this.found == result.found;
        }
    }
}

