/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.authentication;

import com.squareup.moshi.Moshi;
import de.gesellix.docker.authentication.AuthConfig;
import de.gesellix.docker.authentication.CredsStore;
import de.gesellix.docker.authentication.FileStore;
import de.gesellix.docker.authentication.NativeStore;
import de.gesellix.docker.engine.DockerEnv;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthConfigReader {
    private static final Logger log = LoggerFactory.getLogger(AuthConfigReader.class);
    private final Moshi moshi = new Moshi.Builder().build();
    private final DockerEnv env;

    public AuthConfigReader() {
        this(new DockerEnv());
    }

    public AuthConfigReader(DockerEnv env) {
        this.env = env;
    }

    public AuthConfig readDefaultAuthConfig() {
        return this.readAuthConfig(null, this.env.getDockerConfigFile());
    }

    public AuthConfig readAuthConfig(String hostname, File dockerCfg) {
        Map parsedDockerCfg;
        log.debug("read authConfig");
        if (hostname == null || hostname.trim().isEmpty()) {
            hostname = this.env.getIndexUrl_v1();
        }
        if ((parsedDockerCfg = this.readDockerConfigFile(dockerCfg)) == null || parsedDockerCfg.isEmpty()) {
            return AuthConfig.EMPTY_AUTH_CONFIG;
        }
        CredsStore credsStore = this.getCredentialsStore(parsedDockerCfg, hostname);
        return credsStore.getAuthConfig(hostname);
    }

    public Map readDockerConfigFile(File dockerCfg) {
        if (dockerCfg == null) {
            dockerCfg = this.env.getDockerConfigFile();
        }
        if (dockerCfg == null || !dockerCfg.exists()) {
            log.info("docker config '${dockerCfg}' doesn't exist");
            return Collections.emptyMap();
        }
        log.debug("reading auth info from {}", (Object)dockerCfg);
        try {
            return (Map)this.moshi.adapter(Map.class).fromJson(Okio.buffer((Source)Okio.source((File)dockerCfg)));
        }
        catch (Exception e) {
            log.debug(MessageFormat.format("failed to read auth info from {}", dockerCfg), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public CredsStore getCredentialsStore(Map parsedDockerCfg) {
        return this.getCredentialsStore(parsedDockerCfg, "");
    }

    public CredsStore getCredentialsStore(Map parsedDockerCfg, String hostname) {
        if (parsedDockerCfg.containsKey("credHelpers") && hostname != null && !hostname.trim().isEmpty()) {
            return new NativeStore((String)((Map)parsedDockerCfg.get("credHelpers")).get(hostname));
        }
        if (parsedDockerCfg.containsKey("credsStore")) {
            return new NativeStore((String)parsedDockerCfg.get("credsStore"));
        }
        return new FileStore(parsedDockerCfg);
    }
}

