/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.rawstream;

import de.gesellix.docker.rawstream.RawStreamHeader;
import de.gesellix.docker.rawstream.StreamType;
import de.gesellix.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawInputStream
extends FilterInputStream {
    private static final Logger log = LoggerFactory.getLogger(RawInputStream.class);
    private static final int EOF = -1;
    private boolean multiplexStreams = true;
    private int remainingFrameSize = -1;

    public RawInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public long copyFullyMultiplexed(OutputStream stdout) throws IOException {
        return this.copyFullyMultiplexed(stdout, null);
    }

    public long copyFullyMultiplexed(OutputStream stdout, OutputStream stderr) throws IOException {
        int count;
        if (stdout == null && stderr == null) {
            throw new IllegalArgumentException("need at least one of stdout or stderr");
        }
        if (!this.multiplexStreams) {
            OutputStream actualOutputStream = stdout != null ? stdout : stderr;
            return IOUtils.copy(this.in, actualOutputStream);
        }
        long sum = 0L;
        while (-1 != (count = this.copyFrame(stdout, stderr))) {
            sum += (long)count;
        }
        return sum;
    }

    public int copyFrame(OutputStream stdout, OutputStream stderr) throws IOException {
        int n;
        ByteArrayOutputStream systemerr = new ByteArrayOutputStream();
        LinkedHashMap<StreamType, OutputStream> outputStreamsByStreamType = new LinkedHashMap<StreamType, OutputStream>();
        outputStreamsByStreamType.put(StreamType.STDOUT, stdout != null ? stdout : stderr);
        outputStreamsByStreamType.put(StreamType.STDERR, stderr != null ? stderr : stdout);
        outputStreamsByStreamType.put(StreamType.SYSTEMERR, systemerr);
        RawStreamHeader parsedHeader = this.readFrameHeader();
        log.trace(parsedHeader.toString());
        if (parsedHeader.equals(RawStreamHeader.EMPTY_HEADER)) {
            return -1;
        }
        int bytesToRead = parsedHeader.getFrameSize();
        int DEFAULT_BUFFER_SIZE = 4096;
        byte[] buffer = new byte[4096];
        int count = 0;
        while (-1 != (n = super.read(buffer, 0, Math.min(4096, bytesToRead)))) {
            OutputStream outputStream = (OutputStream)outputStreamsByStreamType.get((Object)parsedHeader.getStreamType());
            outputStream.write(buffer, 0, n);
            count += n;
            if ((bytesToRead -= n) > 0) continue;
            this.failOnSystemerr(parsedHeader, systemerr);
            return count;
        }
        this.failOnSystemerr(parsedHeader, systemerr);
        return count;
    }

    private void failOnSystemerr(RawStreamHeader parsedHeader, ByteArrayOutputStream systemerr) {
        if (parsedHeader.getStreamType().equals((Object)StreamType.SYSTEMERR)) {
            log.error(systemerr.toString());
            throw new IllegalStateException("error from daemon in stream: " + systemerr);
        }
    }

    @Override
    public synchronized int read(@NotNull byte[] b, int off, int len) throws IOException {
        if (this.multiplexStreams) {
            if (this.remainingFrameSize <= 0) {
                RawStreamHeader parsedHeader = this.readFrameHeader();
                log.trace(parsedHeader.toString());
                if (parsedHeader.equals(RawStreamHeader.EMPTY_HEADER)) {
                    return -1;
                }
                this.remainingFrameSize = parsedHeader.getFrameSize();
            }
            int count = this.readRemainingFrameSize(b, off, len, this.remainingFrameSize);
            this.remainingFrameSize -= Math.max(count, 0);
            return count;
        }
        return super.read(b, off, len);
    }

    public RawStreamHeader readFrameHeader() throws IOException {
        int[] headerBuf = new int[]{this.read(), this.read(), this.read(), this.read(), this.read(), this.read(), this.read(), this.read()};
        if (Arrays.stream(headerBuf).anyMatch(it -> it < 0)) {
            return RawStreamHeader.EMPTY_HEADER;
        }
        try {
            RawStreamHeader parsedHeader = new RawStreamHeader(headerBuf);
            log.trace(parsedHeader.toString());
            return parsedHeader;
        }
        catch (Exception e) {
            log.error("could not parse header - setting multiplexStreams=false could help.", (Throwable)e);
            throw e;
        }
    }

    public int readRemainingFrameSize(byte[] b, int off, int len, int remainingFrameSize) throws IOException {
        int updatedLen = Math.min(len, remainingFrameSize);
        return super.read(b, off, updatedLen);
    }

    public void setMultiplexStreams(boolean multiplexStreams) {
        this.multiplexStreams = multiplexStreams;
    }
}

