/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.authentication;

import de.gesellix.docker.authentication.AuthConfig;
import de.gesellix.docker.authentication.CredsStore;
import de.gesellix.docker.authentication.FileStore;
import de.gesellix.docker.authentication.NativeStore;
import de.gesellix.docker.engine.DockerConfigReader;
import de.gesellix.docker.engine.DockerEnv;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthConfigReader {
    private static final Logger log = LoggerFactory.getLogger(AuthConfigReader.class);
    private final DockerEnv env;
    private DockerConfigReader dockerConfigReader;

    public AuthConfigReader() {
        this(new DockerEnv());
    }

    public AuthConfigReader(DockerEnv env) {
        this.env = env;
        this.dockerConfigReader = env.getDockerConfigReader();
    }

    public AuthConfig readDefaultAuthConfig() {
        return this.readAuthConfig(null, this.dockerConfigReader.getDockerConfigFile());
    }

    public AuthConfig readAuthConfig(String hostname, File dockerCfg) {
        Map parsedDockerCfg;
        log.debug("read authConfig");
        if (hostname == null || hostname.trim().isEmpty()) {
            hostname = this.env.getIndexUrl_v1();
        }
        if ((parsedDockerCfg = this.dockerConfigReader.readDockerConfigFile(dockerCfg)) == null || parsedDockerCfg.isEmpty()) {
            return AuthConfig.EMPTY_AUTH_CONFIG;
        }
        CredsStore credsStore = this.getCredentialsStore(parsedDockerCfg, hostname);
        return credsStore.getAuthConfig(hostname);
    }

    public CredsStore getCredentialsStore(Map parsedDockerCfg) {
        return this.getCredentialsStore(parsedDockerCfg, "");
    }

    public CredsStore getCredentialsStore(Map parsedDockerCfg, String hostname) {
        if (parsedDockerCfg.containsKey("credHelpers") && hostname != null && !hostname.trim().isEmpty()) {
            return new NativeStore((String)((Map)parsedDockerCfg.get("credHelpers")).get(hostname));
        }
        if (parsedDockerCfg.containsKey("credsStore")) {
            return new NativeStore((String)parsedDockerCfg.get("credsStore"));
        }
        return new FileStore(parsedDockerCfg);
    }
}

