/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.builder;

import de.gesellix.docker.builder.GlobsMatcher;
import de.gesellix.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerignoreFileFilter {
    private static final Logger log = LoggerFactory.getLogger(DockerignoreFileFilter.class);
    private final GlobsMatcher globsMatcher;

    public DockerignoreFileFilter(File base) {
        this(base, Collections.emptyList());
    }

    public DockerignoreFileFilter(File base, List<String> additionalExcludes) {
        List<String> dockerignore = this.getDockerignorePatterns(base);
        dockerignore.add(".dockerignore");
        dockerignore.addAll(additionalExcludes);
        try {
            dockerignore = this.relativize(dockerignore, base);
        }
        catch (IllegalArgumentException e) {
            log.error(String.format("base: %1$s, dockerignore: %2$s", base.getAbsolutePath(), dockerignore), (Throwable)e);
            throw e;
        }
        log.debug("base: {}", (Object)base.getAbsolutePath());
        log.debug("dockerignore: {}", dockerignore);
        this.globsMatcher = new GlobsMatcher(base, dockerignore);
    }

    public List<String> getDockerignorePatterns(File base) {
        ArrayList<String> result = new ArrayList<String>();
        File[] files = base.listFiles();
        if (files == null || files.length == 0) {
            return result;
        }
        Optional<File> dockerignoreFile = Arrays.stream(files).filter(file -> {
            String relativeFileName = this.relativize(base, (File)file);
            return ".dockerignore".equals(relativeFileName);
        }).findFirst();
        if (!dockerignoreFile.isPresent()) {
            return result;
        }
        try {
            Collections.addAll(result, IOUtils.toString(new FileInputStream(dockerignoreFile.get())).split("[\r\n]+"));
            return result;
        }
        catch (IOException e) {
            log.error("Couldn't read {}", (Object)dockerignoreFile.get());
            throw new RuntimeException(e);
        }
    }

    public List<String> relativize(Collection<String> dockerignores, File base) {
        return dockerignores.stream().map(dockerignore -> new File((String)dockerignore).isAbsolute() ? this.relativize(base, new File((String)dockerignore)) : dockerignore).collect(Collectors.toList());
    }

    public String relativize(File base, File absolute) {
        Path basePath = base.getAbsoluteFile().toPath();
        Path otherPath = absolute.getAbsoluteFile().toPath();
        if (!basePath.getRoot().equals(otherPath.getRoot())) {
            return otherPath.toString();
        }
        return basePath.relativize(otherPath).toString();
    }

    public List<File> collectFiles(File base) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        Files.walk(base.toPath(), new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && !this.getGlobsMatcher().matches(p.toFile())).forEach(p -> files.add(p.toFile()));
        log.debug("filtered list of files: {}", files);
        return files;
    }

    public GlobsMatcher getGlobsMatcher() {
        return this.globsMatcher;
    }
}

