/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.context;

import com.squareup.moshi.Moshi;
import de.gesellix.docker.context.EndpointMetaBase;
import de.gesellix.docker.context.Metadata;
import java.io.File;
import java.io.FileNotFoundException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataStore {
    private static final Logger log = LoggerFactory.getLogger(MetadataStore.class);
    public static final String metadataDir = "meta";
    final String metaFile = "meta.json";
    private final Moshi moshi = new Moshi.Builder().build();
    File root;

    public MetadataStore(File root) {
        this.root = root;
    }

    public Metadata getMetadata(String contextName) {
        return this.getByID(this.getContextDir(contextName));
    }

    public Metadata getByID(String contextDirectory) {
        Map payload = this.getMetadataPayload(contextDirectory);
        Metadata metadata = new Metadata((String)payload.get("Name"));
        metadata.setMetadata(payload.get("Metadata"));
        metadata.getEndpoints().putAll((Map)payload.get("Endpoints"));
        if (metadata.getEndpoints().containsKey("docker")) {
            Map endpointMeta = (Map)metadata.getEndpoints().get("docker");
            metadata.getEndpoints().put("docker", new EndpointMetaBase((String)endpointMeta.get("Host"), false));
        }
        return metadata;
    }

    public String getContextDir(String contextName) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] hashBytes = messageDigest.digest(contextName.getBytes(StandardCharsets.UTF_8));
        BigInteger noHash = new BigInteger(1, hashBytes);
        String hashStr = noHash.toString(16);
        return hashStr;
    }

    private Map getMetadataPayload(String contextDirectory) {
        File contextMetadata = new File(new File(this.root, contextDirectory), "meta.json");
        if (!contextMetadata.exists()) {
            throw new IllegalStateException("context does not exist", new FileNotFoundException(contextMetadata.getAbsolutePath()));
        }
        try {
            return (Map)this.moshi.adapter(Map.class).fromJson(Okio.buffer((Source)Okio.source((File)contextMetadata)));
        }
        catch (Exception e) {
            log.debug(MessageFormat.format("failed to read metadata from {}", contextMetadata), (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

