/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.engine;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import java.util.function.Supplier;
import okhttp3.Response;

public class AttachConfig {
    private final boolean expectMultiplexedResponse;
    private final Streams streams;
    private final Callbacks callbacks;

    public AttachConfig() {
        this(false);
    }

    public AttachConfig(boolean expectMultiplexedResponse) {
        this.expectMultiplexedResponse = expectMultiplexedResponse;
        this.streams = new Streams();
        this.callbacks = new Callbacks();
    }

    public Streams getStreams() {
        return this.streams;
    }

    public Object onFailure(Exception e) {
        return this.callbacks.onFailure.apply(e);
    }

    public void setOnFailure(Function<Exception, ?> onFailure) {
        this.callbacks.onFailure = onFailure;
    }

    public Object onResponse(Response r) {
        return this.callbacks.onResponse.apply(r);
    }

    public void setOnResponse(Function<Response, ?> onResponse) {
        this.callbacks.onResponse = onResponse;
    }

    public Object onSinkClosed(Response r) {
        return this.callbacks.onSinkClosed.apply(r);
    }

    public void setOnSinkClosed(Function<Response, ?> onSinkClosed) {
        this.callbacks.onSinkClosed = onSinkClosed;
    }

    public Object onSinkWritten(Response r) {
        return this.callbacks.onSinkWritten.apply(r);
    }

    public void setOnSinkWritten(Function<Response, ?> onSinkWritten) {
        this.callbacks.onSinkWritten = onSinkWritten;
    }

    public Object onSourceConsumed() {
        return this.callbacks.onSourceConsumed.get();
    }

    public void setOnSourceConsumed(Supplier<?> onSourceConsumed) {
        this.callbacks.onSourceConsumed = onSourceConsumed;
    }

    public boolean isExpectMultiplexedResponse() {
        return this.expectMultiplexedResponse;
    }

    public static class Callbacks {
        private Function<Exception, ?> onFailure = e -> null;
        private Function<Response, ?> onResponse = r -> null;
        private Function<Response, ?> onSinkClosed = r -> null;
        private Function<Response, ?> onSinkWritten = r -> null;
        private Supplier<?> onSourceConsumed = () -> null;
    }

    public static class Streams {
        private InputStream stdin = null;
        private OutputStream stdout = System.out;
        private OutputStream stderr = System.err;

        public InputStream getStdin() {
            return this.stdin;
        }

        public void setStdin(InputStream stdin) {
            this.stdin = stdin;
        }

        public OutputStream getStdout() {
            return this.stdout;
        }

        public void setStdout(OutputStream stdout) {
            this.stdout = stdout;
        }

        public OutputStream getStderr() {
            return this.stderr;
        }

        public void setStderr(OutputStream stderr) {
            this.stderr = stderr;
        }
    }
}

