/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.engine;

import de.gesellix.docker.context.ContextStore;
import de.gesellix.docker.context.DockerContextResolver;
import de.gesellix.docker.context.EndpointMetaBase;
import de.gesellix.docker.engine.DockerConfigReader;
import java.io.File;

public class DockerEnv {
    private String dockerHost;
    private int defaultTlsPort = 2376;
    private String tlsVerify = System.getProperty("docker.tls.verify", System.getenv("DOCKER_TLS_VERIFY"));
    private String certPath = System.getProperty("docker.cert.path", System.getenv("DOCKER_CERT_PATH"));
    private String defaultCertPath = new File((String)System.getProperties().get("user.home"), ".docker").getAbsolutePath();
    private final String indexUrl_v1 = "https://index.docker.io/v1/";
    private final String indexUrl_v2 = "https://registry-1.docker.io";
    private DockerConfigReader dockerConfigReader;
    private DockerContextResolver dockerContextResolver;
    private String contextsDirectoryName = "contexts";
    private File dockerContextStoreDir = null;
    public static final String dockerEndpointDefaultName = "docker";
    public static final String dockerDefaultContextName = "default";
    private String apiVersion = System.getProperty("docker.api.version", System.getenv("DOCKER_API_VERSION"));
    private String tmpdir = System.getProperty("docker.tmpdir", System.getenv("DOCKER_TMPDIR"));
    private String dockerContentTrust = System.getProperty("docker.content.trust", System.getenv("DOCKER_CONTENT_TRUST"));
    private String contentTrustServer = System.getProperty("docker.content.trust.server", System.getenv("DOCKER_CONTENT_TRUST_SERVER"));
    private String officialNotaryServer = "https://notary.docker.io";

    public DockerEnv() {
        this(null);
    }

    public DockerEnv(String dockerHost) {
        this.dockerConfigReader = new DockerConfigReader();
        this.dockerContextResolver = new DockerContextResolver();
        this.resetDockerHostFromCurrentConfig(dockerHost);
    }

    @Deprecated
    void resetDockerHostFromCurrentConfig() {
        this.resetDockerHostFromCurrentConfig(null);
    }

    @Deprecated
    void resetDockerHostFromCurrentConfig(String dockerHostOverride) {
        this.dockerContextStoreDir = null;
        this.getDockerConfigReader().resetDockerConfigFile();
        this.dockerHost = dockerHostOverride == null ? this.getDockerHostFromContextOrHostOrDefault() : dockerHostOverride;
    }

    private String getDockerHostFromContextOrHostOrDefault() {
        String dockerContextName;
        ContextStore store = new ContextStore(this.getDockerContextStoreDir());
        EndpointMetaBase dockerEndpoint = this.dockerContextResolver.resolveDockerEndpoint(store, dockerContextName = this.dockerContextResolver.resolveDockerContextName(this.getDockerConfigReader()));
        if (dockerEndpoint != null && dockerEndpoint.getHost() != null) {
            return dockerEndpoint.getHost();
        }
        return DockerEnv.getDefaultDockerHost();
    }

    public static String getDockerHostFromSystemPropertyOrEnvironment() {
        String configuredDockerHost = System.getProperty("docker.host", System.getenv("DOCKER_HOST"));
        if (configuredDockerHost != null && !configuredDockerHost.isEmpty()) {
            return configuredDockerHost;
        }
        return null;
    }

    public static String getDockerContextFromSystemPropertyOrEnvironment() {
        String configuredDockerContext = System.getProperty("docker.context", System.getenv("DOCKER_CONTEXT"));
        if (configuredDockerContext != null && !configuredDockerContext.isEmpty()) {
            return configuredDockerContext;
        }
        return null;
    }

    public static String getDefaultDockerHost() {
        if (((String)System.getProperties().get("os.name")).toLowerCase().contains("windows")) {
            return "npipe:////./pipe/docker_engine";
        }
        return "unix:///var/run/docker.sock";
    }

    public File getDockerConfigFile() {
        return this.dockerConfigReader.getDockerConfigFile();
    }

    public DockerConfigReader getDockerConfigReader() {
        return this.dockerConfigReader;
    }

    public File getDockerContextStoreDir() {
        if (this.dockerContextStoreDir == null) {
            this.dockerContextStoreDir = new File(this.getDockerConfigFile().getParentFile(), this.contextsDirectoryName);
        }
        return this.dockerContextStoreDir;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    public void setDockerHost(String dockerHost) {
        this.dockerHost = dockerHost;
    }

    public int getDefaultTlsPort() {
        return this.defaultTlsPort;
    }

    public void setDefaultTlsPort(int defaultTlsPort) {
        this.defaultTlsPort = defaultTlsPort;
    }

    public String getTlsVerify() {
        return this.tlsVerify;
    }

    public void setTlsVerify(String tlsVerify) {
        this.tlsVerify = tlsVerify;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getDefaultCertPath() {
        return this.defaultCertPath;
    }

    public void setDefaultCertPath(String defaultCertPath) {
        this.defaultCertPath = defaultCertPath;
    }

    public String getIndexUrl_v1() {
        return "https://index.docker.io/v1/";
    }

    public String getIndexUrl_v2() {
        return "https://registry-1.docker.io";
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getTmpdir() {
        return this.tmpdir;
    }

    public void setTmpdir(String tmpdir) {
        this.tmpdir = tmpdir;
    }

    public String getDockerContentTrust() {
        return this.dockerContentTrust;
    }

    public void setDockerContentTrust(String dockerContentTrust) {
        this.dockerContentTrust = dockerContentTrust;
    }

    public String getContentTrustServer() {
        return this.contentTrustServer;
    }

    public void setContentTrustServer(String contentTrustServer) {
        this.contentTrustServer = contentTrustServer;
    }

    public String getOfficialNotaryServer() {
        return this.officialNotaryServer;
    }

    public void setOfficialNotaryServer(String officialNotaryServer) {
        this.officialNotaryServer = officialNotaryServer;
    }
}

