/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.hijack;

import de.gesellix.docker.engine.AttachConfig;
import de.gesellix.docker.rawstream.Frame;
import de.gesellix.docker.rawstream.FrameReader;
import java.io.IOException;
import java.net.Socket;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.connection.RealConnection;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HijackingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(HijackingInterceptor.class);
    private final AttachConfig attachConfig;
    private final Source stdin;
    private final Sink stdout;

    public HijackingInterceptor(AttachConfig attachConfig, Source stdin, Sink stdout) {
        this.attachConfig = attachConfig;
        this.stdin = stdin;
        this.stdout = stdout;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request originalRequest;
        Connection connection = chain.connection();
        if (connection == null) {
            throw new IllegalStateException("Connection is null. This one should only be used as a network interceptor, not as application interceptor.");
        }
        Sink sink = Okio.sink((Socket)connection.socket());
        Source source = Okio.source((Socket)connection.socket());
        Request modifiedRequest = originalRequest = chain.request();
        if (this.stdin != null) {
            modifiedRequest = originalRequest.newBuilder().method(originalRequest.method(), originalRequest.body()).header("transfer-encoding", "chunked").build();
        }
        if ((response = chain.proceed(modifiedRequest)).code() != 101 && !response.isSuccessful() || this.stdin == null) {
            return response;
        }
        connection.socket().setSoTimeout(0);
        ((RealConnection)connection).setNoNewExchanges(true);
        chain.call().timeout().clearTimeout().clearDeadline();
        Thread stdin2sink = new Thread(() -> {
            Buffer tmpBuffer = new Buffer();
            try (BufferedSink bufferedSink = Okio.buffer((Sink)sink);){
                long count = 0L;
                while (bufferedSink.isOpen()) {
                    long n = this.stdin.read(tmpBuffer, 1024L);
                    if (n < 0L) {
                        log.warn("finished after " + count + " bytes");
                        this.attachConfig.onSinkWritten(response);
                        break;
                    }
                    count += n;
                    bufferedSink.write(tmpBuffer, n);
                    bufferedSink.flush();
                }
            }
            catch (Exception e) {
                log.error("error", (Throwable)e);
                this.attachConfig.onFailure(e);
                throw new RuntimeException(e);
            }
            this.attachConfig.onSinkClosed(response);
        });
        stdin2sink.setName("stdin2sink-" + System.identityHashCode(originalRequest));
        stdin2sink.setUncaughtExceptionHandler((thread, exception) -> log.error("", exception));
        stdin2sink.setDaemon(true);
        stdin2sink.start();
        Thread source2stdout = new Thread(() -> {
            Buffer tmpBuffer = new Buffer();
            try (BufferedSink bufferedSink = Okio.buffer((Sink)this.stdout);){
                Object frame;
                long count = 0L;
                FrameReader frameReader = new FrameReader(source, this.attachConfig.isExpectMultiplexedResponse());
                while ((frame = frameReader.readNext((Class)Frame.class)) != null) {
                    if (frame == null || ((Frame)frame).getPayload() == null) continue;
                    count += (long)((Frame)frame).getPayload().length;
                    bufferedSink.write(((Frame)frame).getPayload());
                    bufferedSink.flush();
                }
            }
            catch (Exception e) {
                log.error("error", (Throwable)e);
                this.attachConfig.onFailure(e);
                throw new RuntimeException(e);
            }
            this.attachConfig.onSourceConsumed();
        });
        source2stdout.setName("source2stdout-" + System.identityHashCode(originalRequest));
        source2stdout.setUncaughtExceptionHandler((thread, exception) -> log.error("", exception));
        source2stdout.setDaemon(true);
        source2stdout.start();
        this.attachConfig.onResponse(response);
        return response;
    }
}

