/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.hijack;

import de.gesellix.docker.engine.AttachConfig;
import de.gesellix.docker.engine.TcpUpgradeVerificator;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkResponseCallback
implements Callback {
    private static final Logger log = LoggerFactory.getLogger(OkResponseCallback.class);
    private final AttachConfig attachConfig;

    public OkResponseCallback(AttachConfig attachConfig) {
        this.attachConfig = attachConfig;
    }

    public void onFailure(Call call, IOException e) {
        log.error("connection failed: " + e.getMessage(), (Throwable)e);
        this.attachConfig.onFailure(e);
    }

    public void onResponse(Call call, Response response) throws IOException {
        TcpUpgradeVerificator.ensureTcpUpgrade(response);
        log.debug("Response content type: " + response.header("Content-Type"));
        this.attachConfig.onResponse(response);
    }
}

