/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.rawstream;

import de.gesellix.docker.rawstream.Frame;
import de.gesellix.docker.response.Reader;
import java.io.EOFException;
import java.io.IOException;
import okio.Buffer;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameReader
implements Reader<Frame> {
    private static final Logger log = LoggerFactory.getLogger(FrameReader.class);
    private final BufferedSource bufferedSource;
    private boolean expectMultiplexedResponse;
    private final Buffer buffer = new Buffer();

    public FrameReader(Source source) {
        this(source, false);
    }

    public FrameReader(Source source, boolean expectMultiplexedResponse) {
        this.bufferedSource = Okio.buffer((Source)source);
        this.expectMultiplexedResponse = expectMultiplexedResponse;
    }

    @Override
    public Frame readNext(Class<Frame> type) {
        if (this.expectMultiplexedResponse) {
            try {
                Frame.StreamType streamType = Frame.StreamType.valueOf(this.bufferedSource.readByte());
                this.bufferedSource.skip(3L);
                int frameSize = this.bufferedSource.readInt();
                return new Frame(streamType, this.bufferedSource.readByteArray((long)frameSize));
            }
            catch (EOFException e) {
                return null;
            }
            catch (IOException e) {
                log.error("error reading multiplexed frames", (Throwable)e);
                return null;
            }
        }
        try {
            long byteCount = this.bufferedSource.read(this.buffer, 8192L);
            if (byteCount < 0L) {
                return null;
            }
            return new Frame(Frame.StreamType.RAW, this.buffer.readByteArray(byteCount));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return !Thread.currentThread().isInterrupted() && this.bufferedSource.isOpen() && !this.bufferedSource.peek().exhausted();
        }
        catch (Exception e) {
            return false;
        }
    }
}

