/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.websocket;

import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebSocketListener
extends WebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebSocketListener.class);

    public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        log.debug("[onOpen]");
    }

    public void onFailure(@NotNull WebSocket webSocket, Throwable t, Response response) {
        log.debug("[onFailure] {}", (Object)t.getMessage());
        t.printStackTrace();
    }

    public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
        log.debug("[onMessage.text] {}", (Object)text);
    }

    public void onMessage(@NotNull WebSocket webSocket, ByteString bytes) {
        log.debug("[onMessage.binary] size: {}", (Object)bytes.size());
    }

    public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        log.debug("[onClosing] {}/{}", (Object)code, (Object)reason);
    }

    public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        log.debug("[onClosed] {}/{}", (Object)code, (Object)reason);
    }
}

