/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.context;

import de.gesellix.docker.context.ContextStore;
import de.gesellix.docker.context.EndpointMetaBase;
import de.gesellix.docker.context.Metadata;
import de.gesellix.docker.engine.DockerConfigReader;
import de.gesellix.docker.engine.DockerEnv;
import java.util.Map;

public class DockerContextResolver {
    public String resolveDockerContextName(DockerConfigReader dockerConfigReader) {
        String dockerHost = DockerEnv.getDockerHostFromSystemPropertyOrEnvironment();
        String dockerContext = DockerEnv.getDockerContextFromSystemPropertyOrEnvironment();
        if (dockerContext != null) {
            return dockerContext;
        }
        if (dockerHost != null) {
            return "default";
        }
        Map configFile = dockerConfigReader.readDockerConfigFile();
        if (configFile != null && configFile.containsKey("currentContext")) {
            return (String)configFile.get("currentContext");
        }
        return "default";
    }

    public EndpointMetaBase resolveDockerEndpoint(ContextStore store, String contextName) {
        Metadata metadata = store.getMetadata(contextName);
        if (metadata == null || metadata.getEndpoints() == null || !metadata.getEndpoints().containsKey("docker")) {
            throw new IllegalStateException("cannot find docker endpoint in context " + contextName);
        }
        if (!(metadata.getEndpoints().get("docker") instanceof EndpointMetaBase)) {
            throw new IllegalStateException("endpoint docker is not of type EndpointMetaBase");
        }
        return (EndpointMetaBase)metadata.getEndpoints().get("docker");
    }
}

