/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.engine;

import com.squareup.moshi.Moshi;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerConfigReader {
    private static final Logger log = LoggerFactory.getLogger(DockerConfigReader.class);
    public File configFile = new File(System.getProperty("user.home") + "/.docker", "config.json");
    public File legacyConfigFile = new File(System.getProperty("user.home"), ".dockercfg");
    private File dockerConfigFile = null;
    private final Moshi moshi = new Moshi.Builder().build();

    @Deprecated
    public void resetDockerConfigFile() {
        this.setDockerConfigFile(null);
    }

    public void setDockerConfigFile(File dockerConfigFile) {
        this.dockerConfigFile = dockerConfigFile;
    }

    public File getDockerConfigFile() {
        if (this.dockerConfigFile == null) {
            this.dockerConfigFile = this.resolveDockerConfigFile(this.configFile, this.legacyConfigFile);
        }
        return this.dockerConfigFile;
    }

    public File resolveDockerConfigFile(File defaultConfigFile, File legacyConfigFile) {
        String dockerConfig = System.getProperty("docker.config", System.getenv("DOCKER_CONFIG"));
        if (dockerConfig != null && !dockerConfig.isEmpty()) {
            return new File(dockerConfig, "config.json");
        }
        if (defaultConfigFile.exists()) {
            return defaultConfigFile;
        }
        if (legacyConfigFile.exists()) {
            return legacyConfigFile;
        }
        log.warn("docker config file not found, assuming '{}' as fallback", (Object)defaultConfigFile);
        return defaultConfigFile;
    }

    public Map readDockerConfigFile() {
        return this.readDockerConfigFile(null);
    }

    public Map readDockerConfigFile(File dockerCfg) {
        if (dockerCfg == null) {
            dockerCfg = this.getDockerConfigFile();
        }
        if (dockerCfg == null || !dockerCfg.exists()) {
            log.info("docker config '{}' doesn't exist", (Object)dockerCfg);
            return Collections.emptyMap();
        }
        log.debug("reading config from {}", (Object)dockerCfg);
        try {
            return (Map)this.moshi.adapter(Map.class).fromJson(Okio.buffer((Source)Okio.source((File)dockerCfg)));
        }
        catch (Exception e) {
            log.debug(MessageFormat.format("failed to read config from {}", dockerCfg), (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

