/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.rawstream;

import de.gesellix.docker.rawstream.StreamType;
import java.io.EOFException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawStreamHeader {
    private static final Logger log = LoggerFactory.getLogger(RawStreamHeader.class);
    public static final RawStreamHeader EMPTY_HEADER = new RawStreamHeader();
    private StreamType streamType;
    private int frameSize;

    private RawStreamHeader() {
    }

    public RawStreamHeader(int[] header) throws IOException {
        if (header == null || header.length != 8) {
            throw new IllegalArgumentException("needs a header with a length of 8, got " + (header == null ? null : Integer.valueOf(header.length)) + ".");
        }
        this.streamType = this.readDockerStreamType(header);
        this.frameSize = this.readFrameSize(header);
    }

    public StreamType readDockerStreamType(int[] header) throws IOException {
        if (header[0] < 0) {
            throw new EOFException(String.valueOf(header[0]));
        }
        try {
            return StreamType.valueOf((byte)(header[0] & 0xFF));
        }
        catch (Exception e) {
            log.error("Invalid StreamType '" + String.valueOf((byte)(header[0] & 0xFF)) + "'");
            throw e;
        }
    }

    public int readFrameSize(int[] header) throws IOException {
        int ch1 = header[4];
        int ch2 = header[5];
        int ch3 = header[6];
        int ch4 = header[7];
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new EOFException(ch1 + " " + ch2 + " " + ch3 + " " + ch4);
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public StreamType getStreamType() {
        return this.streamType;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public String toString() {
        return "RawDockerHeader{streamType=" + (Object)((Object)this.getStreamType()) + ", frameSize=" + this.getFrameSize() + "}";
    }
}

