/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.Collections;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreUtil {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreUtil.class);
    public static final char[] KEY_STORE_PASSWORD;

    public static KeyStore createDockerKeyStore(String certPath) throws IOException, GeneralSecurityException {
        PrivateKey privKey = KeyStoreUtil.loadPrivateKey(new File(certPath, "key.pem").getAbsolutePath());
        Certificate[] certs = KeyStoreUtil.loadCertificates(new File(certPath, "cert.pem").getAbsolutePath()).toArray(new Certificate[0]);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        keyStore.setKeyEntry("docker", privKey, KEY_STORE_PASSWORD, certs);
        KeyStoreUtil.addCA(keyStore, new File(certPath, "ca.pem").getAbsolutePath());
        return keyStore;
    }

    public static PrivateKey loadPrivateKey(String keyPath) throws IOException, GeneralSecurityException {
        try (PEMParser parser = new PEMParser((Reader)new FileReader(keyPath));){
            Object parsedObject;
            while ((parsedObject = parser.readObject()) != null) {
                if (parsedObject instanceof PEMKeyPair) {
                    PEMKeyPair keyPair = (PEMKeyPair)parsedObject;
                    PrivateKey privateKey = KeyStoreUtil.generatePrivateKey(keyPair.getPrivateKeyInfo());
                    return privateKey;
                }
                if (!(parsedObject instanceof PrivateKeyInfo)) continue;
                PrivateKey privateKey = KeyStoreUtil.generatePrivateKey((PrivateKeyInfo)parsedObject);
                return privateKey;
            }
        }
        throw new GeneralSecurityException("Cannot generate private key from file: " + keyPath);
    }

    public static PrivateKey generatePrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        try {
            return new JcaPEMKeyConverter().getPrivateKey(keyInfo);
        }
        catch (Exception e) {
            if (e.getCause() instanceof InvalidKeySpecException) {
                log.error("couldn't create private key for asn1oid '" + keyInfo.getPrivateKeyAlgorithm().getAlgorithm().getId() + "'", e.getCause());
            }
            throw e;
        }
    }

    public static void addCA(KeyStore keyStore, String caPath) throws KeyStoreException, CertificateException {
        for (Certificate certificate : KeyStoreUtil.loadCertificates(caPath)) {
            X509Certificate crt = (X509Certificate)certificate;
            String alias = crt.getSubjectX500Principal().getName();
            keyStore.setCertificateEntry(alias, crt);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<? extends Certificate> loadCertificates(String certPath) throws CertificateException {
        try (FileInputStream is = new FileInputStream(certPath);){
            Collection<? extends Certificate> collection = CertificateFactory.getInstance("X509").generateCertificates(is);
            return collection;
        }
        catch (IOException ignored) {
            return Collections.emptyList();
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        KEY_STORE_PASSWORD = "docker".toCharArray();
    }
}

