/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.filesocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

class AsynchronousFileByteChannel
implements AsynchronousByteChannel {
    private final AsynchronousFileChannel fileChannel;

    AsynchronousFileByteChannel(AsynchronousFileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    @Override
    public <A> void read(ByteBuffer dst, A attachment, final CompletionHandler<Integer, ? super A> handler) {
        this.fileChannel.read(dst, 0L, attachment, new CompletionHandler<Integer, A>(){

            @Override
            public void completed(Integer read, A attachment) {
                handler.completed(read > 0 ? read : -1, attachment);
            }

            @Override
            public void failed(Throwable exc, A attachment) {
                if (exc instanceof AsynchronousCloseException) {
                    handler.completed(-1, attachment);
                    return;
                }
                handler.failed(exc, attachment);
            }
        });
    }

    @Override
    public Future<Integer> read(ByteBuffer dst) {
        CompletableFutureHandler future = new CompletableFutureHandler();
        this.fileChannel.read(dst, 0L, null, future);
        return future;
    }

    @Override
    public <A> void write(ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.fileChannel.write(src, 0L, attachment, handler);
    }

    @Override
    public Future<Integer> write(ByteBuffer src) {
        return this.fileChannel.write(src, 0L);
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }

    @Override
    public boolean isOpen() {
        return this.fileChannel.isOpen();
    }

    private static class CompletableFutureHandler
    extends CompletableFuture<Integer>
    implements CompletionHandler<Integer, Object> {
        private CompletableFutureHandler() {
        }

        @Override
        public void completed(Integer read, Object attachment) {
            this.complete(read > 0 ? read : -1);
        }

        @Override
        public void failed(Throwable exc, Object attachment) {
            if (exc instanceof AsynchronousCloseException) {
                this.complete(-1);
                return;
            }
            this.completeExceptionally(exc);
        }
    }
}

