/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.filesocket;

import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import de.gesellix.docker.client.filesocket.ExtendedKernel32;
import de.gesellix.docker.client.filesocket.FileSocket;
import de.gesellix.docker.client.filesocket.NamedPipeSink;
import de.gesellix.docker.client.filesocket.NamedPipeSource;
import de.gesellix.docker.client.filesocket.NamedPipeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedPipeJniSocket
extends FileSocket {
    private static final Logger log = LoggerFactory.getLogger(NamedPipeJniSocket.class);
    private WinNT.HANDLE handle;
    private boolean connected = false;
    private boolean closed = false;
    private BufferedSource source;
    private BufferedSink sink;
    private final Timeout ioTimeout = new Timeout().timeout(1000L, TimeUnit.MILLISECONDS);

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Expected endpoint to be a InetSocketAddress");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)endpoint;
        InetAddress address = inetSocketAddress.getAddress();
        String socketPath = this.decodeHostname(address);
        this.connect(socketPath);
    }

    void connect(String socketPath) {
        socketPath = socketPath.replace("/", "\\");
        log.debug("connect via '{}'...", (Object)socketPath);
        this.handle = NamedPipeUtils.connect(socketPath, 10000, 500, 50);
        this.connected = true;
        this.source = Okio.buffer((Source)new NamedPipeSource(this.handle, this.ioTimeout));
        this.sink = Okio.buffer((Sink)new NamedPipeSink(this.handle, this.ioTimeout));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.ensureOpen();
        return this.source.inputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.ensureOpen();
        return this.sink.outputStream();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        log.debug("closing handle {}...", (Object)this.handle);
        try {
            if (this.handle != null && !WinBase.INVALID_HANDLE_VALUE.equals((Object)this.handle)) {
                ExtendedKernel32.INSTANCE.CancelIoEx(this.handle, null);
            }
            if (this.source != null) {
                log.debug("closing source {}...", (Object)this.source);
                this.source.close();
            }
            if (this.sink != null) {
                log.debug("closing sink {}...", (Object)this.sink);
                this.sink.close();
            }
        }
        finally {
            if (this.handle != null) {
                NamedPipeUtils.closeHandle(this.handle);
            }
            this.closed = true;
            this.connected = false;
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("NamedPipeSocket is closed");
        }
        if (!this.connected) {
            throw new IOException("NamedPipeSocket is not connected");
        }
    }
}

