/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.filesocket;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import de.gesellix.docker.client.filesocket.NamedPipeUtils;
import java.io.IOException;
import okio.Buffer;
import okio.Sink;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

public class NamedPipeSink
implements Sink {
    private final WinNT.HANDLE handle;
    private final int timeoutMillis;

    public NamedPipeSink(WinNT.HANDLE handle, Timeout timeout) {
        this.handle = handle;
        this.timeoutMillis = (int)timeout.timeoutNanos() / 1000;
    }

    public void write(@NotNull Buffer source, long byteCount) throws IOException {
        IntByReference bytesWritten;
        if (byteCount < 0L) {
            throw new IllegalArgumentException("Invalid buffer size: " + byteCount);
        }
        if (byteCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Can only write max 2147483647 bytes");
        }
        if (byteCount == 0L) {
            return;
        }
        byte[] data = source.readByteArray(byteCount);
        boolean ok = NamedPipeUtils.writeOverlapped(this.handle, data, data.length, bytesWritten = new IntByReference(), this.timeoutMillis);
        if (!ok) {
            int err = Kernel32.INSTANCE.GetLastError();
            if (err == 995) {
                return;
            }
            throw new IOException("Failed to write to Named Pipe. WinError=" + err);
        }
        if (bytesWritten.getValue() <= 0) {
            throw new IOException("No bytes written to Named Pipe");
        }
    }

    public void flush() {
    }

    @NotNull
    public Timeout timeout() {
        return Timeout.NONE;
    }

    public void close() {
    }
}

