/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.filesocket;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import de.gesellix.docker.client.filesocket.NamedPipeUtils;
import okio.Buffer;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

public class NamedPipeSource
implements Source {
    private final WinNT.HANDLE handle;
    private final int timeoutMillis;

    public NamedPipeSource(WinNT.HANDLE handle, Timeout timeout) {
        this.handle = handle;
        this.timeoutMillis = (int)(timeout.timeoutNanos() / 1000000L);
    }

    public long read(@NotNull Buffer sink, long byteCount) {
        if (byteCount < 0L) {
            throw new IllegalArgumentException("Invalid buffer size: " + byteCount);
        }
        if (byteCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Can only read max 2147483647 bytes");
        }
        if (byteCount == 0L) {
            return 0L;
        }
        byte[] data = new byte[(int)byteCount];
        IntByReference bytesRead = new IntByReference();
        boolean ok = NamedPipeUtils.readOverlapped(this.handle, data, bytesRead, this.timeoutMillis);
        if (!ok) {
            int err = Kernel32.INSTANCE.GetLastError();
            if (err == 995) {
                return -1L;
            }
            return err == 0 ? 0L : -1L;
        }
        if (bytesRead.getValue() <= 0) {
            return -1L;
        }
        sink.write(data, 0, bytesRead.getValue());
        sink.flush();
        return bytesRead.getValue();
    }

    @NotNull
    public Timeout timeout() {
        return Timeout.NONE;
    }

    public void close() {
    }
}

