/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.filesocket;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import de.gesellix.docker.client.filesocket.ExtendedKernel32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamedPipeUtils {
    private static final Logger log = LoggerFactory.getLogger(NamedPipeUtils.class);

    private NamedPipeUtils() {
    }

    public static WinNT.HANDLE connect(String path, int totalTimeoutMs, int busyWaitCapMs, int notFoundBaseSleepMs) {
        int err;
        long deadline = System.nanoTime() + (long)totalTimeoutMs * 1000000L;
        int notFoundBackoff = notFoundBaseSleepMs;
        while (true) {
            WinNT.HANDLE h;
            if (!WinBase.INVALID_HANDLE_VALUE.equals((Object)(h = Kernel32.INSTANCE.CreateFile(path, -1073741824, 0, null, 3, 0x40000000, null)))) {
                log.debug("connected");
                return h;
            }
            err = Kernel32.INSTANCE.GetLastError();
            long remainingMs = Math.max(0L, (deadline - System.nanoTime()) / 1000000L);
            if (remainingMs == 0L) {
                log.debug("Connect timed out; last error=" + err);
                throw new RuntimeException("Connect timed out; last error=" + err);
            }
            if (err == 231) {
                log.debug("Pipe busy; last error=" + err);
                int to = (int)Math.min(remainingMs, (long)busyWaitCapMs);
                boolean ok = Kernel32.INSTANCE.WaitNamedPipe(path, to);
                if (ok) continue;
                int e2 = Kernel32.INSTANCE.GetLastError();
                if (e2 == 121 && deadline - System.nanoTime() > 0L) {
                    log.debug("Retry wait; last error=" + err);
                    continue;
                }
                throw new RuntimeException("WaitNamedPipe failed: " + e2);
            }
            if (err != 2) break;
            log.debug("File not found; last error=" + err);
            int sleepMs = Math.min(notFoundBackoff, (int)remainingMs);
            try {
                Thread.sleep(sleepMs);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while waiting for pipe", ie);
            }
            notFoundBackoff = Math.min(notFoundBackoff * 2, 250);
        }
        throw new RuntimeException("CreateFile failed: " + err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readOverlapped(WinNT.HANDLE handle, byte[] buf, IntByReference bytesRead, int timeoutMillis) {
        WinNT.HANDLE evt = Kernel32.INSTANCE.CreateEvent(null, false, false, null);
        if (evt == null || WinBase.INVALID_HANDLE_VALUE.equals((Object)evt)) {
            throw new RuntimeException("CreateEvent failed: " + Kernel32.INSTANCE.GetLastError());
        }
        WinBase.OVERLAPPED overlapped = new WinBase.OVERLAPPED();
        overlapped.hEvent = evt;
        overlapped.write();
        try {
            boolean bl;
            int err;
            boolean ok = Kernel32.INSTANCE.ReadFile(handle, buf, buf.length, null, overlapped);
            if (!ok) {
                err = Kernel32.INSTANCE.GetLastError();
                if (err != 997) {
                    log.debug("IO pending; last error=" + err);
                    boolean bl2 = false;
                    return bl2;
                }
                int wait = Kernel32.INSTANCE.WaitForSingleObject(evt, timeoutMillis);
                if (wait != 0) {
                    log.debug("File not found; last error=" + err);
                    ExtendedKernel32.INSTANCE.CancelIoEx(handle, overlapped.getPointer());
                    boolean bl3 = false;
                    return bl3;
                }
            }
            if (!ExtendedKernel32.INSTANCE.GetOverlappedResult(handle, overlapped, bytesRead, false)) {
                err = Kernel32.INSTANCE.GetLastError();
                log.debug("Failed to get overlapped result; last error=" + err);
                bl = false;
                return bl;
            }
            int n = bytesRead.getValue();
            log.debug("Bytes read: {}", (Object)bytesRead.getValue());
            bl = n >= 0;
            return bl;
        }
        finally {
            NamedPipeUtils.closeHandle(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeOverlapped(WinNT.HANDLE handle, byte[] buf, int len, IntByReference bytesWritten, int timeoutMs) {
        if (len < 0 || len > buf.length) {
            throw new IllegalArgumentException("len out of range");
        }
        if (len == 0) {
            return true;
        }
        long deadline = System.nanoTime() + (long)timeoutMs * 1000000L;
        int totalWritten = 0;
        while (totalWritten < len) {
            long remainingMs = (deadline - System.nanoTime()) / 1000000L;
            if (remainingMs <= 0L) {
                throw new RuntimeException("writeOverlapped: overall timeout; written=" + totalWritten + "/" + len);
            }
            WinNT.HANDLE evt = Kernel32.INSTANCE.CreateEvent(null, false, false, null);
            if (evt == null || WinBase.INVALID_HANDLE_VALUE.equals((Object)evt)) {
                throw new RuntimeException("CreateEvent failed: " + Kernel32.INSTANCE.GetLastError());
            }
            WinBase.OVERLAPPED ol = new WinBase.OVERLAPPED();
            ol.hEvent = evt;
            ol.write();
            try {
                boolean ok = Kernel32.INSTANCE.WriteFile(handle, buf, len, null, ol);
                if (!ok) {
                    int err = Kernel32.INSTANCE.GetLastError();
                    if (err != 997) {
                        if (err == 232 || err == 109) {
                            throw new RuntimeException("writeOverlapped: pipe closed by peer");
                        }
                        throw new RuntimeException("WriteFile failed: " + err);
                    }
                    int wait = Kernel32.INSTANCE.WaitForSingleObject(evt, (int)Math.min(Integer.MAX_VALUE, remainingMs));
                    if (wait != 0) {
                        ExtendedKernel32.INSTANCE.CancelIoEx(handle, ol.getPointer());
                        throw new RuntimeException("writeOverlapped: wait failed/timeout (Wait=" + wait + ")");
                    }
                }
                if (!ExtendedKernel32.INSTANCE.GetOverlappedResult(handle, ol, bytesWritten, false)) {
                    int e2 = Kernel32.INSTANCE.GetLastError();
                    if (e2 == 995) {
                        throw new RuntimeException("writeOverlapped: operation aborted");
                    }
                    throw new RuntimeException("GetOverlappedResult(write) failed: " + e2);
                }
                int n = bytesWritten.getValue();
                if (n < 0) {
                    throw new RuntimeException("writeOverlapped: negative bytesWritten? " + n);
                }
                if (n == 0) {
                    throw new RuntimeException("writeOverlapped: wrote 0 bytes, likely peer closed");
                }
                totalWritten += n;
            }
            finally {
                NamedPipeUtils.closeHandle(evt);
            }
        }
        return true;
    }

    public static boolean readToBuffer(WinNT.HANDLE handle, byte[] buf, IntByReference bytesRead) {
        return Kernel32.INSTANCE.ReadFile(handle, buf, buf.length, bytesRead, null);
    }

    public static boolean writeFromBuffer(WinNT.HANDLE handle, byte[] buf, int len, IntByReference written) {
        return Kernel32.INSTANCE.WriteFile(handle, buf, len, written, null);
    }

    public static void closeHandle(WinNT.HANDLE handle) {
        if (handle != null && !WinBase.INVALID_HANDLE_VALUE.equals((Object)handle)) {
            Kernel32.INSTANCE.CloseHandle(handle);
        }
    }
}

