/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.remote.api.client;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import de.gesellix.docker.engine.DockerClientConfig;
import de.gesellix.docker.engine.EngineRequest;
import de.gesellix.docker.engine.RequestMethod;
import de.gesellix.docker.remote.api.Config;
import de.gesellix.docker.remote.api.ConfigCreateRequest;
import de.gesellix.docker.remote.api.ConfigSpec;
import de.gesellix.docker.remote.api.IdResponse;
import de.gesellix.docker.remote.api.core.ApiClient;
import de.gesellix.docker.remote.api.core.ApiInfrastructureResponse;
import de.gesellix.docker.remote.api.core.ClientError;
import de.gesellix.docker.remote.api.core.ClientException;
import de.gesellix.docker.remote.api.core.Informational;
import de.gesellix.docker.remote.api.core.Redirection;
import de.gesellix.docker.remote.api.core.RequestConfig;
import de.gesellix.docker.remote.api.core.ResponseConsumerKt;
import de.gesellix.docker.remote.api.core.ResponseExtensionsKt;
import de.gesellix.docker.remote.api.core.ResponseType;
import de.gesellix.docker.remote.api.core.Serializer;
import de.gesellix.docker.remote.api.core.ServerError;
import de.gesellix.docker.remote.api.core.ServerException;
import de.gesellix.docker.remote.api.core.Success;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0013\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u001a\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012J \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001eJ \u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001e\u00a8\u0006!"}, d2={"Lde/gesellix/docker/remote/api/client/ConfigApi;", "Lde/gesellix/docker/remote/api/core/ApiClient;", "dockerClientConfig", "Lde/gesellix/docker/engine/DockerClientConfig;", "proxy", "Ljava/net/Proxy;", "<init>", "(Lde/gesellix/docker/engine/DockerClientConfig;Ljava/net/Proxy;)V", "(Lde/gesellix/docker/engine/DockerClientConfig;)V", "configCreate", "Lde/gesellix/docker/remote/api/IdResponse;", "body", "Lde/gesellix/docker/remote/api/ConfigCreateRequest;", "configCreateRequestConfig", "Lde/gesellix/docker/remote/api/core/RequestConfig;", "configDelete", "", "id", "", "configDeleteRequestConfig", "configInspect", "Lde/gesellix/docker/remote/api/Config;", "configInspectRequestConfig", "configList", "", "filters", "configListRequestConfig", "configUpdate", "version", "", "Lde/gesellix/docker/remote/api/ConfigSpec;", "configUpdateRequestConfig", "Companion", "api-client"})
@SourceDebugExtension(value={"SMAP\nConfigApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigApi.kt\nde/gesellix/docker/remote/api/client/ConfigApi\n+ 2 ApiClient.kt\nde/gesellix/docker/remote/api/core/ApiClient\n+ 3 ResponseConsumer.kt\nde/gesellix/docker/remote/api/core/ResponseConsumerKt\n*L\n1#1,316:1\n118#2,8:317\n236#2,16:325\n90#2,16:341\n106#2:359\n108#2,6:364\n252#2,14:370\n118#2,8:384\n236#2,16:392\n90#2,16:408\n106#2:426\n108#2,6:431\n252#2,14:437\n118#2,8:451\n236#2,16:459\n90#2,16:475\n106#2:493\n108#2,6:498\n252#2,14:504\n118#2,8:518\n236#2,16:526\n90#2,16:542\n106#2:560\n108#2,6:565\n252#2,14:571\n118#2,8:585\n236#2,16:593\n90#2,16:609\n106#2:627\n108#2,6:632\n252#2,14:638\n86#3,2:357\n91#3,4:360\n86#3,2:424\n91#3,4:427\n86#3,2:491\n91#3,4:494\n86#3,2:558\n91#3,4:561\n86#3,2:625\n91#3,4:628\n*S KotlinDebug\n*F\n+ 1 ConfigApi.kt\nde/gesellix/docker/remote/api/client/ConfigApi\n*L\n56#1:317,8\n56#1:325,16\n56#1:341,16\n56#1:359\n56#1:364,6\n56#1:370,14\n108#1:384,8\n108#1:392,16\n108#1:408,16\n108#1:426\n108#1:431,6\n108#1:437,14\n160#1:451,8\n160#1:459,16\n160#1:475,16\n160#1:493\n160#1:498,6\n160#1:504,14\n212#1:518,8\n212#1:526,16\n212#1:542,16\n212#1:560\n212#1:565,6\n212#1:571,14\n272#1:585,8\n272#1:593,16\n272#1:609,16\n272#1:627\n272#1:632,6\n272#1:638,14\n56#1:357,2\n56#1:360,4\n108#1:424,2\n108#1:427,4\n160#1:491,2\n160#1:494,4\n212#1:558,2\n212#1:561,4\n272#1:625,2\n272#1:628,4\n*E\n"})
public final class ConfigApi
extends ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<DockerClientConfig> defaultClientConfig$delegate = LazyKt.lazy(ConfigApi::defaultClientConfig_delegate$lambda$2);

    public ConfigApi(@NotNull DockerClientConfig dockerClientConfig, @Nullable Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)dockerClientConfig, (String)"dockerClientConfig");
        super(dockerClientConfig, proxy);
    }

    public /* synthetic */ ConfigApi(DockerClientConfig dockerClientConfig, Proxy proxy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dockerClientConfig = Companion.getDefaultClientConfig();
        }
        this(dockerClientConfig, proxy);
    }

    public ConfigApi(@NotNull DockerClientConfig dockerClientConfig) {
        Intrinsics.checkNotNullParameter((Object)dockerClientConfig, (String)"dockerClientConfig");
        this(dockerClientConfig, null);
    }

    public /* synthetic */ ConfigApi(DockerClientConfig dockerClientConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dockerClientConfig = Companion.getDefaultClientConfig();
        }
        this(dockerClientConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IdResponse configCreate(@Nullable ConfigCreateRequest body) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        RequestConfig localVariableConfig = this.configCreateRequestConfig(body);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(IdResponse.class, InputStream.class)) {
                object = (IdResponse)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(IdResponse.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)IdResponse.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (IdResponse)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<IdResponse>((IdResponse)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.IdResponse");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (IdResponse)t;
    }

    @NotNull
    public final RequestConfig configCreateRequestConfig(@Nullable ConfigCreateRequest body) {
        ConfigCreateRequest localVariableBody = body;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        return new RequestConfig(requestMethod, "/configs/create", localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void configDelete(@NotNull String id) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.configDeleteRequestConfig(id);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig configDeleteRequestConfig(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.DELETE;
        String string = StringsKt.replace$default((String)"/configs/{id}", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Config configInspect(@NotNull String id) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.configInspectRequestConfig(id);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Config.class, InputStream.class)) {
                object = (Config)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Config.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Config.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (Config)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Config>((Config)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.Config");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (Config)t;
    }

    @NotNull
    public final RequestConfig configInspectRequestConfig(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/configs/{id}", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Config> configList(@Nullable String filters) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        RequestConfig localVariableConfig = this.configListRequestConfig(filters);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(List.class, InputStream.class)) {
                object = (List)((Object)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv));
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(List.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)List.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (List)((Object)body$iv$iv$iv.string());
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<List>((List)object, response$iv$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.collections.List<de.gesellix.docker.remote.api.Config>");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (List)t;
    }

    @NotNull
    public final RequestConfig configListRequestConfig(@Nullable String filters) {
        Map map;
        Object localVariableBody = null;
        Map $this$configListRequestConfig_u24lambda_u240 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (filters != null) {
            $this$configListRequestConfig_u24lambda_u240.put("filters", CollectionsKt.listOf((Object)filters.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        Class<Config> clazz = Config.class;
        return new RequestConfig(requestMethod, "/configs", localVariableHeaders, localVariableQuery, localVariableBody, (Type)((Object)clazz));
    }

    /*
     * WARNING - void declaration
     */
    public final void configUpdate(@NotNull String id, long version, @Nullable ConfigSpec body) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.configUpdateRequestConfig(id, version, body);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var18_18 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig configUpdateRequestConfig(@NotNull String id, long version, @Nullable ConfigSpec body) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ConfigSpec localVariableBody = body;
        Map $this$configUpdateRequestConfig_u24lambda_u241 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        $this$configUpdateRequestConfig_u24lambda_u241.put("version", CollectionsKt.listOf((Object)String.valueOf(version)));
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/configs/{id}/update", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    private static final DockerClientConfig defaultClientConfig_delegate$lambda$2() {
        return new DockerClientConfig();
    }

    @NotNull
    public static final DockerClientConfig getDefaultClientConfig() {
        return Companion.getDefaultClientConfig();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u00020\u00058FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lde/gesellix/docker/remote/api/client/ConfigApi$Companion;", "", "<init>", "()V", "defaultClientConfig", "Lde/gesellix/docker/engine/DockerClientConfig;", "getDefaultClientConfig$annotations", "getDefaultClientConfig", "()Lde/gesellix/docker/engine/DockerClientConfig;", "defaultClientConfig$delegate", "Lkotlin/Lazy;", "api-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DockerClientConfig getDefaultClientConfig() {
            Lazy lazy = defaultClientConfig$delegate;
            return (DockerClientConfig)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultClientConfig$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseType.values().length];
            try {
                nArray[ResponseType.Success.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Informational.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Redirection.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ClientError.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ServerError.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

