/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.remote.api.client;

import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import de.gesellix.docker.engine.DockerClientConfig;
import de.gesellix.docker.engine.EngineRequest;
import de.gesellix.docker.engine.RequestMethod;
import de.gesellix.docker.remote.api.ContainerCreateRequest;
import de.gesellix.docker.remote.api.ContainerCreateResponse;
import de.gesellix.docker.remote.api.ContainerInspectResponse;
import de.gesellix.docker.remote.api.ContainerPruneResponse;
import de.gesellix.docker.remote.api.ContainerSummary;
import de.gesellix.docker.remote.api.ContainerTopResponse;
import de.gesellix.docker.remote.api.ContainerUpdateRequest;
import de.gesellix.docker.remote.api.ContainerUpdateResponse;
import de.gesellix.docker.remote.api.ContainerWaitResponse;
import de.gesellix.docker.remote.api.FilesystemChange;
import de.gesellix.docker.remote.api.core.ApiClient;
import de.gesellix.docker.remote.api.core.ApiInfrastructureResponse;
import de.gesellix.docker.remote.api.core.Cancellable;
import de.gesellix.docker.remote.api.core.ClientError;
import de.gesellix.docker.remote.api.core.ClientException;
import de.gesellix.docker.remote.api.core.Frame;
import de.gesellix.docker.remote.api.core.Informational;
import de.gesellix.docker.remote.api.core.Redirection;
import de.gesellix.docker.remote.api.core.RequestConfig;
import de.gesellix.docker.remote.api.core.ResponseConsumerKt;
import de.gesellix.docker.remote.api.core.ResponseExtensionsKt;
import de.gesellix.docker.remote.api.core.ResponseType;
import de.gesellix.docker.remote.api.core.Serializer;
import de.gesellix.docker.remote.api.core.ServerError;
import de.gesellix.docker.remote.api.core.ServerException;
import de.gesellix.docker.remote.api.core.StreamCallback;
import de.gesellix.docker.remote.api.core.Success;
import de.gesellix.docker.remote.api.core.SuccessStream;
import de.gesellix.docker.response.JsonChunksReader;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u0085\u00012\u00020\u0001:\u0004\u0085\u0001\u0086\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0013\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJe\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!JO\u0010\"\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010#JO\u0010$\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010%JO\u0010&\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010#J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010*\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\fH\u0007J\u0018\u00100\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\fJ1\u00101\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\u00102\u001a\u0004\u0018\u00010\u00172\b\u00103\u001a\u0004\u0018\u00010\u00172\b\u00104\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u00105J1\u00106\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u00102\u001a\u0004\u0018\u00010\u00172\b\u00103\u001a\u0004\u0018\u00010\u00172\b\u00104\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u00107J\u000e\u00108\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u00109\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u001d\u0010:\u001a\u00020;2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010<\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010=J\u001d\u0010>\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010<\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010?J\u0018\u0010@\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\u0010A\u001a\u0004\u0018\u00010\fJ\u0018\u0010B\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010A\u001a\u0004\u0018\u00010\fJ9\u0010C\u001a\b\u0012\u0004\u0012\u00020D0(2\b\u0010E\u001a\u0004\u0018\u00010\u00172\b\u0010F\u001a\u0004\u0018\u00010G2\b\u0010<\u001a\u0004\u0018\u00010\u00172\b\u0010H\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010IJ3\u0010J\u001a\u00020\u000f2\b\u0010E\u001a\u0004\u0018\u00010\u00172\b\u0010F\u001a\u0004\u0018\u00010G2\b\u0010<\u001a\u0004\u0018\u00010\u00172\b\u0010H\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010KJo\u0010L\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\u0010M\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u00172\b\u0010N\u001a\u0004\u0018\u00010G2\b\u0010O\u001a\u0004\u0018\u00010G2\b\u0010P\u001a\u0004\u0018\u00010\u00172\b\u0010Q\u001a\u0004\u0018\u00010\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010RJY\u0010S\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010M\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u00172\b\u0010N\u001a\u0004\u0018\u00010G2\b\u0010O\u001a\u0004\u0018\u00010G2\b\u0010P\u001a\u0004\u0018\u00010\u00172\b\u0010Q\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010TJ\u000e\u0010U\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010V\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010W\u001a\u00020X2\b\u0010H\u001a\u0004\u0018\u00010\fJ\u0010\u0010Y\u001a\u00020\u000f2\b\u0010H\u001a\u0004\u0018\u00010\fJ\u0016\u0010Z\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\fJ\u0016\u0010[\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\fJ'\u0010\\\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\u0010]\u001a\u0004\u0018\u00010G2\b\u0010^\u001a\u0004\u0018\u00010G\u00a2\u0006\u0002\u0010_J'\u0010`\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010]\u001a\u0004\u0018\u00010G2\b\u0010^\u001a\u0004\u0018\u00010G\u00a2\u0006\u0002\u0010aJ\u001d\u0010b\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\u0010c\u001a\u0004\u0018\u00010G\u00a2\u0006\u0002\u0010dJ\u001d\u0010e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010c\u001a\u0004\u0018\u00010G\u00a2\u0006\u0002\u0010fJ\u0018\u0010g\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\fJ\u0018\u0010h\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\fJ?\u0010i\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010j\u001a\u0004\u0018\u00010\u00172\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u001d2\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010kJ'\u0010l\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010j\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010mJ\u001d\u0010n\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\u0010c\u001a\u0004\u0018\u00010G\u00a2\u0006\u0002\u0010dJ\u001d\u0010o\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010c\u001a\u0004\u0018\u00010G\u00a2\u0006\u0002\u0010fJ\u0018\u0010p\u001a\u00020q2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010r\u001a\u0004\u0018\u00010\fJ\u0018\u0010s\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010r\u001a\u0004\u0018\u00010\fJ\u000e\u0010t\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010u\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010v\u001a\u00020w2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010x\u001a\u00020yJ\u0016\u0010z\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010x\u001a\u00020yJ\u0018\u0010{\u001a\u00020|2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010}\u001a\u0004\u0018\u00010\fJ\u001c\u0010{\u001a\u00020|2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010}\u001a\u0004\u0018\u00010~H\u0007J\u0018\u0010\u007f\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010}\u001a\u0004\u0018\u00010~J6\u0010\u0080\u0001\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0007\u0010\u0081\u0001\u001a\u00020\n2\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010\f2\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\fJ6\u0010\u0084\u0001\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0007\u0010\u0081\u0001\u001a\u00020\n2\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010\f2\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\f\u00a8\u0006\u0087\u0001"}, d2={"Lde/gesellix/docker/remote/api/client/ContainerApi;", "Lde/gesellix/docker/remote/api/core/ApiClient;", "dockerClientConfig", "Lde/gesellix/docker/engine/DockerClientConfig;", "proxy", "Ljava/net/Proxy;", "<init>", "(Lde/gesellix/docker/engine/DockerClientConfig;Ljava/net/Proxy;)V", "(Lde/gesellix/docker/engine/DockerClientConfig;)V", "containerArchive", "Ljava/io/InputStream;", "id", "", "path", "containerArchiveRequestConfig", "Lde/gesellix/docker/remote/api/core/RequestConfig;", "containerArchiveInfo", "", "containerArchiveInfoRequestConfig", "containerAttach", "", "detachKeys", "logs", "", "stream", "stdin", "stdout", "stderr", "callback", "Lde/gesellix/docker/remote/api/core/StreamCallback;", "Lde/gesellix/docker/remote/api/core/Frame;", "timeoutMillis", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Lde/gesellix/docker/remote/api/core/StreamCallback;J)V", "containerAttachRequestConfig", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lde/gesellix/docker/remote/api/core/RequestConfig;", "containerAttachWebsocket", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "containerAttachWebsocketRequestConfig", "containerChanges", "", "Lde/gesellix/docker/remote/api/FilesystemChange;", "containerChangesRequestConfig", "containerCreate", "Lde/gesellix/docker/remote/api/ContainerCreateResponse;", "body", "Lde/gesellix/docker/remote/api/ContainerCreateRequest;", "name", "containerCreateRequestConfig", "containerDelete", "v", "force", "link", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "containerDeleteRequestConfig", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lde/gesellix/docker/remote/api/core/RequestConfig;", "containerExport", "containerExportRequestConfig", "containerInspect", "Lde/gesellix/docker/remote/api/ContainerInspectResponse;", "size", "(Ljava/lang/String;Ljava/lang/Boolean;)Lde/gesellix/docker/remote/api/ContainerInspectResponse;", "containerInspectRequestConfig", "(Ljava/lang/String;Ljava/lang/Boolean;)Lde/gesellix/docker/remote/api/core/RequestConfig;", "containerKill", "signal", "containerKillRequestConfig", "containerList", "Lde/gesellix/docker/remote/api/ContainerSummary;", "all", "limit", "", "filters", "(Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/String;)Ljava/util/List;", "containerListRequestConfig", "(Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/String;)Lde/gesellix/docker/remote/api/core/RequestConfig;", "containerLogs", "follow", "since", "until", "timestamps", "tail", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/String;Lde/gesellix/docker/remote/api/core/StreamCallback;J)V", "containerLogsRequestConfig", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/String;)Lde/gesellix/docker/remote/api/core/RequestConfig;", "containerPause", "containerPauseRequestConfig", "containerPrune", "Lde/gesellix/docker/remote/api/ContainerPruneResponse;", "containerPruneRequestConfig", "containerRename", "containerRenameRequestConfig", "containerResize", "h", "w", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)V", "containerResizeRequestConfig", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Lde/gesellix/docker/remote/api/core/RequestConfig;", "containerRestart", "t", "(Ljava/lang/String;Ljava/lang/Integer;)V", "containerRestartRequestConfig", "(Ljava/lang/String;Ljava/lang/Integer;)Lde/gesellix/docker/remote/api/core/RequestConfig;", "containerStart", "containerStartRequestConfig", "containerStats", "oneShot", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Lde/gesellix/docker/remote/api/core/StreamCallback;J)Ljava/lang/Object;", "containerStatsRequestConfig", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lde/gesellix/docker/remote/api/core/RequestConfig;", "containerStop", "containerStopRequestConfig", "containerTop", "Lde/gesellix/docker/remote/api/ContainerTopResponse;", "psArgs", "containerTopRequestConfig", "containerUnpause", "containerUnpauseRequestConfig", "containerUpdate", "Lde/gesellix/docker/remote/api/ContainerUpdateResponse;", "update", "Lde/gesellix/docker/remote/api/ContainerUpdateRequest;", "containerUpdateRequestConfig", "containerWait", "Lde/gesellix/docker/remote/api/ContainerWaitResponse;", "condition", "Lde/gesellix/docker/remote/api/client/ContainerApi$ConditionContainerWait;", "containerWaitRequestConfig", "putContainerArchive", "inputStream", "noOverwriteDirNonDir", "copyUIDGID", "putContainerArchiveRequestConfig", "Companion", "ConditionContainerWait", "api-client"})
@SourceDebugExtension(value={"SMAP\nContainerApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContainerApi.kt\nde/gesellix/docker/remote/api/client/ContainerApi\n+ 2 ApiClient.kt\nde/gesellix/docker/remote/api/core/ApiClient\n+ 3 ResponseConsumer.kt\nde/gesellix/docker/remote/api/core/ResponseConsumerKt\n*L\n1#1,1753:1\n118#2,8:1754\n236#2,16:1762\n90#2,16:1778\n106#2:1796\n108#2,6:1801\n252#2,14:1807\n118#2,8:1821\n236#2,16:1829\n90#2,16:1845\n106#2:1863\n108#2,6:1868\n252#2,14:1874\n118#2,8:1888\n236#2,16:1896\n90#2,16:1912\n106#2:1930\n108#2,6:1935\n252#2,14:1941\n118#2,8:1955\n236#2,16:1963\n90#2,16:1979\n106#2:1997\n108#2,6:2002\n252#2,14:2008\n118#2,8:2022\n236#2,16:2030\n90#2,16:2046\n106#2:2064\n108#2,6:2069\n252#2,14:2075\n118#2,8:2089\n236#2,16:2097\n90#2,16:2113\n106#2:2131\n108#2,6:2136\n252#2,14:2142\n118#2,8:2156\n236#2,16:2164\n90#2,16:2180\n106#2:2198\n108#2,6:2203\n252#2,14:2209\n118#2,8:2223\n236#2,16:2231\n90#2,16:2247\n106#2:2265\n108#2,6:2270\n252#2,14:2276\n118#2,8:2290\n236#2,16:2298\n90#2,16:2314\n106#2:2332\n108#2,6:2337\n252#2,14:2343\n118#2,8:2357\n236#2,16:2365\n90#2,16:2381\n106#2:2399\n108#2,6:2404\n252#2,14:2410\n118#2,8:2424\n236#2,16:2432\n90#2,16:2448\n106#2:2466\n108#2,6:2471\n252#2,14:2477\n118#2,8:2491\n236#2,16:2499\n90#2,16:2515\n106#2:2533\n108#2,6:2538\n252#2,14:2544\n118#2,8:2558\n236#2,16:2566\n90#2,16:2582\n106#2:2600\n108#2,6:2605\n252#2,14:2611\n118#2,8:2625\n236#2,16:2633\n90#2,16:2649\n106#2:2667\n108#2,6:2672\n252#2,14:2678\n118#2,8:2692\n236#2,16:2700\n90#2,16:2716\n106#2:2734\n108#2,6:2739\n252#2,14:2745\n118#2,8:2759\n236#2,16:2767\n90#2,16:2783\n106#2:2801\n108#2,6:2806\n252#2,14:2812\n129#2,8:2826\n271#2,16:2834\n287#2,14:2867\n118#2,8:2881\n236#2,16:2889\n90#2,16:2905\n106#2:2923\n108#2,6:2928\n252#2,14:2934\n118#2,8:2948\n236#2,16:2956\n90#2,16:2972\n106#2:2990\n108#2,6:2995\n252#2,14:3001\n118#2,8:3015\n236#2,16:3023\n90#2,16:3039\n106#2:3057\n108#2,6:3062\n252#2,14:3068\n118#2,8:3082\n236#2,16:3090\n90#2,16:3106\n106#2:3124\n108#2,6:3129\n252#2,14:3135\n118#2,8:3149\n236#2,16:3157\n90#2,16:3173\n106#2:3191\n108#2,6:3196\n252#2,14:3202\n118#2,8:3216\n236#2,16:3224\n90#2,16:3240\n106#2:3258\n108#2,6:3263\n252#2,14:3269\n86#3,2:1794\n91#3,4:1797\n86#3,2:1861\n91#3,4:1864\n86#3,2:1928\n91#3,4:1931\n86#3,2:1995\n91#3,4:1998\n86#3,2:2062\n91#3,4:2065\n86#3,2:2129\n91#3,4:2132\n86#3,2:2196\n91#3,4:2199\n86#3,2:2263\n91#3,4:2266\n86#3,2:2330\n91#3,4:2333\n86#3,2:2397\n91#3,4:2400\n86#3,2:2464\n91#3,4:2467\n86#3,2:2531\n91#3,4:2534\n86#3,2:2598\n91#3,4:2601\n86#3,2:2665\n91#3,4:2668\n86#3,2:2732\n91#3,4:2735\n86#3,2:2799\n91#3,4:2802\n39#3,17:2850\n86#3,2:2921\n91#3,4:2924\n86#3,2:2988\n91#3,4:2991\n86#3,2:3055\n91#3,4:3058\n86#3,2:3122\n91#3,4:3125\n86#3,2:3189\n91#3,4:3192\n86#3,2:3256\n91#3,4:3259\n*S KotlinDebug\n*F\n+ 1 ContainerApi.kt\nde/gesellix/docker/remote/api/client/ContainerApi\n*L\n79#1:1754,8\n79#1:1762,16\n79#1:1778,16\n79#1:1796\n79#1:1801,6\n79#1:1807,14\n136#1:1821,8\n136#1:1829,16\n136#1:1845,16\n136#1:1863\n136#1:1868,6\n136#1:1874,14\n320#1:1888,8\n320#1:1896,16\n320#1:1912,16\n320#1:1930\n320#1:1935,6\n320#1:1941,14\n406#1:1955,8\n406#1:1963,16\n406#1:1979,16\n406#1:1997\n406#1:2002,6\n406#1:2008,14\n461#1:2022,8\n461#1:2030,16\n461#1:2046,16\n461#1:2064\n461#1:2069,6\n461#1:2075,14\n522#1:2089,8\n522#1:2097,16\n522#1:2113,16\n522#1:2131\n522#1:2136,6\n522#1:2142,14\n591#1:2156,8\n591#1:2164,16\n591#1:2180,16\n591#1:2198\n591#1:2203,6\n591#1:2209,14\n644#1:2223,8\n644#1:2231,16\n644#1:2247,16\n644#1:2265\n644#1:2270,6\n644#1:2276,14\n703#1:2290,8\n703#1:2298,16\n703#1:2314,16\n703#1:2332\n703#1:2337,6\n703#1:2343,14\n764#1:2357,8\n764#1:2365,16\n764#1:2381,16\n764#1:2399\n764#1:2404,6\n764#1:2410,14\n953#1:2424,8\n953#1:2432,16\n953#1:2448,16\n953#1:2466\n953#1:2471,6\n953#1:2477,14\n1005#1:2491,8\n1005#1:2499,16\n1005#1:2515,16\n1005#1:2533\n1005#1:2538,6\n1005#1:2544,14\n1063#1:2558,8\n1063#1:2566,16\n1063#1:2582,16\n1063#1:2600\n1063#1:2605,6\n1063#1:2611,14\n1121#1:2625,8\n1121#1:2633,16\n1121#1:2649,16\n1121#1:2667\n1121#1:2672,6\n1121#1:2678,14\n1184#1:2692,8\n1184#1:2700,16\n1184#1:2716,16\n1184#1:2734\n1184#1:2739,6\n1184#1:2745,14\n1243#1:2759,8\n1243#1:2767,16\n1243#1:2783,16\n1243#1:2801\n1243#1:2806,6\n1243#1:2812,14\n1303#1:2826,8\n1303#1:2834,16\n1303#1:2867,14\n1377#1:2881,8\n1377#1:2889,16\n1377#1:2905,16\n1377#1:2923\n1377#1:2928,6\n1377#1:2934,14\n1442#1:2948,8\n1442#1:2956,16\n1442#1:2972,16\n1442#1:2990\n1442#1:2995,6\n1442#1:3001,14\n1500#1:3015,8\n1500#1:3023,16\n1500#1:3039,16\n1500#1:3057\n1500#1:3062,6\n1500#1:3068,14\n1553#1:3082,8\n1553#1:3090,16\n1553#1:3106,16\n1553#1:3124\n1553#1:3129,6\n1553#1:3135,14\n1639#1:3149,8\n1639#1:3157,16\n1639#1:3173,16\n1639#1:3191\n1639#1:3196,6\n1639#1:3202,14\n1701#1:3216,8\n1701#1:3224,16\n1701#1:3240,16\n1701#1:3258\n1701#1:3263,6\n1701#1:3269,14\n79#1:1794,2\n79#1:1797,4\n136#1:1861,2\n136#1:1864,4\n320#1:1928,2\n320#1:1931,4\n406#1:1995,2\n406#1:1998,4\n461#1:2062,2\n461#1:2065,4\n522#1:2129,2\n522#1:2132,4\n591#1:2196,2\n591#1:2199,4\n644#1:2263,2\n644#1:2266,4\n703#1:2330,2\n703#1:2333,4\n764#1:2397,2\n764#1:2400,4\n953#1:2464,2\n953#1:2467,4\n1005#1:2531,2\n1005#1:2534,4\n1063#1:2598,2\n1063#1:2601,4\n1121#1:2665,2\n1121#1:2668,4\n1184#1:2732,2\n1184#1:2735,4\n1243#1:2799,2\n1243#1:2802,4\n1303#1:2850,17\n1377#1:2921,2\n1377#1:2924,4\n1442#1:2988,2\n1442#1:2991,4\n1500#1:3055,2\n1500#1:3058,4\n1553#1:3122,2\n1553#1:3125,4\n1639#1:3189,2\n1639#1:3192,4\n1701#1:3256,2\n1701#1:3259,4\n*E\n"})
public final class ContainerApi
extends ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<DockerClientConfig> defaultClientConfig$delegate = LazyKt.lazy(ContainerApi::defaultClientConfig_delegate$lambda$20);

    public ContainerApi(@NotNull DockerClientConfig dockerClientConfig, @Nullable Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)dockerClientConfig, (String)"dockerClientConfig");
        super(dockerClientConfig, proxy);
    }

    public /* synthetic */ ContainerApi(DockerClientConfig dockerClientConfig, Proxy proxy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dockerClientConfig = Companion.getDefaultClientConfig();
        }
        this(dockerClientConfig, proxy);
    }

    public ContainerApi(@NotNull DockerClientConfig dockerClientConfig) {
        Intrinsics.checkNotNullParameter((Object)dockerClientConfig, (String)"dockerClientConfig");
        this(dockerClientConfig, null);
    }

    public /* synthetic */ ContainerApi(DockerClientConfig dockerClientConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dockerClientConfig = Companion.getDefaultClientConfig();
        }
        this(dockerClientConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final InputStream containerArchive(@NotNull String id, @NotNull String path) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        RequestConfig localVariableConfig = this.containerArchiveRequestConfig(id, path);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(InputStream.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(InputStream.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)InputStream.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (InputStream)((Object)body$iv$iv$iv.string());
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<InputStream>((InputStream)object, response$iv$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type java.io.InputStream");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (InputStream)t;
    }

    @NotNull
    public final RequestConfig containerArchiveRequestConfig(@NotNull String id, @NotNull String path) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object localVariableBody = null;
        Map $this$containerArchiveRequestConfig_u24lambda_u240 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        $this$containerArchiveRequestConfig_u24lambda_u240.put("path", CollectionsKt.listOf((Object)path));
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/containers/{id}/archive", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object containerArchiveInfo(@NotNull String id, @NotNull String path) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        RequestConfig localVariableConfig = this.containerArchiveInfoRequestConfig(id, path);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Map map;
                String stats;
                Map<String, List<String>> map2 = localVarResponse.getHeaders();
                String string6 = "X-Docker-Container-Path-Stat".toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                List<String> list = map2.get(string6);
                String string7 = stats = list != null ? (String)CollectionsKt.first(list) : null;
                if (stats == null) {
                    map = null;
                } else {
                    JsonAdapter jsonAdapter = new Moshi.Builder().build().adapter(Map.class);
                    byte[] byArray = Base64.getDecoder().decode(stats);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
                    byte[] byArray2 = byArray;
                    map = (Map)jsonAdapter.fromJson(new String(byArray2, Charsets.UTF_8));
                }
                return map;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string8 = ((ClientError)localVarError).getMessage();
                if (string8 == null) {
                    string8 = "";
                }
                throw new ClientException(stringBuilder.append(string8).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string9 = ((ServerError)localVarError).getMessage();
                if (string9 == null) {
                    string9 = "";
                }
                throw new ServerException(stringBuilder.append(string9).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public final RequestConfig containerArchiveInfoRequestConfig(@NotNull String id, @NotNull String path) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object localVariableBody = null;
        Map $this$containerArchiveInfoRequestConfig_u24lambda_u241 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        $this$containerArchiveInfoRequestConfig_u24lambda_u241.put("path", CollectionsKt.listOf((Object)path));
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.HEAD;
        String string = StringsKt.replace$default((String)"/containers/{id}/archive", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    public final void containerAttach(@NotNull String id, @Nullable String detachKeys, @Nullable Boolean logs, @Nullable Boolean stream, @Nullable Boolean stdin, @Nullable Boolean stdout, @Nullable Boolean stderr, @NotNull StreamCallback<Frame> callback, long timeoutMillis) throws UnsupportedOperationException, ClientException, ServerException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        RequestConfig localVariableConfig = this.containerAttachRequestConfig(id, detachKeys, logs, stream, stdin, stdout, stderr);
        Object object = this.containerInspect(id, false).getConfig();
        boolean expectMultiplexedResponse = !(object != null && (object = object.getTty()) != null ? (Boolean)object : false);
        ApiInfrastructureResponse<Frame> localVarResponse = this.requestFrames(localVariableConfig, expectMultiplexedResponse);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Job cfr_ignored_0 = (Job)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(timeoutMillis, callback, localVarResponse, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ long $timeoutMillis;
                    final /* synthetic */ StreamCallback<Frame> $callback;
                    final /* synthetic */ ApiInfrastructureResponse<Frame> $localVarResponse;
                    {
                        this.$timeoutMillis = $timeoutMillis;
                        this.$callback = $callback;
                        this.$localVarResponse = $localVarResponse;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                                return BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$timeoutMillis, this.$callback, this.$localVarResponse, null){
                                    int label;
                                    private /* synthetic */ Object L$0;
                                    final /* synthetic */ long $timeoutMillis;
                                    final /* synthetic */ StreamCallback<Frame> $callback;
                                    final /* synthetic */ ApiInfrastructureResponse<Frame> $localVarResponse;
                                    {
                                        this.$timeoutMillis = $timeoutMillis;
                                        this.$callback = $callback;
                                        this.$localVarResponse = $localVarResponse;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                                this.label = 1;
                                                Object object3 = TimeoutKt.withTimeout((long)this.$timeoutMillis, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$callback, $this$launch, this.$localVarResponse, null){
                                                    int label;
                                                    final /* synthetic */ StreamCallback<Frame> $callback;
                                                    final /* synthetic */ CoroutineScope $$this$launch;
                                                    final /* synthetic */ ApiInfrastructureResponse<Frame> $localVarResponse;
                                                    {
                                                        this.$callback = $callback;
                                                        this.$$this$launch = $$this$launch;
                                                        this.$localVarResponse = $localVarResponse;
                                                        super(2, $completion);
                                                    }

                                                    /*
                                                     * Unable to fully structure code
                                                     */
                                                    public final Object invokeSuspend(Object var1_1) {
                                                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)var1_1);
                                                                this.$callback.onStarting((Cancellable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$cancel(kotlinx.coroutines.CoroutineScope ), ()V)((CoroutineScope)this.$$this$launch));
                                                                v0 = this.$localVarResponse;
                                                                Intrinsics.checkNotNull(v0, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.core.SuccessStream<*>");
                                                                v1 = ((SuccessStream)v0).getData();
                                                                Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type kotlinx.coroutines.flow.Flow<de.gesellix.docker.remote.api.core.Frame>");
                                                                this.label = 1;
                                                                v2 = v1.collect(new FlowCollector(this.$callback){
                                                                    final /* synthetic */ StreamCallback<Frame> $callback;
                                                                    {
                                                                        this.$callback = $callback;
                                                                    }

                                                                    public final Object emit(Frame it, Continuation<? super Unit> $completion) {
                                                                        this.$callback.onNext(it);
                                                                        return Unit.INSTANCE;
                                                                    }
                                                                }, (Continuation)this);
                                                                if (v2 == var2_2) {
                                                                    return var2_2;
                                                                }
                                                                ** GOTO lbl18
                                                            }
                                                            case 1: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v2 = $result;
lbl18:
                                                                // 2 sources

                                                                this.$callback.onFinished();
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }

                                                    private static final /* synthetic */ void invokeSuspend$cancel(CoroutineScope $this$invokeSuspend_u24cancel) {
                                                        CoroutineScopeKt.cancel$default((CoroutineScope)$this$invokeSuspend_u24cancel, null, (int)1, null);
                                                    }
                                                }), (Continuation)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        function2.L$0 = value;
                                        return (Continuation)function2;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        Function2<CoroutineScope, Continuation<? super Job>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Job> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.core.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.core.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig containerAttachRequestConfig(@NotNull String id, @Nullable String detachKeys, @Nullable Boolean logs, @Nullable Boolean stream, @Nullable Boolean stdin, @Nullable Boolean stdout, @Nullable Boolean stderr) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$containerAttachRequestConfig_u24lambda_u242 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (detachKeys != null) {
            $this$containerAttachRequestConfig_u24lambda_u242.put("detachKeys", CollectionsKt.listOf((Object)detachKeys.toString()));
        }
        if (logs != null) {
            $this$containerAttachRequestConfig_u24lambda_u242.put("logs", CollectionsKt.listOf((Object)logs.toString()));
        }
        if (stream != null) {
            $this$containerAttachRequestConfig_u24lambda_u242.put("stream", CollectionsKt.listOf((Object)stream.toString()));
        }
        if (stdin != null) {
            $this$containerAttachRequestConfig_u24lambda_u242.put("stdin", CollectionsKt.listOf((Object)stdin.toString()));
        }
        if (stdout != null) {
            $this$containerAttachRequestConfig_u24lambda_u242.put("stdout", CollectionsKt.listOf((Object)stdout.toString()));
        }
        if (stderr != null) {
            $this$containerAttachRequestConfig_u24lambda_u242.put("stderr", CollectionsKt.listOf((Object)stderr.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/containers/{id}/attach", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void containerAttachWebsocket(@NotNull String id, @Nullable String detachKeys, @Nullable Boolean logs, @Nullable Boolean stream, @Nullable Boolean stdin, @Nullable Boolean stdout, @Nullable Boolean stderr) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerAttachWebsocketRequestConfig(id, detachKeys, logs, stream, stdin, stdout, stderr);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var21_22 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig containerAttachWebsocketRequestConfig(@NotNull String id, @Nullable String detachKeys, @Nullable Boolean logs, @Nullable Boolean stream, @Nullable Boolean stdin, @Nullable Boolean stdout, @Nullable Boolean stderr) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$containerAttachWebsocketRequestConfig_u24lambda_u243 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (detachKeys != null) {
            $this$containerAttachWebsocketRequestConfig_u24lambda_u243.put("detachKeys", CollectionsKt.listOf((Object)detachKeys.toString()));
        }
        if (logs != null) {
            $this$containerAttachWebsocketRequestConfig_u24lambda_u243.put("logs", CollectionsKt.listOf((Object)logs.toString()));
        }
        if (stream != null) {
            $this$containerAttachWebsocketRequestConfig_u24lambda_u243.put("stream", CollectionsKt.listOf((Object)stream.toString()));
        }
        if (stdin != null) {
            $this$containerAttachWebsocketRequestConfig_u24lambda_u243.put("stdin", CollectionsKt.listOf((Object)stdin.toString()));
        }
        if (stdout != null) {
            $this$containerAttachWebsocketRequestConfig_u24lambda_u243.put("stdout", CollectionsKt.listOf((Object)stdout.toString()));
        }
        if (stderr != null) {
            $this$containerAttachWebsocketRequestConfig_u24lambda_u243.put("stderr", CollectionsKt.listOf((Object)stderr.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/containers/{id}/attach/ws", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FilesystemChange> containerChanges(@NotNull String id) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerChangesRequestConfig(id);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(List.class, InputStream.class)) {
                object = (List)((Object)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv));
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(List.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)List.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (List)((Object)body$iv$iv$iv.string());
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<List>((List)object, response$iv$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.collections.List<de.gesellix.docker.remote.api.FilesystemChange>");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (List)t;
    }

    @NotNull
    public final RequestConfig containerChangesRequestConfig(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/containers/{id}/changes", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        Class<FilesystemChange> clazz = FilesystemChange.class;
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, (Type)((Object)clazz));
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final ContainerCreateResponse containerCreate(@NotNull ContainerCreateRequest body, @Nullable String name) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        RequestConfig localVariableConfig = this.containerCreateRequestConfig(body, name);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(ContainerCreateResponse.class, InputStream.class)) {
                object = (ContainerCreateResponse)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(ContainerCreateResponse.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)ContainerCreateResponse.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (ContainerCreateResponse)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<ContainerCreateResponse>((ContainerCreateResponse)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.ContainerCreateResponse");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (ContainerCreateResponse)t;
    }

    public static /* synthetic */ ContainerCreateResponse containerCreate$default(ContainerApi containerApi, ContainerCreateRequest containerCreateRequest, String string, int n, Object object) throws UnsupportedOperationException, ClientException, ServerException {
        if ((n & 2) != 0) {
            string = "";
        }
        return containerApi.containerCreate(containerCreateRequest, string);
    }

    @NotNull
    public final RequestConfig containerCreateRequestConfig(@NotNull ContainerCreateRequest body, @Nullable String name) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        ContainerCreateRequest localVariableBody = body;
        Map $this$containerCreateRequestConfig_u24lambda_u244 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (name != null) {
            $this$containerCreateRequestConfig_u24lambda_u244.put("name", CollectionsKt.listOf((Object)name.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        return new RequestConfig(requestMethod, "/containers/create", localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void containerDelete(@NotNull String id, @Nullable Boolean v, @Nullable Boolean force, @Nullable Boolean link) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerDeleteRequestConfig(id, v, force, link);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var18_19 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                if (((ClientError)localVarError).getStatusCode() == 404) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig containerDeleteRequestConfig(@NotNull String id, @Nullable Boolean v, @Nullable Boolean force, @Nullable Boolean link) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$containerDeleteRequestConfig_u24lambda_u245 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (v != null) {
            $this$containerDeleteRequestConfig_u24lambda_u245.put("v", CollectionsKt.listOf((Object)v.toString()));
        }
        if (force != null) {
            $this$containerDeleteRequestConfig_u24lambda_u245.put("force", CollectionsKt.listOf((Object)force.toString()));
        }
        if (link != null) {
            $this$containerDeleteRequestConfig_u24lambda_u245.put("link", CollectionsKt.listOf((Object)link.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.DELETE;
        String string = StringsKt.replace$default((String)"/containers/{id}", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final InputStream containerExport(@NotNull String id) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerExportRequestConfig(id);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(InputStream.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(InputStream.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)InputStream.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (InputStream)((Object)body$iv$iv$iv.string());
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<InputStream>((InputStream)object, response$iv$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type java.io.InputStream");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (InputStream)t;
    }

    @NotNull
    public final RequestConfig containerExportRequestConfig(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/containers/{id}/export", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContainerInspectResponse containerInspect(@NotNull String id, @Nullable Boolean size) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerInspectRequestConfig(id, size);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(ContainerInspectResponse.class, InputStream.class)) {
                object = (ContainerInspectResponse)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(ContainerInspectResponse.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)ContainerInspectResponse.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (ContainerInspectResponse)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<ContainerInspectResponse>((ContainerInspectResponse)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.ContainerInspectResponse");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (ContainerInspectResponse)t;
    }

    @NotNull
    public final RequestConfig containerInspectRequestConfig(@NotNull String id, @Nullable Boolean size) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$containerInspectRequestConfig_u24lambda_u246 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (size != null) {
            $this$containerInspectRequestConfig_u24lambda_u246.put("size", CollectionsKt.listOf((Object)size.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/containers/{id}/json", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void containerKill(@NotNull String id, @Nullable String signal) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerKillRequestConfig(id, signal);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig containerKillRequestConfig(@NotNull String id, @Nullable String signal) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$containerKillRequestConfig_u24lambda_u247 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (signal != null) {
            $this$containerKillRequestConfig_u24lambda_u247.put("signal", CollectionsKt.listOf((Object)signal.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/containers/{id}/kill", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ContainerSummary> containerList(@Nullable Boolean all, @Nullable Integer limit, @Nullable Boolean size, @Nullable String filters) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        RequestConfig localVariableConfig = this.containerListRequestConfig(all, limit, size, filters);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var18_19 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(List.class, InputStream.class)) {
                object = (List)((Object)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv));
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(List.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)List.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (List)((Object)body$iv$iv$iv.string());
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<List>((List)object, response$iv$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.collections.List<de.gesellix.docker.remote.api.ContainerSummary>");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (List)t;
    }

    @NotNull
    public final RequestConfig containerListRequestConfig(@Nullable Boolean all, @Nullable Integer limit, @Nullable Boolean size, @Nullable String filters) {
        Map map;
        Object localVariableBody = null;
        Map $this$containerListRequestConfig_u24lambda_u248 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (all != null) {
            $this$containerListRequestConfig_u24lambda_u248.put("all", CollectionsKt.listOf((Object)all.toString()));
        }
        if (limit != null) {
            $this$containerListRequestConfig_u24lambda_u248.put("limit", CollectionsKt.listOf((Object)limit.toString()));
        }
        if (size != null) {
            $this$containerListRequestConfig_u24lambda_u248.put("size", CollectionsKt.listOf((Object)size.toString()));
        }
        if (filters != null) {
            $this$containerListRequestConfig_u24lambda_u248.put("filters", CollectionsKt.listOf((Object)filters.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        Class<ContainerSummary> clazz = ContainerSummary.class;
        return new RequestConfig(requestMethod, "/containers/json", localVariableHeaders, localVariableQuery, localVariableBody, (Type)((Object)clazz));
    }

    public final void containerLogs(@NotNull String id, @Nullable Boolean follow, @Nullable Boolean stdout, @Nullable Boolean stderr, @Nullable Integer since, @Nullable Integer until, @Nullable Boolean timestamps, @Nullable String tail, @NotNull StreamCallback<Frame> callback, long timeoutMillis) throws UnsupportedOperationException, ClientException, ServerException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        RequestConfig localVariableConfig = this.containerLogsRequestConfig(id, follow, stdout, stderr, since, until, timestamps, tail);
        Object object = this.containerInspect(id, false).getConfig();
        boolean expectMultiplexedResponse = !(object != null && (object = object.getTty()) != null ? (Boolean)object : false);
        ApiInfrastructureResponse<Frame> localVarResponse = this.requestFrames(localVariableConfig, expectMultiplexedResponse);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Job cfr_ignored_0 = (Job)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(timeoutMillis, callback, localVarResponse, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ long $timeoutMillis;
                    final /* synthetic */ StreamCallback<Frame> $callback;
                    final /* synthetic */ ApiInfrastructureResponse<Frame> $localVarResponse;
                    {
                        this.$timeoutMillis = $timeoutMillis;
                        this.$callback = $callback;
                        this.$localVarResponse = $localVarResponse;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                                return BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$timeoutMillis, this.$callback, this.$localVarResponse, null){
                                    int label;
                                    private /* synthetic */ Object L$0;
                                    final /* synthetic */ long $timeoutMillis;
                                    final /* synthetic */ StreamCallback<Frame> $callback;
                                    final /* synthetic */ ApiInfrastructureResponse<Frame> $localVarResponse;
                                    {
                                        this.$timeoutMillis = $timeoutMillis;
                                        this.$callback = $callback;
                                        this.$localVarResponse = $localVarResponse;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                                this.label = 1;
                                                Object object3 = TimeoutKt.withTimeout((long)this.$timeoutMillis, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$callback, $this$launch, this.$localVarResponse, null){
                                                    int label;
                                                    final /* synthetic */ StreamCallback<Frame> $callback;
                                                    final /* synthetic */ CoroutineScope $$this$launch;
                                                    final /* synthetic */ ApiInfrastructureResponse<Frame> $localVarResponse;
                                                    {
                                                        this.$callback = $callback;
                                                        this.$$this$launch = $$this$launch;
                                                        this.$localVarResponse = $localVarResponse;
                                                        super(2, $completion);
                                                    }

                                                    /*
                                                     * Unable to fully structure code
                                                     */
                                                    public final Object invokeSuspend(Object var1_1) {
                                                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)var1_1);
                                                                this.$callback.onStarting((Cancellable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$cancel(kotlinx.coroutines.CoroutineScope ), ()V)((CoroutineScope)this.$$this$launch));
                                                                v0 = this.$localVarResponse;
                                                                Intrinsics.checkNotNull(v0, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.core.SuccessStream<*>");
                                                                v1 = ((SuccessStream)v0).getData();
                                                                Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type kotlinx.coroutines.flow.Flow<de.gesellix.docker.remote.api.core.Frame>");
                                                                this.label = 1;
                                                                v2 = v1.collect(new FlowCollector(this.$callback){
                                                                    final /* synthetic */ StreamCallback<Frame> $callback;
                                                                    {
                                                                        this.$callback = $callback;
                                                                    }

                                                                    public final Object emit(Frame it, Continuation<? super Unit> $completion) {
                                                                        this.$callback.onNext(it);
                                                                        return Unit.INSTANCE;
                                                                    }
                                                                }, (Continuation)this);
                                                                if (v2 == var2_2) {
                                                                    return var2_2;
                                                                }
                                                                ** GOTO lbl18
                                                            }
                                                            case 1: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v2 = $result;
lbl18:
                                                                // 2 sources

                                                                this.$callback.onFinished();
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }

                                                    private static final /* synthetic */ void invokeSuspend$cancel(CoroutineScope $this$invokeSuspend_u24cancel) {
                                                        CoroutineScopeKt.cancel$default((CoroutineScope)$this$invokeSuspend_u24cancel, null, (int)1, null);
                                                    }
                                                }), (Continuation)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        function2.L$0 = value;
                                        return (Continuation)function2;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        Function2<CoroutineScope, Continuation<? super Job>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Job> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.core.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.core.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig containerLogsRequestConfig(@NotNull String id, @Nullable Boolean follow, @Nullable Boolean stdout, @Nullable Boolean stderr, @Nullable Integer since, @Nullable Integer until, @Nullable Boolean timestamps, @Nullable String tail) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$containerLogsRequestConfig_u24lambda_u249 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (follow != null) {
            $this$containerLogsRequestConfig_u24lambda_u249.put("follow", CollectionsKt.listOf((Object)follow.toString()));
        }
        if (stdout != null) {
            $this$containerLogsRequestConfig_u24lambda_u249.put("stdout", CollectionsKt.listOf((Object)stdout.toString()));
        }
        if (stderr != null) {
            $this$containerLogsRequestConfig_u24lambda_u249.put("stderr", CollectionsKt.listOf((Object)stderr.toString()));
        }
        if (since != null) {
            $this$containerLogsRequestConfig_u24lambda_u249.put("since", CollectionsKt.listOf((Object)since.toString()));
        }
        if (until != null) {
            $this$containerLogsRequestConfig_u24lambda_u249.put("until", CollectionsKt.listOf((Object)until.toString()));
        }
        if (timestamps != null) {
            $this$containerLogsRequestConfig_u24lambda_u249.put("timestamps", CollectionsKt.listOf((Object)timestamps.toString()));
        }
        if (tail != null) {
            $this$containerLogsRequestConfig_u24lambda_u249.put("tail", CollectionsKt.listOf((Object)tail.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/containers/{id}/logs", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void containerPause(@NotNull String id) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerPauseRequestConfig(id);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig containerPauseRequestConfig(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/containers/{id}/pause", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContainerPruneResponse containerPrune(@Nullable String filters) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        RequestConfig localVariableConfig = this.containerPruneRequestConfig(filters);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(ContainerPruneResponse.class, InputStream.class)) {
                object = (ContainerPruneResponse)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(ContainerPruneResponse.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)ContainerPruneResponse.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (ContainerPruneResponse)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<ContainerPruneResponse>((ContainerPruneResponse)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.ContainerPruneResponse");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (ContainerPruneResponse)t;
    }

    @NotNull
    public final RequestConfig containerPruneRequestConfig(@Nullable String filters) {
        Map map;
        Object localVariableBody = null;
        Map $this$containerPruneRequestConfig_u24lambda_u2410 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (filters != null) {
            $this$containerPruneRequestConfig_u24lambda_u2410.put("filters", CollectionsKt.listOf((Object)filters.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        return new RequestConfig(requestMethod, "/containers/prune", localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void containerRename(@NotNull String id, @NotNull String name) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        RequestConfig localVariableConfig = this.containerRenameRequestConfig(id, name);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig containerRenameRequestConfig(@NotNull String id, @NotNull String name) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object localVariableBody = null;
        Map $this$containerRenameRequestConfig_u24lambda_u2411 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        $this$containerRenameRequestConfig_u24lambda_u2411.put("name", CollectionsKt.listOf((Object)name));
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/containers/{id}/rename", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void containerResize(@NotNull String id, @Nullable Integer h, @Nullable Integer w) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerResizeRequestConfig(id, h, w);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var17_18 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig containerResizeRequestConfig(@NotNull String id, @Nullable Integer h, @Nullable Integer w) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$containerResizeRequestConfig_u24lambda_u2412 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (h != null) {
            $this$containerResizeRequestConfig_u24lambda_u2412.put("h", CollectionsKt.listOf((Object)h.toString()));
        }
        if (w != null) {
            $this$containerResizeRequestConfig_u24lambda_u2412.put("w", CollectionsKt.listOf((Object)w.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/containers/{id}/resize", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void containerRestart(@NotNull String id, @Nullable Integer t) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerRestartRequestConfig(id, t);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig containerRestartRequestConfig(@NotNull String id, @Nullable Integer t) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$containerRestartRequestConfig_u24lambda_u2413 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (t != null) {
            $this$containerRestartRequestConfig_u24lambda_u2413.put("t", CollectionsKt.listOf((Object)t.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/containers/{id}/restart", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void containerStart(@NotNull String id, @Nullable String detachKeys) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerStartRequestConfig(id, detachKeys);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig containerStartRequestConfig(@NotNull String id, @Nullable String detachKeys) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$containerStartRequestConfig_u24lambda_u2414 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (detachKeys != null) {
            $this$containerStartRequestConfig_u24lambda_u2414.put("detachKeys", CollectionsKt.listOf((Object)detachKeys.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/containers/{id}/start", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    @NotNull
    public final Object containerStats(@NotNull String id, @Nullable Boolean stream, @Nullable Boolean oneShot, @NotNull StreamCallback<Object> callback, long timeoutMillis) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        RequestConfig localVariableConfig = this.containerStatsRequestConfig(id, stream, oneShot);
        ApiClient this_$iv = this;
        boolean $i$f$requestStream = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean bl = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.access$prepareRequest(this_$iv, engineRequest$iv, "application/json");
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient this_$iv$iv = this_$iv;
        boolean $i$f$requestStream2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Flow flow;
            ResponseBody $this$consumeStream$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$consumeStream = false;
            if ($this$consumeStream$iv$iv$iv == null) {
                flow = FlowKt.emptyFlow();
            } else if (Intrinsics.areEqual((Object)mediaType$iv$iv, (Object)"application/json")) {
                Flow events$iv$iv$iv;
                JsonChunksReader reader$iv$iv$iv = new JsonChunksReader((Source)$this$consumeStream$iv$iv$iv.source(), Serializer.getMoshi());
                flow = events$iv$iv$iv = FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super Object>, Continuation<? super Unit>, Object>(reader$iv$iv$iv, $this$consumeStream$iv$iv$iv, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ JsonChunksReader $reader;
                    final /* synthetic */ ResponseBody $this_consumeStream;
                    {
                        this.$reader = $reader;
                        this.$this_consumeStream = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$flow = (FlowCollector)this.L$0;
lbl6:
                                // 3 sources

                                while (this.$reader.hasNext()) {
                                    next = this.$reader.readNext(Object.class);
                                    this.L$0 = $this$flow;
                                    this.label = 1;
                                    v0 = $this$flow.emit(next, (Continuation)this);
                                    if (v0 != var2_2) continue;
                                    var5_5 = var2_2;
                                    return var5_5;
                                }
                                break;
                            }
                            case 1: {
                                $this$flow = (FlowCollector)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** GOTO lbl6
                            }
                        }
                        Util.closeQuietly((Closeable)((Closeable)this.$this_consumeStream));
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        Function2<FlowCollector<? super Object>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    public final Object invoke(FlowCollector<? super Object> p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            } else {
                throw new UnsupportedOperationException("Can't handle media type " + mediaType$iv$iv);
            }
            apiInfrastructureResponse = new SuccessStream(flow, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(timeoutMillis, callback, (ApiInfrastructureResponse<Object>)localVarResponse, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ long $timeoutMillis;
                    final /* synthetic */ StreamCallback<Object> $callback;
                    final /* synthetic */ ApiInfrastructureResponse<Object> $localVarResponse;
                    {
                        this.$timeoutMillis = $timeoutMillis;
                        this.$callback = $callback;
                        this.$localVarResponse = $localVarResponse;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                                return BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$timeoutMillis, this.$callback, this.$localVarResponse, null){
                                    int label;
                                    private /* synthetic */ Object L$0;
                                    final /* synthetic */ long $timeoutMillis;
                                    final /* synthetic */ StreamCallback<Object> $callback;
                                    final /* synthetic */ ApiInfrastructureResponse<Object> $localVarResponse;
                                    {
                                        this.$timeoutMillis = $timeoutMillis;
                                        this.$callback = $callback;
                                        this.$localVarResponse = $localVarResponse;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                                this.label = 1;
                                                Object object3 = TimeoutKt.withTimeout((long)this.$timeoutMillis, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$callback, $this$launch, this.$localVarResponse, null){
                                                    int label;
                                                    final /* synthetic */ StreamCallback<Object> $callback;
                                                    final /* synthetic */ CoroutineScope $$this$launch;
                                                    final /* synthetic */ ApiInfrastructureResponse<Object> $localVarResponse;
                                                    {
                                                        this.$callback = $callback;
                                                        this.$$this$launch = $$this$launch;
                                                        this.$localVarResponse = $localVarResponse;
                                                        super(2, $completion);
                                                    }

                                                    /*
                                                     * Unable to fully structure code
                                                     */
                                                    public final Object invokeSuspend(Object var1_1) {
                                                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)var1_1);
                                                                this.$callback.onStarting((Cancellable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$cancel(kotlinx.coroutines.CoroutineScope ), ()V)((CoroutineScope)this.$$this$launch));
                                                                v0 = this.$localVarResponse;
                                                                Intrinsics.checkNotNull(v0, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.core.SuccessStream<*>");
                                                                this.label = 1;
                                                                v1 = ((SuccessStream)v0).getData().collect(new FlowCollector(this.$callback){
                                                                    final /* synthetic */ StreamCallback<Object> $callback;
                                                                    {
                                                                        this.$callback = $callback;
                                                                    }

                                                                    public final Object emit(Object it, Continuation<? super Unit> $completion) {
                                                                        this.$callback.onNext(it);
                                                                        return Unit.INSTANCE;
                                                                    }
                                                                }, (Continuation)this);
                                                                if (v1 == var2_2) {
                                                                    return var2_2;
                                                                }
                                                                ** GOTO lbl16
                                                            }
                                                            case 1: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v1 = $result;
lbl16:
                                                                // 2 sources

                                                                this.$callback.onFinished();
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }

                                                    private static final /* synthetic */ void invokeSuspend$cancel(CoroutineScope $this$invokeSuspend_u24cancel) {
                                                        CoroutineScopeKt.cancel$default((CoroutineScope)$this$invokeSuspend_u24cancel, null, (int)1, null);
                                                    }
                                                }), (Continuation)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        function2.L$0 = value;
                                        return (Continuation)function2;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        Function2<CoroutineScope, Continuation<? super Job>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Job> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string5 = ((ClientError)localVarError).getMessage();
                if (string5 == null) {
                    string5 = "";
                }
                throw new ClientException(stringBuilder.append(string5).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ServerError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ServerException(stringBuilder.append(string6).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final RequestConfig containerStatsRequestConfig(@NotNull String id, @Nullable Boolean stream, @Nullable Boolean oneShot) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$containerStatsRequestConfig_u24lambda_u2415 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (stream != null) {
            $this$containerStatsRequestConfig_u24lambda_u2415.put("stream", CollectionsKt.listOf((Object)stream.toString()));
        }
        if (oneShot != null) {
            $this$containerStatsRequestConfig_u24lambda_u2415.put("one-shot", CollectionsKt.listOf((Object)oneShot.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/containers/{id}/stats", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void containerStop(@NotNull String id, @Nullable Integer t) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerStopRequestConfig(id, t);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                if (((ClientError)localVarError).getStatusCode() == 404) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                if (((ServerError)localVarError).getStatusCode() == 304) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig containerStopRequestConfig(@NotNull String id, @Nullable Integer t) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$containerStopRequestConfig_u24lambda_u2416 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (t != null) {
            $this$containerStopRequestConfig_u24lambda_u2416.put("t", CollectionsKt.listOf((Object)t.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/containers/{id}/stop", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContainerTopResponse containerTop(@NotNull String id, @Nullable String psArgs) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerTopRequestConfig(id, psArgs);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(ContainerTopResponse.class, InputStream.class)) {
                object = (ContainerTopResponse)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(ContainerTopResponse.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)ContainerTopResponse.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (ContainerTopResponse)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<ContainerTopResponse>((ContainerTopResponse)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.ContainerTopResponse");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (ContainerTopResponse)t;
    }

    @NotNull
    public final RequestConfig containerTopRequestConfig(@NotNull String id, @Nullable String psArgs) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$containerTopRequestConfig_u24lambda_u2417 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (psArgs != null) {
            $this$containerTopRequestConfig_u24lambda_u2417.put("ps_args", CollectionsKt.listOf((Object)psArgs.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/containers/{id}/top", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void containerUnpause(@NotNull String id) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerUnpauseRequestConfig(id);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig containerUnpauseRequestConfig(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/containers/{id}/unpause", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContainerUpdateResponse containerUpdate(@NotNull String id, @NotNull ContainerUpdateRequest update) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        RequestConfig localVariableConfig = this.containerUpdateRequestConfig(id, update);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(ContainerUpdateResponse.class, InputStream.class)) {
                object = (ContainerUpdateResponse)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(ContainerUpdateResponse.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)ContainerUpdateResponse.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (ContainerUpdateResponse)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<ContainerUpdateResponse>((ContainerUpdateResponse)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.ContainerUpdateResponse");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (ContainerUpdateResponse)t;
    }

    @NotNull
    public final RequestConfig containerUpdateRequestConfig(@NotNull String id, @NotNull ContainerUpdateRequest update) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        ContainerUpdateRequest localVariableBody = update;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/containers/{id}/update", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    @NotNull
    public final ContainerWaitResponse containerWait(@NotNull String id, @Nullable String condition) throws UnsupportedOperationException, ClientException, ServerException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CharSequence charSequence = condition;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.containerWait(id, ConditionContainerWait.NotMinusRunning) : this.containerWait(id, ConditionContainerWait.valueOf(condition));
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final ContainerWaitResponse containerWait(@NotNull String id, @Nullable ConditionContainerWait condition) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.containerWaitRequestConfig(id, condition);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(ContainerWaitResponse.class, InputStream.class)) {
                object = (ContainerWaitResponse)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(ContainerWaitResponse.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)ContainerWaitResponse.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (ContainerWaitResponse)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<ContainerWaitResponse>((ContainerWaitResponse)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.ContainerWaitResponse");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (ContainerWaitResponse)t;
    }

    public static /* synthetic */ ContainerWaitResponse containerWait$default(ContainerApi containerApi, String string, ConditionContainerWait conditionContainerWait, int n, Object object) throws UnsupportedOperationException, ClientException, ServerException {
        if ((n & 2) != 0) {
            conditionContainerWait = ConditionContainerWait.NotMinusRunning;
        }
        return containerApi.containerWait(string, conditionContainerWait);
    }

    @NotNull
    public final RequestConfig containerWaitRequestConfig(@NotNull String id, @Nullable ConditionContainerWait condition) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$containerWaitRequestConfig_u24lambda_u2418 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (condition != null) {
            $this$containerWaitRequestConfig_u24lambda_u2418.put("condition", CollectionsKt.listOf((Object)condition.getValue()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/containers/{id}/wait", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void putContainerArchive(@NotNull String id, @NotNull String path, @NotNull InputStream inputStream, @Nullable String noOverwriteDirNonDir, @Nullable String copyUIDGID) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        RequestConfig localVariableConfig = this.putContainerArchiveRequestConfig(id, path, inputStream, noOverwriteDirNonDir, copyUIDGID);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var19_20 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig putContainerArchiveRequestConfig(@NotNull String id, @NotNull String path, @NotNull InputStream inputStream, @Nullable String noOverwriteDirNonDir, @Nullable String copyUIDGID) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Source localVariableBody = Okio.source((InputStream)inputStream);
        Map $this$putContainerArchiveRequestConfig_u24lambda_u2419 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        $this$putContainerArchiveRequestConfig_u24lambda_u2419.put("path", CollectionsKt.listOf((Object)path));
        if (noOverwriteDirNonDir != null) {
            $this$putContainerArchiveRequestConfig_u24lambda_u2419.put("noOverwriteDirNonDir", CollectionsKt.listOf((Object)noOverwriteDirNonDir.toString()));
        }
        if (copyUIDGID != null) {
            $this$putContainerArchiveRequestConfig_u24lambda_u2419.put("copyUIDGID", CollectionsKt.listOf((Object)copyUIDGID.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.PUT;
        String string = StringsKt.replace$default((String)"/containers/{id}/archive", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public final ContainerCreateResponse containerCreate(@NotNull ContainerCreateRequest body) throws UnsupportedOperationException, ClientException, ServerException {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return ContainerApi.containerCreate$default(this, body, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final ContainerWaitResponse containerWait(@NotNull String id) throws UnsupportedOperationException, ClientException, ServerException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return ContainerApi.containerWait$default(this, id, null, 2, null);
    }

    private static final DockerClientConfig defaultClientConfig_delegate$lambda$20() {
        return new DockerClientConfig();
    }

    @NotNull
    public static final DockerClientConfig getDefaultClientConfig() {
        return Companion.getDefaultClientConfig();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u00020\u00058FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lde/gesellix/docker/remote/api/client/ContainerApi$Companion;", "", "<init>", "()V", "defaultClientConfig", "Lde/gesellix/docker/engine/DockerClientConfig;", "getDefaultClientConfig$annotations", "getDefaultClientConfig", "()Lde/gesellix/docker/engine/DockerClientConfig;", "defaultClientConfig$delegate", "Lkotlin/Lazy;", "api-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DockerClientConfig getDefaultClientConfig() {
            Lazy lazy = defaultClientConfig$delegate;
            return (DockerClientConfig)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultClientConfig$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lde/gesellix/docker/remote/api/client/ContainerApi$ConditionContainerWait;", "", "value", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "NotMinusRunning", "NextMinusExit", "Removed", "api-client"})
    public static final class ConditionContainerWait
    extends Enum<ConditionContainerWait> {
        @NotNull
        private final String value;
        @Json(name="not-running")
        public static final /* enum */ ConditionContainerWait NotMinusRunning = new ConditionContainerWait("not-running");
        @Json(name="next-exit")
        public static final /* enum */ ConditionContainerWait NextMinusExit = new ConditionContainerWait("next-exit");
        @Json(name="removed")
        public static final /* enum */ ConditionContainerWait Removed = new ConditionContainerWait("removed");
        private static final /* synthetic */ ConditionContainerWait[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ConditionContainerWait(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static ConditionContainerWait[] values() {
            return (ConditionContainerWait[])$VALUES.clone();
        }

        public static ConditionContainerWait valueOf(String value) {
            return Enum.valueOf(ConditionContainerWait.class, value);
        }

        @NotNull
        public static EnumEntries<ConditionContainerWait> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = conditionContainerWaitArray = new ConditionContainerWait[]{ConditionContainerWait.NotMinusRunning, ConditionContainerWait.NextMinusExit, ConditionContainerWait.Removed};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseType.values().length];
            try {
                nArray[ResponseType.Success.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Informational.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Redirection.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ClientError.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ServerError.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

