/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.remote.api.client;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import de.gesellix.docker.engine.DockerClientConfig;
import de.gesellix.docker.engine.EngineRequest;
import de.gesellix.docker.engine.RequestMethod;
import de.gesellix.docker.remote.api.DistributionInspect;
import de.gesellix.docker.remote.api.core.ApiClient;
import de.gesellix.docker.remote.api.core.ApiInfrastructureResponse;
import de.gesellix.docker.remote.api.core.ClientError;
import de.gesellix.docker.remote.api.core.ClientException;
import de.gesellix.docker.remote.api.core.Informational;
import de.gesellix.docker.remote.api.core.Redirection;
import de.gesellix.docker.remote.api.core.RequestConfig;
import de.gesellix.docker.remote.api.core.ResponseConsumerKt;
import de.gesellix.docker.remote.api.core.ResponseExtensionsKt;
import de.gesellix.docker.remote.api.core.ResponseType;
import de.gesellix.docker.remote.api.core.Serializer;
import de.gesellix.docker.remote.api.core.ServerError;
import de.gesellix.docker.remote.api.core.ServerException;
import de.gesellix.docker.remote.api.core.Success;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0013\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0010"}, d2={"Lde/gesellix/docker/remote/api/client/DistributionApi;", "Lde/gesellix/docker/remote/api/core/ApiClient;", "dockerClientConfig", "Lde/gesellix/docker/engine/DockerClientConfig;", "proxy", "Ljava/net/Proxy;", "<init>", "(Lde/gesellix/docker/engine/DockerClientConfig;Ljava/net/Proxy;)V", "(Lde/gesellix/docker/engine/DockerClientConfig;)V", "distributionInspect", "Lde/gesellix/docker/remote/api/DistributionInspect;", "name", "", "distributionInspectRequestConfig", "Lde/gesellix/docker/remote/api/core/RequestConfig;", "Companion", "api-client"})
@SourceDebugExtension(value={"SMAP\nDistributionApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DistributionApi.kt\nde/gesellix/docker/remote/api/client/DistributionApi\n+ 2 ApiClient.kt\nde/gesellix/docker/remote/api/core/ApiClient\n+ 3 ResponseConsumer.kt\nde/gesellix/docker/remote/api/core/ResponseConsumerKt\n*L\n1#1,94:1\n118#2,8:95\n236#2,16:103\n90#2,16:119\n106#2:137\n108#2,6:142\n252#2,14:148\n86#3,2:135\n91#3,4:138\n*S KotlinDebug\n*F\n+ 1 DistributionApi.kt\nde/gesellix/docker/remote/api/client/DistributionApi\n*L\n53#1:95,8\n53#1:103,16\n53#1:119,16\n53#1:137\n53#1:142,6\n53#1:148,14\n53#1:135,2\n53#1:138,4\n*E\n"})
public final class DistributionApi
extends ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<DockerClientConfig> defaultClientConfig$delegate = LazyKt.lazy(DistributionApi::defaultClientConfig_delegate$lambda$0);

    public DistributionApi(@NotNull DockerClientConfig dockerClientConfig, @Nullable Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)dockerClientConfig, (String)"dockerClientConfig");
        super(dockerClientConfig, proxy);
    }

    public /* synthetic */ DistributionApi(DockerClientConfig dockerClientConfig, Proxy proxy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dockerClientConfig = Companion.getDefaultClientConfig();
        }
        this(dockerClientConfig, proxy);
    }

    public DistributionApi(@NotNull DockerClientConfig dockerClientConfig) {
        Intrinsics.checkNotNullParameter((Object)dockerClientConfig, (String)"dockerClientConfig");
        this(dockerClientConfig, null);
    }

    public /* synthetic */ DistributionApi(DockerClientConfig dockerClientConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dockerClientConfig = Companion.getDefaultClientConfig();
        }
        this(dockerClientConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DistributionInspect distributionInspect(@NotNull String name) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        RequestConfig localVariableConfig = this.distributionInspectRequestConfig(name);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(DistributionInspect.class, InputStream.class)) {
                object = (DistributionInspect)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(DistributionInspect.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)DistributionInspect.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (DistributionInspect)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<DistributionInspect>((DistributionInspect)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.DistributionInspect");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (DistributionInspect)t;
    }

    @NotNull
    public final RequestConfig distributionInspectRequestConfig(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/distribution/{name}/json", (String)"{name}", (String)name, (boolean)false, (int)4, null);
        RequestConfig localVariableConfig = new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
        return localVariableConfig;
    }

    private static final DockerClientConfig defaultClientConfig_delegate$lambda$0() {
        return new DockerClientConfig();
    }

    @NotNull
    public static final DockerClientConfig getDefaultClientConfig() {
        return Companion.getDefaultClientConfig();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u00020\u00058FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lde/gesellix/docker/remote/api/client/DistributionApi$Companion;", "", "<init>", "()V", "defaultClientConfig", "Lde/gesellix/docker/engine/DockerClientConfig;", "getDefaultClientConfig$annotations", "getDefaultClientConfig", "()Lde/gesellix/docker/engine/DockerClientConfig;", "defaultClientConfig$delegate", "Lkotlin/Lazy;", "api-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DockerClientConfig getDefaultClientConfig() {
            Lazy lazy = defaultClientConfig$delegate;
            return (DockerClientConfig)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultClientConfig$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseType.values().length];
            try {
                nArray[ResponseType.Success.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Informational.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Redirection.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ClientError.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ServerError.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

