/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.remote.api.client;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import de.gesellix.docker.engine.DockerClientConfig;
import de.gesellix.docker.engine.EngineRequest;
import de.gesellix.docker.engine.RequestMethod;
import de.gesellix.docker.remote.api.ExecConfig;
import de.gesellix.docker.remote.api.ExecInspectResponse;
import de.gesellix.docker.remote.api.ExecStartConfig;
import de.gesellix.docker.remote.api.IdResponse;
import de.gesellix.docker.remote.api.core.ApiClient;
import de.gesellix.docker.remote.api.core.ApiInfrastructureResponse;
import de.gesellix.docker.remote.api.core.Cancellable;
import de.gesellix.docker.remote.api.core.ClientError;
import de.gesellix.docker.remote.api.core.ClientException;
import de.gesellix.docker.remote.api.core.Frame;
import de.gesellix.docker.remote.api.core.Informational;
import de.gesellix.docker.remote.api.core.LoggingCallback;
import de.gesellix.docker.remote.api.core.Redirection;
import de.gesellix.docker.remote.api.core.RequestConfig;
import de.gesellix.docker.remote.api.core.ResponseConsumerKt;
import de.gesellix.docker.remote.api.core.ResponseExtensionsKt;
import de.gesellix.docker.remote.api.core.ResponseType;
import de.gesellix.docker.remote.api.core.Serializer;
import de.gesellix.docker.remote.api.core.ServerError;
import de.gesellix.docker.remote.api.core.ServerException;
import de.gesellix.docker.remote.api.core.StreamCallback;
import de.gesellix.docker.remote.api.core.Success;
import de.gesellix.docker.remote.api.core.SuccessStream;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.FlowCollector;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0013\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ'\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0019J'\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u001bJ?\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0012\b\u0002\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010!\u0018\u00010 2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#H\u0007\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a8\u0006'"}, d2={"Lde/gesellix/docker/remote/api/client/ExecApi;", "Lde/gesellix/docker/remote/api/core/ApiClient;", "dockerClientConfig", "Lde/gesellix/docker/engine/DockerClientConfig;", "proxy", "Ljava/net/Proxy;", "<init>", "(Lde/gesellix/docker/engine/DockerClientConfig;Ljava/net/Proxy;)V", "(Lde/gesellix/docker/engine/DockerClientConfig;)V", "containerExec", "Lde/gesellix/docker/remote/api/IdResponse;", "id", "", "execConfig", "Lde/gesellix/docker/remote/api/ExecConfig;", "containerExecRequestConfig", "Lde/gesellix/docker/remote/api/core/RequestConfig;", "execInspect", "Lde/gesellix/docker/remote/api/ExecInspectResponse;", "execInspectRequestConfig", "execResize", "", "h", "", "w", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)V", "execResizeRequestConfig", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Lde/gesellix/docker/remote/api/core/RequestConfig;", "execStart", "execStartConfig", "Lde/gesellix/docker/remote/api/ExecStartConfig;", "callback", "Lde/gesellix/docker/remote/api/core/StreamCallback;", "Lde/gesellix/docker/remote/api/core/Frame;", "timeoutMillis", "", "(Ljava/lang/String;Lde/gesellix/docker/remote/api/ExecStartConfig;Lde/gesellix/docker/remote/api/core/StreamCallback;Ljava/lang/Long;)V", "execStartRequestConfig", "Companion", "api-client"})
@SourceDebugExtension(value={"SMAP\nExecApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecApi.kt\nde/gesellix/docker/remote/api/client/ExecApi\n+ 2 ApiClient.kt\nde/gesellix/docker/remote/api/core/ApiClient\n+ 3 ResponseConsumer.kt\nde/gesellix/docker/remote/api/core/ResponseConsumerKt\n*L\n1#1,306:1\n118#2,8:307\n236#2,16:315\n90#2,16:331\n106#2:349\n108#2,6:354\n252#2,14:360\n118#2,8:374\n236#2,16:382\n90#2,16:398\n106#2:416\n108#2,6:421\n252#2,14:427\n118#2,8:441\n236#2,16:449\n90#2,16:465\n106#2:483\n108#2,6:488\n252#2,14:494\n86#3,2:347\n91#3,4:350\n86#3,2:414\n91#3,4:417\n86#3,2:481\n91#3,4:484\n*S KotlinDebug\n*F\n+ 1 ExecApi.kt\nde/gesellix/docker/remote/api/client/ExecApi\n*L\n70#1:307,8\n70#1:315,16\n70#1:331,16\n70#1:349\n70#1:354,6\n70#1:360,14\n123#1:374,8\n123#1:382,16\n123#1:398,16\n123#1:416\n123#1:421,6\n123#1:427,14\n177#1:441,8\n177#1:449,16\n177#1:465,16\n177#1:483\n177#1:488,6\n177#1:494,14\n70#1:347,2\n70#1:350,4\n123#1:414,2\n123#1:417,4\n177#1:481,2\n177#1:484,4\n*E\n"})
public final class ExecApi
extends ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<DockerClientConfig> defaultClientConfig$delegate = LazyKt.lazy(ExecApi::defaultClientConfig_delegate$lambda$1);

    public ExecApi(@NotNull DockerClientConfig dockerClientConfig, @Nullable Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)dockerClientConfig, (String)"dockerClientConfig");
        super(dockerClientConfig, proxy);
    }

    public /* synthetic */ ExecApi(DockerClientConfig dockerClientConfig, Proxy proxy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dockerClientConfig = Companion.getDefaultClientConfig();
        }
        this(dockerClientConfig, proxy);
    }

    public ExecApi(@NotNull DockerClientConfig dockerClientConfig) {
        Intrinsics.checkNotNullParameter((Object)dockerClientConfig, (String)"dockerClientConfig");
        this(dockerClientConfig, null);
    }

    public /* synthetic */ ExecApi(DockerClientConfig dockerClientConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dockerClientConfig = Companion.getDefaultClientConfig();
        }
        this(dockerClientConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IdResponse containerExec(@NotNull String id, @NotNull ExecConfig execConfig) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)execConfig, (String)"execConfig");
        RequestConfig localVariableConfig = this.containerExecRequestConfig(id, execConfig);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(IdResponse.class, InputStream.class)) {
                object = (IdResponse)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(IdResponse.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)IdResponse.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (IdResponse)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<IdResponse>((IdResponse)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.IdResponse");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (IdResponse)t;
    }

    @NotNull
    public final RequestConfig containerExecRequestConfig(@NotNull String id, @NotNull ExecConfig execConfig) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)execConfig, (String)"execConfig");
        ExecConfig localVariableBody = execConfig;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/containers/{id}/exec", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExecInspectResponse execInspect(@NotNull String id) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.execInspectRequestConfig(id);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(ExecInspectResponse.class, InputStream.class)) {
                object = (ExecInspectResponse)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(ExecInspectResponse.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)ExecInspectResponse.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (ExecInspectResponse)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<ExecInspectResponse>((ExecInspectResponse)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.ExecInspectResponse");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (ExecInspectResponse)t;
    }

    @NotNull
    public final RequestConfig execInspectRequestConfig(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/exec/{id}/json", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void execResize(@NotNull String id, @Nullable Integer h, @Nullable Integer w) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.execResizeRequestConfig(id, h, w);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var17_18 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig execResizeRequestConfig(@NotNull String id, @Nullable Integer h, @Nullable Integer w) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$execResizeRequestConfig_u24lambda_u240 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (h != null) {
            $this$execResizeRequestConfig_u24lambda_u240.put("h", CollectionsKt.listOf((Object)h.toString()));
        }
        if (w != null) {
            $this$execResizeRequestConfig_u24lambda_u240.put("w", CollectionsKt.listOf((Object)w.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/exec/{id}/resize", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    @JvmOverloads
    public final void execStart(@NotNull String id, @Nullable ExecStartConfig execStartConfig, @Nullable StreamCallback<Frame> callback, @Nullable Long timeoutMillis) throws UnsupportedOperationException, ClientException, ServerException {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.execStartRequestConfig(id, execStartConfig);
        ExecStartConfig execStartConfig2 = execStartConfig;
        if ((execStartConfig2 != null ? execStartConfig2.getTty() : null) != null) {
            Boolean bl2 = execStartConfig.getTty();
            bl = !(bl2 != null ? bl2 : false);
        } else {
            Object object = this.execInspect(id).getProcessConfig();
            bl = !(object != null && (object = object.getTty()) != null ? (Boolean)object : false);
        }
        boolean expectMultiplexedResponse = bl;
        ApiInfrastructureResponse<Frame> localVarResponse = this.requestFrames(localVariableConfig, expectMultiplexedResponse);
        Duration timeout = timeoutMillis == null ? Duration.of(10L, ChronoUnit.MINUTES) : Duration.of(timeoutMillis, ChronoUnit.MILLIS);
        StreamCallback streamCallback = callback;
        if (streamCallback == null) {
            streamCallback = new LoggingCallback();
        }
        StreamCallback actualCallback = streamCallback;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Job cfr_ignored_0 = (Job)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(timeout, (StreamCallback<Frame>)actualCallback, localVarResponse, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Duration $timeout;
                    final /* synthetic */ StreamCallback<Frame> $actualCallback;
                    final /* synthetic */ ApiInfrastructureResponse<Frame> $localVarResponse;
                    {
                        this.$timeout = $timeout;
                        this.$actualCallback = $actualCallback;
                        this.$localVarResponse = $localVarResponse;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                                return BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$timeout, this.$actualCallback, this.$localVarResponse, null){
                                    int label;
                                    private /* synthetic */ Object L$0;
                                    final /* synthetic */ Duration $timeout;
                                    final /* synthetic */ StreamCallback<Frame> $actualCallback;
                                    final /* synthetic */ ApiInfrastructureResponse<Frame> $localVarResponse;
                                    {
                                        this.$timeout = $timeout;
                                        this.$actualCallback = $actualCallback;
                                        this.$localVarResponse = $localVarResponse;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                                this.label = 1;
                                                Object object3 = TimeoutKt.withTimeoutOrNull((long)this.$timeout.toMillis(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$actualCallback, $this$launch, this.$localVarResponse, null){
                                                    int label;
                                                    final /* synthetic */ StreamCallback<Frame> $actualCallback;
                                                    final /* synthetic */ CoroutineScope $$this$launch;
                                                    final /* synthetic */ ApiInfrastructureResponse<Frame> $localVarResponse;
                                                    {
                                                        this.$actualCallback = $actualCallback;
                                                        this.$$this$launch = $$this$launch;
                                                        this.$localVarResponse = $localVarResponse;
                                                        super(2, $completion);
                                                    }

                                                    /*
                                                     * Unable to fully structure code
                                                     */
                                                    public final Object invokeSuspend(Object var1_1) {
                                                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)var1_1);
                                                                this.$actualCallback.onStarting((Cancellable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$cancel(kotlinx.coroutines.CoroutineScope ), ()V)((CoroutineScope)this.$$this$launch));
                                                                v0 = this.$localVarResponse;
                                                                Intrinsics.checkNotNull(v0, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.core.SuccessStream<*>");
                                                                v1 = ((SuccessStream)v0).getData();
                                                                Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type kotlinx.coroutines.flow.Flow<de.gesellix.docker.remote.api.core.Frame>");
                                                                this.label = 1;
                                                                v2 = v1.collect(new FlowCollector(this.$actualCallback){
                                                                    final /* synthetic */ StreamCallback<Frame> $actualCallback;
                                                                    {
                                                                        this.$actualCallback = $actualCallback;
                                                                    }

                                                                    public final Object emit(Frame it, Continuation<? super Unit> $completion) {
                                                                        this.$actualCallback.onNext(it);
                                                                        return Unit.INSTANCE;
                                                                    }
                                                                }, (Continuation)this);
                                                                if (v2 == var2_2) {
                                                                    return var2_2;
                                                                }
                                                                ** GOTO lbl18
                                                            }
                                                            case 1: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                v2 = $result;
lbl18:
                                                                // 2 sources

                                                                this.$actualCallback.onFinished();
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }

                                                    private static final /* synthetic */ void invokeSuspend$cancel(CoroutineScope $this$invokeSuspend_u24cancel) {
                                                        CoroutineScopeKt.cancel$default((CoroutineScope)$this$invokeSuspend_u24cancel, null, (int)1, null);
                                                    }
                                                }), (Continuation)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        function2.L$0 = value;
                                        return (Continuation)function2;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        Function2<CoroutineScope, Continuation<? super Job>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Job> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.core.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.core.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static /* synthetic */ void execStart$default(ExecApi execApi, String string, ExecStartConfig execStartConfig, StreamCallback streamCallback, Long l, int n, Object object) throws UnsupportedOperationException, ClientException, ServerException {
        if ((n & 4) != 0) {
            streamCallback = null;
        }
        if ((n & 8) != 0) {
            l = null;
        }
        execApi.execStart(string, execStartConfig, streamCallback, l);
    }

    @NotNull
    public final RequestConfig execStartRequestConfig(@NotNull String id, @Nullable ExecStartConfig execStartConfig) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ExecStartConfig localVariableBody = execStartConfig;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/exec/{id}/start", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    @JvmOverloads
    public final void execStart(@NotNull String id, @Nullable ExecStartConfig execStartConfig, @Nullable StreamCallback<Frame> callback) throws UnsupportedOperationException, ClientException, ServerException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ExecApi.execStart$default(this, id, execStartConfig, callback, null, 8, null);
    }

    @JvmOverloads
    public final void execStart(@NotNull String id, @Nullable ExecStartConfig execStartConfig) throws UnsupportedOperationException, ClientException, ServerException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ExecApi.execStart$default(this, id, execStartConfig, null, null, 12, null);
    }

    private static final DockerClientConfig defaultClientConfig_delegate$lambda$1() {
        return new DockerClientConfig();
    }

    @NotNull
    public static final DockerClientConfig getDefaultClientConfig() {
        return Companion.getDefaultClientConfig();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u00020\u00058FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lde/gesellix/docker/remote/api/client/ExecApi$Companion;", "", "<init>", "()V", "defaultClientConfig", "Lde/gesellix/docker/engine/DockerClientConfig;", "getDefaultClientConfig$annotations", "getDefaultClientConfig", "()Lde/gesellix/docker/engine/DockerClientConfig;", "defaultClientConfig$delegate", "Lkotlin/Lazy;", "api-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DockerClientConfig getDefaultClientConfig() {
            Lazy lazy = defaultClientConfig$delegate;
            return (DockerClientConfig)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultClientConfig$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseType.values().length];
            try {
                nArray[ResponseType.Success.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Informational.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Redirection.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ClientError.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ServerError.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

