/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.remote.api.client;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Types;
import de.gesellix.docker.engine.DockerClientConfig;
import de.gesellix.docker.engine.EngineRequest;
import de.gesellix.docker.engine.RequestMethod;
import de.gesellix.docker.remote.api.Network;
import de.gesellix.docker.remote.api.NetworkConnectRequest;
import de.gesellix.docker.remote.api.NetworkCreateRequest;
import de.gesellix.docker.remote.api.NetworkCreateResponse;
import de.gesellix.docker.remote.api.NetworkDisconnectRequest;
import de.gesellix.docker.remote.api.NetworkPruneResponse;
import de.gesellix.docker.remote.api.core.ApiClient;
import de.gesellix.docker.remote.api.core.ApiInfrastructureResponse;
import de.gesellix.docker.remote.api.core.ClientError;
import de.gesellix.docker.remote.api.core.ClientException;
import de.gesellix.docker.remote.api.core.Informational;
import de.gesellix.docker.remote.api.core.Redirection;
import de.gesellix.docker.remote.api.core.RequestConfig;
import de.gesellix.docker.remote.api.core.ResponseConsumerKt;
import de.gesellix.docker.remote.api.core.ResponseExtensionsKt;
import de.gesellix.docker.remote.api.core.ResponseType;
import de.gesellix.docker.remote.api.core.Serializer;
import de.gesellix.docker.remote.api.core.ServerError;
import de.gesellix.docker.remote.api.core.ServerException;
import de.gesellix.docker.remote.api.core.Success;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0001*B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0013\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0019J'\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010 J'\u0010!\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0$2\b\u0010%\u001a\u0004\u0018\u00010\fJ\u0010\u0010&\u001a\u00020\u00102\b\u0010%\u001a\u0004\u0018\u00010\fJ\u0010\u0010'\u001a\u00020(2\b\u0010%\u001a\u0004\u0018\u00010\fJ\u0010\u0010)\u001a\u00020\u00102\b\u0010%\u001a\u0004\u0018\u00010\f\u00a8\u0006+"}, d2={"Lde/gesellix/docker/remote/api/client/NetworkApi;", "Lde/gesellix/docker/remote/api/core/ApiClient;", "dockerClientConfig", "Lde/gesellix/docker/engine/DockerClientConfig;", "proxy", "Ljava/net/Proxy;", "<init>", "(Lde/gesellix/docker/engine/DockerClientConfig;Ljava/net/Proxy;)V", "(Lde/gesellix/docker/engine/DockerClientConfig;)V", "networkConnect", "", "id", "", "container", "Lde/gesellix/docker/remote/api/NetworkConnectRequest;", "networkConnectRequestConfig", "Lde/gesellix/docker/remote/api/core/RequestConfig;", "networkCreate", "Lde/gesellix/docker/remote/api/NetworkCreateResponse;", "networkConfig", "Lde/gesellix/docker/remote/api/NetworkCreateRequest;", "networkCreateRequestConfig", "networkDelete", "networkDeleteRequestConfig", "networkDisconnect", "Lde/gesellix/docker/remote/api/NetworkDisconnectRequest;", "networkDisconnectRequestConfig", "networkInspect", "Lde/gesellix/docker/remote/api/Network;", "verbose", "", "scope", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;)Lde/gesellix/docker/remote/api/Network;", "networkInspectRequestConfig", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;)Lde/gesellix/docker/remote/api/core/RequestConfig;", "networkList", "", "filters", "networkListRequestConfig", "networkPrune", "Lde/gesellix/docker/remote/api/NetworkPruneResponse;", "networkPruneRequestConfig", "Companion", "api-client"})
@SourceDebugExtension(value={"SMAP\nNetworkApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkApi.kt\nde/gesellix/docker/remote/api/client/NetworkApi\n+ 2 ApiClient.kt\nde/gesellix/docker/remote/api/core/ApiClient\n+ 3 ResponseConsumer.kt\nde/gesellix/docker/remote/api/core/ResponseConsumerKt\n*L\n1#1,442:1\n118#2,8:443\n236#2,16:451\n90#2,16:467\n106#2:485\n108#2,6:490\n252#2,14:496\n118#2,8:510\n236#2,16:518\n90#2,16:534\n106#2:552\n108#2,6:557\n252#2,14:563\n118#2,8:577\n236#2,16:585\n90#2,16:601\n106#2:619\n108#2,6:624\n252#2,14:630\n118#2,8:644\n236#2,16:652\n90#2,16:668\n106#2:686\n108#2,6:691\n252#2,14:697\n118#2,8:711\n236#2,16:719\n90#2,16:735\n106#2:753\n108#2,6:758\n252#2,14:764\n118#2,8:778\n236#2,16:786\n90#2,16:802\n106#2:820\n108#2,6:825\n252#2,14:831\n118#2,8:845\n236#2,16:853\n90#2,16:869\n106#2:887\n108#2,6:892\n252#2,14:898\n86#3,2:483\n91#3,4:486\n86#3,2:550\n91#3,4:553\n86#3,2:617\n91#3,4:620\n86#3,2:684\n91#3,4:687\n86#3,2:751\n91#3,4:754\n86#3,2:818\n91#3,4:821\n86#3,2:885\n91#3,4:888\n*S KotlinDebug\n*F\n+ 1 NetworkApi.kt\nde/gesellix/docker/remote/api/client/NetworkApi\n*L\n62#1:443,8\n62#1:451,16\n62#1:467,16\n62#1:485\n62#1:490,6\n62#1:496,14\n115#1:510,8\n115#1:518,16\n115#1:534,16\n115#1:552\n115#1:557,6\n115#1:563,14\n167#1:577,8\n167#1:585,16\n167#1:601,16\n167#1:619\n167#1:624,6\n167#1:630,14\n223#1:644,8\n223#1:652,16\n223#1:668,16\n223#1:686\n223#1:691,6\n223#1:697,14\n278#1:711,8\n278#1:719,16\n278#1:735,16\n278#1:753\n278#1:758,6\n278#1:764,14\n340#1:778,8\n340#1:786,16\n340#1:802,16\n340#1:820\n340#1:825,6\n340#1:831,14\n398#1:845,8\n398#1:853,16\n398#1:869,16\n398#1:887\n398#1:892,6\n398#1:898,14\n62#1:483,2\n62#1:486,4\n115#1:550,2\n115#1:553,4\n167#1:617,2\n167#1:620,4\n223#1:684,2\n223#1:687,4\n278#1:751,2\n278#1:754,4\n340#1:818,2\n340#1:821,4\n398#1:885,2\n398#1:888,4\n*E\n"})
public final class NetworkApi
extends ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<DockerClientConfig> defaultClientConfig$delegate = LazyKt.lazy(NetworkApi::defaultClientConfig_delegate$lambda$3);

    public NetworkApi(@NotNull DockerClientConfig dockerClientConfig, @Nullable Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)dockerClientConfig, (String)"dockerClientConfig");
        super(dockerClientConfig, proxy);
    }

    public /* synthetic */ NetworkApi(DockerClientConfig dockerClientConfig, Proxy proxy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dockerClientConfig = Companion.getDefaultClientConfig();
        }
        this(dockerClientConfig, proxy);
    }

    public NetworkApi(@NotNull DockerClientConfig dockerClientConfig) {
        Intrinsics.checkNotNullParameter((Object)dockerClientConfig, (String)"dockerClientConfig");
        this(dockerClientConfig, null);
    }

    public /* synthetic */ NetworkApi(DockerClientConfig dockerClientConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dockerClientConfig = Companion.getDefaultClientConfig();
        }
        this(dockerClientConfig);
    }

    /*
     * WARNING - void declaration
     */
    public final void networkConnect(@NotNull String id, @NotNull NetworkConnectRequest container) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        RequestConfig localVariableConfig = this.networkConnectRequestConfig(id, container);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig networkConnectRequestConfig(@NotNull String id, @NotNull NetworkConnectRequest container) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        NetworkConnectRequest localVariableBody = container;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/networks/{id}/connect", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NetworkCreateResponse networkCreate(@NotNull NetworkCreateRequest networkConfig) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)networkConfig, (String)"networkConfig");
        RequestConfig localVariableConfig = this.networkCreateRequestConfig(networkConfig);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(NetworkCreateResponse.class, InputStream.class)) {
                object = (NetworkCreateResponse)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(NetworkCreateResponse.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)NetworkCreateResponse.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (NetworkCreateResponse)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<NetworkCreateResponse>((NetworkCreateResponse)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.NetworkCreateResponse");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (NetworkCreateResponse)t;
    }

    @NotNull
    public final RequestConfig networkCreateRequestConfig(@NotNull NetworkCreateRequest networkConfig) {
        Intrinsics.checkNotNullParameter((Object)networkConfig, (String)"networkConfig");
        NetworkCreateRequest localVariableBody = networkConfig;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        return new RequestConfig(requestMethod, "/networks/create", localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void networkDelete(@NotNull String id) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.networkDeleteRequestConfig(id);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                if (((ClientError)localVarError).getStatusCode() == 404) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig networkDeleteRequestConfig(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.DELETE;
        String string = StringsKt.replace$default((String)"/networks/{id}", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void networkDisconnect(@NotNull String id, @NotNull NetworkDisconnectRequest container) throws UnsupportedOperationException, ClientException, ServerException {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        RequestConfig localVariableConfig = this.networkDisconnectRequestConfig(id, container);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var16_17 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Object.class, InputStream.class)) {
                object = ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Object.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Object.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Object>(object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final RequestConfig networkDisconnectRequestConfig(@NotNull String id, @NotNull NetworkDisconnectRequest container) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        NetworkDisconnectRequest localVariableBody = container;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        String string = StringsKt.replace$default((String)"/networks/{id}/disconnect", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Network networkInspect(@NotNull String id, @Nullable Boolean verbose, @Nullable String scope) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RequestConfig localVariableConfig = this.networkInspectRequestConfig(id, verbose, scope);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var17_18 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(Network.class, InputStream.class)) {
                object = (Network)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(Network.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Network.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (Network)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<Network>((Network)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.Network");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (Network)t;
    }

    @NotNull
    public final RequestConfig networkInspectRequestConfig(@NotNull String id, @Nullable Boolean verbose, @Nullable String scope) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object localVariableBody = null;
        Map $this$networkInspectRequestConfig_u24lambda_u240 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (verbose != null) {
            $this$networkInspectRequestConfig_u24lambda_u240.put("verbose", CollectionsKt.listOf((Object)verbose.toString()));
        }
        if (scope != null) {
            $this$networkInspectRequestConfig_u24lambda_u240.put("scope", CollectionsKt.listOf((Object)scope.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        String string = StringsKt.replace$default((String)"/networks/{id}", (String)"{id}", (String)id, (boolean)false, (int)4, null);
        return new RequestConfig(requestMethod, string, localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Network> networkList(@Nullable String filters) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        RequestConfig localVariableConfig = this.networkListRequestConfig(filters);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(List.class, InputStream.class)) {
                object = (List)((Object)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv));
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(List.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)List.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (List)((Object)body$iv$iv$iv.string());
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<List>((List)object, response$iv$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.collections.List<de.gesellix.docker.remote.api.Network>");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (List)t;
    }

    @NotNull
    public final RequestConfig networkListRequestConfig(@Nullable String filters) {
        Map map;
        Object localVariableBody = null;
        Map $this$networkListRequestConfig_u24lambda_u241 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (filters != null) {
            $this$networkListRequestConfig_u24lambda_u241.put("filters", CollectionsKt.listOf((Object)filters.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.GET;
        Class<Network> clazz = Network.class;
        return new RequestConfig(requestMethod, "/networks", localVariableHeaders, localVariableQuery, localVariableBody, (Type)((Object)clazz));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NetworkPruneResponse networkPrune(@Nullable String filters) throws UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        EngineRequest engineRequest;
        RequestConfig localVariableConfig = this.networkPruneRequestConfig(filters);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        EngineRequest it$iv = engineRequest = new EngineRequest(localVariableConfig.getMethod(), localVariableConfig.getPath());
        boolean $i$a$-also-ApiClient$request$engineRequest$1$iv22 = false;
        it$iv.setHeaders(localVariableConfig.getHeaders());
        it$iv.setQuery(localVariableConfig.getQuery());
        it$iv.setBody(localVariableConfig.getBody());
        EngineRequest engineRequest$iv = engineRequest;
        Request request$iv = ApiClient.prepareRequest$default(this_$iv, engineRequest$iv, null, 2, null);
        OkHttpClient client$iv = ApiClient.access$prepareClient(this_$iv, engineRequest$iv);
        ApiClient $i$a$-also-ApiClient$request$engineRequest$1$iv22 = this_$iv;
        Type elementType$iv$iv = localVariableConfig.getElementType();
        boolean $i$f$request2 = false;
        Response response$iv$iv = client$iv.newCall(request$iv).execute();
        String string2 = Response.header$default((Response)response$iv$iv, (String)"Content-Type", null, (int)2, null);
        if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null)) != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String mediaType$iv$iv = string;
        if (response$iv$iv.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv$iv)) {
            apiInfrastructureResponse = new Informational(response$iv$iv.message(), response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (response$iv$iv.isSuccessful()) {
            Object object;
            void this_$iv$iv;
            void var15_16 = this_$iv$iv;
            ResponseBody body$iv$iv$iv = response$iv$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv$iv == null) {
                object = null;
            } else if (Intrinsics.areEqual(NetworkPruneResponse.class, InputStream.class)) {
                object = (NetworkPruneResponse)ResponseConsumerKt.consumeInputStream(body$iv$iv$iv);
            } else {
                String string5 = mediaType$iv$iv;
                if (Intrinsics.areEqual((Object)string5, (Object)"application/json")) {
                    if (elementType$iv$iv == null) {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        object = Serializer.getMoshi().adapter(NetworkPruneResponse.class).fromJson(content$iv$iv$iv$iv);
                    } else {
                        ResponseBody $this$consumeJson$iv$iv$iv$iv = body$iv$iv$iv;
                        boolean $i$f$consumeJson = false;
                        String content$iv$iv$iv$iv = $this$consumeJson$iv$iv$iv$iv.string();
                        Type[] typeArray = new Type[]{elementType$iv$iv};
                        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)NetworkPruneResponse.class)), (Type[])typeArray);
                        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
                        Type adapterType$iv$iv$iv$iv = parameterizedType;
                        JsonAdapter jsonAdapter = Serializer.getMoshi().adapter(adapterType$iv$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
                        JsonAdapter adapter$iv$iv$iv$iv = jsonAdapter;
                        object = adapter$iv$iv$iv$iv.fromJson(content$iv$iv$iv$iv);
                    }
                } else if (Intrinsics.areEqual((Object)string5, (Object)"text/plain")) {
                    object = (NetworkPruneResponse)body$iv$iv$iv.string();
                } else if (string5 == null) {
                    body$iv$iv$iv.close();
                    object = null;
                } else {
                    throw new UnsupportedOperationException("responseBody currently does not support media type " + mediaType$iv$iv + '.');
                }
            }
            apiInfrastructureResponse = new Success<NetworkPruneResponse>((NetworkPruneResponse)object, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isClientError(response$iv$iv)) {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ClientError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv$iv.body();
            apiInfrastructureResponse = new ServerError(response$iv$iv.message(), responseBody != null ? responseBody.string() : null, response$iv$iv.code(), response$iv$iv.headers().toMultimap());
        }
        ApiInfrastructureResponse localVarResponse = apiInfrastructureResponse;
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type de.gesellix.docker.remote.api.NetworkPruneResponse");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ApiInfrastructureResponse localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(((ClientError)localVarError).getStatusCode()).append(' ');
                String string6 = ((ClientError)localVarError).getMessage();
                if (string6 == null) {
                    string6 = "";
                }
                throw new ClientException(stringBuilder.append(string6).toString(), ((ClientError)localVarError).getStatusCode(), localVarResponse);
            }
            case 5: {
                ApiInfrastructureResponse localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(((ServerError)localVarError).getStatusCode()).append(' ');
                String string7 = ((ServerError)localVarError).getMessage();
                if (string7 == null) {
                    string7 = "";
                }
                throw new ServerException(stringBuilder.append(string7).toString(), ((ServerError)localVarError).getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (NetworkPruneResponse)t;
    }

    @NotNull
    public final RequestConfig networkPruneRequestConfig(@Nullable String filters) {
        Map map;
        Object localVariableBody = null;
        Map $this$networkPruneRequestConfig_u24lambda_u242 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (filters != null) {
            $this$networkPruneRequestConfig_u24lambda_u242.put("filters", CollectionsKt.listOf((Object)filters.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        RequestMethod requestMethod = RequestMethod.POST;
        return new RequestConfig(requestMethod, "/networks/prune", localVariableHeaders, localVariableQuery, localVariableBody, null, 32, null);
    }

    private static final DockerClientConfig defaultClientConfig_delegate$lambda$3() {
        return new DockerClientConfig();
    }

    @NotNull
    public static final DockerClientConfig getDefaultClientConfig() {
        return Companion.getDefaultClientConfig();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u00020\u00058FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lde/gesellix/docker/remote/api/client/NetworkApi$Companion;", "", "<init>", "()V", "defaultClientConfig", "Lde/gesellix/docker/engine/DockerClientConfig;", "getDefaultClientConfig$annotations", "getDefaultClientConfig", "()Lde/gesellix/docker/engine/DockerClientConfig;", "defaultClientConfig$delegate", "Lkotlin/Lazy;", "api-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DockerClientConfig getDefaultClientConfig() {
            Lazy lazy = defaultClientConfig$delegate;
            return (DockerClientConfig)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultClientConfig$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseType.values().length];
            try {
                nArray[ResponseType.Success.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Informational.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Redirection.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ClientError.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ServerError.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

